[DO NOT MODIFY THIS FILE MANUALLY. It is generated by src/third_party/scripts/gen_thirdpartyreadme.py]: #

# MongoDB Third Party Dependencies

MongoDB depends on third party libraries to implement some
functionality. This document describes which libraries are depended
upon, and how. It is maintained by and for humans, and so while it is a
best effort attempt to describe the server's dependencies, it is subject
to change as libraries are added or removed.

## Server Vendored Libraries

This is the list of third party libraries vendored into the server
codebase, and the upstream source where updates may be obtained. These
sources are periodically consulted, and the existence of new versions is
reflected in this list. A ticket is filed in Jira if a determination is
made to upgrade a vendored library.

Whenever a vendored library is included in released binary artifacts, is
not authored by MongoDB, and has a license which requires reproduction,
a notice will be included in
`THIRD-PARTY-NOTICES`.

| Name                                                 | License                           | Vendored Version                         | Emits persisted data | Distributed in Release Binaries |
| ---------------------------------------------------- | --------------------------------- | ---------------------------------------- | -------------------- | ------------------------------- |
| [Abseil Common Libraries (C++)]                      | Apache-2.0                        | 20250512.1                               |                      | ✗                               |
| [Asio C++ Library]                                   | BSL-1.0                           | 1.12.2                                   |                      | ✗                               |
| [AWS SDK for C++]                                    | Apache-2.0                        | 1.11.471                                 |                      | ✗                               |
| [benchmark]                                          | Apache-2.0                        | 1.5.2                                    |                      |                                 |
| [Boost C++ Libraries]                                | BSL-1.0                           | 1.88.0                                   |                      | ✗                               |
| [c-ares]                                             | MIT                               | 1.27.0                                   |                      | ✗                               |
| [CRoaring]                                           | Apache-2.0 OR MIT                 | 3.0.1                                    |                      | ✗                               |
| [Cyrus SASL]                                         | BSD-Attribution-HPND-disclaimer   | 2.1.28                                   |                      |                                 |
| [fmt]                                                | MIT                               | 11.1.3                                   |                      | ✗                               |
| [folly]                                              | Apache-2.0                        | 2023.12.25.00                            |                      | ✗                               |
| [gperftools]                                         | BSD-3-Clause                      | 2.9.1                                    |                      | ✗                               |
| [gRPC (C++)]                                         | Apache-2.0                        | 1.59.5                                   |                      | ✗                               |
| [ICU4C - International Components for Unicode C/C++] | Unicode-3.0                       | 57.1                                     | ✗                    | ✗                               |
| [immer]                                              | BSL-1.0                           | 0b3aaf699b9d6f2e89f8e2b6d1221c307e02bda3 |                      | ✗                               |
| [Intel® Decimal Floating-Point Math Library]         | BSD-3-Clause                      | 2.0.1                                    |                      | ✗                               |
| [JSON Schema Store]                                  | Apache-2.0                        | 6847cfc3a17a04a7664474212db50c627e1e3408 |                      |                                 |
| [JSON-Schema-Test-Suite]                             | MIT                               | 728066f9c5c258ba3b1804a22a5b998f2ec77ec0 |                      |                                 |
| [libmongocrypt]                                      | Apache-2.0                        | 1.14.0                                   | ✗                    | ✗                               |
| [librdkafka - The Apache Kafka C/C++ library]        | BSD-2-Clause                      | 2.0.2                                    |                      | ✗                               |
| [LibTomCrypt]                                        | Unlicense                         | 1.18.2                                   | ✗                    | ✗                               |
| [libunwind]                                          | MIT                               | 1.8.1                                    |                      | ✗                               |
| [linenoise]                                          | BSD-2-Clause                      | 6cdc775807e57b2c3fd64bd207814f8ee1fe35f3 |                      | ✗                               |
| [MongoDB C Driver]                                   | Apache-2.0                        | 1.28.1                                   | ✗                    | ✗                               |
| [Mozilla Firefox ESR]                                | MPL-2.0                           | 128.11.0esr                              |                      | ✗                               |
| [MurmurHash3]                                        | Public Domain                     | a6bd3ce7be8ad147ea820a7cf6229a975c0c96bb |                      | ✗                               |
| [nlohmann/json]                                      | MIT                               | 3.11.3                                   | ✗                    |                                 |
| [node]                                               | ISC                               | 22.1.0                                   |                      |                                 |
| [opentelemetry-cpp]                                  | Apache-2.0                        | 1.17.0                                   | ✗                    |                                 |
| [opentelemetry-proto]                                | Apache-2.0                        | 1.3.2                                    | ✗                    |                                 |
| [PCRE2 - Perl-Compatible Regular Expressions]        | BSD-3-Clause WITH PCRE2-exception | 10.40                                    |                      | ✗                               |
| [Protobuf]                                           | BSD-3-Clause                      | v25.0                                    |                      | ✗                               |
| [pypi/ocspbuilder]                                   | MIT                               | 0.10.2                                   |                      |                                 |
| [pypi/ocspresponder]                                 | Apache-2.0                        | 0.5.0                                    |                      |                                 |
| [re2]                                                | BSD-3-Clause                      | 2023-11-01                               |                      | ✗                               |
| [S2 Geometry Library]                                | Apache-2.0                        | a25c502bda9d7e0274b9e2b7825fbddf13cc0306 | ✗                    | ✗                               |
| [SafeInt]                                            | MIT                               | 3.0.26                                   |                      | ✗                               |
| [snappy]                                             | BSD-3-Clause                      | 1.1.10                                   | ✗                    | ✗                               |
| [Snowball Stemming Algorithms (libstemmer)]          | BSD-3-Clause                      | 1.0.0                                    | ✗                    | ✗                               |
| [tcmalloc]                                           | Apache-2.0                        | f3b20f9a07e175c5d897df7b49d9830d4efa6110 |                      | ✗                               |
| [timelib]                                            | MIT                               | 2022.13                                  |                      | ✗                               |
| [Unicode Character Database]                         | Unicode-DFS-2016                  | 8.0.0                                    | ✗                    | ✗                               |
| [valgrind.h]                                         | BSD-4-Clause                      | 093bef43d69236287ccc748591c9560a71181b0a |                      | ✗                               |
| [WiredTiger]                                         | GPL-2.0-only OR GPL-3.0-only      | 12.0.0                                   | ✗                    | ✗                               |
| [yaml-cpp]                                           | MIT                               | 0.6.3                                    |                      | ✗                               |
| [zlib]                                               | Zlib                              | 1.3.1                                    | ✗                    | ✗                               |
| [Zstandard (zstd)]                                   | BSD-3-Clause OR GPL-2.0-only      | 1.5.5                                    | ✗                    | ✗                               |

[AWS SDK for C++]: https://github.com/aws/aws-sdk-cpp.git
[Abseil Common Libraries (C++)]: https://github.com/abseil/abseil-cpp.git
[Asio C++ Library]: https://github.com/chriskohlhoff/asio.git
[Boost C++ Libraries]: https://github.com/boostorg/boost.git
[CRoaring]: https://github.com/roaringbitmap/croaring.git
[Cyrus SASL]: https://github.com/cyrusimap/cyrus-sasl.git
[ICU4C - International Components for Unicode C/C++]: https://github.com/unicode-org/icu.git
[Intel® Decimal Floating-Point Math Library]: https://www.netlib.org/misc/intel/
[JSON Schema Store]: https://github.com/schemastore/schemastore.git
[JSON-Schema-Test-Suite]: https://github.com/json-schema-org/JSON-Schema-Test-Suite.git
[LibTomCrypt]: https://github.com/libtom/libtomcrypt.git
[MongoDB C Driver]: https://github.com/mongodb/mongo-c-driver.git
[Mozilla Firefox ESR]: https://github.com/mozilla-firefox/firefox.git
[MurmurHash3]: https://github.com/aappleby/smhasher/blob/a6bd3ce/
[PCRE2 - Perl-Compatible Regular Expressions]: https://github.com/pcre2project/pcre2.git
[Protobuf]: https://github.com/protocolbuffers/protobuf.git
[S2 Geometry Library]: https://github.com/google/s2geometry.git
[SafeInt]: https://github.com/dcleblanc/safeint.git
[Snowball Stemming Algorithms (libstemmer)]: http://github.com/snowballstem/snowball.git
[Unicode Character Database]: https://www.unicode.org/Public/8.0.0/
[WiredTiger]: https://github.com/wiredtiger/wiredtiger.git
[Zstandard (zstd)]: https://github.com/facebook/zstd.git
[benchmark]: https://github.com/google/benchmark.git
[c-ares]: https://github.com/c-ares/c-ares.git
[fmt]: https://github.com/fmtlib/fmt.git
[folly]: https://github.com/facebook/folly.git
[gRPC (C++)]: https://github.com/grpc/grpc.git
[gperftools]: https://github.com/gperftools/gperftools.git
[immer]: https://github.com/arximboldi/immer.git
[libmongocrypt]: https://github.com/mongodb/libmongocrypt.git
[librdkafka - The Apache Kafka C/C++ library]: https://github.com/confluentinc/librdkafka.git
[libunwind]: https://github.com/libunwind/libunwind.git
[linenoise]: https://github.com/antirez/linenoise
[nlohmann/json]: https://github.com/nlohmann/json.git
[node]: https://nodejs.org/
[opentelemetry-cpp]: https://github.com/open-telemetry/opentelemetry-cpp.git
[opentelemetry-proto]: https://github.com/open-telemetry/opentelemetry-proto
[pypi/ocspbuilder]: https://pypi.org/project/ocspbuilder/
[pypi/ocspresponder]: https://pypi.org/project/ocspresponder/
[re2]: https://github.com/google/re2.git
[snappy]: https://github.com/google/tcmalloc.git
[tcmalloc]: https://github.com/google/tcmalloc.git
[timelib]: https://github.com/derickr/timelib.git
[valgrind.h]: https://sourceware.org/git/valgrind.git
[yaml-cpp]: https://github.com/jbeder/yaml-cpp.git
[zlib]: https://zlib.net/fossils/

## Dynamically Linked Libraries

Sometimes MongoDB needs to load libraries provided and managed by the
runtime environment. These libraries are not vendored into the MongoDB
source directory, and are not compiled into release artifacts. Because
they are provided by the runtime environment, the precise versions of
these libraries cannot be known in advance. Further, these libraries may
themselves load other libraries. The full set of transitively linked
libraries will depend on the runtime environment, and cannot be outlined
here. On Windows and Mac OS, other libraries and components provided by
the Operating System may be loaded.

For Windows Enterprise, we may ship precompiled DLLs containing some of
these libraries. Releases prepared in this fashion will include a copy
of these libraries' license in a file named
`THIRD-PARTY-NOTICES.windows`.

| Name       | Enterprise Only |                    Has Windows DLLs                     |
| :--------- | :-------------: | :-----------------------------------------------------: |
| Cyrus SASL |       Yes       |                           Yes                           |
| libldap    |       Yes       |                           No                            |
| net-snmp   |       Yes       |                           Yes                           |
| OpenSSL    |       No        | Yes<sup>\[<a href="#note_ssl" id="ref_ssl">3</a>]</sup> |
| libcurl    |       No        |                           No                            |

## Notes:

1. <a id="note_vg" href="#ref_vg">^</a>
   The majority of Valgrind is licensed under the GPL, with the exception of a single
   header file which is licensed under a BSD license. This BSD licensed header is the only
   file from Valgrind which is vendored and consumed by MongoDB.

2. <a id="note_wt" href="#ref_wt">^</a>
   WiredTiger is maintained by MongoDB in a separate repository. As a part of our
   development process, we periodically ingest the latest snapshot of that repository.

3. <a id="note_ssl" href="#ref_ssl">^</a>
   OpenSSL is only shipped as a dependency of the MongoDB tools written in Go. The MongoDB
   shell and server binaries use Windows' cryptography APIs.
