/**
 * Tests that shard filtering works as expected when the DISTINCT_SCAN optimization is applied to a
 * $group query.
 *
 * @tags: [
 *   featureFlagShardFilteringDistinctScan,
 *   do_not_wrap_aggregations_in_facets,
 *   not_allowed_with_signed_security_token,
 *   expects_explicit_underscore_id_index,
 *   # Index filter commands do not support causal consistency.
 *   does_not_support_causal_consistency,
 *   requires_fcv_82
 * ]
 */

import {
    runGroupConversionToDistinctScanTests
} from "jstests/libs/query/group_conversion_to_distinct_scan.js";
import {
    prepareShardedCollectionWithOrphans
} from "jstests/libs/query/group_to_distinct_scan_utils.js";
import {ShardingTest} from "jstests/libs/shardingtest.js";

TestData.skipCheckOrphans = true;

const st = new ShardingTest({shards: 2});
const db = prepareShardedCollectionWithOrphans(st);

// Query hashes programmatically obtained for the subsequent tests. Validated locally that these are
// the same as with featureFlagShardFilteringDistinctScan dsisabled, though the test cannot run with
// the flag off because of orphans.
// TODO SERVER-100039: replace this with passthrough suite for validating query hashes.
const queryHashes = [
    "68D3AC9FA8143DC330E43A0A87CA681083314ECEDE43FCEA785AF3D65F799ED6",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "4C975276D7761BE842864616D294D70EA441E563A6F0C380A44A65080367F81A",
    "14906D45C5A1C5696E49E9D193C6EEE363CB657E2B43B16CAAF3E1EBCC1AF43E",
    "C9C251182A037DF60BCE1653FE155C343E84F6ABF5C18CD8C5DD3A9C120D981E",
    "AA44E7ABD92986793FA04191DB95B0C3BCEEE420D084BFDE96E5BA19F0A5C846",
    "916CF8FD7636DA8597FC6AA3DF4EF0560234259E8AAACC853D033C4795B23B60",
    "DCDDA17F4ED11CF70A43FEBE001E4ED573C94C160E3E4AA8A70B2BA54329A176",
    "01CD741213FCD78E7C8A271CDB17097B5746D281FA05CBDCB8B5752448BFD6AD",
    "E4342FCC9F42E5D130EC77604FD935F8086F09B12D00B3EC425191418AE64AB5",
    "E5E9E7F119C4F9090ADE0DD6EBF57AF85CD510DC3BC4D8F88F414C79BB79FE0F",
    "54543195C098289479E6276187E5552D3F6078C10C6B0398A1F20F98903100E4",
    "F0AC85DDDF5CE2C1D76635FA6E1EA0233EEB1022FB7C1C8B845FB42CFB105C06",
    "5B8BD3ABD41F572B20D995AA2C5C19CB0A172CA064A59DB9258FD270541DDB1D",
    "D02F1888DCAF804D7D3A74C5F86CB4F484D29442289B06BB2F818DD8B0CA5DF1",
    "054218F3F25D7BAB88C3FBF849722ADF6E64D35B959A5C5F5276489D5C870E69",
    "2A5A661703D6A8D9F8031E4F3E643A4695CB1488D85F6468C0026E4957175A05",
    "8FF80C702503BA9ADAE3CCF2CC5B0DCA81D64B14CF7722FB0485B01F9DC155AA",
    "9BD5EDEEDDF840A7265AA3A98B2891FFD44AACB94E5A296B5D8EC3A343547398",
    "EEF628512130C724C6005ACA5396C7FD0CED4E63C13AA58E0520ACB42B39E8B1",
    "182934E5D0D191F8CE857A589CB54F8FCDDCC4DAAD14DE38D0CB6A23F213BC6F",
    "C47969C0F5919D3713752D4965B6D2EC735F56E9B2D4399BA36DF41A42CD7449",
    "2131CC739ADDFB873FA96ABA5738B7F2CD9F03E48A7E505AEE3BE491E34D722C",
    "6EBAFD67508FE076DFA4CBC98305EB40C9DB8B989A0DDB0F6221D802E92E56D5",
    "C37BCDF7830307CA03B6173579C3D0673DC7A8487B570DF56F0C3EFDA1A39243",
    "2830E3EC4BEF804C66EBFB1C70E15D2DAAA4DA527455A653E246E802FAD2F071",
    "BAC894516EF5E5B73B4908B96E52C1EA06E4CBF0F0D9EBDEF268CC2C46E12FB9",
    "F3115083368ECA9684F47D0DF29960297E1B3269C8E398EE30ED422C5923879E",
    "F80762948E7B6BD5927DBB883C85D2CC59904A41DF9C0C323E8E8AB16B42ED12",
    "6100B82742A6C4D5A1A1DF91FDF8FABFCC065DC6F8D780405B76919998CE367B",
    "B92FC19982A2282660479642F457AFFD3A4D352F40407A2FCA91613B230D57EA",
    "B8251D07C76B69B951270C5CD738032789A4CC857FA42A52E58BC1FF16A329EF",
    "59311AA521DD6E032912FF5BECFE8FEB0556744A831E63D6FD30E944841C7F98",
    "A4B85A95F4F7D0FF29998887C6AC95C5EB3B30ACCE6A5483557891B87E5C4BE6",
    "0466E10DCD56A8D882D621EB8CF61EA0578E9C31A40CACF18B2E8A343AB98BCF",
    "14A2A7F1D305435E9E112D1C82609B3942909C4BEE422A1799168711EFB53702",
    "A55241F173CA826C919460D853E9E9713B23851229B82F0346B55107E0005390",
    "0CA76A0941B6C3451DA8ED1B4D545A96D87A18E2EA9B46D257BE1F375E5DB264",
    "5DC90034328C5CDAF20EE8835CBAC9CEE128936476F102C52E450DE3DA82CBDD",
    "AA44E7ABD92986793FA04191DB95B0C3BCEEE420D084BFDE96E5BA19F0A5C846",
    "3C43DEC0F9A83FA11FF21458D850965F250910AF0A939232822412CB9CC3E598",
    "B84D4005C1516833204EB77DF83911B24E4850318BBE837F016950D9802809C3",
    "EE1A319B8C8CD245AE9329A1E38A4C982645E5A9C6F1CC00608EC1448AC5278E",
    "60BE16AEA1D7A89713F6ABD3D87F19626E0A9CABB999D8115A7AE3483C32CF01",
    "7E3A85823938D854CD8F8FA836B8B032CA975F93860FB536D1F28A6C1C5BDCBE",
    "DF79820A194F45509A1B218A12CABB9237AB1264200731F208A20CC6786B7B8A",
    "DCA9E8C10AFEF7013A9D4106C849502EEED27B1069E0ADF39E66D9E9EBF515EC",
    "BD934AF6B503DA18738B1AD10FD9197F608E848647536FC9E6CDCDD6D121276C",
    "A735D4222C05BD560213425C2D549CACB1C01174DBBC3D24C936EB352A14E6A3",
    "94DE630859E9365B2D9B3A9CE78BA3C1EFF6A1F720DCAE19E8B615DAE216BB52",
    "68B56D96A37957394ADDAE577D36E252C46108E736AB3344C14573B97EA2B009",
    "8A924B1DD64C8046F4CA08D48565E80653FC102A1B102E4FFB5850F42256870D",
    "5FF3BDDEEFC6C2BE0D6AF357B0D1AF678E7750CA8F5CFF2032B5665904119E65",
    "5A46DD8FE2A16AE3D102B8A4DEED6455EC50C802E7C0527F03309FCCE36873F0",
    "2318233438474575DB92F7BDFEA1DFC170922EF3612D8D96FBE15A5F942F28C2",
    "5FD6A02901A388B44ED673EC67321EF8C7D03CDCC25BBB58A3950C685679A53B",
    "6781E413C3C2B00BF51DD2A7010976264AA71743243D38F64E53F0AC7AE8746E",
    "8A924B1DD64C8046F4CA08D48565E80653FC102A1B102E4FFB5850F42256870D",
    "5FF3BDDEEFC6C2BE0D6AF357B0D1AF678E7750CA8F5CFF2032B5665904119E65",
    "5A46DD8FE2A16AE3D102B8A4DEED6455EC50C802E7C0527F03309FCCE36873F0",
    "2318233438474575DB92F7BDFEA1DFC170922EF3612D8D96FBE15A5F942F28C2",
    "5FD6A02901A388B44ED673EC67321EF8C7D03CDCC25BBB58A3950C685679A53B",
    "05AAFDB52F1B18593BA5BA367B00986784AF1CF120C8D53A82AB45278EE6C552",
    "8A924B1DD64C8046F4CA08D48565E80653FC102A1B102E4FFB5850F42256870D",
    "5FF3BDDEEFC6C2BE0D6AF357B0D1AF678E7750CA8F5CFF2032B5665904119E65",
    "5A46DD8FE2A16AE3D102B8A4DEED6455EC50C802E7C0527F03309FCCE36873F0",
    "2318233438474575DB92F7BDFEA1DFC170922EF3612D8D96FBE15A5F942F28C2",
    "5FD6A02901A388B44ED673EC67321EF8C7D03CDCC25BBB58A3950C685679A53B",
    "BC9CBB73E702123FA6FC5FF66E504E4CCEB13C42C2AFB8B0FDFDC2280250814B",
    "61E6A85CE56543B591ACA8550D1DC53FED12B8C8A72151689CAA690B17868FCB",
    "43C9A9660F64443FC4263DB17AD1747488C63DDA8969733D073F21CF7D8F2F53",
];
runGroupConversionToDistinctScanTests(db, queryHashes, true);

st.stop();
