import {createSearchIndex} from "jstests/libs/search.js";
import {checkForExistingIndex, datasets} from "jstests/with_mongot/e2e_lib/search_e2e_utils.js";

// Plot embeddings for 17 movies where array index corresponds to the _id of the movie, or null if
// the entry has no plot embedding.
const plotEmbeddings = [
    null,
    [
        0.006585975,    -0.03453151,    -0.0073834695,  -0.032803606,    -0.0032448056,
        0.015856847,    -0.0032713888,  0.011949126,    -0.0062968833,   0.0032148995,
        0.0071708043,   0.0016248949,   0.014487816,    -0.000010448943, 0.027673058,
        0.007955007,    0.04298495,     -0.022741884,   -0.0005798449,   0.013730196,
        0.03205928,     -0.0019704758,  -0.007031243,   -0.021891223,    -0.0035355587,
        0.01367703,     0.0048447787,   -0.022236804,   0.029773125,     -0.0073768236,
        0.020947522,    -0.009988618,   0.00035949555,  -0.012234895,    -0.012892827,
        -0.005987854,   0.00027143885,  -0.009211061,   0.0009104728,    -0.012088687,
        0.008533191,    0.0048314873,   0.012500726,    0.0008249083,    -0.016680926,
        -0.0088521885,  -0.006060958,   -0.024456497,   -0.029613627,    0.0015825281,
        0.025533114,    0.033228934,    -0.043303948,   -0.011802918,    -0.009530059,
        -0.00873921,    -0.011071881,   0.007988236,    -0.0032065923,   -0.021838056,
        -0.0030387861,  0.009450309,    -0.01367703,    -0.0012867906,   -0.0031916392,
        0.011430753,    -0.008652815,   0.0022446145,   -0.0020867772,   0.0034823925,
        0.034053013,    0.019525323,    0.011949126,    0.007988236,     0.031793445,
        -0.016521426,   -0.021877931,   0.001591666,    -0.011929188,    0.007609426,
        0.011743106,    -0.012899472,   -0.022941258,   -0.002982297,    0.026556564,
        0.01746513,     -0.0039808266,  -0.0043563135,  -0.02793889,     -0.000674132,
        -0.01588343,    -0.030118708,   0.010746238,    0.022422886,     -0.024748912,
        0.031846613,    -0.022675425,   -0.0139827365,  0.004794935,     -0.055558782,
        0.0076891757,   0.0057585747,   -0.008254068,   -0.0029407607,   0.0012419315,
        -0.002762986,   0.004588916,    -0.0035023298,  0.02684898,      -0.00143549,
        0.0057319915,   0.017943624,    0.0055392636,   -0.049019326,    -0.012533954,
        -0.038625315,   0.017239172,    -0.00996868,    -0.010241158,    -0.006735505,
        0.018142998,    -0.009297457,   0.0064829653,   0.0063035293,    -0.011497212,
        0.018408831,    0.008240776,    -0.01654801,    -0.0030853066,   -0.0068916813,
        0.022595676,    0.010513635,    0.015484684,    0.002748033,     -0.007968299,
        0.014022611,    0.0046653426,   0.007237262,    0.01367703,      -0.00692491,
        0.020920938,    0.010320907,    0.0010799404,   -0.00652284,     -0.012068749,
        0.006054312,    0.00076924986,  0.010108242,    0.013032389,     0.0035089755,
        0.03080987,     -0.009629746,   0.026556564,    0.005000955,     0.01949874,
        0.013583989,    0.0053531816,   0.015976472,    -0.002736403,    -0.026131235,
        0.0072040334,   -0.00082366227, -0.0011073543,  0.006054312,     0.0047583836,
        0.025453364,    0.025280574,    -0.00785532,    -0.010187992,    -0.017598044,
        -0.004585593,   0.018847452,    -0.009569934,   0.02591857,      -0.015351769,
        0.028045222,    0.0022678748,   0.036232833,    -0.010945612,    -0.00015088014,
        -0.015684057,   0.031128867,    0.0074432814,   0.0051371935,    -0.0067255367,
        -0.008719273,   0.0087591475,   0.0018126385,   0.03216561,      -0.029241463,
        0.03065037,     -0.006087541,   0.0051970053,   -0.009915515,    -0.6524568,
        -0.00755626,    -0.0063002063,  0.0021432664,   0.006336758,     0.015258728,
        0.021678558,    -0.002156558,   -0.00428321,    0.022702008,     -0.0062138108,
        0.0039475975,   -0.008254068,   -0.017092964,   -0.023193797,    -0.024336873,
        0.0011513826,   -0.03546192,    -0.008958521,   0.013318158,     -0.017026506,
        0.021678558,    0.00096280844,  -0.012693454,   0.003339508,     0.0016921835,
        0.019870903,    -0.026131235,   -0.007948361,   0.026357193,     -0.021080436,
        0.004555687,    -0.0009827458,  0.01110511,     0.051624473,     -0.020708272,
        -0.030198457,   0.011277901,    -0.015351769,   0.021651974,     -0.022848217,
        -0.0070777633,  -0.015989764,   -0.0016265564,  -0.008340463,    0.0043430217,
        0.009483539,    -0.0051471624,  0.025626155,    -0.00210173,     0.017704377,
        0.015484684,    0.0063234665,   0.015657475,    -0.011849439,    0.0075629056,
        0.028630052,    -0.02785914,    0.018422121,    0.0065461,       -0.008692689,
        -0.006243717,   0.0072638453,   0.003291326,    -0.023007715,    0.05215614,
        -0.0058516157,  0.018820869,    0.01823604,     -0.03115545,     0.012454205,
        0.0057918034,   -0.018023375,   -0.01932595,    0.029321212,     0.009270873,
        0.02964021,     -0.014806814,   -0.0012427622,  0.0023758688,    -0.00011079773,
        -0.017837293,   -0.01959178,    0.0079350695,   -0.011457337,    -0.00038649407,
        -0.025812237,   0.004990986,    0.01739867,     -0.00040020098,  0.014766939,
        0.02481537,     -0.002741387,   -0.017824002,   0.0029424222,    0.0024556182,
        0.0063965702,   -0.013377969,   -0.009277519,   -0.021319686,    0.011650065,
        -0.0037449012,  -0.012806431,   0.00022678748,  0.009503475,     0.009988618,
        -0.013358032,   0.020548774,    0.05311313,     -0.009237644,    -0.0140757775,
        0.018262623,    -0.0047550607,  0.0026184402,   -0.0021133602,   -0.017717669,
        0.018807577,    0.0055492325,   0.021067144,    -0.044447023,    0.005582461,
        0.021798182,    0.0076958216,   -0.029268047,   0.033468183,     0.02617111,
        0.0013333111,   -0.020030402,   -0.03918356,    0.0002319795,    0.002762986,
        -0.0005873214,  0.0088521885,   0.0053498587,   0.0031285044,    0.0261844,
        0.021426018,    -0.016694218,   0.024270415,    -0.0018375601,   -0.0021848024,
        0.0179835,      0.0062304256,   -0.007868612,   0.009330685,     -0.02306088,
        -0.012892827,   -0.010075013,   -0.03835948,    -0.0069980137,   0.012148499,
        -0.00020248882, -0.008161027,   -0.002201417,   0.0053133066,    0.007642655,
        -0.02169185,    -0.019046826,   -0.018874036,   -0.019565197,    0.025293866,
        -0.0071840957,  -0.03732274,    0.0021366205,   0.015976472,     -0.0014221985,
        0.0052501718,   0.010673135,    -0.0034990069,  -0.029055381,    0.0075429683,
        -0.017318921,   -0.019777862,   0.019445574,    -0.0051670996,   -0.0009503476,
        -0.0050109234,  -0.007396761,   0.0053232755,   -0.0003243975,   -0.002399129,
        0.0024340195,   0.0005250172,   -0.007549614,   0.036950577,     0.002279505,
        0.038120236,    0.027486976,    -0.010892445,   0.025905278,     0.00039397058,
        0.015006187,    -0.001216179,   -0.012261477,   0.013770071,     0.012706745,
        -0.0037083493,  0.026450234,    0.031607363,    0.035063174,     0.01739867,
        -0.0020336108,  0.0143549,      -0.011822855,   0.018036665,     -0.026955312,
        -0.0006197197,  -0.033122603,   0.02769964,     -0.00034412715,  0.010972194,
        -0.012460851,   -0.0027729548,  -0.008287297,   0.003435872,     0.008067986,
        -0.0011422447,  0.012201665,    -0.017770834,   -0.01271339,     0.008672752,
        -0.00886548,    -0.019512031,   0.0010425579,   -0.046547092,    0.023459628,
        0.005396379,    0.03362768,     0.0052202656,   -0.020788021,    -0.0016406787,
        -0.002654992,   -0.020309525,   0.016734092,    0.01739867,      -0.009689557,
        0.0059479796,   -0.02195768,    -0.009882285,   -0.014487816,    0.012626995,
        0.018581621,    0.038864564,    -0.026104651,   0.0128861815,    0.02423054,
        0.010752884,    0.0203494,      -0.029666794,   0.010540218,     -0.018289207,
        0.014992896,    -0.0073834695,  0.016840424,    0.009782598,     -0.008898709,
        0.017239172,    0.00033478154,  0.032218777,    0.02009686,      0.013863112,
        -0.003808036,   -0.0047683525,  0.018382248,    0.017943624,     -0.0073236576,
        0.004303147,    -0.019193033,   0.010892445,    -0.010919028,    0.01485998,
        -0.004436063,   0.012686808,    -0.015418226,   -0.004216752,    -0.028071804,
        -0.002829444,   -0.008048048,   0.010121534,    -0.014155527,    -0.0011763043,
        -0.036259413,   0.007629364,    0.018010084,    0.009962035,     -0.0040638987,
        -0.021625392,   0.010912382,    -0.032963105,   0.021731723,     -0.020243067,
        0.015697349,    -0.024190664,   -0.0065726833,  0.0038279733,    -0.009643037,
        0.006858452,    -0.0021067145,  0.034744173,    -0.01874112,     0.018967077,
        0.021638682,    0.0047550607,   -0.024416622,   0.0039841495,    0.012819723,
        0.0013416182,   -0.005469483,   0.0033976587,   -0.0058848443,   0.0035521733,
        0.0065693604,   -0.01384982,    -0.008965167,   0.005688794,     -0.009908869,
        -0.030411122,   0.0034757466,   0.043250784,    -0.016574593,    0.004093805,
        -0.03030479,    -0.032192193,   -0.024363456,   0.1151582,       0.029427545,
        0.01485998,     0.009343977,    0.008732565,    0.0076559465,    -0.021638682,
        -0.017531587,   0.007649301,    -0.010506989,   -0.018501872,    -0.024124207,
        0.001585851,    0.015471392,    0.03782782,     0.0070644715,    -0.001955523,
        -0.04136338,    -0.007150867,   0.011111756,    0.00974937,      0.019963944,
        0.024270415,    0.02735406,     -0.010653197,   -0.010573448,    0.004994309,
        0.016773967,    -0.012208311,   -0.029746544,   -0.020974103,    -0.0064032157,
        -0.012015583,   0.0042665955,   0.011895959,    0.0025303834,    0.0066889846,
        -0.0049112365,  0.030092124,    -0.0028693187,  0.010413948,     0.031182034,
        -0.0063799554,  -0.034398593,   0.006619204,    0.0015193931,    -0.010015201,
        0.01697334,     -0.012959285,   -0.008832251,   0.03333527,      -0.008845543,
        -0.013902986,   0.0021316363,   0.0005823371,   -0.0060443436,   0.010972194,
        -0.0056987624,  -0.000192624,   0.013311512,    -0.028603468,    -0.013610572,
        0.0024190666,   -0.011317776,   0.021173477,    -0.02498816,     -0.011729814,
        -0.0017411963,  -0.014035902,   -0.0038944313,  0.01907341,      -0.033840347,
        0.02085448,     -0.009782598,   0.023273546,    0.0042533036,    0.007516385,
        -0.023565961,   -0.0017843938,  0.013338095,    -0.021997556,    -0.029400961,
        -0.002636716,   -0.0117829805,  -0.002651669,   0.024602704,     -0.00054370845,
        0.0025420135,   -0.010201283,   0.019379115,    0.022143763,     -0.005283401,
        0.028576884,    0.0022662133,   -0.0032082538,  -0.009137957,    -0.006360018,
        -0.011277901,   0.008526545,    0.012181728,    -0.012912764,    -0.02692873,
        -0.011975708,   -0.0017079673,  0.011125048,    0.011397525,     -0.002264552,
        0.0047617066,   -0.03421251,    -0.0038445878,  0.0023409785,    -0.01670751,
        0.0055060345,   -0.007715759,   0.011244671,    -0.0009005042,   0.028417386,
        0.025519822,    0.0075894888,   -0.0130922,     0.010207929,     -0.02068169,
        0.028337637,    0.025453364,    0.00070445344,  -0.0013050664,   0.0050341836,
        -0.025506532,   0.0077556334,   -0.0019621686,  -0.023898251,    0.020402566,
        0.025798945,    0.00068036246,  -0.024629287,   0.016534718,     -0.022276679,
        0.0017063059,   -0.008107861,   -0.0019737987,  -0.011424108,    -0.01681384,
        -0.025134366,   -0.009888931,   -0.02069498,    -0.026968604,    0.013264991,
        0.0029457451,   -0.006067604,   0.008931938,    -0.016773967,    -0.005619013,
        -0.002543675,   0.01697334,     -0.00013011205, -0.030916201,    -0.00088305894,
        -0.008180964,   0.0047916127,   0.00584497,     0.028975632,     -0.02025636,
        0.020150026,    -0.00012824293, 0.0015002864,   -0.025798945,    -0.0024738943,
        -0.00117132,    -0.049683906,   0.0014064147,   -0.0010716332,   0.0117829805,
        0.015976472,    0.0013989382,   0.013364678,    0.0028045222,    -0.009397143,
        -0.018847452,   -0.019458864,   -0.03987472,    0.0067022764,    0.0020585326,
        -0.023313422,   -0.0060210833,  -0.0042632725,  -0.0060210833,   0.039715223,
        0.031261783,    -0.026569856,   0.0075695515,   0.016867008,     0.013490948,
        0.0085730655,   -0.022143763,   0.004784967,    -0.0005719531,   0.016361928,
        0.0053465357,   0.012852952,    0.0011065236,   0.0030504162,    0.012819723,
        0.015830265,    -0.006243717,   -0.019286074,   0.03142128,      0.006768734,
        -0.009383852,   0.0074166986,   -0.017651211,   -0.020336108,    -0.004592239,
        0.001441305,    -0.028178137,   -0.009456955,   -0.017691085,    -0.0062703,
        0.014806814,    0.0016473245,   -0.04245329,    0.045563515,     0.010035139,
        0.034903675,    -0.0035422046,  0.03235169,     -0.003171702,    0.010865862,
        -0.014740356,   0.020841189,    -0.002394145,   0.0077290502,    0.018422121,
        0.0036585059,   0.01856833,     -0.012999159,   -0.02921488,     0.001807654,
        -0.030623786,   -0.029932626,   0.025293866,    0.0034823925,    0.0050109234,
        -0.0054495456,  -0.010526927,   0.016680926,    0.022064013,     -0.018382248,
        -0.004436063,   -0.0069780764,  -0.042772286,   -0.030118708,    -0.015152395,
        -0.008293943,   0.010394011,    0.004216752,    -0.018967077,    0.015418226,
        -0.013444427,   0.014899855,    0.015989764,    0.013484302,     0.0032265296,
        0.0024738943,   -0.014447941,   -0.012680162,   -0.0059479796,   0.0008564758,
        -0.0076360092,  0.0107794665,   0.029985791,    -0.019379115,    0.0024572797,
        -0.0054362537,  0.020495607,    0.0090316245,   0.018222747,     -0.008925292,
        -0.01503277,    -0.0036352456,  -0.00007689383, 0.009350622,     0.006469674,
        -0.028497135,   -0.024974868,   -0.0052933693,  0.004406157,     -0.044207778,
        0.0025303834,   0.027114812,    0.004585593,    -0.012214957,    0.012985868,
        -0.0090316245,  0.005648919,    0.026264152,    -0.0082075475,   -0.022702008,
        0.025307158,    -0.032218777,   0.009556642,    -0.00023945601,  0.008892063,
        -0.009935452,   0.012028875,    0.023565961,    -0.002000382,    0.02820472,
        -0.04019372,    -0.0214526,     0.0038645251,   -0.009257581,    0.0067089223,
        -0.022914674,   -0.01705309,    -0.00036427221, 0.013078909,     0.013716904,
        -0.011178214,   -0.02692873,    0.0054262853,   0.014062486,     -0.0027148041,
        0.02929463,     -0.029427545,   0.010068367,    -0.01983103,     0.022595676,
        0.013291574,    -0.030437704,   -0.00692491,    -0.005712054,    0.014926438,
        0.007735696,    -0.03200611,    -0.0074499273,  -0.0046354365,   -0.015551141,
        0.018900618,    0.0006126585,   -0.019658238,   0.014474524,     0.034717593,
        0.012274769,    -0.0035156214,  0.022476053,    -0.029268047,    0.01067978,
        -0.039024062,   -0.03697716,    -0.03806707,    -0.011463983,    0.012068749,
        -0.008034756,   -0.004931174,   -0.022356428,   -0.028922465,    -0.031447865,
        0.022489343,    -0.014062486,   0.01304568,     0.031128867,     0.008161027,
        -0.012766557,   0.038120236,    -0.003078661,   0.003369414,     -0.020017112,
        0.0026832365,   -0.0006953155,  -0.026357193,   0.004107096,     0.0038312962,
        -0.021545641,   0.019126575,    0.00992216,     -0.0010865862,   -0.023512796,
        0.00092127227,  0.0052900463,   0.008001528,    0.0049477885,    0.020030402,
        0.0058017722,   0.014620732,    0.014487816,    0.0035787565,    0.017119547,
        0.0048248414,   0.00844015,     -0.028816134,   -0.020881062,    -0.011989,
        -0.021492476,   0.009875639,    0.008367046,    -0.022329845,    -0.03469101,
        -0.011331067,   0.019711405,    0.014115652,    -0.012195019,    -0.00019096254,
        0.010287679,    -0.017611336,   -0.013304866,   0.023951417,     0.020282943,
        -0.011178214,   0.01891391,     0.006931556,    0.0021964326,    0.010121534,
        0.019857612,    -0.03814682,    -0.0021632037,  0.0025353679,    0.01620243,
        -0.018501872,   0.023074172,    0.034398593,    0.0037515468,    0.005300015,
        0.0011364296,   -0.010839279,   -0.0027829234,  -0.015870139,    -0.0067022764,
        -0.00044900598, 0.007396761,    -0.003216561,   -0.011377588,    -0.027088229,
        -0.004868039,   -0.015099228,   -0.02372546,    0.009656329,     0.2049029,
        -0.004505844,   0.022236804,    0.028470552,    -0.0015592678,   0.033920098,
        0.017358797,    0.0045789476,   -0.01110511,    -0.017598044,    -0.018435413,
        -0.00049718795, 0.029773125,    -0.0030703538,  0.0011920881,    -0.023778627,
        -0.020827897,   -0.0037382552,  -0.014381483,   -0.0018176228,   0.010586739,
        0.007549614,    -0.0027762775,  -0.004495875,   0.019405698,     -0.014753647,
        -0.037429072,   -0.015431518,   0.013610572,    0.017837293,     -0.01596318,
        0.0023825148,   -0.007157513,   0.0073170117,   -0.03006554,     -0.0016572932,
        0.0053598275,   -0.007955007,   -0.027726224,   -0.012992514,    0.012799786,
        -0.013703613,   -0.0025420135,  0.0035156214,   -0.00979589,     0.019644946,
        0.0051139332,   -0.0063932473,  -0.008692689,   0.029321212,     -0.040140554,
        -0.004339699,   -0.0010674796,  0.04450019,     -0.005658888,    0.011164922,
        0.022755176,    0.012108624,    -0.0058848443,  -0.00093871745,  -0.00015420302,
        0.008293943,    0.0033959972,   0.008812314,    0.0018458674,    0.02700848,
        -0.02244947,    0.004216752,    0.032564357,    -0.010015201,    -0.00022595676,
        -0.029268047,   -0.023180505,   -0.0021266518,  -0.0064231534,   -0.020043693,
        0.027513558,    0.01664105,     0.0037349323,   -0.0035388817,   0.004412803,
        0.0009702849,   -0.008446796,   -0.0029424222,  -0.016162554,    -0.022529218,
        0.043064702,    0.013417845,    -0.026981896,   0.020402566,     0.0010026832,
        -0.04245329,    -0.00077132665, -0.003774807,   0.0038312962,    0.015471392,
        -0.009510121,   0.013942861,    -0.0023260254,  -0.019339241,    0.000575276,
        0.010394011,    0.018714536,    -0.011111756,   -0.018847452,    -0.01596318,
        0.012527308,    0.018967077,    0.019605072,    -0.016454969,    -0.027885722,
        -0.014248568,   -0.005957948,   -0.017863875,   0.015750516,     0.0018209456,
        -0.0090316245,  -0.02607807,    0.037748072,    -0.02820472,     -0.0031301656,
        -0.030703537,   -0.011297838,   -0.008659461,   -0.0021366205,   -0.030676953,
        -0.031261783,   0.029773125,    0.015019479,    -0.028045222,    0.014833397,
        -0.04912566,    -0.016149262,   -0.0020817928,  -0.005373119,    0.009064853,
        0.010294325,    -0.0106864255,  0.0016996601,   0.0048281644,    -0.004110419,
        -0.0053598275,  0.029613627,    -0.0046287905,  0.026290733,     0.01055351,
        0.018302498,    0.01030097,     0.00048140422,  -0.0033428308,   -0.025373615,
        -0.013823237,   -0.010493698,   -0.009350622,   0.013431136,     -0.01763792,
        -0.016667634,   -0.012135208,   -0.008453441,   0.016840424,     -0.03748224,
        0.006426476,    0.0086661065,   -0.05598411,    -0.015870139,    -0.013005805,
        -0.16906883,    0.03251119,     0.016069513,    -0.009377206,    0.031208616,
        0.020110153,    0.020575358,    -0.013823237,   0.0015900045,    -0.005097319,
        -0.002093423,   0.002242953,    -0.029321212,   0.0020817928,    -0.011277901,
        0.02347292,     -0.016215721,   0.0011414139,   -0.0066291727,   0.011882667,
        0.02532045,     -0.022064013,   -0.010659843,   0.0013067279,    0.027194561,
        0.012972577,    -0.011277901,   -0.0008938584,  -0.014394775,    -0.0047650295,
        -0.018036665,   0.004598885,    0.0384924,      -0.000108824766, 0.008705981,
        -0.016893592,   -0.0039808266,  -0.007901841,   -0.028762966,    0.012680162,
        0.0054428997,   -0.0027048353,  0.02820472,     -0.013730196,    0.011238026,
        0.03065037,     0.025240699,    0.009390498,    0.007057826,     -0.014142235,
        -0.017425254,   -0.019644946,   0.005283401,    0.015737224,     0.028098388,
        0.018555038,    0.022515927,    0.008705981,    -0.0022113856,   -0.0203494,
        -0.006659079,   0.00016375635,  0.0049378197,   -0.024549538,    -0.022914674,
        -0.018036665,   -0.025094492,   0.0227153,      -0.009629746,    0.022409594,
        0.00023156415,  0.0069182646,   0.030676953,    -0.024934994,    0.013876404,
        -0.0007862797,  -0.016614467,   0.0027164654,   -0.0067820256,   -0.012573829,
        -0.01932595,    0.012248185,    -0.014195401,   -0.016348636,    0.00823413,
        0.007230616,    0.0006766242,   -0.0048348103,  -0.02667619,     -0.024310289,
        -0.00046271292, -0.017584752,   -0.027726224,   -0.02574578,     0.017943624,
        0.033920098,    0.016734092,    -0.006951493,   0.0072904285,    -0.010573448,
        0.012620349,    0.017664501,    -0.014634023,   0.014221985,     0.037987318,
        0.011490566,    -0.005658888,   -0.008799022,   0.02134627,      0.008426858,
        -0.013650447,   0.018847452,    0.00017663256,  0.029241463,     0.0125206625,
        0.0060443436,   -0.016056221,   -0.014660606,   0.03134153,      0.0070910547,
        0.0575791,      0.0068783895,   -0.028124971,   0.0014462895,    -0.0078088,
        -0.01815629,    -0.1154772,     -0.0038778167,  -0.012028875,    0.013557406,
        -0.013484302,   0.008918647,    -0.0037714841,  0.048753493,     -0.02052219,
        0.011776335,    -0.0022030785,  -0.034425177,   0.020721564,     -0.008958521,
        0.00996868,     -0.009563288,   -0.016867008,   0.014966313,     -0.02355267,
        0.0039775036,   0.008380338,    -0.0023858375,  0.011703231,     -0.032803606,
        0.01612268,     -0.01055351,    -0.021891223,   0.007230616,     0.029507294,
        0.012866244,    -0.003914369,   -0.03080987,    0.030995952,     0.0021332977,
        0.010938966,    -0.028842716,   -0.01763792,    -0.016096096,    0.030012375,
        -0.05784493,    -0.014660606,   -0.004093805,   -0.0065760063,   -0.022236804,
        -0.010792758,   -0.02913513,    0.0017843938,   -0.009928806,    0.008719273,
        -0.03065037,    -0.04729142,    0.004213429,    -0.01646826,     -0.005575815,
        0.023353295,    0.009716141,    0.001732889,    0.005931365,     0.010241158,
        0.012168436,    0.009171186,    -0.0013657092,  -0.017358797,    -0.009084791,
        -0.017877167,   0.003276373,    -0.024669161,   0.0017461806,    0.008101215,
        -0.024974868,   0.0137966545,   0.023021007,    -0.011676648,    0.003774807,
        -0.035435338,   -0.011390879,   -0.0013083894,  -0.008214192,    0.025014743,
        -0.0053232755,  -0.02000382,    -0.018634787,   0.02178489,      -0.021558933,
        0.019113284,    0.012733328,    -0.0027064967,  0.008287297,     0.004878008,
        0.0019505385,   0.002390822,    0.0057220226,   -0.0013142044,   -0.027021771,
        -0.006399893,   0.011337712,    -0.0052900463,  -0.02236972,     0.0014778569,
        0.0016664311,   -0.039635476,   0.002789569,    -0.07278466,     0.04465969,
        -0.011696585,   -0.013271637,   0.0050375066,   0.009789244,     0.02591857,
        -0.016135972,   -0.0077689253,  -0.0034558093,  -0.013404553,    0.011065235,
        0.0076027806,   -0.009636391,   -0.01839554,    0.014022611,     0.018674662,
        -0.0034757466,  0.0117829805,   -0.00007606311, 0.011317776,     0.0016008039,
        0.009230998,    -0.01367703,    -0.00221637,    0.009908869,     0.007861966,
        0.027566725,    -0.022183638,   0.0025935185,   -0.00798159,     -0.00248054,
        -0.0068850354,  0.021745015,    0.0073834695,   -0.009962035,    0.0045656557,
        0.017172715,    -0.00055907684, 0.06911618,     -0.0067919944,   -0.021585517,
        0.018541746,    -0.02203743,    -0.009005042,   0.0077290502,    -0.0020585326,
        0.012447559,    0.02735406,     0.0069980137,   0.030995952,     0.03166053,
        -0.015059354,   0.019791154,    -0.0017096287,  -0.029427545,    0.042931784,
        0.00705118,     -0.0018093155,  -0.011397525,   0.027141394,     0.0057087312,
        0.026543275,    0.010938966,    -0.011331067,   0.006340081,     0.008141089,
        -0.007137575,   -0.010354136,   -0.034053013,   0.006655756,     -0.015630892,
        0.0018574975,   -0.010247803,   -0.010413948,   0.01992407,      0.014979605,
        0.011085173,    -0.017066382,   -0.015843557,   0.015165687,     -0.025453364,
        -0.036844242,   0.0006384109,   0.031633947,    0.024868535,     0.0017004908,
        0.028151555,    -0.023592545,   0.008971812,    -0.0066723702,   0.012148499,
        -0.0025536437,  0.016242303,    -0.020442441,   0.015630892,     -0.03333527,
        -0.0031982851,  0.018528454,    0.025267283,    -0.011683294,    -0.0043563135,
        0.004120388,    -0.0015908353,  -0.031447865,   -0.010247803,    -0.023180505,
        -0.03192636,    -0.02330013,    0.009084791,    0.032378275,     0.015910015,
        0.005080704,    0.005712054,    -0.0101747,     0.0046055303,    0.012301352,
        0.015351769,    -0.019910779,   0.023871668,    0.011497212,     0.012906118,
        0.015311893,    -0.006170613,   0.0015509606,   0.014474524,     0.01511252,
        0.005678825,    -0.015139103,   -0.013623863,   0.0053565046,    -0.017279046,
        -0.013145367,   -0.004522458,   -0.018063249,   0.005283401,     -0.017930334,
        0.016415095,    -0.039555725,   0.030411122,    0.0009121343,    0.007396761,
        0.012460851,    -0.011836147,   0.039954472,    0.0014521045,    0.032484606,
        -0.0064763194,  -0.015099228,   0.001609942,    -0.030357955,    -0.003911046,
        -0.015258728,   -0.016827133,   0.044819187,    0.0088521885,    0.007828738,
        0.009284165,    -0.0066690473,  0.025187533,    0.0013756779,    0.013451073,
        -0.005403025,   -0.018541746,   -0.019658238,   0.012779849,     0.007024597,
        -0.0134377815,  -0.021771599,   0.0017312275,   -0.005243526,    -0.014740356,
        -0.008805668,   0.0018940493,   0.013663738,    0.014408067,     -0.0052634636,
        0.00873921,     -0.03240486,    -0.021638682,   -0.0036784431,   0.005675502,
        -0.03317577,    0.0059945,      0.0034059659,   -0.0057020853,   -0.002105053,
        -0.014235276
    ],
    [
        -0.021402612,   -0.023307139,    0.00538062,     -0.011793412,    0.0108811045,
        0.016980916,    -0.01897867,     -0.011027606,   -0.006499362,    0.0040121577,
        0.017407104,    0.023160638,     0.017899884,    -0.023213912,    -0.0013909368,
        -0.029247131,   0.033136092,     -0.004278525,   -0.0006709127,   -0.03665214,
        0.0027768791,   0.011693525,     -0.001621511,   -0.016647957,    -0.0032297035,
        -0.0027519073,  0.028048478,     -0.010281778,   0.014770067,     -0.00047363437,
        -0.002004414,   0.013351661,     -0.020363782,   -0.015622443,    -0.013278411,
        0.01883217,     -0.0067157857,   -0.01663464,    0.00497108,      0.0008082583,
        0.007185258,    0.0034894117,    0.0081175435,   0.002981649,     -0.02061683,
        0.008137521,    0.0027086225,    -0.02435929,    -0.023586825,    0.012372761,
        -0.011460453,   0.011553682,     -0.03015278,    0.019604634,     -0.030818697,
        -0.04317814,    -0.021309385,    -0.008050952,   0.0066558532,    -0.026823187,
        0.0038423485,   -0.017140737,    -0.0029849787,  -0.0006571781,   -0.018059704,
        0.007917768,    -0.00040100765,  -0.007624764,   0.018858805,     0.0073717153,
        0.013371639,    0.018073022,     -0.0061397664,  0.012985406,     -0.00028010187,
        -0.024385927,   -0.017260602,    0.014224014,    -0.002135933,    0.008270705,
        0.008190795,    -0.035560034,    -0.003512719,   0.047226924,     0.03324264,
        0.013398276,    -0.023333777,    0.022694495,    0.007791244,     0.018379344,
        0.0074316477,   0.020656785,     -0.0051109227,  0.034920756,     -0.009109762,
        0.005953309,    -0.018139614,    -0.009262923,   -0.0211762,      -0.04440343,
        0.0027419184,   -0.008050952,    -0.0001492073,  -0.0055271215,   -0.0039555547,
        0.0024905344,   0.009129739,     -0.030845335,   0.019804409,     -0.0002328633,
        -0.020816606,   0.008423866,     0.018552482,    -0.008017656,    -0.009522631,
        -0.035586674,   0.019005308,     0.0038756444,   0.0026620084,    -0.00066633447,
        0.023919784,    -0.0017546946,   0.016115222,    -0.008290683,    0.013071976,
        0.016741185,    0.008030974,     -0.015462622,   0.00024347637,   -0.013218477,
        0.028394755,    0.0021942006,    0.020337144,    0.006339542,     -0.0053739604,
        0.016448181,    -0.021895392,    0.0041453415,   0.015662398,     -0.023653418,
        0.03529367,     0.009975456,     -0.007551513,   -0.012672424,    -0.035906315,
        0.018805532,    0.008150839,     -0.015103026,   0.01369128,      0.0028617838,
        0.016807778,    -0.011567,       0.008810098,    -0.028980764,    0.016155178,
        0.008483799,    0.015382712,     0.016794458,    0.016967598,     -0.0097756805,
        -0.0031497935,  0.014250651,     0.0078977905,   -0.03649232,     -0.007285146,
        0.026863143,    0.0028051806,    0.0073184418,   -0.0021625697,   -0.046161454,
        -0.0015699023,  0.037104964,     -0.014770067,   0.017393785,     0.012419376,
        0.010095321,    -0.00032338657,  0.013498164,    -0.031617798,    -0.015142982,
        0.0007645574,   0.0062130173,    0.019338267,    0.030259326,     -0.003642573,
        0.006615898,    -0.0017130747,   -0.03611941,    0.022801042,     -0.004065431,
        -0.00366588,    0.00086236413,   -0.011753458,   -0.014250651,    -0.65931237,
        0.0024422552,   0.004128693,     -0.0079044495,  0.0033129435,    0.013584733,
        0.030499056,    -0.004814589,    -0.009895545,   0.0011878317,    -0.0064494186,
        0.0060731745,   0.009682451,     0.008383911,    -0.029220494,    -0.013105271,
        0.0019577998,   -0.031724345,    -0.012366102,   0.021775527,     -0.013271751,
        0.023027454,    -0.006852299,    -0.011307293,   -0.00472469,     0.00448163,
        0.018725622,    -0.006525999,    -0.0035959587,  0.0034011775,    -0.02657014,
        0.04448334,     -0.00382903,     0.018099658,    0.053007096,     -0.016275043,
        -0.03201735,    -0.0018129625,   0.0077446294,   0.03649232,      -0.019831046,
        0.025970813,    0.005157537,     -0.0078977905,  0.0031231567,    0.015289484,
        0.014690157,    0.00024160347,   0.0070387563,   0.0070121195,    -0.00081907946,
        -0.017340511,   -0.020057458,    0.0054305634,   -0.028634485,    0.026796551,
        0.03862326,     0.011640252,     -0.0021559105,  -0.0014125791,   0.00896326,
        -0.0012860546,  -0.00070462475,  0.02956677,     -0.016368272,    0.039422363,
        -0.0006542647,  0.0290074,       0.011293974,    -0.041260295,    0.021882074,
        0.005979946,    -0.0025105118,   0.0050509903,   -0.007112007,    0.024905343,
        0.005437223,    -0.015662398,    -0.006289598,   -0.0011795077,   -0.0034727638,
        -0.0021725583,  0.008397229,     0.015342757,    -0.008350615,    -0.020843241,
        -0.04946441,    0.02241481,      0.013877736,    -0.0052407766,   0.004425027,
        0.035480127,    -0.019245038,    -0.010781216,   0.009163035,     0.017780017,
        0.007964383,    0.0053872787,    0.01018855,     -0.03529367,     -0.0051775146,
        -0.012485968,   0.0022091838,    -0.014463745,   -0.009948819,    -0.0006908902,
        -0.03438802,    0.012392739,     0.048185848,    -0.013105271,    -0.024425883,
        -0.02068342,    0.0011994853,    -0.0031664413,  -0.027076237,    -0.024572384,
        0.018539164,    0.018925397,     0.025797674,    -0.018632393,    0.027835384,
        0.012366102,    0.016568046,     -0.017207328,   0.010528168,     0.0197245,
        0.0022907588,   -0.015103026,    -0.027182784,   0.0023357084,    0.0014317243,
        0.002403965,    0.004088738,     0.0011312286,   0.026623413,     0.0001550341,
        0.003845678,    0.008104226,     0.032896362,    0.0045915064,    -0.031431343,
        -0.0002671997,  0.0071186665,    0.0011786753,   -0.008736848,    -0.021136247,
        -0.026783234,   -0.012625811,    -0.044509977,   -0.0009872238,   -0.023759965,
        -0.027076237,   -0.00047862876,  0.015222891,    0.0031514582,    -0.011600296,
        0.021655662,    -0.011134153,    -0.01718069,    -0.02738256,     0.012639129,
        0.010255141,    -0.016994234,    -0.004221922,   0.014916569,     0.007791244,
        0.009842272,    0.007917768,     -0.00011788835, -0.032363627,    -0.011860005,
        -0.046987195,   0.0067324336,    0.0052041514,   0.02461234,      -0.00831732,
        0.008830076,    -0.007398352,    -0.024492474,   -0.009595882,    0.0049244654,
        -0.032656632,   -0.00961586,     -0.015755625,   0.019950911,     0.021535797,
        0.029620044,    0.001906191,     -0.017713426,   0.006059856,     -0.013704598,
        0.0029516828,   -0.0020643466,   -0.014117467,   -0.0039222585,   -0.020590194,
        -0.013558096,   0.0171141,       -0.005427234,   0.022401491,     0.01792652,
        0.00079452374,  0.0113206105,    -0.0018229512,  0.022374853,     -0.007891132,
        -0.00093395036, -0.015262847,    0.052421086,    0.0037857455,    0.014956525,
        0.011853346,    -0.003136475,    -0.012106394,   0.018778896,     0.0067624003,
        -0.00074666087, 0.003878974,     -0.01923172,    0.0004607322,    0.008597005,
        -0.005956639,   -0.009256264,    0.0031964078,   -0.014277288,    0.010235163,
        0.01507639,     0.020483647,     0.020363782,    -0.021735573,    -0.010847809,
        0.0033179377,   -0.0101019805,   0.023240548,    -0.0066591827,   -0.028527938,
        0.0063695083,   -0.01947145,     0.009176354,    0.018232843,     0.01783329,
        -0.013058658,   0.025597898,     -0.025411442,   -0.0008032639,   0.010927719,
        0.0145303365,   0.027888658,     -0.028474666,   0.009629178,     -0.016488137,
        -0.009049829,   -0.030658877,    -0.0011428823,  0.008304001,     -0.0073184418,
        0.02762229,     -0.00994216,     0.020923153,    0.026303772,     -0.0010946032,
        -0.03374874,    0.024399245,     0.0018712303,   0.029833138,     0.014570292,
        0.027182784,    0.016341634,     0.007937746,    -0.009509313,    0.021415932,
        -0.012625811,   0.024745522,     -0.030605603,   0.02427938,      0.003267994,
        0.00399551,     0.008357274,     0.009795657,    0.01963127,      -0.0059366613,
        -0.030339237,   0.0025271599,    0.0218288,      0.016967598,     -0.03281645,
        -0.008863372,   0.013378298,     -0.003765768,   0.03699842,      0.0025687797,
        -0.0005826785,  0.00079618854,   -0.01743374,    -0.018232843,    -0.0107678985,
        0.009429403,    -0.011919937,    0.04277859,     -0.032230444,    -0.005696931,
        0.022787724,    0.002600411,     -0.025078483,   0.017167373,     -0.006559295,
        0.012106394,    -0.0027219409,   0.024745522,    -0.010468235,    0.014117467,
        -0.004348446,   -0.020443691,    -0.012459331,   -0.03308282,     -0.007644742,
        -0.03233699,    0.00062596315,   0.025864266,    -0.031671073,    0.0057668523,
        0.003349569,    0.0026436956,    -0.013877736,   0.11219391,      0.018006431,
        0.017487014,    -0.0018046385,   0.0097756805,   0.005820126,     -0.0038889628,
        -0.026610095,   0.022801042,     0.0051941625,   -0.005104264,    -0.021708935,
        -0.01612854,    0.0063828267,    0.0069455276,   -0.0074116704,   -0.018765576,
        -0.003029928,   0.001956135,     -0.0070520747,  0.0036392433,    -0.0042585474,
        0.039076082,    0.029753229,     -0.02876767,    -0.00081741466,  -0.0044017197,
        0.007731311,    0.0052774022,    -0.02395974,    -0.0023889819,   -0.0020427043,
        0.017060826,    0.002347362,     0.0021559105,   0.010361688,     0.017327193,
        -0.00554044,    0.011507068,     0.0040387944,   0.012186305,     0.03316273,
        0.006689149,    -0.014929888,    0.025065163,    -0.012093076,    0.006805685,
        0.012292852,    0.0015174613,    -0.013904373,   0.07143971,      -0.005334005,
        -0.026650049,   -0.024998572,    0.03281645,     0.005670294,     -0.0039522247,
        -0.018885443,   0.016807778,     0.02836812,     0.0009855591,    -0.02892749,
        -0.010055366,   -0.005350653,    0.014730113,    -0.032789815,    0.008603664,
        0.0018395992,   -0.022960862,    -0.02754238,    -0.005840103,    -0.018765576,
        0.011293974,    0.0003469018,    0.012419376,    0.006529329,     0.009515972,
        -0.021003062,   -0.0026187235,   0.008690233,    0.004042124,     -0.028874217,
        -0.030339237,   -0.018112976,    -0.016647957,   0.00035938778,   0.00025866763,
        -0.012153008,   0.012006506,     0.0024955287,   0.03252345,      0.008304001,
        -0.0023673396,  0.019085217,     0.007618105,    -0.0042652064,   0.019671226,
        0.017167373,    -0.007771266,    -0.0012627476,  0.008090907,     -0.027835384,
        -0.01246599,    -0.005680283,    -0.004335128,   -0.0034011775,   0.006346201,
        0.003625925,    -0.034574475,    -0.0081242025,  0.006406134,     -0.0133117065,
        0.012905496,    -0.00554044,     0.025051845,    0.013265092,     0.031617798,
        0.011793412,    -0.004504937,    0.011806731,    -0.015795581,    -0.030126143,
        0.023120683,    0.004837896,     0.012239578,    0.019657908,     0.016341634,
        -0.016035313,   -0.017660152,    0.009848931,    -0.015462622,    -0.0025954165,
        0.0077779256,   -0.009342833,    -0.026410319,   -0.0063695083,   -0.02502521,
        0.00562035,     -0.015422667,    0.0006018236,   -0.031005155,    0.026663367,
        0.010201868,    -0.027169466,    -0.025224984,   -0.024266062,    -0.009276241,
        -0.0057568634,  -0.016927643,    -0.004048783,   0.012905496,     0.015835537,
        -0.015089708,   0.0055038147,    -0.012659106,   -0.0436576,      -0.007864495,
        -0.007571491,   0.023280503,     -0.004471641,   0.013598051,     0.008909986,
        0.025757719,    0.01849921,      -0.015103026,   -0.005513803,    -0.022960862,
        0.012392739,    -0.04570863,     0.037025057,    0.005770182,     0.012572537,
        0.0015798911,   0.009269582,     -0.005973287,   0.011806731,     -0.00085986697,
        -0.01173348,    -0.021549115,    -0.026370363,   0.0013584733,    0.013005384,
        -0.010454917,   -0.017300557,    -0.013125249,   -0.00051733525,  0.015342757,
        0.003307949,    0.004757986,     0.0008540402,   0.021895392,     -0.006649194,
        -0.027302649,   -0.01507639,     -0.007964383,   -0.005257425,    -0.0021892064,
        0.006825662,    0.020243915,     0.02647691,     -0.001703086,    -0.0063828267,
        -0.0047080424,  -0.0035293668,   -0.013085294,   0.023573507,     -0.026210543,
        -0.0039422363,  0.003675869,     -0.01663464,    -0.027116193,    -0.022281626,
        -0.0141973775,  -0.058227893,    -0.005916684,   -0.0018395992,   0.022508038,
        0.01703419,     -0.011333929,    -0.03739797,    0.0037790863,    0.010488213,
        0.03308282,     -0.0039422363,   0.04317814,     0.00062887656,   -0.018552482,
        -0.0047280197,  0.025784355,     0.0037025055,   0.017660152,     0.0054338933,
        0.018232843,    -0.011720162,    0.0073850336,   -0.020203961,    0.021056335,
        -0.023240548,   -0.030019596,    0.0277022,      0.0022474742,    0.00798436,
        -0.014144104,   -0.021375977,    -0.005467189,   -0.008510436,    -0.01662132,
        -0.02387983,    -0.011287315,    -0.013877736,   -0.025238302,    -0.017566925,
        -0.0223349,     0.012019825,     -0.0007541524,  -0.012565878,    0.007444966,
        -0.0018262808,  -0.021162882,    0.0027652257,   0.0005031845,    0.024412563,
        -0.0059599685,  -0.000043830947, -0.00969577,    -0.029060673,    0.0056902715,
        0.008403889,    0.008836735,     0.029806502,    0.00017948578,   0.023733327,
        -0.0052740728,  -0.0059999237,   0.00087817974,  -0.012745676,    -0.012692402,
        0.0024838753,   -0.01369128,     -0.001584053,   0.010201868,     0.009109762,
        -0.014823341,   -0.03878308,     -0.023360413,   -0.038862992,    -0.016368272,
        -0.022294944,   -0.0033512337,   -0.019005308,   -0.010062025,    -0.01703419,
        -0.012719039,   0.009808976,     0.008184136,    -0.009462698,    0.01996423,
        0.024306016,    -0.00782454,     0.0074183294,   0.004814589,     -0.015049753,
        -0.021722253,   -0.004271866,    0.01213969,     0.010042047,     0.012938792,
        -0.032177173,   0.0054139155,    -0.022201715,   -0.00863696,     0.013784508,
        -0.0023856522,  0.007571491,     0.027755473,    -0.00782454,     -0.0020476987,
        -0.0041520004,  -0.0066591827,   -0.0073916926,  0.0061331075,    0.008330638,
        0.035453487,    -0.008430526,    -0.013265092,   0.007291805,     0.021322703,
        0.0134249125,   -0.01622177,     -0.020963106,   -0.008710211,    -0.005763523,
        -0.014756748,   -0.02818166,     -0.03284309,    -0.02338705,     -0.022308262,
        0.022947544,    0.00920965,      -0.017913202,   0.018112976,     0.03055233,
        0.026583457,    0.013618029,     0.003602618,    -0.020243915,    -0.0022508039,
        -0.012532582,   -0.0039522247,   -0.021935347,   0.017393785,     0.033029545,
        0.013744554,    -0.0031464638,   -0.02687646,    -0.0054305634,   -0.032230444,
        -0.005324017,   -0.029034037,    0.01817957,     0.03486748,      0.005314028,
        0.0063495305,   0.02786202,      0.010481553,    0.0054904963,    -0.032070626,
        -0.005390608,   0.028554576,     -0.034760933,   -0.00480793,     0.012106394,
        -0.020829923,   -0.0043051615,   0.007218554,    -0.0033445745,   -0.0015690699,
        0.013025361,    0.004042124,     -0.000998045,   -0.01409083,     0.0073650563,
        -0.01612854,    0.014490382,     0.003592629,    -0.009922182,    0.0051841736,
        0.0129787475,   0.020550238,     -0.0047846227,  0.02297418,      -0.00936947,
        0.01409083,     0.004824578,     -0.016235087,   -0.0055870544,   -0.0008989897,
        -0.029540135,   0.027835384,     0.014983161,    0.0042685363,    0.016275043,
        0.0015182936,   -0.007358397,    -0.022534674,   0.005793489,     0.00067632325,
        0.0014700146,   0.025677808,     0.011527046,    0.0032363627,    -0.0025304893,
        0.013877736,    -0.021442568,    -0.0072118947,  0.017247284,     -0.026996328,
        -0.043630965,   0.019657908,     0.009396107,    -0.0062196767,   0.0024139537,
        0.011953233,    -0.007851176,    0.0021725583,   0.00080284773,   -0.002265787,
        -0.008723529,   -0.0057169083,   0.024079604,    -0.019751135,    -0.024945298,
        0.0028268232,   0.008510436,     -0.0134249125,  0.02932704,      0.22033904,
        -0.01059476,    -0.0012927138,   0.02623718,     -0.010954356,    -0.005580395,
        0.0026403659,   0.0062196767,    -0.020510282,   0.014783385,     0.007531536,
        -0.009575904,   -0.0038490077,   0.0016223434,   -0.0025404783,   -0.017740063,
        -0.020390417,   0.002851795,     -0.0018346049,  -0.03055233,     -0.0020410395,
        -0.0056536463,  0.003307949,     -0.00765806,    0.03087197,      -0.021908712,
        0.025238302,    -0.009895545,    0.011360566,    0.014024239,     -0.013571414,
        -0.020750014,   0.017819973,     0.0009006545,   -0.011200746,    -0.0018445936,
        0.006289598,    0.0067024673,    0.010734603,    0.0141973775,    0.007771266,
        -0.0032163851,  -0.0043151504,   0.014357198,    -0.021242794,    0.03406838,
        -0.0011220723,  -0.00781788,     0.012932133,    0.012153008,     -0.050716337,
        -0.0023573507,  0.008783462,     0.01759356,     -0.01703419,     0.015023116,
        0.014823341,    -0.0036059474,   -0.014170741,   0.002533819,     -0.011700184,
        0.028581211,    -0.0078112213,   0.0074516255,   -0.0040387944,   0.014716794,
        -0.01988432,    0.026676686,     0.008363933,    -0.000855705,    -0.023453642,
        -0.012232918,   -0.011280656,    0.0036159363,   -0.0058800583,   -0.022441445,
        0.019444814,    -0.002738589,    0.03276318,     0.0005785165,    0.0010096986,
        -0.020057458,   0.0078112213,    0.012346125,    -0.001776337,    -0.002958342,
        0.035453487,    0.011586978,     0.011993188,    0.0060898224,    -0.0072318725,
        -0.021216156,   -0.003251346,    0.014810022,    0.009769021,     0.029779864,
        0.008190795,    0.0034095016,    -0.0031031792,  -0.0056603053,   -0.012186305,
        -0.022960862,   0.032150533,     -0.013957647,   0.0020243914,    -0.015835537,
        -0.00016086089, 0.020443691,     0.013957647,    -0.024412563,    -0.015462622,
        -0.017780017,   0.013258433,     -0.016581366,   0.0046647573,    0.02778211,
        0.0039788615,   0.0031381398,    -0.0019827716,  -0.023187274,    -0.0006488541,
        -0.023134,      -0.0030265986,   -0.006938868,   -0.0009539279,   -0.026383681,
        0.0011537034,   0.006805685,     0.015422667,    -0.018272797,    0.017460378,
        -0.009542609,   -0.019524723,    0.01572899,     0.008130862,     -0.006019901,
        0.011187427,    -0.020297188,    0.015742308,    -0.004092068,    0.015875492,
        -0.0065326584,  0.014956525,     0.018592438,    0.022907589,     -0.02354687,
        0.0018679007,   0.009342833,     -0.017780017,   0.005100934,     -0.009083125,
        -0.03300291,    -0.0016889352,   0.0076980153,   0.00799102,      -0.010315074,
        -0.0052441065,  -0.008923305,    0.0027835383,   -0.0049444432,   -0.039875187,
        0.0067657297,   0.009895545,     -0.035826404,   -0.0070187785,   -0.0057801707,
        -0.17036854,    0.01662132,      0.0030499056,   -0.01897867,     0.027276013,
        0.0033762057,   0.029726591,     -0.02184212,    -0.011007629,    0.011693525,
        0.0072984644,   -0.00029113115,  -0.017393785,   -0.018592438,    0.00045240822,
        -0.012639129,   0.0015615784,    -0.0010787876,  0.009216309,     -0.012272874,
        0.006625887,    -0.015262847,    0.0046314616,   0.00047987734,   -0.0013210154,
        0.00025929193,  -0.012705721,    -0.013551436,   0.016181814,     -0.010747921,
        -0.0027569016,  -0.02411956,     0.0136380065,   -0.00084363524,  0.004311821,
        -0.015808899,   -0.014836659,    -0.019990867,   -0.02615727,     0.020496964,
        0.005670294,    0.03382865,      0.0050509903,   -0.017566925,    0.01628836,
        0.031830892,    -0.015489259,    0.0063262237,   0.0036791984,    0.003925588,
        0.0037524495,   -0.031564526,    -0.0055604177,  -0.010721284,    -0.00078828074,
        0.013138567,    0.016035313,     0.004441675,    0.016368272,     -0.0064261113,
        0.0063595194,   -0.02158907,     0.0043884013,   -0.022947544,    -0.01663464,
        -0.005493826,   -0.019751135,    0.011640252,    -0.03920927,     0.02615727,
        -0.017979793,   0.0027752144,    0.0004249391,   -0.02004414,     0.009868909,
        0.026956372,    -0.011846686,    -0.008616982,   0.0012186305,    0.00094560394,
        -0.015063072,   0.037584428,     -0.02273445,    -0.011753458,    0.015396031,
        0.0105881,      0.01988432,      -0.01719401,    -0.0177667,      -0.023014136,
        0.0072585093,   -0.03822371,     -0.016408226,   -0.026423637,    -0.011447135,
        0.015542532,    -0.011513727,    0.0014533666,   0.0134249125,    -0.00021267765,
        -0.01857912,    0.0063928156,    -0.0059433207,  -0.0031398046,   0.028847579,
        0.028714396,    0.02696969,      0.016754504,    0.031644437,     -0.013731235,
        0.005044331,    0.0018962023,    0.0009855591,   0.041526664,     -0.0062696207,
        0.032629997,    -0.009422744,    -0.01050819,    0.018685667,     -0.0010721284,
        0.05314028,     -0.007791244,    -0.035267033,   0.0031081736,    -0.02192203,
        -0.009982115,   -0.10010084,     -0.0033911888,  0.010082003,     0.036305863,
        -0.025677808,   -0.00016221353,  0.016821096,    0.0030415817,    -0.021549115,
        0.023759965,    -0.0016148518,   -0.019271675,   0.021136247,     -0.0040054983,
        0.048585396,    -0.026650049,    -0.0011894965,  0.0025704445,    -0.0017397115,
        0.026530184,    -0.010521509,    0.02722274,     0.00798436,      -0.018099658,
        -0.011014288,   0.0018928727,    -0.03382865,    0.01889876,      0.008357274,
        0.01848589,     0.010401644,     -0.0039722025,  0.018459255,     -0.0033179377,
        -0.022534674,   -0.008530413,    -0.030925244,   0.0257444,       0.022055212,
        -0.04384406,    -0.023320457,    0.00399551,     0.020670103,     -0.015116345,
        -0.00052565924, -0.016088586,    -0.031005155,   0.018512528,     -0.0044017197,
        -0.027302649,   -0.030925244,    -0.015475941,   -0.03071215,     0.0030765424,
        0.053593103,    -0.0055670766,   0.0081175435,   0.009855591,     0.004441675,
        0.025611216,    -0.008916645,    0.00082407385,  -0.029620044,    -0.004032135,
        -0.0022907588,  0.004474971,     -0.0197245,     0.0098888865,    0.016168496,
        -0.017127417,   0.0042685363,    0.007757948,    -0.013391617,    -0.0068323216,
        -0.027435834,   0.005437223,     -0.00028759346, -0.01612854,     0.010095321,
        -0.01865903,    -0.013484845,    -0.021549115,   0.006958846,     -0.0136380065,
        0.0028418063,   0.0025704445,    -0.0023856522,  -0.030445782,    0.010827831,
        -0.00081907946, 0.01604863,      0.010721284,    -0.03649232,     -0.015009798,
        -0.019165128,   0.015902128,     -0.0067657297,  -0.01377119,     -0.006812344,
        0.0039988393,   -0.017806655,    -0.01768679,    -0.061157934,    0.008044293,
        0.024892025,    -0.011187427,    -0.0075981277,  -0.000077673125, 0.013624688,
        0.00684564,     0.004618143,     -0.0145303365,  -0.005104264,    0.02372001,
        0.02598413,     0.019977547,     -0.016847732,   0.0046081543,    0.006499362,
        0.0027569016,   0.022281626,     0.017606879,    -0.016408226,    0.0113272695,
        0.0071186665,   0.017633516,     0.019524723,    0.000008447538,  0.0032413572,
        0.009549268,    -0.005084286,    -0.001433389,   0.014743431,     -0.019245038,
        -0.0041053863,  -0.0012818926,   0.015928766,    -0.014317242,    -0.013591392,
        0.018019749,    -0.0044216975,   0.0449628,      -0.026463592,    -0.016754504,
        0.013757871,    -0.019165128,    -0.011933255,   0.017886564,     -0.00936947,
        0.013384957,    0.04954432,      -0.0006084828,  0.021442568,     0.019191764,
        -0.026343727,   -0.0009622519,   -0.013032021,   0.014037557,     0.0363325,
        0.00053023745,  -0.008949942,    -0.0038423485,  0.022707812,     -0.019804409,
        0.015928766,    0.027355922,     0.019657908,    -0.0038423485,   -0.008210773,
        0.0033146082,   0.022880951,     -0.011447135,   0.0055870544,    -0.004165319,
        -0.0008203281,  0.009489335,     -0.019045262,   0.035453487,     -0.0052274587,
        0.0026936394,   -0.008004338,    0.005983276,    0.0059666275,    -0.011473772,
        -0.048771854,   -0.018232843,    0.0216823,      -0.0065060216,   0.0052241287,
        0.026277134,    0.016741185,     0.016821096,    -0.01588881,     0.013218477,
        -0.0010388325,  -0.0065393173,   0.014916569,    0.015848855,     -0.023320457,
        -0.008270705,   0.021948665,     0.008150839,    -0.0078112213,   -0.018512528,
        -0.014397153,   -0.025837628,    -0.020563556,   0.0025687797,    -0.00023889818,
        -0.030339237,   0.007438307,     0.009242945,    0.029859776,     0.013957647,
        0.012013165,    0.009735725,     0.012246237,    -0.0067257746,   0.0067091268,
        -0.005590384,   -0.03388192,     0.038490076,    -0.004817919,    -0.0010621396,
        -0.0018728952,  -0.00994216,     0.010941037,    0.0145303365,    0.020670103,
        -0.022188397,   -0.027262693,    -0.023733327,   0.027675563,     0.012446012,
        -0.042805225,   0.009103103,     0.014650202,    -0.0109943105,   -0.004701383,
        0.02053692,     -0.012479308,    0.03151125,     -0.004578188,    0.0025604558,
        0.018912079,    -0.026303772,    0.0031264862,   -0.0053173574,   0.02362678,
        -0.038303617,   -0.024319336,    -0.0045848475,  -0.021402612,    0.017420422,
        -0.0012818926,  -0.015369394,    0.016181814,    -0.0076314234,   -0.004854544,
        -0.0046248026,  -0.0071519623,   0.0149698425,   0.006086493,     0.02754238,
        -0.0060731745,  -0.010355029,    0.014024239,    0.03308282,      0.011527046,
        -0.011680206,   -0.011713502,    -0.0012169656,  -0.0057835,      -0.013058658,
        -0.010281778,   0.006176392,     0.006396145,    0.012505945,     -0.00087485014,
        0.016168496,    0.0024955287,    0.002127609,    0.016261725,     0.008423866,
        -0.016368272,   -0.0024589032,   0.0017497003,   -0.0065393173,   -0.0071519623,
        -0.015222891
    ],
    [
        -0.008296754,    0.0034882557,     -0.0012540631,   -0.016928595,    -0.018121505,
        0.0017508295,    0.0061689513,     -0.0094360495,   -0.0139932325,   0.009509768,
        0.0027745203,    0.017035823,      0.012686393,     -0.0072512827,   0.0041919383,
        -0.00705023,     0.04026405,       0.0012423351,    0.0033525454,    0.016888384,
        -0.0077606146,   0.02133834,       0.037529744,     -0.0069765113,   0.005227357,
        -0.0057534436,   0.013738567,      -0.034580976,    -0.0011761553,   0.00019403631,
        0.012967867,     -0.011165098,     -0.0048219017,   -0.004329324,    -0.015320177,
        -0.0051603396,   -0.0073048966,    -0.004021044,    0.0074322294,    -0.011218713,
        0.024220088,     0.0017558559,     0.014288109,     -0.004868814,    -0.0061521973,
        -0.0063264426,   0.0031297125,     -0.021579603,    -0.031015651,    0.00059268513,
        0.018469995,     0.016499683,      -0.030184636,    0.003893711,     -0.011232116,
        -0.01621821,     -0.0094025405,    -0.0006530008,   0.020601148,     -0.007365212,
        0.015105722,     -0.0147706345,    -0.016513087,    0.005492076,     0.014180881,
        0.008631841,     -0.019126765,     0.022799319,     0.0028314851,    0.013886005,
        0.033213824,     0.00081551797,    0.0012314447,    -0.039272197,    0.016419262,
        0.005257515,     -0.034312908,     0.0026036259,    0.011346046,     -0.0006039943,
        0.033187017,     -0.03163221,      -0.010025803,    0.019676307,     0.029460847,
        -0.018242136,    -0.008390578,     0.02970211,      0.0011728045,    -0.0023020476,
        -0.022249777,    -0.0064973366,    -0.0023389072,   0.022021918,     -0.019609291,
        0.042703487,     0.0030610196,     0.016901787,     -0.011486782,    -0.04522334,
        -0.009797944,    0.0036356938,     -0.025185138,    -0.017009016,    0.013276147,
        0.00028126364,   0.012311096,      0.003632343,     0.021981707,     0.00058807764,
        -0.009690716,    0.017250279,      0.0023355563,    -0.04610797,     0.0012172034,
        -0.014650003,    0.014931477,      0.01051503,      0.018094698,     -0.01979694,
        0.025721278,     -0.0025315823,    0.013430286,     0.0010010723,    0.0037161147,
        0.04752874,      -0.02222297,      -0.01753175,     -0.000052017018, -0.0059578465,
        0.0094025405,    -0.0026438364,    0.03559964,      0.025292367,     -0.035117116,
        0.017813224,     -0.0058104084,    -0.00090389716,  -0.017893646,    -0.015145932,
        0.015186142,     0.018778276,      -0.027061624,    0.010615556,     -0.036377043,
        0.013557619,     0.012264184,      0.01918038,      0.010649065,     -0.0033642733,
        0.007552861,     -0.01047482,      0.008980331,     0.0017122945,    0.023027178,
        0.018617433,     -0.0018614082,    0.027450327,     -0.02715545,     0.009677312,
        0.022785915,     -0.020011395,     -0.0103474865,   -0.018630836,    0.017076032,
        0.021968303,     -0.009295313,     -0.00824314,     0.025480015,     -0.019729922,
        -0.0033173612,   0.03648427,       -0.020560937,    0.026297627,     -0.016807964,
        0.027718395,     0.0035150626,     0.022772511,     -0.011104783,    -0.010615556,
        -0.0113929575,   0.026096575,      0.01313541,      -0.005639514,    0.0029990287,
        0.005639514,     0.008611736,      -0.011305835,    0.0111718,       -0.018885503,
        0.01136615,      -0.013229234,     -0.024555175,    -0.024783034,    -0.66995955,
        -0.030104214,    -0.003863553,     -0.002668968,    0.02526556,      0.031685825,
        0.020091817,     -0.027959658,     0.0030090811,    0.013979829,     0.009931979,
        0.018939117,     0.0006019,        -0.0086921565,   -0.006594512,    -0.030801196,
        0.0073786154,    -0.036457464,     -0.0016436017,   0.0019032941,    -0.028281342,
        0.018965924,     -0.018268943,     0.0020775395,    -0.017424524,    -0.008946823,
        0.034956276,     -0.008538016,     -0.02715545,     -0.00038828206,  -0.017652383,
        0.01852361,      0.0077941236,     0.015923334,     0.050048593,     -0.009033945,
        -0.023563318,    0.019636098,      -0.013738567,    0.01059545,      -0.010153136,
        -0.0005357203,   0.0010538485,     -0.016124386,    -0.009054051,    0.0043661837,
        0.01020675,      -0.018805081,     0.01952887,      -0.017732803,    0.014475758,
        0.032838523,     -0.0030040548,    0.017344102,     0.004758235,     0.017665787,
        0.026096575,     -0.011399659,     0.02111048,      -0.010756292,    -0.008826192,
        0.005043059,     -0.023952018,     -0.0056294613,   -0.011024362,    0.034152064,
        -0.010307276,    0.01841638,       0.018201925,     -0.02222297,     0.01868445,
        0.032007508,     -0.008739069,     -0.0006031566,   -0.008377175,    0.0024863454,
        0.009462857,     -0.008290052,     -0.011198607,    0.018671047,     -0.0052910238,
        -0.021928092,    -0.008182825,     0.002084241,     0.012378113,     -0.031042458,
        -0.024313912,    -0.027557554,     -0.0048219017,   0.0031364143,    0.0111583965,
        0.019863958,     -0.01806789,      -0.012103342,    -0.006313039,    0.018617433,
        -0.008913314,    0.0023472845,     -0.013175621,    -0.008028684,    -0.000020524078,
        -0.01525316,     -0.000116338015,  0.027182257,     0.0025717926,    0.007774018,
        -0.004795095,    -0.0060483203,    0.059350606,     -0.0014484135,   -0.00951647,
        0.0018329258,    0.0068625817,     0.010789801,     -0.004453306,    -0.018322557,
        0.010327381,     -0.004691218,     0.009657207,     -0.04278391,     0.010950643,
        -0.007083739,    0.010320679,      -0.0027795467,   0.010045908,     -0.0029705463,
        -0.0020457061,   -0.024179878,     -0.03340147,     -0.01586972,     -0.010273767,
        0.016566701,     0.0051368834,     -0.0044834637,   -0.0032335895,   -0.0054183565,
        -0.0010211776,   -0.026793556,     -0.0012942735,   -0.00033927558,  -0.01375197,
        0.0058338647,    0.024662403,      0.005669672,     -0.019502062,    -0.02676675,
        -0.0032268877,   -0.0055959527,    -0.038467985,    -0.0031029056,   0.004269008,
        -0.014475758,    -0.018697854,     0.01221057,      0.0128807435,    0.0018446539,
        -0.0037194656,   -0.026029557,     -0.015159335,    -0.002858292,    0.018939117,
        0.036108974,     -0.0005512181,    0.0018748117,    -0.012920954,    -0.016740946,
        0.014221092,     0.02322823,       -0.025278963,    -0.030131022,    0.003027511,
        -0.024608789,    -0.03184667,      0.007995175,     -0.007398721,    0.0016293605,
        -0.010769696,    -0.009730926,     0.004500218,     -0.007150756,    -0.0094695585,
        0.0087256655,    -0.0019920922,    -0.0049291295,   0.01741112,      -0.008089,
        0.045303762,     0.008987033,      0.011098081,     0.036430657,     -0.0075126505,
        0.048386563,     0.025801698,      0.0018764872,    -0.00171397,     -0.0024863454,
        -0.008866401,    -0.0025801698,    0.03474182,      0.028576218,     0.012156956,
        -0.0031715983,   0.027436923,      -0.015963545,    0.038548406,     -0.020976445,
        -0.0020775395,   -0.016164597,     0.0064470735,    -0.010159837,    -0.010856818,
        -0.014180881,    0.0035619747,     -0.009449453,    -0.00018785814,  0.003843448,
        -0.009355629,    -0.0005742553,    -0.024649,       -0.0095700845,   0.01324934,
        -0.016231613,    -0.007954965,     -0.008564823,    -0.009268506,    0.042944748,
        0.0016385753,    0.027718395,      0.00039456494,   -0.028066887,    0.010387696,
        -0.007753913,    0.0122038685,     0.0020155483,    0.013162217,     -0.014502565,
        -0.010736187,    -0.013939619,     0.0029990287,    0.014207688,     -0.007392019,
        0.010106224,     0.032302387,      -0.014824249,    0.02423349,      0.009751031,
        0.030828003,     0.018309154,      -0.014073653,    0.020547533,     -0.040666156,
        -0.00082305743,  -0.007673492,     0.022008514,     0.025506822,     -0.0077606146,
        0.018134909,     0.020279465,      0.026753346,     0.024850052,     0.006001408,
        -0.0007757264,   0.008196228,      0.009509768,     0.010830011,     0.00042681705,
        0.025359383,     0.0049056737,     -0.00008623254,  -0.010394398,    0.0058539696,
        -0.0044834637,   0.0010077741,     -0.042167347,    0.028844288,     -0.015159335,
        -0.009429348,    0.023965422,      0.007599773,     -0.00466106,     -0.007673492,
        -0.014569582,    0.0122038685,     0.01113159,      0.0054686195,    -0.0015908255,
        -0.02072178,     0.009462857,      -0.025211945,    0.0013018129,    -0.02758436,
        0.03782462,      0.006269478,      0.015454212,     -0.018054487,    -0.026109979,
        0.033213824,     0.0037965355,     0.018845292,     -0.030720776,    -0.0033994575,
        0.029594883,     0.00701002,       -0.0069765113,   0.01294106,      0.006309688,
        -0.0073786154,   -0.0035318169,    0.00039665922,   -0.020078413,    0.010722783,
        0.005666321,     0.013054989,      -0.0038803073,   0.019408239,     0.0030878265,
        -0.015521229,    0.009348927,      0.020788796,     -0.00022995345,  0.008028684,
        -0.01298127,     -0.009134471,     0.008732367,     0.08615757,      0.040934227,
        0.00074640627,   0.0015011897,     0.01806789,      0.009080857,     -0.0041416753,
        -0.01798747,     0.0011635895,     -0.030667162,    -0.0047850423,   -0.014690214,
        0.017933855,     0.003454747,      0.014194285,     0.00013895638,   -0.007445633,
        -0.0023238282,   -0.009047349,     -0.03208793,     -0.007733808,    0.010079416,
        -0.0074054226,   0.0050698663,     -0.008444192,    -0.012545657,    -0.0060181622,
        0.022893144,     -0.027383309,     -0.029300006,    -0.008229736,    -0.0024578632,
        0.010253662,     0.0026522134,     -0.00004526292,  -0.018805081,    -0.014582986,
        0.013128708,     0.017049227,      0.010133031,     0.00007947844,   0.016915191,
        0.021324936,     -0.024019035,     0.009791242,     0.00901384,      0.0084575955,
        0.010407802,     -0.026512083,     -0.020520728,    0.028549412,     0.001802768,
        -0.016204806,    -0.008913314,     0.003913816,     0.0030107566,    0.025131524,
        -0.00912777,     0.00045739373,    0.011064572,     -0.021740444,    -0.0365915,
        0.011547098,     -0.012753411,     0.0052072518,    -0.022692092,    0.0056261104,
        0.004992796,     0.00442985,       -0.0072713876,   0.023603527,     -0.036805954,
        -0.025801698,    0.011051169,      0.016379053,     -0.007834334,    0.008584929,
        -0.019435046,    -0.0000061323535, 0.014448951,     -0.0004904836,   -0.031873476,
        -0.000055708213, -0.017263683,     0.008846297,     -0.007686896,    0.0054552164,
        -0.021512585,    -0.0040344475,    -0.00209932,     0.021311533,     -0.008236438,
        0.033696346,     0.014757231,      0.009509768,     -0.008993735,    0.033267435,
        0.020936236,     0.00007256728,    0.006416916,     0.0019485309,    -0.03358912,
        -0.008390578,    -0.0005947794,    0.01298127,      0.010675872,     0.0070368266,
        0.003143116,     -0.035921324,     -0.018108102,    0.008035386,     -0.00097091455,
        0.016821368,     -0.006165601,     0.017920453,     -0.0013931241,   0.01856382,
        0.0065006875,    -0.018322557,     -0.016178,       -0.0077405097,   -0.033776768,
        0.014958283,     0.026900783,      -0.02719566,     -0.0055724964,   0.020078413,
        -0.012786919,    0.0039875354,     0.006772108,     -0.035572834,    0.016338842,
        -0.012311096,    -0.01983715,      -0.012130149,    -0.023858193,    -0.02804008,
        0.0065878103,    -0.009925277,     -0.008906612,    0.00081468024,   -0.016673928,
        -0.013718462,    -0.01298127,      -0.011473378,    -0.024903664,    0.01806789,
        -0.002469591,    -0.0075796675,    -0.009831453,    -0.022946756,    -0.005790303,
        -0.019930974,    0.00020052862,    0.0019703114,    -0.02296016,     0.0038032373,
        -0.016539894,    0.045062497,      0.010367592,     0.041818857,     -0.006661529,
        0.0037764304,    0.019287607,      0.006416916,     -0.0024796438,   0.0076667904,
        -0.010856818,    -0.05704521,      0.028549412,     0.013979829,     0.0031715983,
        0.028281342,     -0.019059747,     0.0131153045,    0.011587308,     0.0029873005,
        -0.023362264,    -0.00793486,      -0.02530577,     -0.015373792,    -0.0027276082,
        0.0111718,       0.0019384782,     -0.017250279,    -0.0029186078,   0.021740444,
        0.026324434,     -0.004895621,     0.0054016025,    0.034875855,     0.009188085,
        0.01174815,      0.009382436,      0.015011897,     -0.009911873,    0.008973629,
        0.014797442,     -0.0036423956,    0.017773014,     0.010984152,     0.014864459,
        0.009174682,     0.010454714,      -0.0121703595,   0.032302387,     0.006309688,
        -0.013269445,    -0.0076600886,    -0.021753848,    -0.012230675,    -0.03023825,
        -0.014757231,    -0.044848043,     0.012083237,     0.004754884,     -0.011466676,
        0.032382805,     -0.019729922,     -0.016151194,    0.031230107,     -0.017746206,
        0.012565762,     -0.0148376515,    0.027209064,     0.029648498,     -0.0011250546,
        0.00031623835,   0.02018564,       0.0029487654,    0.005053112,     0.005673023,
        0.005666321,     0.012498745,      -0.015119125,    -0.015454212,    0.0066380734,
        -0.03393761,     -0.035143923,     -0.0032805016,   0.012733306,     0.010923835,
        -0.017558558,    -0.017344102,     0.005100024,     0.010421205,     -0.0025835207,
        -0.0035921326,   -0.014958283,     -0.019502062,    -0.024126263,    -0.016432665,
        0.0008997086,    -0.0049257786,    -0.01174815,     -0.004657709,    -0.012425026,
        -0.007298195,    -0.00889991,      -0.020614551,    0.008269947,     0.009489664,
        0.012760113,     0.004952586,      -0.0030090811,   -0.018630836,    0.0046208496,
        0.006222565,     0.0011602388,     0.030265057,     -0.0048520598,   0.00442985,
        -0.011600711,    0.0074858433,     0.0023137757,    -0.009315418,    0.007854439,
        -0.007552861,    -0.009040647,     0.008906612,     0.010032505,     0.011808465,
        -0.039352614,    -0.012572464,     0.0062192148,    -0.0024176526,   -0.034902662,
        -0.0122708855,   0.015226353,      -0.007914755,    0.0061689513,    0.00045655604,
        0.008799384,     0.012954463,      0.017705997,     -0.011681132,    0.007995175,
        0.027329694,     -0.035197537,     0.01790705,      -0.012331202,    0.033079788,
        -0.0112589225,   0.011379554,      0.031793054,     0.007237879,     0.018630836,
        -0.04369534,     -0.02442114,      0.0011870457,    -0.014877862,    0.006128741,
        0.0019284256,    -0.009141173,     0.03447375,      -0.0032486683,   0.011741448,
        -0.005384848,    -0.02322823,      -0.00020545021,  0.0040914123,    -0.00026534701,
        0.030131022,     -0.037985463,     -0.016110983,    0.009275208,     0.012083237,
        0.02530577,      -0.05455216,      -0.010233557,    0.007727106,     0.010441311,
        -0.005133533,    -0.027128642,     0.00007586579,   -0.017478138,    -0.025600646,
        0.0024930472,    -0.0047515337,    -0.013477199,    -0.0156150535,   0.012384815,
        0.010488222,     -0.0015070537,    -0.0020775395,   -0.0113929575,   0.0015430755,
        -0.021539392,    -0.021740444,     -0.015119125,    -0.003478203,    0.019046344,
        0.013034884,     -0.01070938,      -0.019327817,    -0.020627955,    -0.05149617,
        0.006309688,     -0.021391954,     0.011741448,     0.014569582,     0.0009558356,
        0.005334585,     0.009509768,      0.0031246862,    0.012277587,     -0.0065040383,
        -0.007653387,    0.0018999432,     -0.016419262,    0.004010991,     0.011493484,
        -0.0003051386,   0.013886005,      0.023750966,     -0.008068895,    -0.012572464,
        -0.0033106594,   0.004684516,      0.01590993,      0.0074858433,    0.014448951,
        0.012384815,     -0.009429348,     0.006336495,     -0.012230675,    -0.0006014811,
        0.0035686765,    0.0038166407,     -0.000017801496, -0.00038451233,  -0.00716416,
        0.011915693,     -0.0033692997,    -0.004614148,    -0.013457093,    -0.00006136281,
        0.004453306,     0.009610295,      -0.021914689,    0.0064504244,    0.009161279,
        -0.0014475757,   -0.022785915,     -0.012257482,    0.01779982,      0.017009016,
        -0.00003740932,  0.012009517,      -0.011252221,    -0.007653387,    -0.00074179884,
        0.014489162,     -0.026176997,     -0.0015305098,   -0.007365212,    -0.0021680128,
        -0.024099456,    0.019904166,      0.01737091,      -0.008135912,    -0.016687332,
        -0.0034312909,   0.005676374,      -0.012840534,    0.002203197,     -0.00014628642,
        0.0001247152,    0.010454714,      0.0029521163,    -0.022544652,    -0.035492413,
        0.018992731,     0.012860639,      -0.030211443,    0.028120501,     0.22603628,
        -0.006467179,    0.011996115,      0.030667162,     -0.0029705463,   0.012659586,
        0.019247396,     0.01459639,       -0.0060952324,   -0.008524613,    0.00720437,
        0.0037596761,    -0.032248773,     0.00040189497,   0.0013051638,    -0.011031063,
        -0.02129813,     0.0009734277,     -0.011868781,    -0.01814831,     0.02226318,
        -0.0040076403,   0.009456155,      -0.019435046,    -0.014891266,    -0.016003754,
        -0.0048855683,   -0.01710284,      0.013075095,     0.019823747,     -0.017384313,
        0.0066414243,    -0.0021160743,    0.0008729016,    -0.007150756,    0.0029537918,
        -0.000673106,    0.00029257283,    0.0051636905,    -0.0074255276,   0.01009282,
        0.028334957,     0.0031715983,     0.013966425,     -0.010320679,    0.003474852,
        -0.010836713,    0.00504641,       0.021391954,     0.014944879,     -0.030908424,
        -0.0006421104,   0.01903294,       0.027611168,     -0.00647053,     0.0031598704,
        0.0062996354,    0.0016209834,     0.010441311,     -0.014824249,    -0.008685455,
        0.0063968105,    -0.0070301252,    0.01148008,      -0.005287673,    0.020560937,
        -0.028629832,    0.0037563252,     0.01586972,      -0.00820293,     -0.01136615,
        -0.024917068,    -0.02703482,      0.0227323,       0.0065006875,    -0.022142548,
        0.015775895,     0.004818551,      0.015186142,     0.01020675,      -0.0006886038,
        -0.010608854,    -0.018590625,     -0.006309688,    -0.013376673,    -0.012900849,
        0.03447375,      0.008477701,      -0.01918038,     0.0015908255,    0.01432832,
        -0.0234963,      -0.008089,        -0.0063264426,   0.00389036,      -0.009871663,
        -0.0008008579,   0.0034815539,     0.00045027313,   0.024032438,     -0.03860202,
        0.009261805,     0.004711323,      0.012089939,     0.0022015215,    -0.0056495667,
        0.014341723,     0.013101901,      0.026565697,     -0.025278963,    -0.03324063,
        -0.023094196,    0.0049324804,     -0.0024210035,   0.006949704,     0.0250377,
        0.005197199,     -0.006517442,     0.025506822,     -0.0127132,      -0.0004917402,
        -0.02472942,     -0.039513458,     0.00762658,      0.0011510238,    -0.025560435,
        -0.005977952,    0.015025301,      0.0037228165,    -0.02261167,     0.0030291863,
        -0.017263683,    -0.009174682,     -0.0067285467,   -0.0054619177,   -0.00097259,
        0.019582484,     -0.011728045,     0.013483901,     0.023710756,     -0.026713135,
        -0.016231613,    0.0119425,        -0.0055993036,   0.018121505,     -0.0062895827,
        -0.00033131725,  0.01979694,       -0.012290991,    0.0014065276,    -0.017786417,
        -0.002573468,    0.012974569,      0.004945884,     -0.005482023,    -0.00045446173,
        -0.030077409,    -0.017853435,     -0.004413096,    0.00670174,      -0.03509031,
        0.007291493,     0.0044466043,     -0.017947258,    -0.007539457,    -0.0064470735,
        -0.17231514,     0.003893711,      0.035680063,     -0.027611168,    0.027302887,
        -0.008638542,    0.015574844,      -0.0019468555,   0.013872601,     -0.0009198138,
        0.0038266934,    0.006282881,      -0.040961035,    -0.013175621,    0.009114366,
        -0.0020054956,   -0.011600711,     0.03270449,      0.0008712262,    -0.00997889,
        -0.016647121,    -0.016968805,     -0.0039071143,   0.0075059487,    0.013571023,
        0.010930537,     -0.004111517,     -0.025466612,    0.010823309,     -0.021767251,
        -0.007673492,    -0.015159335,     0.042998362,     -0.0050129015,   0.013671549,
        -0.012351306,    0.0014509266,     -0.008732367,    -0.032409612,    0.023348862,
        0.0020691622,    0.014918073,      0.020266062,     -0.003893711,    -0.0032637473,
        0.050745573,     0.0075193522,     -0.020989848,    -0.010943941,    -0.012009517,
        0.015574844,     -0.02211574,      -0.008370473,    0.0064403717,    0.02873706,
        0.017250279,     0.000033561057,   -0.00171397,     0.0008414872,    -0.023281844,
        0.00059017196,   -0.01636565,      0.029300006,     -0.008115807,    -0.0043862886,
        -0.01837617,     -0.0023606878,    -0.0007635795,   -0.028442184,    0.021485778,
        -0.012807025,    -0.0025600647,    0.004503569,     -0.02511812,     -0.005538988,
        0.029246392,     0.0020423552,     0.0032687737,    -0.0021830918,   -0.01930101,
        -0.019756729,    0.023576722,      -0.008236438,    -0.005917636,    0.015963545,
        0.0059444434,    0.013302954,      0.010803205,     -0.009985592,    -0.021472374,
        -0.024702612,    -0.018054487,     -0.008109105,    -0.027115239,    0.020896025,
        0.03517073,      -0.0046778144,    0.015708879,     0.017169857,     -0.0046744635,
        0.0046744635,    0.032356,         -0.011580606,    0.0026304328,    0.018845292,
        0.011071274,     -0.0121368505,    0.0074255276,    0.03739571,      -0.0011661027,
        -0.013101901,    0.0048353053,     0.009945381,     0.02873706,      -0.024019035,
        0.037797812,     -0.028710254,     0.00419864,      0.006460477,     -0.0008486078,
        0.06160239,      0.008564823,      -0.012290991,    0.011071274,     -0.021485778,
        -0.017049227,    -0.11784339,      -0.01991757,     -0.002600275,    0.024032438,
        -0.0057601454,   0.008765875,      -0.0015221327,   0.015199546,     -0.026431661,
        0.015950141,     0.015239757,      -0.0500754,      0.006179004,     -0.014703617,
        -0.00032691925,  0.0033709751,     -0.020051606,    0.008316859,     -0.012693095,
        0.02719566,      -0.002588547,     -0.00025550384,  0.0033944312,    -0.01702242,
        0.022088934,     0.019863958,      -0.014609793,    0.013296252,     0.019756729,
        0.007311598,     0.007800825,      -0.029031936,    0.038387567,     0.004711323,
        0.0071708616,    -0.012063132,     0.003297256,     -0.009885066,    0.038280338,
        -0.029460847,    -0.012337903,     -0.017933855,    0.0039004125,    -0.015373792,
        0.0037127638,    -0.0073719136,    -0.009040647,    0.007928158,     0.004148377,
        -0.019930974,    -0.040666156,     0.00616225,      -0.01236471,     0.0047213756,
        0.01263278,      -0.0208022,       0.020118622,     0.0055222334,    -0.00705023,
        -0.0074255276,   -0.0055054794,    -0.0045270254,   -0.039004125,    -0.020051606,
        -0.00059645483,  0.0017994172,     -0.02962169,     -0.008263245,    0.01903294,
        -0.022276582,    0.010267066,      0.011031063,     0.000057540718,  0.011118187,
        -0.026364645,    0.0114264665,     0.011728045,     -0.021593006,    0.011138291,
        -0.00061279035,  -0.00041194758,   -0.008920016,    0.02049392,      -0.025225349,
        -0.017210068,    -0.0049123755,    0.008068895,     0.0014861109,    0.0066883364,
        0.0040445,       -0.0122708855,    0.010836713,     -0.018496802,    -0.01856382,
        -0.006721845,    0.013550918,      -0.008363771,    -0.014918073,    0.018992731,
        0.005307778,     -0.013557619,     -0.013845795,    -0.038977318,    0.030131022,
        -0.00052483,     -0.013028182,     -0.0069966163,   -0.01968971,     -0.0032402913,
        -0.0057132333,   -0.00032775695,   0.0057500927,    -0.0048152,      0.018469995,
        0.004067956,     -0.003917167,     -0.018831888,    -0.011077976,    0.031042458,
        -0.021365147,    0.00179104,       -0.005187147,    0.027664782,     0.005927689,
        0.012807025,     0.00023204774,    -0.0112589225,   -0.0028247833,   -0.0055758473,
        0.018537013,     -0.025627453,     0.0062393197,    -0.0036792553,   -0.03525115,
        -0.010133031,    -0.0007937373,    0.0062728287,    -0.013872601,    -0.0018446539,
        0.013644742,     0.019783536,      0.05227357,      -0.015588247,    -0.030881617,
        0.016124386,     -0.007908053,     -0.015668668,    0.011962606,     -0.03297256,
        0.0005135208,    0.031873476,      -0.011111485,    0.027557554,     0.023161212,
        -0.017116243,    -0.01922059,      -0.039352614,    -0.0017424524,   0.02384479,
        0.018939117,     -0.0019585835,    -0.0023975475,   -0.0073518087,   0.008893209,
        0.006105285,     0.017933855,      -0.0071708616,   0.01221057,      0.02222297,
        0.016673928,     0.020292869,      -0.027718395,    0.005927689,     -0.0050631645,
        0.031096073,     -0.0050363573,    0.0068324236,    -0.0015279966,   -0.013316357,
        0.013175621,     -0.018738065,     -0.0010236908,   -0.018858695,    -0.0063934596,
        -0.034875855,    0.02129813,       0.0335087,       0.013363269,     -0.007954965,
        0.024823245,     0.002372416,      -0.009757733,    0.01564186,      0.014355127,
        -0.011446572,    -0.0021328286,    -0.0034145364,   0.01903294,      -0.01574909,
        -0.011908991,    0.01574909,       0.020386692,     -0.0036155886,   0.009154577,
        0.011299133,     -0.0015380493,    -0.022705495,    0.005773549,     -0.0050799185,
        -0.023308652,    -0.01302148,      0.016968805,     0.041202296,     -0.010025803,
        0.005843917,     0.014810845,      -0.007894649,    0.025506822,     -0.0036088869,
        -0.0043628328,   -0.022330197,     0.018724661,     0.021391954,     0.008236438,
        0.009972189,     -0.004145026,     0.009931979,     0.027115239,     0.03286533,
        -0.028147306,    -0.014810845,     0.0006182355,    0.0035988344,    0.005689777,
        -0.02530577,     0.0071440544,     -0.017880242,    -0.018764872,    -0.023442686,
        0.007961667,     -0.030533126,     0.05173743,      -0.0018446539,   -0.018671047,
        -0.0043695346,   -0.0036859568,    0.019783536,     -0.023067389,    0.018992731,
        -0.027369905,    -0.0025349332,    0.017491542,     -0.03755655,     0.025587242,
        -0.0031112826,   -0.012773516,     0.02719566,      -0.004691218,    0.034125257,
        -0.0069363005,   -0.01324934,      0.021177499,     0.032597262,     0.024488157,
        -0.008383877,    -0.02769159,      0.0027091783,    0.017893646,     -0.0011996115,
        -0.01440874,     -0.02908555,      -0.0036759044,   -0.0013060016,   -0.029434042,
        -0.0031766247,   -0.007003318,     0.0036122377,    0.004503569,     -0.024246894,
        0.0058573205,    -0.013966425,     -0.0059008817,   0.027289484,     -0.0069966163,
        -0.02326844,     0.005358041,      0.00333244,      -0.013530812,    -0.013309656,
        -0.020587744
    ],
    [
        0.0055872854,    -0.027353462,   -0.010486804,    -0.005832916,    0.00030847153,
        0.020344792,     -0.006029421,   -0.00023539632,  0.001838957,     -0.0050665475,
        -0.00021902092,  0.026580542,    0.03054994,      -0.03972016,     0.030052127,
        -0.009189872,    0.034899246,    -0.024812,       0.011973689,     0.000330783,
        0.0007663685,    0.004755415,    0.023501968,     -0.021641724,    0.011973689,
        -0.007984643,    -0.0006353654,  -0.017292418,    0.009563231,     0.013015165,
        0.007408229,     -0.0070676208,  0.010388551,     -0.005420256,    -0.018458346,
        -0.015484574,    0.005220476,    -0.002603688,    0.0004095896,    -0.016178891,
        0.009399477,     0.011397276,    -0.011462777,    -0.012196395,    0.0005616761,
        0.007820889,     0.0030474612,   -0.024183186,    -0.028218083,    0.01450205,
        0.008475905,     0.006825265,    -0.01116802,     -0.014947462,    -0.02688185,
        0.008829613,     -0.025087107,   -0.00558401,     0.010945315,     -0.010945315,
        -0.011181121,    0.00059811136,  -0.001098789,    0.0044115316,    -0.016598102,
        0.0031604515,    0.0016244393,   -0.004922444,    -0.0065436084,   0.0008703523,
        0.019191964,     0.015484574,    0.012478052,     -0.0027003027,   0.02022689,
        -0.018340444,    -0.022231238,   -0.011095968,    0.009890739,     0.015982386,
        0.015484574,     -0.02934471,    -0.011731334,    0.037912317,     0.017200716,
        -0.004224852,    -0.012864511,   0.0036320628,    -0.0206854,      -0.013427825,
        -0.0021173388,   0.007814339,    -0.0017456172,   0.0015106302,    -0.011672382,
        -0.0025987753,   -0.006825265,   0.0008507018,    -0.0010210059,   -0.04412187,
        -0.0131658185,   0.014397249,    0.012360149,     -0.0080959955,   -0.009753186,
        0.023226863,     0.021667924,    -0.00991039,     0.011875438,     -0.0006701631,
        0.002891895,     0.0017243292,   0.0044049816,    -0.037335902,    -0.00990384,
        -0.040401377,    0.012759709,    -0.0025283613,   0.008063245,     -0.01323787,
        0.035737664,     -0.009988992,   0.018117739,     -0.002333494,    0.0075392323,
        -0.007473731,    -0.0017128665,  -0.023947379,    0.009006468,     -0.016139591,
        0.004925719,     -0.002027274,   0.010257548,     -0.007342728,    -0.01737102,
        0.010794661,     -0.042680833,   -0.009222623,    -0.009818687,    -0.008606908,
        0.02310896,      0.030366534,    -0.023043457,    0.0070479703,    -0.01780333,
        0.020370992,     0.013689831,    0.02606963,      0.0016866658,    -0.020541297,
        0.023921179,     -0.024628596,   0.006334003,     0.008711711,     0.015654879,
        0.006727013,     -0.011023916,   0.020606799,     -0.020908106,    -0.009412577,
        0.011619981,     -0.0015564814,  -0.0038351177,   -0.010093794,    -0.0020436493,
        0.03641888,      0.015026064,    -0.015209468,    0.0012240609,    -0.009668034,
        -0.020384094,    0.019598074,    -0.005043622,    0.020816404,     0.015667979,
        0.030078327,     0.0011700221,   0.022611147,     0.01527497,      -0.02271595,
        -0.0059770197,   0.015838284,    0.010178946,     0.00475869,      0.002674102,
        -0.018445246,    -0.009078519,   0.008803413,     0.021143911,     -0.01695181,
        0.0045130593,    0.0020764002,   -0.014423449,    0.015196367,     -0.67618597,
        -0.005508683,    -0.005043622,   -0.0014516789,   0.018929958,     0.03550186,
        0.018681051,     -0.004460658,   -0.015641779,    0.01569418,      0.0046735383,
        0.0024923354,    -0.004991221,   -0.016218193,    -0.009995542,    -0.016191991,
        0.0037859916,    -0.02559802,    0.012622155,     -0.0019093712,   -0.039458156,
        0.021261815,     0.031755168,    -0.0030441862,   -0.0036582635,   0.0033536812,
        0.02153692,      -0.03400842,    -0.0025365488,   0.005217201,     -0.022912454,
        0.017187616,     -0.012674557,   0.019676676,     0.048968986,     -0.025349114,
        0.0016768406,    0.02355437,     0.0010357439,    0.022846952,     -0.018078437,
        -0.016833907,    -0.00051664375, -0.000117800504, -0.010984615,    0.016309895,
        0.020043485,     -0.012884161,   0.011364525,     0.0011307211,    -0.00067630387,
        0.039562955,     -0.0042707035,  -0.0023040182,   0.011855787,     -0.017174516,
        0.013912536,     0.005606936,    0.009759736,     -0.005053447,    -0.0068383655,
        0.016571902,     0.0035632863,   0.018497648,     -0.01608719,     0.035868667,
        -0.016833907,    0.027903674,    0.004470483,     -0.027353462,    0.024209386,
        0.025715923,     -0.005698638,   -0.007401679,    0.0103033995,    0.01075536,
        0.01820944,      0.0021058759,   -0.009157121,    -0.014371048,    0.022021633,
        -0.005079648,    -0.017619926,   0.0071724234,    0.02604343,      -0.010932215,
        -0.033301007,    -0.015327371,   0.012019541,     -0.027903674,    0.010919115,
        0.03550186,      -0.03225298,    0.0047750655,    -0.0004044723,   -0.028794497,
        -0.0060850973,   0.00022004439,  -0.009301225,    -0.033694014,    0.0038645936,
        -0.016716005,    -0.00068899477, -0.015052265,    0.01116802,      -0.01779023,
        -0.013689831,    0.0008384203,   0.036261678,     -0.011881988,    -0.0011299023,
        0.01610029,      -0.00032607507, 0.0020960507,    -0.006491207,    -0.027458264,
        0.02358057,      -0.008135296,   0.017174516,     -0.020842604,    0.017436521,
        0.020423394,     0.013702932,    -0.017397221,    0.017528225,     0.0024677722,
        -0.007742287,    -0.047449347,   -0.015838284,    0.006170249,     -0.012602505,
        -0.0024022707,   -0.0016817532,  0.005675712,     0.004463933,     0.021550022,
        0.010198597,     0.0029393835,   0.0045294347,    -0.013781534,    -0.018733453,
        0.011482428,     0.020777103,    -0.0046833633,   0.02023999,      -0.03691669,
        -0.018654851,    -0.003759791,   -0.033274803,    -0.0066778865,   0.022100234,
        -0.0070610708,   0.0134933265,   0.015157066,     0.006897317,     0.005911518,
        -0.0077029862,   -0.027065255,   0.0016162517,    -0.005046897,    0.021982333,
        -0.0007553151,   -0.022349142,   0.0045327097,    -0.0055283336,   -0.009202973,
        0.0056888126,    0.039877366,    -0.0080894455,   -0.029397111,    -0.017462723,
        -0.03673329,     -0.014685456,   0.024943003,     -0.0027052155,   -0.0047816155,
        -0.0025709372,   -0.008187698,   -0.010486804,    -0.0049322695,   -0.011174571,
        -0.0020092612,   0.028375287,    0.012045741,     0.033694014,     -0.008587258,
        0.017423421,     0.03432283,     -0.013860135,    0.020069685,     0.0023138435,
        0.01942777,      0.01986008,     0.0056462367,    -0.006533783,    0.00090965326,
        0.007074171,     0.038750738,    0.006989019,     0.037021495,     0.016309895,
        -0.007683336,    0.017122114,    -0.031990975,    0.015432173,     -0.020004183,
        -0.010486804,    -0.042497426,   0.04055858,      -0.008921316,    0.028244283,
        -0.019231265,    -0.00867241,    -0.0026642769,   0.015445273,     0.0043558553,
        -0.010237898,    0.01200644,     -0.0072575756,   0.00206985,      0.006818715,
        0.008554507,     -0.008567607,   -0.01983388,     -0.035868667,    0.01986008,
        0.017161416,     0.026960453,    0.011456227,     -0.011410376,    -0.0064420807,
        0.008980268,     -0.008692061,   0.007978093,     0.028794497,     -0.019375369,
        -0.0069300677,   -0.0011184396,  0.01530117,      0.009871089,     0.010283749,
        0.02151072,      0.032803193,    -0.020200688,    -0.0040447228,   0.012274997,
        0.008528306,     -0.012720408,   -0.027772672,    0.008836164,     -0.014357948,
        0.010532655,     -0.015995488,   0.012196395,     0.0206985,       0.0030114353,
        0.019139564,     0.023030357,    0.030497538,     0.026750848,     0.0019339343,
        -0.0064158803,   0.012969314,    0.014554452,     0.018536948,     -0.013755333,
        0.012333948,     0.00025525148,  0.022008533,     0.026292335,     0.0071986243,
        -0.0041102245,   0.0026593644,   -0.034584835,    -0.0004830742,   0.0034388332,
        0.017292418,     -0.003347131,   0.005999945,     -0.002412096,    0.017397221,
        -0.026279235,    0.010958415,    0.0053121783,    0.003936645,     -0.030890547,
        -0.013467126,    0.010513004,    -0.017698528,    0.015497675,     -0.003966121,
        0.011823036,     0.0010218247,   0.00033037362,   -0.003037636,    -0.012687657,
        0.035632864,     -0.011967139,   0.0050370716,    -0.022833852,    0.00086625846,
        0.026200633,     0.006032696,    -0.0023465944,   0.023894979,     0.0060490714,
        -0.013277171,    -0.02979012,    0.009333976,     0.006399505,     0.00537768,
        -0.00030478707,  0.008174597,    -0.015903784,    -0.018733453,    0.0032537912,
        -0.020501995,    0.009563231,    0.028820697,     -0.01114182,     -0.010185496,
        -0.026318537,    -0.017462723,   -0.01899546,     0.109728254,     0.03649748,
        0.028034678,     0.017515123,    0.011646181,     -0.002279455,    -0.026331637,
        -0.027222458,    0.008521756,    0.00096942345,   0.013303372,     -0.027825072,
        -0.0015941449,   0.00909817,     0.016624302,     -0.0050337967,   -0.005086198,
        -0.020148287,    0.0066811615,   -0.0050206967,   0.0028820697,    -0.009242274,
        0.0065992847,    0.013080667,    -0.019257465,    -0.031335957,    0.0019945232,
        0.017698528,     -0.016047888,   -0.0135064265,   -0.024812,       -0.018353544,
        -0.00019619771,  -0.0026118758,  -0.0023351314,   0.0046800883,    0.014803358,
        0.007178974,     0.036130674,    -0.014777157,    0.020449596,     0.016873209,
        0.016585002,     -0.022388441,   0.020921206,     0.00992349,      -0.0001695877,
        0.028244283,     0.0038809688,   0.0052663274,    0.05460212,      -0.00022475231,
        0.0044835834,    0.01697801,     -0.006032696,    0.0106505575,    0.018667951,
        0.0021926656,    -0.003229228,   0.008325252,     -0.01238635,     -0.023829477,
        -0.0056298613,   -0.022270538,   -0.0075064814,   -0.018432146,    -0.0041069495,
        -0.024982305,    -0.012609055,   -0.011109069,    -0.005875492,    -0.039327152,
        -0.011344874,    -0.011325224,   0.03212198,      -0.008371103,    -0.0021550022,
        -0.007571983,    0.018707253,    0.008554507,     0.008168047,     0.0026577269,
        -0.005780515,    -0.015039164,   0.0056560617,    0.028453888,     0.008770662,
        -0.0016612839,   -0.0048405672,  0.010571956,     0.022637347,     0.0041593504,
        0.022034733,     0.0036680887,   0.016716005,     -0.02310896,     0.018366644,
        0.013316472,     -0.007650585,   -0.0022385167,   0.0027084905,    -0.04351925,
        0.010146195,     -0.007571983,   0.0046899132,    0.001034925,     -0.0060588964,
        -0.012687657,    -0.015890684,   -0.017685428,    0.02275525,      -0.019729078,
        -0.0075981836,   -0.012484602,   -0.0010545756,   0.014082841,     0.015956186,
        0.012720408,     -0.005243402,   -0.015929986,    -0.006727013,    -0.012988964,
        0.014384148,     0.040217973,    0.0022925555,    0.0049748453,    -0.0027150407,
        -0.039562955,    0.0044835834,   -0.0073754783,   -0.022493243,    -0.0017046788,
        0.0023040182,    -0.0008064883,  -0.033589214,    0.0038121922,    -0.008639659,
        -0.001116802,    -0.009307775,   -0.016650504,    -0.019401569,    -0.0023875327,
        0.020816404,     -0.002130439,   -0.027929876,    -0.021550022,    -0.0042412276,
        -0.0023875327,   0.0065108575,   -0.0029508465,   0.0044148066,    -0.0027936427,
        0.012274997,     -0.0015048989,  -0.010932215,    -0.04805196,     -0.018157039,
        0.012484602,     0.026606744,    0.004709564,     0.02185133,      0.0074933814,
        0.02187753,      0.019349169,    0.004627687,     0.0049748453,    -0.0008011662,
        -0.002891895,    -0.063562736,   -0.00067057245,  0.051353242,     -0.00053383794,
        0.015602478,     -0.014672355,   0.0087248115,    -0.0033127426,   0.0024104584,
        0.0007974818,    -0.01607409,    -0.010879813,    -0.004716114,    0.01241255,
        0.010454053,     -0.00024235586, -0.008986818,    -0.03552806,     0.041842412,
        0.0013968213,    0.0024202836,   -0.00639623,     0.01986008,      -0.018510748,
        -0.0026610019,   -0.014737857,   -0.00091456587,  0.0018733453,    -0.0027592543,
        -0.008135296,    -0.015589377,   0.008240099,     0.0059802947,    -0.00077209994,
        0.012609055,     0.013106867,    0.011842687,     0.03513505,      0.018471448,
        0.007414779,     0.014908161,    -0.013964938,    -0.023685373,    -0.025991028,
        -0.01034925,     -0.051012635,   -0.0057313885,   -0.0014590478,   0.0042838035,
        0.011233522,     -0.026266135,   -0.04092539,     0.010617807,     0.020318592,
        0.044960286,     0.016847007,    0.032855596,     0.01241255,      -0.006068722,
        -0.023069657,    0.055964556,    0.0077160867,    0.011390725,     0.00042576028,
        0.0061767995,    0.019100262,    -0.015379772,    -0.024812,       -0.0013894524,
        -0.034846842,    -0.032803193,   0.020619899,     -0.011868888,    0.009425678,
        -0.019886281,    -0.0061866245,  -0.005249952,    0.00949773,      -0.010401651,
        0.012451851,     -0.0060228705,  -0.025467016,    -0.04459348,     -0.005508683,
        -0.015104665,    0.012157094,    -0.0050239717,   -0.0050599976,   0.0050272467,
        0.012085042,     -0.0019453971,  -0.0053056283,   -0.0019306592,   0.0056789876,
        0.009720435,     -0.005832916,   -0.00785364,     -0.009943141,    0.019113362,
        -0.003962846,    0.011619981,    0.027510665,     0.0005915612,    -0.0043787807,
        -0.008777212,    0.01607409,     0.016257493,     -0.0021582772,   -0.0038580433,
        -0.009838338,    -0.009065419,   0.017017312,     0.001401734,     0.008475905,
        -0.023947379,    -0.019165764,   -0.016453998,    -0.0009898928,   -0.022388441,
        -0.0068056146,   -0.0043165544,  -0.011423476,    0.0037270403,    -0.0061407737,
        -0.002493973,    0.017986735,    0.025689721,     0.015956186,     -0.007735737,
        0.03020933,      -0.037073895,   0.013192019,     0.008613458,     0.020056585,
        -0.015654879,    0.0069038672,   0.017030412,     -0.0029328335,   0.0082532,
        -0.03972016,     -0.026213733,   -0.018982358,    -0.021209413,    0.0046014865,
        -0.020619899,    -0.0016457273,  0.021261815,     -0.011220422,    -0.004634237,
        -0.026239935,    0.0041593504,   0.011403826,     0.012288097,     0.00787329,
        0.034270428,     -0.015916886,   -0.0046768133,   -0.009851438,    0.009248824,
        -0.0039530206,   -0.027615469,   0.0011642907,    -0.00023253063,  0.025126407,
        -0.0037827166,   -0.01606099,    -0.011515179,    -0.020423394,    -0.024641696,
        0.030654741,     0.008796863,    -0.01696491,     0.0084235035,    0.03348441,
        0.010211697,     -0.0017243292,  0.0051647997,    -0.017881932,    0.013303372,
        -0.00433948,     -0.02527051,    0.0053056283,    0.0011642907,    0.033143803,
        -0.02646264,     -0.01730552,    -0.03104775,     -0.016781505,    -0.037414506,
        -0.00744098,     -0.017711628,   0.014986763,     0.026213733,     0.012202946,
        -0.0023105685,   0.023829477,    0.0049715703,    0.014554452,     -0.0057182885,
        -0.011488978,    -0.008888565,   -0.0047750655,   0.011698583,     0.014279345,
        -0.008469355,    -0.003998872,   0.02183823,      -0.00027224096,  -0.008076346,
        0.027405864,     -0.031178754,   0.008482455,     -0.020449596,    0.010958415,
        0.0060588964,    0.020842604,    0.01323787,      -0.02562422,     0.008299051,
        -0.0013575203,   0.02313516,     -0.009268474,    0.0103558,       -0.010231348,
        0.007840539,     0.01693871,     0.008436604,     -0.009314326,    0.0024186461,
        -0.016611202,    -0.0012453488,  -0.01238635,     0.014659255,     0.014986763,
        0.0011299023,    -0.028165681,   -0.012753159,    0.009432228,     -0.0029115453,
        0.009851438,     0.0058067157,   0.00702832,      -0.008521756,    -0.010801211,
        0.0055578095,    -0.026606744,   -0.009268474,    0.0022205038,    -0.0020501995,
        -0.028165681,    0.028191881,    0.0054693823,    -0.0206985,      -0.009962791,
        -0.0065861843,   -0.0053907805,  -0.013938737,    -0.01198024,     0.0034028073,
        -0.023750875,    0.015956186,    -0.023763975,    -0.017698528,    -0.022794552,
        0.011194221,     -0.0067466632,  -0.042654634,    0.024890602,     0.20876665,
        -0.017737828,    0.012078492,    0.023672273,     -0.012478052,    0.010074143,
        0.025545618,     -0.0011962227,  -0.005289253,    0.0068383655,    -0.010545755,
        0.018772755,     -0.009406027,   -0.0012469864,   -0.01822254,     -0.007323077,
        -0.037466906,    -0.008489005,   -0.014999863,    -0.0067073624,   0.020187588,
        0.009478079,     0.0028689695,   -0.003887519,    0.0039071697,    -0.030392734,
        -0.00026630488,  -0.007919142,   0.0053907805,    0.019715978,     -0.006890767,
        -0.020554397,    -0.013912536,   -0.0071331225,   -0.0071658734,   0.0011069768,
        -0.005495583,    0.0051353243,   0.0001261929,    0.025755223,     0.01693871,
        0.007899491,     -0.006494482,   0.016336095,     -0.0032701667,   -0.0056429617,
        0.001483611,     -0.007919142,   0.014082841,     0.021274915,     -0.025807625,
        0.0013779895,    0.015196367,    0.03269839,      0.00058091717,   -0.019991083,
        0.0027445164,    0.0034584836,   0.015065365,     -0.014619954,    -0.007637485,
        0.02025309,      0.005449732,    0.0031080502,    -0.014750957,    0.008056695,
        -0.029816322,    0.016585002,    -0.00044377323,  -0.022021633,    -0.009399477,
        -0.008940966,    -0.024576195,   0.0018864457,    0.0017849181,    -0.024916803,
        0.0034519336,    -0.0064322557,  0.04173761,      -0.022034733,    0.0034060823,
        0.00067916955,   -0.0103164995,  -0.011482428,    -0.025087107,    -0.0076964363,
        0.020973608,     0.0018995459,   -0.010519555,    -0.0000373052,   0.005934444,
        -0.025388414,    -0.0056888126,  -0.018419046,    0.0040283473,    0.028899299,
        -0.013087217,    0.012746608,    -0.014999863,    -0.013159269,    -0.030392734,
        -0.018170139,    0.0009980804,   -0.015550076,    -0.02103911,     -0.0048438422,
        0.002166465,     0.013296822,    0.03259359,      -0.0017603551,   -0.011246622,
        -0.0013755333,   -0.00060220517, -0.022244338,    0.0011274461,    0.0106374575,
        0.027432064,     0.008213899,    0.005249952,     0.0019453971,    -0.007106922,
        -0.018026035,    0.00019783525,  -0.013008615,    0.000029219847,  -0.035239853,
        0.008344902,     0.030864347,    0.020043485,     -0.024563095,    0.010067593,
        -0.023606772,    0.012098143,    -0.00909162,     0.0055676345,    0.021746526,
        0.0012690932,    -0.011508629,   -0.014803358,    0.0013288634,    0.0207378,
        0.005734664,     0.011030467,    0.01776403,      0.020488895,     -0.011095968,
        0.011619981,     0.009713885,    -0.0058492916,   0.001401734,     -0.014619954,
        -0.02769407,     -0.0049813953,  0.010172396,     0.015484574,     -0.031257357,
        -0.025113307,    -0.029135104,   -0.009772836,    0.00015444045,   -0.029554315,
        -0.0045425347,   0.008115646,    -0.03471584,     0.0029115453,    0.009216073,
        -0.16768406,     0.011384175,    0.017017312,     -0.009071969,    0.017017312,
        0.014921261,     0.0138077345,   -0.007958443,    -0.008993368,    -0.0033667814,
        0.012052292,     -0.0033635064,  -0.035737664,    -0.010395101,    -0.014790257,
        -0.0058492916,   -0.0065501584,  0.0080894455,    0.019152664,     -0.011849237,
        0.01154138,      -0.023711573,   -0.0082663,      0.013742233,     0.0044082566,
        0.020881904,     0.00639623,     -0.010906014,    -0.0004093849,   -0.0041495254,
        -0.0031506263,   0.004879868,    0.024982305,     -0.012772809,    0.014842659,
        0.004820917,     -0.015432173,   -0.009602533,    -0.014174543,    -0.00065460644,
        0.020803303,     0.01155448,     0.031257357,     -0.022047833,    -0.0040709237,
        0.021654824,     0.01735792,     0.017423421,     0.02026619,      -0.013860135,
        0.013585028,     -0.035266053,   -0.011226972,    0.010211697,     0.023056557,
        0.014672355,     0.008358003,    0.009301225,     0.0041822763,    -0.011351424,
        -0.020030385,    -0.020030385,   0.0072641256,    -0.027510665,    -0.01899546,
        -0.013408175,    -0.0039431956,  0.0053056283,    -0.01700421,     0.014292446,
        -0.02934471,     -0.010493354,   0.004061098,     -0.020462696,    0.0055676345,
        -0.00054407254,  -0.007074171,   0.0030114353,    -0.025453916,    -0.03400842,
        -0.036209274,    0.01983388,     -0.0115806805,   -0.013427825,    0.011705133,
        0.009006468,     -0.009176772,   -0.0020911382,   -0.0058165407,   -0.0038318427,
        0.007938792,     -0.018536948,   -0.014685456,    -0.0248251,      0.01575968,
        0.045641504,     0.0071986243,   0.0043231044,    0.016676703,     0.0064257053,
        -0.015327371,    0.018301142,    -0.0059213433,   0.01733172,      0.037728913,
        0.036576085,     0.036838092,    0.0046931887,    0.04215682,      -0.003838393,
        -0.020567497,    0.0015818633,   0.0016981285,    0.039903566,     -0.0050992984,
        0.004663713,     -0.008541407,   -0.0075326823,   0.041213598,     0.0041790013,
        0.05096023,      0.0033225678,   -0.018838257,    -0.01405664,     -0.0067597637,
        0.0012690932,    -0.10307329,    -0.018104637,    -0.017855732,    0.010860163,
        -0.0018848081,   0.017881932,    0.0034552086,    0.022126434,     -0.010257548,
        0.012674557,     0.01114837,     -0.014371048,    0.031650364,     0.0005199188,
        0.031571764,     -0.0033373057,  -0.0138077345,   0.004221577,     -0.02850629,
        -0.0019060961,   0.003283267,    -0.003144076,    -0.0032095776,   -0.0029966976,
        -0.006949718,    0.016152691,    -0.02525741,     0.01902166,      0.013329572,
        -0.0054399064,   0.02772027,     -0.02152382,     0.017095914,     -0.01528807,
        -0.0015237306,   0.011881988,    -0.033353407,    0.0077160867,    0.056069355,
        -0.028925499,    0.0007020951,   -0.00052196573,  -0.0037008396,   -0.024301087,
        -0.00744098,     -0.010683308,   0.0014926173,    0.002983597,     -0.0049715703,
        -0.03387742,     -0.025113307,   -0.000019586509, -0.041816212,    0.012045741,
        0.031073952,     0.005904968,    0.0024841477,    0.013585028,     0.0012207858,
        0.0063438285,    -0.0051320493,  -0.024432091,    -0.0012117793,   0.019349169,
        -0.019165764,    0.013558828,    -0.019218165,    0.00227618,      0.0008646209,
        -0.0063471035,   -0.00057109195, 0.015589377,     0.0035305354,    0.0106505575,
        -0.052610874,    0.0040316223,   -0.016650504,    -0.00061448675,  0.023331665,
        -0.027065255,    0.0017341544,   -0.016205093,    0.025074007,     -0.016624302,
        -0.000081876984, 0.032541186,    -0.0036615385,   -0.008384203,    0.0006128492,
        0.0014623229,    -0.0024497593,  0.00049535575,   -0.006792514,    -0.0165588,
        -0.014292446,    0.025977928,    -0.014069741,    -0.004293629,    -0.013742233,
        -0.0037106648,   -0.017724728,   0.00787329,      -0.05910863,     0.034087025,
        0.017030412,     0.0014123779,   -0.009137471,    -0.014934361,    0.025480116,
        -0.0064191553,   0.014606853,    -0.0057936152,   -0.01776403,     0.025964828,
        0.016611202,     -0.005993395,   -0.0043984316,   -0.015052265,    -0.014999863,
        0.006533783,     0.0034486584,   -0.0008793588,   -0.013978038,    -0.0103427,
        0.011842687,     -0.016218193,   -0.001817669,    -0.000052196574, -0.013388524,
        0.027327262,     -0.009628733,   -0.02314826,     -0.0006263589,   -0.03516125,
        0.0035993122,    0.015235669,    -0.0011143457,   -0.0106440075,   -0.005092748,
        0.0008175417,    -0.0011086143,  0.06723083,      -0.021170111,    -0.013368874,
        0.013106867,     -0.0013321384,  -0.03969396,     0.018641751,     0.0015220931,
        0.011482428,     0.016663603,    -0.0073623783,   0.01530117,      0.01612649,
        -0.011973689,    -0.0024039082,  -0.007146223,    -0.009556681,    0.007827439,
        0.004925719,     0.0008547957,   -0.008770662,    0.012464952,     -0.0028394938,
        0.03639268,      -0.0019650476,  -0.0021615522,   -0.008770662,    -0.01076846,
        -0.007886391,    0.015209468,    -0.019637374,    -0.009988992,    -0.010827412,
        0.010093794,     0.013467126,    0.010421302,     -0.014109042,    -0.012825211,
        0.0070676208,    0.0017619926,   0.0076243845,    0.0014492226,    0.0053907805,
        -0.042261623,    -0.007113472,   0.03605207,      0.025545618,     -0.001116802,
        0.020829504,     -0.010604707,   0.0075392323,    -0.012628705,    0.025191909,
        -0.010119995,    0.008528306,    -0.007827439,    0.013205119,     -0.0040283473,
        -0.012851411,    0.020135187,    0.024864402,     -0.00867241,     0.0061898995,
        0.0018913583,    -0.017960535,   -0.019283667,    0.0047455896,    0.0039137197,
        -0.048837982,    0.0047652405,   0.008999918,     0.021288015,     -0.011659282,
        -0.015943086,    0.009812137,    -0.007283776,    0.0027870925,    -0.0040152473,
        -0.020973608,    -0.02023999,    0.022598047,     0.009988992,     0.020790203,
        0.020030385,     -0.012694207,   0.013781534,     0.016493298,     0.038148124,
        -0.0053252787,   -0.009386377,   -0.016676703,    -0.004591661,    0.008698611,
        -0.020515095,    0.0024317463,   -0.021681024,    0.0002953712,    -0.023698473,
        0.00014799264,   -0.031231156,   0.036314078,     -0.0029180956,   -0.006779414,
        0.0013771708,    -0.03804332,    0.031781368,     0.01160688,      0.019532572,
        -0.01488196,     -0.027615469,   0.012255346,     -0.013899436,    0.017960535,
        0.0014434912,    -0.015969286,   0.0025054356,    0.007689886,     -0.0020141737,
        -0.0013992776,   -0.024851302,   0.04750175,      0.0043198294,    0.033143803,
        -0.0048012664,   -0.03958916,    -0.012687657,    -0.0010365626,   -0.013074116,
        -0.0024268336,   -0.020960508,   0.0066353106,    -0.015340471,    -0.022453943,
        -0.011868888,    0.015026064,    0.0019339343,    0.005580735,     -0.00054980395,
        0.0071658734,    -0.009956241,   0.0036648137,    0.00786674,      0.005004321,
        -0.021615522,    -0.016611202,   0.02606963,      -0.0049715703,   -0.015143966,
        -0.0030572864
    ],
    [
        0.00044115665,  -0.023998922,   -0.00072612,     -0.012444592,   -0.019026173,
        0.0136846,      0.009716575,    0.0022669889,    0.0036691516,   0.01284521,
        0.010734017,    -0.0027995564,  0.020933878,     -0.025143545,   0.008864467,
        0.0009252367,   0.026148269,    -0.0077325623,   0.01129997,     0.011827768,
        0.012152078,    0.019674793,    0.020056333,     -0.04588665,    0.00922693,
        0.0121393595,   0.017461855,    -0.031159174,    0.027750742,    -0.0015619331,
        -0.0004932211,  -0.024558516,   0.007993282,     -0.012285617,   -0.028564695,
        -0.019789254,   0.010695863,    -0.020043615,    -0.0029299161,  -0.002898121,
        0.01019986,     -0.0017455496,  -0.0013465214,   -0.0024100665,  -0.020107206,
        0.009843755,    -0.0031731485,  -0.034058884,    -0.03273621,    0.012743466,
        0.019471303,    0.0139262425,   -0.010168064,    -0.020018179,   -0.0076181,
        0.0047565433,   -0.006279527,   -0.0105178105,   0.014447682,    -0.0091697,
        0.016037436,    0.010670427,    0.0018441143,    -0.0048519284,  -0.007675331,
        0.0023162712,   -0.0047406456,  -0.003904435,    0.0063081426,   0.0019712946,
        0.02510539,     -0.0022669889,  -0.0030825324,   -0.0014856248,  0.02808141,
        0.0023607842,   -0.020692235,   0.0018298065,    -0.007605382,   0.006848659,
        0.0034402271,   -0.033550162,   0.0010826223,    0.022752555,    0.026809607,
        0.00981196,     -0.004956852,   0.026809607,     -0.016101025,   0.021073775,
        -0.0079614865,  0.0004757338,   0.01769078,      0.008349387,    -0.012609926,
        0.018123193,    0.0015094712,   0.0035642278,    0.004209668,    -0.03937502,
        -0.014930967,   0.012031256,    -0.003007814,    -0.0050713145,  0.0037772548,
        0.014409528,    0.011058327,    0.0032748927,    0.028742747,    -0.026300885,
        0.011280892,    0.018492015,    0.011846845,     -0.030777631,   -0.010028167,
        -0.03098112,    0.024278719,    0.01123002,      -0.007611741,   -0.007675331,
        0.0034815606,   0.0001675203,   0.012787979,     -0.002303553,   0.0030284808,
        0.018034166,    -0.025982935,   -0.0304724,      -0.014791069,   -0.0089026205,
        0.026326321,    -0.004384541,   0.010301604,     0.0037359213,   -0.020069052,
        0.028997108,    -0.013188597,   0.03164246,      -0.019051608,   -0.021557061,
        0.023388457,    0.0008378002,   -0.0019999102,   -0.002446631,   -0.017932422,
        0.0021588856,   0.022688964,    0.031311788,     0.006149167,    -0.021137366,
        0.041282725,    0.0062381937,   0.019789254,     -0.0055800355,  0.03349929,
        0.011064686,    0.0056531643,   0.033473853,     -0.016457131,   -0.0024164256,
        0.01736011,     0.012877005,    0.0039934614,    -0.01840299,    -0.0019013454,
        0.028055973,    0.0058979862,   0.0016453951,    -0.0012503413,  -0.017957859,
        -0.0061459877,  0.040519644,    -0.008832672,    0.037009466,    -0.00471203,
        0.013112289,    0.010365195,    0.016164616,     -0.0008664158,  -0.00826036,
        -0.02510539,    0.020234386,    -0.011840486,    0.0014538298,   -0.020018179,
        -0.014295066,   0.019229662,    -0.005214392,    0.013697318,    -0.005952038,
        0.007236559,    -0.0007893127,  0.0029140185,    -0.02640263,    -0.67069805,
        -0.0049218773,  -0.010282527,   0.0007467868,    0.0154651245,   0.021442598,
        0.0038917172,   -0.008769082,   -0.021785986,    -0.008241284,   0.0052398285,
        0.011656074,    0.02537247,     -0.016724208,    0.020666799,    -0.01924238,
        0.025079954,    -0.017474573,   0.020552335,     0.0058216783,   -0.03316862,
        0.026122833,    0.0028488387,   -0.01652072,     0.0010389041,   0.008826313,
        0.027420072,    -0.035457868,   0.0030555066,    0.034109756,    -0.04222386,
        0.03672967,     0.026326321,    0.021518907,     0.0432413,      -0.015999282,
        -0.025168981,   0.040774003,    -0.024507644,    0.024940057,    -0.027394636,
        -0.003376637,   -0.0075863046,  0.0046611577,    -0.013226751,   -0.00042048987,
        0.016495284,    -0.020679517,   0.022180244,     -0.007242918,   -0.010734017,
        -0.004505362,   0.018606478,    -0.02013264,     -0.0025992473,  0.018949864,
        0.015999282,    0.007916974,    0.023134096,     0.0016438053,   0.012997827,
        -0.0023782717,  -0.021124648,   0.018822685,     -0.0041079237,  0.035127196,
        -0.013570137,   0.012031256,    0.02039972,      -0.025957499,   0.018746376,
        -0.0046516196,  -0.017639907,   0.010753094,     0.000034651664, 0.0009967756,
        0.019509457,    -0.014078859,   -0.000092354756, 0.0007372483,   -0.0062000393,
        -0.009538522,   -0.007986923,   0.0052334694,    0.012177514,    -0.018021448,
        -0.023477484,   0.003859922,    0.0011160071,    -0.019140635,   0.01962392,
        0.013099571,    -0.0074146115,  0.00013483099,   0.012775261,    -0.0152870715,
        -0.007192046,   0.019611202,    -0.006021987,    -0.03472022,    0.01090571,
        -0.009856473,   -0.0018886274,  -0.00084018486,  -0.0037104853,  -0.0050140833,
        -0.0022797068,  0.028946236,    0.04957488,      -0.00041333598, -0.009532163,
        0.0074909194,   0.011649716,    0.017703498,     -0.021417161,   -0.019992743,
        0.010288886,    -0.0059170634,  0.023859024,     -0.017843395,   -0.008966211,
        -0.0051825973,  -0.0047406456,  -0.013595574,    0.017220212,    0.0013028032,
        -0.002142988,   -0.029378649,   -0.00819677,     0.017919704,    -0.00026330297,
        -0.002743915,   0.0029442238,   0.005818499,     0.023935333,    0.018988019,
        0.01284521,     -0.011388996,   0.012444592,     -0.010816684,   -0.019801972,
        0.00948765,     0.007344662,    -0.010486015,    -0.0070267115,  -0.016075589,
        0.009067955,    -0.0055164453,  -0.02963301,     0.003815409,    0.0029140185,
        -0.011509817,   0.0036437155,   -0.0012042384,   0.012190231,    0.009150622,
        -0.0016438053,  -0.012241104,   0.010358836,     -0.0032415078,  0.023261277,
        0.01646985,     -0.011134635,   0.0075926636,    -0.006816864,   0.007370098,
        -0.007338303,   0.012997827,    -0.010575042,    -0.022129372,   0.0010802377,
        -0.038077783,   -0.005777165,   0.0036087409,    -0.027420072,   0.0040888465,
        0.011923153,    -0.016927697,   -0.005869371,    0.0014752914,   0.00063868356,
        0.005325675,    0.009309598,    -0.012832492,    0.027674433,    -0.015185327,
        0.013481111,    0.023490202,    -0.009818319,    0.020234386,    -0.0054782913,
        0.031998564,    0.0066133756,   0.000091957314,  0.0002110398,   -0.0060792184,
        0.014078859,    0.029683882,    0.031667896,     0.025168981,    -0.0050458782,
        -0.0024052975,  0.027852485,    -0.012470028,    0.029963678,    -0.034440424,
        0.009939141,    -0.037467316,   0.013239469,     0.0022447323,   -0.00026211064,
        0.0061873216,   0.013531984,    -0.011249097,    0.015147174,    -0.002956942,
        -0.014816505,   0.008559234,    -0.011223662,    -0.011338123,   0.02686048,
        -0.0024943235,  -0.0019267815,  0.0062509114,    -0.031617023,   0.032456413,
        0.0008688004,   0.015922973,    -0.0029013006,   -0.054382294,   0.004546696,
        0.00040975903,  -0.03128635,    0.0066133756,    -0.0023083223,  -0.007255636,
        -0.01155433,    -0.03164246,    0.028615568,     -0.013379367,   0.003945769,
        0.031718764,    0.039731126,    -0.016151898,    0.018695503,    0.0051094685,
        0.020348847,    -0.01750001,    -0.03756906,     -0.0069758394,  -0.023121377,
        -0.007675331,   -0.0071093785,  0.010441503,     0.015566869,    -0.004400438,
        0.014409528,    -0.002239963,   0.027776176,     0.0197511,      0.014333219,
        0.001891807,    -0.0005154776,  0.01845386,      0.009907345,    -0.0147783505,
        -0.022345578,   -0.0045149005,  0.0030539169,    -0.0013481112,  0.007719844,
        -0.016597029,   -0.002278117,   -0.041791447,    -0.01381178,    -0.01465117,
        -0.012323771,   0.0024180154,   0.0014220347,    -0.009373188,   0.0152870715,
        -0.035661355,   0.000121914236, 0.025168981,     0.0034847402,   0.008470207,
        -0.021557061,   -0.004349566,   -0.021200955,    0.02226927,     -0.03438955,
        0.012063052,    0.005611831,    -0.0073510213,   -0.0137609085,  -0.011395355,
        0.007185687,    -0.01582123,    0.011058327,     -0.0183394,     -0.021671522,
        0.02652981,     -0.01826309,    -0.013468393,    0.014167885,    0.005312957,
        -0.026122833,   0.0015873691,   0.0123110525,    -0.005519625,   0.0014363425,
        -0.009417701,   -0.00781523,    0.01116643,      -0.012438233,   -0.019496739,
        -0.018555606,   -0.008317592,   0.021150084,     -0.004718389,   -0.005707216,
        -0.031845946,   -0.032685336,   -0.0029267366,   0.10388087,     0.006835941,
        0.009341393,    0.017054878,    0.027420072,     -0.0023019633,  -0.019547611,
        -0.028055973,   0.002885403,    -0.0041333595,   -0.016342668,   0.0034179706,
        0.0066324524,   0.0056181895,   0.0027836587,    0.012743466,    -0.010193501,
        -0.012285617,   0.011605202,    -0.00039127812,  -0.003589664,   0.018479297,
        0.014867377,    0.02407523,     -0.0013338034,   -0.025703138,   -0.0079614865,
        0.018085038,    -0.013315777,   -0.026733298,    -0.024215128,   -0.013315777,
        -0.007707126,   0.008234925,    0.014752914,     0.042351037,    -0.020476028,
        -0.0035610483,  0.047514558,    -0.014066141,    0.029734753,    0.027216583,
        -0.000568337,   -0.047082145,   0.024355028,     -0.014244193,   -0.011624279,
        0.025156263,    -0.009290521,   -0.006899531,    0.03454217,     -0.016736927,
        -0.0067087607,  0.019547611,    0.013392085,     0.0015690869,   0.010727658,
        -0.005764447,   0.0019204225,   0.00088390306,   -0.0010667248,  -0.0022320142,
        0.011808691,    -0.021442598,   0.00052859314,   -0.022485476,   0.0022177065,
        -0.017080314,   -0.016368104,   -0.029785626,    0.0059234225,   -0.035254378,
        0.004409977,    -0.00277571,    0.017741652,     0.0041174623,   0.0019220122,
        -0.020476028,   0.0038885376,   -0.0101807825,   -0.00044234897, -0.030319784,
        -0.012724388,   -0.009722934,   0.0074082525,    0.035076328,    0.015477843,
        0.00729379,     -0.02833577,    0.008254001,     0.013252187,    -0.005869371,
        0.004034795,    -0.01800873,    0.0066260933,    -0.020488746,   0.015172609,
        -0.013442958,   0.009996371,    -0.008870826,    0.003414791,    -0.022103935,
        -0.010823043,   0.009385906,    0.013519266,     -0.006492554,   -0.008184052,
        0.0016406259,   -0.045683164,   -0.028971672,    0.005627728,    -0.007948768,
        0.011433509,    -0.0062063984,  -0.0041556163,   0.022752555,    0.0047470047,
        0.012832492,    0.0057294723,   -0.03848476,     0.00055164454,  -0.033524726,
        0.01794514,     0.030345218,    -0.01704216,     0.0035928434,   0.017868832,
        -0.013010545,   -0.0037995114,  -0.01968751,     -0.010295245,   -0.0042255656,
        0.014600298,    0.01884812,     -0.017589035,    0.0124827465,   -0.026962223,
        0.0032717132,   -0.019916434,   0.008145898,     -0.019674793,   -0.011904076,
        0.013633728,    -0.017398264,   -0.028361207,    -0.019534893,   0.0032748927,
        -0.0032939697,  -0.0033003287,  0.004530798,     -0.022968762,   0.0069376854,
        0.0059424993,   0.014206039,    -0.0008370053,   -0.036577053,   -0.0028551978,
        -0.0066833245,  0.024176974,    0.0077389213,    0.032634463,    -0.008362104,
        0.01943315,     0.010555965,    -0.0040220767,   0.0035483304,   -0.008769082,
        0.01239372,     -0.04924421,    0.012527259,     0.015922973,    0.020234386,
        -0.0068804543,  0.008323951,    0.030065423,     0.013468393,    0.017512728,
        -0.0015396765,  0.00548783,     -0.027776176,    -0.00419695,    0.028361207,
        -0.010829402,   -0.00393623,    0.010797608,     -0.017894268,   0.036297258,
        0.020336129,    -0.019509457,   -0.008368463,    0.019064326,    -0.0099455,
        0.02111193,     -0.015757639,   -0.0042573605,   -0.02220568,    -0.009067955,
        0.006266809,    -0.003783614,   -0.0066642477,   -0.0051539815,  0.015999282,
        -0.016762363,   0.003085712,    0.00826036,      0.01761447,     0.018390272,
        -0.025334315,   0.025703138,    -0.0046516196,   -0.017093033,   -0.05150802,
        -0.005595933,   -0.032507285,   -0.014816505,    -0.009881909,   0.013735472,
        0.016342668,    -0.008368463,   -0.023591945,    0.018275809,    0.00497275,
        0.04357197,     0.0068804543,   0.027572688,     0.0048900824,   -0.010994737,
        -0.014536708,   0.04189319,     0.009659343,     0.0110328905,   -0.0021779626,
        -0.013112289,   0.016864108,    -0.012794338,    -0.0075417915,  0.0015611382,
        -0.023795433,   -0.020857569,   0.014434963,     0.0030936608,   0.008991647,
        -0.026504373,   -0.0039553074,  -0.010803966,    0.034898274,    -0.008025077,
        -0.016151898,   -0.0028106845,  -0.041664265,    -0.03454217,    0.0076181,
        -0.005236649,   -0.0017010365,  -0.012997827,    0.00671512,     -0.004015718,
        -0.0003714062,  0.01284521,     -0.0050903913,   0.011974025,    -0.0035928434,
        0.013277623,    0.008966211,    0.008006,        -0.021328136,   0.015401534,
        0.015019993,    0.001710575,    0.022536349,     -0.005106289,   -0.0072174817,
        -0.023477484,   0.015185327,    0.0025595035,    0.02716571,     -0.00600291,
        -0.019801972,   -0.02279071,    -0.0034815606,   0.00077540235,  0.008889902,
        -0.020056333,   -0.013722754,   -0.018708222,    0.02439318,     -0.012775261,
        -0.021595215,   0.016762363,    -0.021900447,    -0.004149257,   -0.003382996,
        0.008292155,    0.0020666798,   0.005723113,     -0.02195132,    -0.0029919166,
        0.04285976,     -0.024253283,   0.012730747,     0.0034306885,   0.0024800159,
        -0.008991647,   0.010829402,    0.01504543,      -0.019127917,   0.039298713,
        -0.040774003,   -0.045403365,   -0.02104834,     0.0009999551,   -0.006114193,
        -0.023846306,   -0.0093286745,  0.00929688,      0.01563046,     0.01355742,
        -0.036551617,   0.00651799,     0.008578311,     0.012285617,    -0.011408073,
        0.015109019,    -0.02652981,    0.004499003,     -0.00037120748, 0.0017280623,
        0.024329592,    -0.034872837,   -0.00017199149,  0.0043527456,   0.02569042,
        0.006753274,    -0.016406259,   -0.0435211,      -0.023350302,   -0.017258367,
        0.025982935,    0.0029585317,   -0.017080314,    0.018809967,    0.025067236,
        0.016406259,    0.021595215,    0.029073415,     -0.015337944,   0.0147783505,
        -0.020997467,   -0.03878999,    -0.02032341,     0.021938602,    0.016597029,
        0.018657349,    -0.0074909194,  -0.02963301,     -0.015210764,   -0.042198423,
        0.018860837,    -0.013353931,   0.020030897,     0.012247463,    -0.008311233,
        0.014663888,    0.02640263,     0.0014164705,    0.01465117,     -0.015541432,
        0.000581055,    -0.0029791985,  0.0059488583,    0.00909975,     0.0055069067,
        -0.0065815803,  -0.016215488,   0.012718029,     0.0024704773,   -0.0033543804,
        -0.007001275,   -0.021658804,   0.012489106,     -0.04466572,    0.030039987,
        0.005287521,    0.0018965761,   0.009188777,     -0.00387264,    -0.0020301156,
        -0.008667338,   0.008864467,    -0.016686056,    -0.0021175519,  0.018301245,
        -0.0080505125,  0.02627545,     -0.0038885376,   -0.003853563,   -0.0007698382,
        0.0028170436,   0.018174065,    -0.010759453,    0.012431874,    -0.00049799035,
        0.008915339,    -0.014600298,   -0.011058327,    0.011605202,    0.01859376,
        -0.01032704,    -0.0048328512,  0.00040618208,   0.016546156,    -0.0077834344,
        0.0016962672,   -0.031311788,   0.004667517,     -0.0006029141,  0.005125366,
        -0.010079038,   0.02607196,     0.005119007,     -0.0063145016,  0.016317232,
        0.012959672,    0.0065370672,   -0.023655536,    -0.007955127,   0.00729379,
        0.009659343,    0.0012320591,   -0.012031256,    -0.009430419,   -0.03634813,
        0.00072532514,  -0.00251658,    -0.030930249,    -0.002311502,   0.2102036,
        -0.009106109,   0.017410982,    -0.002762992,    -0.018313963,   0.032354668,
        0.016724208,    0.031108301,    -0.0031985845,   0.0002563478,   -0.016253643,
        -0.00897257,    0.020387001,    0.010416066,     -0.012171155,   -0.008788158,
        -0.035585046,   -0.0152362,     -0.025079954,    -0.02749638,    0.019191507,
        0.0012678286,   0.0034688427,   -0.011675151,    0.01652072,     -0.007198405,
        -0.012158437,   -0.0130741345,  0.0127371065,    0.025029082,    0.003929871,
        -0.015668612,   -0.020348847,   -0.018988019,    -0.021188237,   -0.01019986,
        0.006346297,    0.0025324777,   -0.021328136,    0.015032711,    0.018708222,
        0.0074146115,   -0.005656344,   -0.0005627728,   -0.015579587,   0.0112872515,
        -0.005344752,   0.0063653737,   -0.015439688,    0.01343024,     -0.014752914,
        -0.0037391006,  -0.004216027,   0.036831412,     -0.0003042391,  0.01924238,
        0.014689324,    -0.01019986,    -0.0037136646,   -0.003952128,   -0.00852108,
        0.038688246,    0.003834486,    0.0037104853,    0.0047406456,   0.016825953,
        -0.018746376,   0.025995653,    0.016508002,     -0.022065781,   -0.028132282,
        -0.02336302,    -0.017372828,   0.006861377,     -0.033397548,   -0.024545798,
        0.024355028,    0.021976756,    0.015198045,     -0.00593614,    0.014066141,
        -0.007694408,   -0.016062872,   0.012158437,     -0.022510912,   -0.015172609,
        0.044335052,    0.012870646,    -0.00852108,     -0.0046325424,  0.003783614,
        -0.028437514,   0.010428784,    0.0060506025,    -0.01956033,    0.017461855,
        -0.004187411,   0.0074146115,   -0.0075926636,   0.008292155,    -0.008145898,
        -0.016075589,   0.039527636,    -0.0130741345,   -0.010212578,   0.001594523,
        0.018492015,    0.011700587,    0.02976019,      -0.018924428,   -0.037340134,
        -0.021480752,   0.0033512008,   -0.0045721317,   0.016635183,    0.004422695,
        0.008037794,    -0.013722754,   0.022409169,     -0.010409707,   -0.019216944,
        -0.02233286,    -0.005351111,   -0.004444951,    0.013544702,    -0.02168424,
        0.0106068365,   0.018631913,    0.022688964,     -0.04026528,    -0.015210764,
        -0.032685336,   -0.0036977672,  -0.013888088,    -0.011312688,   0.0074336883,
        -0.004762902,   -0.0011629049,  -0.0035419713,   0.010867557,    -0.0032224308,
        0.010238014,    0.021773268,    -0.016444413,    0.017983293,    -0.01303598,
        0.037772547,    0.021391725,    -0.00833031,     0.008323951,    -0.017932422,
        -0.0034752015,  -0.013061416,   0.002615145,     0.0068423,      -0.023184968,
        -0.020793978,   -0.02917516,    -0.010377912,    0.021061057,    -0.023312148,
        0.0025388368,   0.008317592,    -0.026377194,    -0.019000737,   -0.021531625,
        -0.16095938,    0.0100090895,   0.038764555,     0.0009943909,   0.004718389,
        0.018797249,    0.036119204,    -0.0050903913,   0.0026707863,   0.0035228943,
        0.025168981,    0.008031436,    -0.03647531,     0.0031826869,   0.0062063984,
        0.011446226,    -0.040214412,   0.020056333,     0.023184968,    0.0012026487,
        -0.009748369,   -0.017398264,   0.0022224756,    0.022574503,    0.009411342,
        0.018161347,    -0.005465573,   0.008209488,     -0.0022224756,  -0.015109019,
        -0.024609387,   -0.005179418,   0.009888268,     -0.010454221,   0.022650812,
        0.0062191165,   -0.022053063,   -0.014638452,    -0.009233289,   -0.00059734995,
        0.013633728,    0.005055417,    0.01750001,      -0.011096481,   0.009220571,
        0.027318329,    0.009284162,    0.01291516,      0.020145359,    -0.011077404,
        0.0077770753,   -0.03278708,    0.01187228,      0.0058820886,   0.030803068,
        0.007993282,    -0.00044433615, -0.0063812714,   -0.0065879393,  -0.032151178,
        -0.0010858017,  -0.013112289,   0.005106289,     -0.0037104853,  -0.005672241,
        -0.0014895992,  -0.019891,      0.006816864,     -0.02562683,    0.018619196,
        -0.009780165,   0.003414791,    0.010670427,     -0.032151178,   0.0006060936,
        -0.004556234,   -0.026580682,   -0.000030478559, 0.009112468,    -0.014345937,
        -0.011484381,   0.031693332,    -0.018771812,    -0.013239469,   0.012743466,
        0.01259085,     -0.0061428086,  -0.014498554,    -0.004912339,   -0.01948402,
        0.007274713,    -0.009678421,   -0.024609387,    -0.026707862,   0.027191147,
        0.037238393,    0.0018679607,   -0.0006585555,   0.029505828,    -0.01872094,
        -0.004444951,   0.007910615,    -0.020285258,    -0.00025614907, 0.035712227,
        0.01652072,     0.015312508,    0.003672331,     0.023032352,    0.0142696295,
        0.0014959583,   0.00335756,     -0.0018361656,   0.03349929,     -0.015070865,
        0.026377194,    -0.014714761,   -0.007986923,    0.043673713,    -0.001168469,
        0.045403365,    0.0017376008,   -0.013633728,    -0.0073573804,  0.0047851587,
        -0.009907345,   -0.083023295,   -0.0018743196,   -0.0082222065,  0.02833577,
        -0.00033802137, -0.0013560599,  -0.013150442,    0.014371374,    -0.017207494,
        0.016215488,    -0.0029299161,  -0.02602109,     0.020997467,    -0.00929688,
        0.010422425,    -0.011675151,   -0.011573407,    -0.01239372,    -0.012813415,
        0.016558874,    0.013697318,    -0.007980564,    -0.009907345,   0.00058582425,
        -0.0029394545,  -0.012355566,   -0.040697694,    0.01381178,     0.0045530545,
        0.012279258,    0.008190411,    -0.027191147,    0.02369369,     -0.022485476,
        -0.006397169,   0.0137609085,   -0.011153712,    0.0049282364,   0.02711484,
        -0.024685696,   -0.004209668,   -0.0023099121,   0.017080314,    -0.032430977,
        -0.0018409349,  -0.015350662,   0.006273168,     -0.01245731,    -0.0040697693,
        -0.044691157,   -0.04184232,    -0.005570497,    -0.022409169,   0.0039712046,
        0.013468393,    0.012260181,    0.015096301,     -0.0070203524,  0.015808512,
        0.012349207,    0.0063558356,   -0.010727658,    -0.029149724,   -0.013125007,
        -0.00066888885, -0.005093571,   -0.016686056,    0.008858108,    0.013366649,
        -0.034745656,   -0.0005417086,  0.026224578,     -0.0060728593,  0.011567048,
        -0.035915717,   0.012450951,    -0.0065370672,   -0.0018743196,  0.018161347,
        -0.018174065,   -0.0041937702,  -0.022930607,    0.020819414,    -0.020285258,
        0.0062254756,   0.016431695,    0.013086853,     -0.0065815803,  -0.009023442,
        -0.0012821364,  -0.0106068365,  0.0043750023,    -0.010734017,   -0.02640263,
        -0.0071729687,  0.002724838,    0.0014983428,    0.0030173527,   0.020107206,
        -0.0137609085,  -0.009843755,   -0.013353931,    -0.055145375,   0.025995653,
        0.0037422802,   0.00072810723,  -0.00033166236,  -0.026173705,   0.011738742,
        -0.021913165,   -0.006158706,   -0.025347034,    -0.015605022,   0.0060728593,
        0.0008831082,   -0.013048698,   -0.01374819,     -0.022294706,   -0.00258176,
        0.008088667,    0.005039519,    0.0019124737,    0.023897178,    0.007141174,
        0.016635183,    0.009780165,    -0.0040443335,   -0.0038758195,  -0.009373188,
        0.03126092,     -0.00871185,    -0.02168424,     0.010829402,    -0.023477484,
        -0.0017328316,  0.024596669,    0.028259462,     -0.0056690616,  0.016622465,
        0.010835761,    0.026555246,    0.0494477,       -0.034974582,   -0.012113923,
        0.0027168891,   -0.024558516,   -0.003452945,    0.0059170634,   -0.013150442,
        -0.0040125386,  0.044157,       -0.0131631605,   0.02343933,     0.030904813,
        -0.025537804,   0.005084032,    -0.022472758,    -0.032812517,   0.027267456,
        0.015261636,    0.006184142,    0.001193905,     0.016279077,    -0.0050903913,
        0.039069787,    0.014625735,    0.0035419713,    0.008635542,    -0.0125209,
        -0.0041174623,  -0.01769078,    -0.03812865,     -0.0022415528,  -0.016902262,
        0.018237654,    0.014231475,    -0.004820133,    0.010702222,    0.00690589,
        0.015261636,    -0.02640263,    0.024253283,     0.013016904,    -0.007675331,
        -0.029480392,   0.009627549,    0.028615568,     0.023935333,    0.008597388,
        0.0013123417,   0.00016513567,  0.004705671,     -0.015668612,   0.00948765,
        -0.0136846,     0.0007893127,   -0.016889544,    0.032965135,    -0.012463669,
        -0.0035101762,  0.017334675,    0.009761088,     0.007249277,    -0.015185327,
        -0.009525804,   -0.004781979,   -0.021251827,    0.023769997,    -0.00968478,
        -0.031515278,   0.010492374,    -0.0025229391,   0.029861934,    -0.011198225,
        0.005185777,    0.0073510213,   -0.015096301,    0.028717311,    -0.013188597,
        0.0036786902,   -0.029989114,   0.01504543,      0.010034526,    -0.0079614865,
        0.02846295,     -0.007662613,   -0.013442958,    0.018949864,    0.023935333,
        -0.009366829,   -0.0021270905,  -0.028183155,    0.003878999,    -0.002569042,
        -0.029531265,   0.0031651997,   0.0045149005,    -0.005885268,   -0.009983653,
        0.019967306,    -0.019916434,   0.038891736,     -0.017449137,   0.00011396547,
        0.012126641,    -0.01181505,    0.020768542,     0.00046897735,  0.03194769,
        0.0004582465,   -0.0022765272,  -0.0013083674,   -0.025054518,   0.008743646,
        0.00046738758,  -0.026682427,   0.0072619948,    -0.0046039266,  0.006829582,
        -0.0074845604,  -0.004120642,   0.023019634,     0.012902441,    0.036297258,
        -0.00780887,    -0.042885195,   0.0013123417,    0.028819056,    0.019026173,
        0.010549606,    -0.022943325,   0.009417701,     0.0054401373,   -0.029429521,
        0.009468573,    -0.0075417915,  -0.010301604,    -0.0030698145,  -0.014409528,
        -0.0034306885,  -0.0048455694,  -0.015897537,    0.0012877005,   -0.012807056,
        -0.026733298,   0.017029442,    0.0074845604,    0.0016231386,   -0.0028695054,
        -0.007382816
    ],
    [
        -0.00028408386, -0.030921403,   0.0017461961,    -0.007926553,   -0.008247016,
        0.029273309,    0.0027844305,   0.0088290805,    0.0020862792,   0.001850837,
        0.0004868257,   0.004914855,    0.030529,        -0.033118863,   0.022419326,
        0.0031359587,   0.030842923,    -0.016101629,    0.018940013,    -0.006186897,
        -0.008390897,   0.007514529,    0.008175075,     -0.012380334,   0.007200606,
        0.0015352791,   0.0071482854,   -0.011484345,    0.007194066,    -0.006736262,
        0.0009049808,   -0.01856069,    0.008959882,     -0.02718049,    -0.030031955,
        -0.012609236,   -0.011432025,   -0.000060597744, 0.0390834,      -0.00019783681,
        0.0071025053,   0.01747504,     -0.015918506,    -0.0062261373,  -0.0049966057,
        0.008534778,    0.009247645,    -0.007959253,    -0.04015597,    0.013838767,
        0.013969569,    0.010934981,    -0.0040025166,   0.0022285255,   -0.0067820423,
        -0.008194695,   -0.0096335085,  0.006209787,     0.010261354,    -0.006445229,
        -0.0066839415,  -0.0025702436,  -0.0028007806,   0.0009164259,   -0.012151431,
        -0.00014674259, 0.011314304,    -0.019737901,    0.0068997634,   0.007331407,
        0.036336575,    -0.0021680298,  0.0024606977,    -0.0007745884,  0.00985587,
        -0.0049573653,  -0.022066163,   -0.0065040896,   -0.010745319,   -0.008802921,
        0.00021173444,  -0.028880905,   -0.021098234,    0.03481928,     0.03822011,
        0.003809585,    -0.011693628,   0.012726957,     -0.012197211,   0.0019865432,
        -0.0028776263,  -0.008436677,   -0.0021631247,   0.0118375085,   -0.0044962913,
        0.002622564,    -0.011360084,   0.00865904,      -0.009659668,   -0.027677534,
        -0.019397818,   0.0040875375,   0.011386245,     -0.0011322479,  0.003714754,
        0.005578671,    0.025218472,    0.012112191,     0.014623574,    -0.002947932,
        0.0041954485,   0.009456927,    0.018142127,     -0.055878274,   -0.014335811,
        -0.03162773,    0.0075733894,   0.015840026,     0.005258208,    -0.015879266,
        0.033354305,    -0.004542072,   -0.006638161,    -0.0075930096,  -0.011366624,
        0.019332416,    -0.019515539,   -0.022445485,    0.005876244,    -0.016559431,
        0.018220607,    -0.0039894367,  0.031209165,     -0.0049737156,  -0.020195706,
        0.0175012,      -0.024669107,   0.0014339081,    -0.005912214,   -0.015800785,
        0.0117197875,   0.008161995,    -0.00982971,     -0.0023348015,  -0.008292796,
        0.035420965,    -0.00040343995, 0.0022628608,    0.00032904677,  -0.009273805,
        0.01975098,     -0.013420203,   0.016650993,     -0.009143004,   0.024865309,
        0.0035185523,   0.007305247,    0.024132822,     -0.012635396,   -0.0118375085,
        -0.00873098,    0.011706707,    0.0009687464,    -0.012295313,   0.0057160123,
        0.03508088,     0.003142499,    0.00035152823,   0.009476547,    -0.028410021,
        -0.009908191,   -0.0033109053,  -0.009188784,    0.0148720965,   -0.031183006,
        0.022066163,    0.014021888,    0.022144644,     -0.0108565,     -0.008155455,
        -0.009005663,   0.025231551,    0.018966174,     0.009156084,    -0.017017236,
        -0.017893605,   -0.021320596,   -0.008103134,    0.015840026,    -0.013420203,
        0.0027533653,   0.0054249796,   -0.009339206,    0.0120271705,   -0.6701207,
        -0.029901154,   -0.012995099,   -0.008050814,    -0.005356309,   0.016977996,
        0.021202875,    -0.008207776,   -0.006464849,    0.0027942406,   -0.004453781,
        0.027154328,    -0.0054249796,  -0.015905425,    0.0003684915,   -0.011432025,
        0.023544217,    -0.024289783,   0.0054053594,    -0.020313427,   -0.03398215,
        0.030031955,    0.020993592,    -0.0015753369,   -0.01965942,    0.0072725466,
        0.02515307,     -0.0078022913,  -0.0094438465,   0.015683064,    -0.022288524,
        0.028880905,    -0.0020388637,  0.009620428,     0.056296837,    -0.02825306,
        -0.0049508256,  0.030319719,    -0.020561948,    0.02189612,     -0.009594268,
        -0.014885177,   -0.004842914,   -0.0040940777,   0.0069651636,   -0.0061836266,
        0.013564085,    -0.0030018876,  0.023504976,     0.007946173,    0.00439492,
        0.030895242,    -0.007109045,   -0.002619294,    -0.0028759914,  0.008711359,
        0.030215077,    -0.013551004,   0.012406494,     -0.010562196,   -0.010503336,
        -0.0016023146,  0.005088167,    0.0026634394,    -0.0011150802,  0.04154246,
        0.015447621,    0.0417779,      0.016781794,     -0.03377287,    0.037696905,
        0.014466613,    -0.0071417456,  0.017775884,     -0.010137093,   0.0028972465,
        0.024315942,    -0.011026541,   -0.008103134,    -0.004470131,   -0.0019244127,
        -0.0027975107,  -0.025859397,   -0.0050293063,   0.02404126,     -0.012275693,
        -0.010719159,   0.01203371,     0.0030002524,    0.005892594,    -0.008632879,
        0.027154328,    -0.0020241486,  0.000026620088,  0.007913472,    -0.0123345535,
        0.007821912,    0.0049508256,   0.0072463863,    -0.039449643,   0.017592762,
        -0.034583837,   0.0058173835,   -0.0136164045,   0.0045191813,   -0.0022432406,
        -0.0027599053,  0.004872345,    0.061633524,     -0.020287266,   -0.008672119,
        0.0023658667,   0.014440453,    -0.004061377,    -0.011785188,   -0.02391046,
        0.0074360482,   0.009411146,    0.030999884,     -0.022602446,   -0.0059449147,
        0.016755633,    0.008417057,    -0.014675895,    0.024760667,    0.015643824,
        -0.025950957,   -0.01975098,    -0.034688476,    0.013256702,    -0.015853105,
        -0.004542072,   0.0031147036,   -0.0036428133,   0.016167028,    -0.0038815255,
        0.013838767,    -0.0061705466,  0.01963326,      0.0041006175,   -0.008436677,
        0.013276322,    0.011327384,    -0.01757968,     0.00070837024,  -0.029377948,
        -0.0011714882,  -0.007501449,   -0.04912893,     0.026591884,    0.017736642,
        -0.009371906,   -0.015604583,   0.00028060944,   0.009581188,    0.00657276,
        -0.024826068,   -0.006252297,   -0.0038651754,   -0.016729474,   0.01858685,
        0.0048265643,   -0.011628226,   0.011360084,     -0.0044014603,  -0.017736642,
        0.016023146,    0.033171184,    -0.008338576,    -0.024211302,   -0.009025283,
        -0.035525605,   -0.02287713,    0.029037867,     -0.002849831,   -0.010627598,
        -0.0019881781,  -0.022602446,   -0.015316821,    0.008227396,    -0.0026863297,
        0.011700167,    -0.00043777528, -0.001362785,    0.03604881,     -0.0003721703,
        0.00057225523,  0.017867444,    -0.009757769,    0.037749227,    -0.021516798,
        0.027991457,    0.012864298,    -0.011248903,    -0.0052778283,  0.013498683,
        0.008528238,    0.021137474,    0.008515158,     0.031339966,    -0.001971828,
        -0.009947431,   0.028462341,    -0.005150297,    0.020575028,    -0.009522327,
        0.0011649482,   -0.028907064,   0.03508088,      0.003377941,    0.004287009,
        -0.024865309,   0.02064043,     -0.0020192435,   0.006477929,    0.014911337,
        -0.005856624,   0.0015025787,   -0.01629783,     -0.0022285255,  0.019070815,
        -0.012426114,   -0.01739656,    -0.0031245137,   -0.015539182,   0.02084971,
        0.0005252486,   0.026539564,    0.006029935,     -0.042222627,   0.013152061,
        0.008031194,    -0.015146779,   0.009221485,     0.022759408,    -0.023060251,
        -0.0026634394,  -0.015094458,   0.023295693,     -0.014518933,   0.014924417,
        0.026448002,    0.04350448,     -0.010405235,    -0.012184132,   0.014793616,
        0.004015597,    0.00004401767,  -0.019031575,    0.023714257,    -0.017592762,
        0.016873354,    -0.012511135,   0.020391908,     0.0036297333,   0.012262613,
        0.009430766,    0.0035545225,   0.022497807,     0.036336575,    0.0074229683,
        -0.013269782,   0.020221865,    0.021438317,     0.017972086,    -0.013328643,
        0.016821034,    0.009169164,    0.005117597,     0.024564466,    -0.008037734,
        -0.01408729,    -0.008070434,   -0.00977085,     0.023884298,    -0.0017412909,
        0.006203247,    -0.004578042,   0.013799527,     -0.008279716,   -0.013904167,
        -0.034296073,   0.020234946,    0.0153299,       -0.011006921,   -0.012753117,
        -0.015382221,   0.0047317334,   -0.03144461,     0.013655645,    -0.025715515,
        0.012870838,    -0.015055218,   -0.011275063,    0.0025244632,   -0.0068997634,
        0.037696905,    -0.005261478,   0.034296073,     -0.021987682,   0.0059710746,
        0.012746577,    -0.02843618,    -0.01739656,     0.011870209,    -0.004018867,
        -0.024525225,   -0.004571502,   0.0066774013,    0.005133947,    -0.0029708222,
        -0.007534149,   -0.0174358,     0.011190043,     0.0009000758,   -0.012896998,
        -0.008541319,   0.013511764,    0.023884298,     0.009156084,    -0.007095965,
        -0.032909583,   -0.02733745,    -0.002501573,    0.11887213,     0.017605841,
        0.018390648,    0.013969569,    0.013577164,     -0.004463591,   -0.019358577,
        -0.018024405,   0.014100369,    -0.0023462465,   0.005761793,    -0.02281173,
        0.002182745,    0.0037376443,   0.01747504,      0.00044840286,  -0.022026923,
        -0.016101629,   0.013825687,    -0.011772108,    0.0066970214,   0.0108892,
        -0.0031915493,  0.01631091,     -0.021909202,    -0.024172062,   0.008619799,
        0.012569996,    -0.008207776,   -0.015042138,    -0.015486862,   -0.010542576,
        0.0008943532,   0.021307515,    -0.0015557167,   0.009476547,    -0.00005768537,
        0.011791728,    0.036388893,    -0.0036657036,   0.023871219,    0.024747588,
        0.0113404635,   -0.037592266,   0.014819776,     -0.005568861,   0.013825687,
        0.017134957,    0.001968558,    -0.021556038,    0.056453798,    0.0017069556,
        -0.009404606,   0.009842791,    0.02172608,      -0.0067493417,  0.014728215,
        0.00878984,     -0.018286008,   0.01642863,      0.006304618,    -0.023151813,
        0.009731609,    -0.0062457575,  0.011464725,     -0.01866533,    -0.009496167,
        0.007403348,    -0.011020001,   0.0038717154,    0.00972507,     -0.031758532,
        -0.010228653,   -0.015996987,   0.008384357,     0.0018998875,   0.020234946,
        -0.02733745,    0.018652251,    0.011229283,     -0.0021189793,  -0.014466613,
        -0.018246768,   -0.014074209,   -0.0106537575,   0.02817458,     0.013642565,
        0.007749971,    -0.006690481,   0.0053955493,    0.013851847,    0.009306505,
        0.0070044044,   -0.0015965921,  -0.0022481456,   -0.025767837,   -0.0016824304,
        0.02733745,     -0.002951202,   0.018299088,     0.021320596,    -0.028593142,
        0.0017134957,   -0.015552263,   0.036179613,     -0.010954601,   -0.014453532,
        -0.005362849,   -0.025754755,   0.0014151054,    -0.0055982913,  -0.013551004,
        0.0053922795,   -0.009417687,   0.0050947065,    0.0112685235,   0.01861301,
        0.025924798,    0.00058533537,  -0.017723562,    -0.008855241,   -0.0075603095,
        0.027075848,    0.016598672,    -0.0017331159,   -0.004211799,   0.01522526,
        -0.026644204,   0.018848453,    0.0065073594,    -0.0028253058,  -0.0076060896,
        0.012550375,    0.0034008313,   -0.030790603,    0.002516288,    -0.021268275,
        0.0025244632,   -0.005313799,   -0.0014077479,   0.0015107539,   -0.009640048,
        -0.008253556,   -0.023387255,   -0.024368264,    -0.027049689,   -0.00092950603,
        0.00087718555,  0.00011823202,  0.017723562,     -0.0239497,     -0.009947431,
        -0.00163992,    0.0102024935,   -0.031078365,    -0.04379224,    -0.011870209,
        0.0063569383,   0.0218438,      0.015905425,     0.034243755,    -0.008430137,
        0.03497624,     0.019463219,    0.0010153443,    0.00015430454,  -0.0060626357,
        0.013799527,    -0.06629005,    0.036755137,     0.018756893,    0.011170423,
        0.032569498,    -0.008443218,   0.026107918,     0.010594897,    -0.008933722,
        -0.014610494,   -0.023622697,   -0.011641307,    0.0030721931,   -0.011229283,
        -0.00072063284, 0.012393414,    -0.014597414,    -0.015015977,   0.071522094,
        0.017775884,    -0.029220987,   -0.0095157875,   0.023243373,    -0.028985545,
        -0.0049704458,  -0.0065073594,  -0.006661051,    -0.014963658,   0.020967431,
        -0.00006550279, -0.0013088295,  0.01975098,      0.009430766,    0.0014952212,
        0.01962018,     -0.009718529,   0.009267265,     0.039737403,    0.022013841,
        -0.0054347897,  0.010091312,    -0.02718049,     -0.023792738,   -0.022746328,
        -0.026487242,   -0.03573489,    -0.017723562,    0.0049867956,   -0.005673502,
        0.009659668,    -0.016821034,   -0.0390834,      0.009509247,    0.014545093,
        0.04007749,     0.0084497575,   0.02817458,      0.0099408915,   -0.013472524,
        -0.016114708,   0.028148418,    0.015683064,     -0.0009205134,  0.0010096218,
        0.01844297,     -0.001850837,   -0.020823551,    -0.01089574,    0.012341093,
        -0.04996606,    -0.014335811,   0.015604583,     -0.009156084,   -0.00436876,
        -0.008855241,   -0.016860275,   0.0019244127,    0.014100369,    -0.02504843,
        0.010424855,    0.001983273,    -0.030921403,    -0.047925558,   -0.011942149,
        -0.014558174,   0.0027811604,   0.010509877,     -0.0136164045,  0.0014894987,
        0.0009164259,   0.0106995385,   0.014597414,     0.020483468,    0.004143128,
        -0.0028759914,  -0.0067035616,  0.007769591,     -0.020470388,   -0.00028776264,
        -0.00763879,    0.0091364635,   0.027023528,     0.00545441,     0.01083688,
        -0.004649983,   0.01625859,     -0.007213686,    0.0111508025,   -0.001973463,
        -0.01090882,    -0.015866185,   -0.0050391164,   0.011418945,    0.015434542,
        -0.020692749,   -0.013152061,   -0.022223124,    0.0023609616,   -0.01858685,
        -0.012641936,   0.019031575,    -0.014532013,    -0.0054871105,  -0.0094438465,
        0.005022766,    0.0053824694,   0.017252678,     0.0034923921,   -0.0151991,
        0.017710483,    -0.04245807,    0.008881401,     0.0034825818,   0.0064942795,
        -0.015748464,   -0.0071352054,  0.011301223,     -0.0069324635,  0.01408729,
        -0.038743313,   -0.019293176,   -0.014702055,    -0.009208404,   0.00432952,
        -0.021477558,   -0.010640678,   0.010012832,     0.015094458,    0.009280345,
        -0.02077123,    -0.02494379,    0.012635396,     0.0021238844,   -0.011752488,
        0.028619302,    -0.024773747,   0.007965793,     0.008848701,    0.013969569,
        0.006860523,    -0.034191433,   -0.00011067008,  -0.008175075,   0.017815124,
        0.0091364635,   -0.012962399,   -0.019855622,    -0.013387503,   -0.022367004,
        0.021385996,    0.013943408,    -0.021542957,    0.010019372,    0.027703693,
        0.0058500837,   -0.0016202999,  0.0306598,       -0.0012123636,  0.006111686,
        -0.023217212,   -0.028540822,   -0.014034969,    -0.0067820423,  0.030738281,
        0.003590493,    -0.004908315,   -0.032988064,    -0.0035316325,  -0.041804064,
        0.0141134495,   -0.022000762,   0.0136164045,    0.030764442,    -0.0040057865,
        0.0040548374,   0.021242116,    0.010065152,     -0.0031310536,  -0.029848834,
        -0.0050587365,  -0.0028563712,  -0.0018328518,   -0.003597033,   0.014793616,
        -0.019554779,   -0.0020143385,  0.029874993,     -0.0034302615,  -0.006455039,
        0.014728215,    -0.034479197,   -0.009731609,    -0.010725698,   0.015591503,
        0.0067951223,   0.0044308905,   0.009509247,     -0.012301853,   0.0017707213,
        -0.00058697036, 0.010097853,    -0.012386873,    -0.0082600955,  0.0023969319,
        -0.0043033594,  0.028854745,    -0.0066839415,   -0.006742802,   -0.00549365,
        -0.021137474,   0.017331159,    -0.011392784,    -0.0044308905,  0.01747504,
        0.0050521963,   -0.03413911,    -0.028828584,    0.0075799297,   0.014832856,
        -0.014571253,   0.0045191813,   -0.0038847956,   0.02172608,     -0.008462838,
        0.018809212,    -0.016611753,   0.009156084,     -0.02393662,    0.0037180241,
        -0.03563025,    0.0262518,      0.010032452,     -0.01523834,    -0.0015123888,
        0.0066774013,   -0.0015393667,  -0.024054341,    -0.025506234,   -0.010477176,
        -0.0048559946,  -0.0070305644,  -0.010869579,    -0.017252678,   -0.029953474,
        0.0061738165,   -0.024420584,   -0.04258887,     0.00983625,     0.21576966,
        -0.004787324,   0.0048592645,   0.012046791,     -0.014924417,   0.024669107,
        0.036493536,    0.016951835,    -0.0010063518,   -0.0034596918,  -0.009299966,
        0.008299336,    -0.014832856,   0.0019113325,    -0.0090645235,  -0.018926933,
        -0.037435304,   -0.0015508117,  -0.016768714,    -0.018756893,   0.021869961,
        -0.00439492,    -0.003606843,   -0.010280974,    0.015983906,    -0.0073771877,
        -0.0032471397,  0.0007529244,   0.0005877879,    -0.0003386525,  -0.006314428,
        -0.031026045,   -0.0051045166,  -0.016533272,    -0.013577164,   -0.004048297,
        0.0063536684,   0.005035846,    -0.0060887956,   0.015643824,    0.02494379,
        0.015042138,    -0.015787704,   0.002517923,     -0.015316821,   0.0149898175,
        -0.008364737,   -0.01752736,    0.010254814,     0.006435419,    -0.024185142,
        -0.01083688,    0.016624833,    0.051718794,     -0.0037572645,  -0.00067485246,
        0.010575277,    0.022353925,    0.007429508,     0.004564962,    -0.005689852,
        0.019044654,    0.006186897,    0.019842543,     -0.024381343,   0.018992335,
        -0.048788846,   0.005163377,    0.023034092,     -0.021699918,   -0.006723182,
        -0.036022652,   -0.012138351,   -0.01204025,     -0.0103921555,  -0.0348716,
        0.018024405,    0.008959882,    0.013158601,     -0.007043645,   0.00870482,
        0.0023282613,   0.008024653,    0.004247769,     -0.017252678,   -0.020470388,
        0.033406626,    0.0104640955,   -0.011660927,    0.0021663948,   0.0018230417,
        -0.02943027,    0.0013913978,   -0.0047480837,   0.013184761,    0.032386377,
        -0.0060855257,  -0.001146963,   -0.006978244,    -0.0086852,     -0.018338328,
        -0.036205772,   0.0196071,      -0.01417885,     -0.021608358,   0.0071679056,
        -0.0008632879,  0.012256073,    0.039449643,     -0.030712122,   -0.0015181114,
        -0.0136164045,  0.0074360482,   -0.010326754,    0.022523966,    0.015395301,
        -0.011713248,   -0.02067967,    0.0015311915,    -0.018979253,   -0.007318327,
        -0.038560193,   -0.01304088,    -0.008914102,    -0.010692998,   -0.028017618,
        0.003175199,    0.020143384,    0.04052221,      -0.014034969,   0.028200738,
        -0.03612729,    -0.012936238,   -0.0063536684,   0.008358196,    0.00763225,
        0.005778143,    -0.006886683,   0.010241734,     0.011347004,    0.021215955,
        0.01746196,     0.00326022,     -0.010287514,    0.016873354,    -0.011490885,
        0.012144892,    0.0038488253,   -0.0055230805,   0.001145328,    -0.015552263,
        -0.024747588,   0.004551882,    -0.0039796266,   0.03709522,     -0.021032833,
        -0.020418067,   -0.016127788,   -0.0037899648,   0.00014061129,  -0.016716393,
        0.013027799,    0.0050489265,   -0.018142127,    -0.011732868,   0.01852145,
        -0.16721626,    0.024682187,    0.008887942,     0.002089549,    0.041908704,
        -0.002836751,   0.01644171,     -0.009646588,    -0.008044274,   0.002403472,
        0.004103888,    -0.00068098377, -0.0370429,      -0.0032520448,  -0.005133947,
        0.007063265,    -0.010712618,   0.008606719,     0.019437058,    0.0027811604,
        0.0071352054,   -0.0064910096,  0.0055525107,    0.007763051,    0.011046161,
        0.012968939,    0.009384986,    -0.016624833,    -0.010228653,   -0.014963658,
        -0.009463467,   -0.0031375939,  0.011674007,     0.0144927725,   0.024224382,
        0.0009205134,   -0.013269782,   -0.017605841,    -0.0122887725,  0.012779277,
        0.005261478,    0.014244251,    0.013263241,     -0.004829834,   0.014702055,
        0.04805636,     0.003606843,    0.0020143385,    -0.0008780031,  -0.012347633,
        0.006304618,    -0.029744193,   0.008135835,     0.00035193696,  0.023871219,
        0.022353925,    0.010006292,    -0.012831598,    0.014754375,    -0.03272646,
        -0.009201865,   0.0013251797,   0.009522327,     -0.014675895,   -0.025571635,
        -0.015879266,   -0.004022137,   0.0018819022,    -0.02956107,    0.019737901,
        -0.036781296,   -0.013348263,   0.02623872,      -0.017893605,   0.006177087,
        -0.0050718165,  -0.014715135,   0.006958624,     -0.010071692,   -0.0097054485,
        -0.038455553,   0.03361591,     0.003809585,     -0.008436677,   0.014061129,
        0.0005665327,   -0.0033109053,  -0.014675895,    -0.013721046,   -0.030947564,
        -0.0021124394,  -0.016088547,   -0.011922529,    -0.03152309,    0.020575028,
        0.029325629,    -0.0003155579,  0.0038913356,    0.012491515,    -0.011883289,
        -0.009404606,   0.018037485,    -0.021477558,    0.020431148,    0.030764442,
        0.02510075,     0.021987682,    0.0077761314,    0.042981274,    -0.0045322618,
        -0.0073902677,  0.008574018,    -0.002056849,    0.027625212,    -0.0017592761,
        0.019214695,    0.010019372,    -0.020012584,    0.04146398,     -0.019201616,
        0.03897876,     0.0049671754,   -0.02935179,     0.021072073,    -0.021490637,
        -0.010287514,   -0.106419854,   -0.0026716145,   -0.019018494,   0.013171681,
        -0.0020094335,  0.010640678,    -0.0046401727,   0.012321473,    -0.0073771877,
        0.008390897,    -0.0058533535,  -0.0218438,      0.019123135,    -0.013930327,
        0.035342485,    0.000036966667, -0.015460702,    0.0045682318,   -0.023191053,
        0.015813865,    -0.010542576,   0.005549241,     0.0137341255,   -0.013407123,
        0.012962399,    -0.0041202377,  -0.032255575,    0.0044374308,   0.007534149,
        0.00766495,     -0.01194869,    -0.015604583,    0.01836449,     -0.020182624,
        0.0030934485,   -0.001960383,   -0.030110436,    0.0072725466,   0.034400716,
        -0.033668227,   0.009175704,    0.009620428,     0.0027942406,   -0.017932845,
        0.006458309,    0.0027746204,   -0.008384357,    0.012419574,    -0.0028988817,
        -0.027546732,   -0.030738281,   0.00016186648,   -0.029848834,   0.007939633,
        0.017344238,    0.0048690746,   0.0046532527,    0.008927182,    0.028017618,
        0.005791223,    -0.0019947183,  -0.01314552,     0.002277576,    0.00044431532,
        -0.0069847843,  -0.0079527125,  -0.014976737,    0.011732868,    0.00035398075,
        -0.0018017865,  0.010137093,    0.021359837,     -0.008220855,   0.008632879,
        -0.037775386,   0.020195706,    -0.013995728,    0.0012401589,   0.013799527,
        -0.017815124,   -0.007920013,   -0.021346755,    0.009993211,    -0.01633707,
        0.006873603,    0.004810214,    0.0032896502,    -0.00025383607, -0.010163253,
        -0.012275693,   0.0037605346,   -0.008999122,    -0.011817888,   -0.03623193,
        -0.021242116,   0.015826944,    0.0061607365,    -0.0064975494,  -0.0067951223,
        -0.012393414,   -0.013551004,   0.008626339,     -0.06644701,    0.024656026,
        0.0024590625,   -0.00020263967, -0.002517923,    -0.012798897,   0.016925676,
        -0.0026814246,  -0.004296819,   -0.005748713,    -0.0056931223,  0.02725897,
        0.0030967183,   -0.002411647,   -0.006736262,    -0.019463219,   -0.00075496815,
        -0.008488998,   0.016572513,    0.011360084,     0.009489627,    0.012504594,
        0.001317822,    0.007926553,    -0.0066185407,   -0.0020862792,  -0.0036885939,
        0.021569118,    -0.0022138103,  0.0018606471,    -0.009646588,   -0.023491895,
        -0.010732238,   0.0017592761,   0.0011714882,    0.008273176,    -0.001744561,
        0.0064942795,   0.01635015,     0.06372634,      -0.02731129,    -0.014571253,
        0.010294055,    -0.011052702,   -0.019267017,    0.0031441338,   0.008593638,
        0.007893852,    0.03495008,     -0.019175455,    0.016703313,    0.037644584,
        -0.00975123,    0.00041938134,  -0.00976431,     -0.0039730864,  0.018181367,
        -0.00050440215, 0.014767455,    -0.0042379587,   0.02524463,     -0.0049966057,
        0.009280345,    0.014924417,    -0.0012115461,   -0.029874993,   -0.0132370815,
        -0.010006292,   0.0035152822,   -0.016206268,    -0.004914855,   -0.023675017,
        -0.0016619927,  0.005330149,    -0.004453781,    0.0003075872,   -0.0053857393,
        -0.0017069556,  -0.008384357,   0.021516798,     -0.006232677,   0.0031097985,
        -0.042039506,   0.00438184,     0.024917629,     0.001138788,    0.006853983,
        0.015696144,    -0.013348263,   0.016114708,     -0.010791099,   0.017867444,
        -0.0035185523,  0.022445485,    -0.014270411,    0.014963658,    -0.040705334,
        -0.007279087,   0.01627167,     0.012373794,     0.0070567247,   0.0008632879,
        0.0070567247,   -0.011588986,   -0.011772108,    0.0046140123,   -0.032229416,
        -0.043059755,   -0.011013461,   0.004780784,     0.023635777,    -0.016546352,
        -0.013034339,   0.011445105,    -0.005814113,    0.00977085,     -0.0045061014,
        -0.002202365,   -0.017200358,   0.014675895,     0.007501449,    0.00761917,
        0.014021888,    0.0014012079,   0.002275941,     0.015630743,    0.010405235,
        -0.004264119,   -0.009424226,   -0.02506151,     -0.0010733873,  0.0074949088,
        -0.01963326,    0.00031433164,  -0.018063646,    -0.017383479,   0.0000909988,
        0.018050566,    -0.027102008,   0.028645463,     -0.008332036,   0.0029528372,
        0.014702055,    -0.027154328,   0.021909202,     0.0034466116,   0.03897876,
        -0.0031228787,  -0.015015977,   0.0062915375,    -0.035604086,   0.02185688,
        0.008613259,    -0.008194695,   0.030188916,     -0.0010096218,  0.0070174844,
        0.0066970214,   0.004607472,    0.022000762,     0.012655016,    0.0087179,
        -0.007279087,   -0.016860275,   0.000018994277,  0.0010177968,   0.01618011,
        -0.012046791,   -0.035473283,   0.013361342,     -0.0067035616,  -0.013577164,
        0.012825058,    -0.007965793,   -0.021699918,    0.011588986,    -0.007161366,
        -0.0050652763,  -0.00540863,    -0.019123135,    0.026304122,    -0.0042150686,
        -0.022393165,   -0.013943408,   0.00078439846,   -0.005801033,   -0.00087555056,
        -0.027232809
    ],
    [
        -0.00801277,    -0.036891863,   0.0075414306,   -0.019070137,   -0.007063722,
        0.014929994,    -0.019490521,   -0.02276442,    -0.018853577,   0.011356732,
        0.003831225,    0.024687994,    -0.010420423,   -0.023859965,   0.009694305,
        -0.0014251648,  0.024293087,    -0.037579764,   0.0022563783,   -0.015133817,
        0.0024920478,   -0.01289814,    0.016802613,    0.0079044895,   -0.013159287,
        -0.0112038655,  -0.012586036,   -0.026344052,   0.020802628,    -0.0068216827,
        0.017490514,    -0.024293087,   -0.002369436,   -0.005691105,   -0.016866308,
        -0.005238874,   -0.0010111504,  -0.020840846,   0.004624222,    -0.014547827,
        -0.0019522369,  0.0022914102,   -0.012586036,   -0.016942741,   -0.017465036,
        0.0022356776,   -0.002694278,   -0.02657335,    -0.0072165886,  0.016904524,
        0.02287907,     0.01138221,     -0.016815351,   -0.012636992,   -0.0021226197,
        -0.01881536,    -0.019923644,   -0.011636988,   -0.0020270778,  -0.0020939573,
        0.008745257,    -0.0052898293,  -0.013770754,   -0.013388587,   0.014038271,
        0.0076242336,   -0.030114766,   0.028458709,    -0.0051051155,  -0.006156075,
        0.030242156,    0.0056369645,   0.02159244,     0.01789816,     0.01254145,
        -0.025286723,   -0.031745344,   -0.0047420566,  -0.015375856,   0.007853534,
        0.011242081,    -0.02194913,    -0.028305842,   0.0059840996,   0.025541501,
        -0.0062325085,  -0.0015589233,  0.0150956,      -0.017987331,   -0.0016608344,
        -0.014560566,   0.008885385,    0.012808966,    0.023987355,    -0.021121101,
        0.014573305,    -0.025605194,   0.015031906,    0.0078089475,   -0.0253122,
        0.01659879,     -0.005767538,   -0.011216604,   -0.016331274,   0.0052325046,
        -0.023350408,   -0.01521025,    -0.009694305,   0.01380897,     0.0032707134,
        0.009254813,    -0.00059315516, 0.022369513,    -0.053095747,   0.0016321719,
        -0.008879015,   -0.025910929,   -0.02614023,    0.000399285,    0.012866292,
        0.027770808,    0.010076473,    -0.00039629932, 0.0019092431,   0.014025532,
        0.008331243,    0.003984092,    -0.01729943,    -0.026000101,   -0.002659246,
        0.016522357,    0.0078407945,   0.006980919,    -0.0043949215,  -0.023643404,
        0.028942788,    -0.014305788,   0.017923636,    -0.01718478,    -0.020280333,
        0.0098662805,   0.020293072,    -0.012401322,   0.015414072,    0.006904485,
        0.018662494,    0.024738949,    0.017324908,    0.016356751,    -0.011312146,
        0.01380897,     -0.0045446036,  0.027490553,    -0.023159325,   0.025006466,
        -0.012445908,   -0.012273933,   0.013885404,    0.006156075,    -0.009910867,
        -0.006410853,   0.0016640192,   0.006815313,    -0.011184757,   0.0040000156,
        0.03622944,     0.011127432,    0.0043121185,   -0.0011926797,  0.009547808,
        -0.004694286,   0.032102037,    -0.044203993,   0.02728673,     -0.012566928,
        0.015222989,    0.011375841,    0.012019155,    -0.009879019,   0.0017117901,
        0.0033821787,   0.02090454,     0.015541461,    0.020140206,    0.0026321758,
        0.0057197674,   0.011484121,    -0.014420439,   0.018879054,    -0.014445916,
        0.0067707268,   0.009840802,    0.010356728,    0.0025509654,   -0.65875417,
        -0.013668843,   -0.020624284,   0.00359874,     -0.008535065,   0.005471359,
        0.0047802734,   -0.005270721,   0.01985995,     -0.0052420585,  0.0049649873,
        -0.0047802734,  0.008063725,    -0.040331367,   -0.013681582,   -0.019363133,
        -0.018687971,   -0.007382194,   0.009936344,    0.005773908,    -0.0032404584,
        0.01615293,     -0.015452289,   -0.008955449,   0.023019198,    0.037936453,
        0.0204332,      0.0027197558,   -0.013961838,   -0.0029538332,  -0.028025586,
        0.034879114,    -0.0021178427,  0.026038317,    0.042293157,    -0.008808952,
        -0.0102420775,  0.017337646,    -0.0155669395,  0.020611545,    0.00053782057,
        -0.01591089,    0.021146579,    0.018968226,    -0.011713421,   -0.009770739,
        0.0011472974,   0.003914028,    0.020051034,    0.022840854,    -0.0004848745,
        0.018637015,    -0.008082834,   0.006675185,    0.009121055,    -0.00018680407,
        0.014573305,    -0.021286707,   0.014382222,    -0.043719914,   0.010490486,
        -0.0020302627,  0.0028439602,   0.006783466,    -0.011350363,   0.042293157,
        0.0038758111,   0.027133863,    0.011350363,    -0.025541501,   0.004691101,
        0.01881536,     0.0013113108,   -0.017350385,   0.028051063,    -0.0013710244,
        0.05110848,     0.0061114887,   0.014471394,    -0.020713456,   -0.0008407676,
        -0.02611475,    -0.023490537,   0.014879039,    0.024598822,    0.005773908,
        -0.022433208,   -0.013617887,   -0.0017531915,  -0.009082838,   0.008515957,
        0.010426792,    -0.030828144,   -0.026318574,   -0.02100645,    0.029070176,
        -0.011089215,   -0.0057516145,  0.019477783,    -0.024458693,   -0.001816886,
        0.009382202,    0.0035668928,   -0.011879027,   0.02242047,     0.009796216,
        0.009095577,    0.005691105,    0.04295558,     -0.033860005,   0.0069172243,
        0.003186318,    -0.015401334,   0.015350378,    -0.0053248615,  -0.024203915,
        0.015388595,    0.016394967,    0.010923609,    -0.048840955,   -0.005630595,
        0.03322306,     0.0024649778,   -0.031414136,   0.015808979,    -0.00963061,
        0.0036274027,   -0.0019984154,  -0.02312111,    0.0021321739,   -0.0056369645,
        0.0036719888,   0.021261228,    0.0013073299,   -0.008617868,   0.013414064,
        0.016101973,    -0.0148663,     0.012808966,    0.014675216,    -0.017133825,
        -0.0045159413,  -0.00882169,    0.026445962,    0.0010055772,   -0.019363133,
        -0.0018742111,  -0.02810202,    -0.026344052,   0.0115159685,   0.011789855,
        0.0066242297,   -0.032127514,   -0.0005999227,  -0.0067770965,  -0.0050382363,
        -0.020242117,   -0.006898116,   -0.0057420605,  -0.010121059,   0.017159302,
        0.011401318,    -0.0106752,     0.0019426827,   0.0037643458,   0.00031051075,
        0.016165668,    0.014242093,    -0.0056019328,  -0.012783489,   0.023172064,
        -0.00359874,    -0.005843972,   0.007700667,    -0.025974624,   -0.005414034,
        -0.020484155,   -0.005293014,   -0.0025684813,  0.0045350497,   0.0015565347,
        0.009140163,    -0.009535069,   0.020726195,    0.01731217,     0.016624268,
        0.014407699,    -0.0018933194,  0.031541523,    0.0034809052,   0.015350378,
        0.012178391,    -0.00053463585, -0.007872642,   0.021261228,    0.02715934,
        0.011375841,    0.011802593,    -0.012866292,   0.02194913,     0.005910851,
        0.0012691132,   0.012127436,    -0.0070891995,  0.006041425,    -0.009968191,
        -0.00917838,    -0.041299522,   0.03564345,     -0.0010230931,  0.016700702,
        -0.008757995,   -0.004793012,   -0.026955519,   0.015401334,    0.016318535,
        -0.0026672077,  0.018509626,    -0.013273937,   -0.0017930006,  0.011993677,
        0.008719779,    -0.0063025723,  -0.020420462,   -0.025337677,   0.010184753,
        0.025388634,    -0.02287907,    0.015197511,    -0.031031968,   0.012751642,
        -0.001228508,   -0.016777135,   0.0037675304,   0.013694321,    0.00086783775,
        -0.0012619476,  -0.0306498,     0.00894908,     0.01033762,     -0.0024315382,
        0.017566947,    0.020051034,    -0.015872672,   0.0027309023,   -0.0033758092,
        0.021847218,    0.007974553,    -0.030089289,   0.020930018,    -0.025617933,
        0.02866253,     0.006840791,    -0.0045095715,  -0.009675196,   -0.017745292,
        0.012407691,    0.005993654,    0.013681582,    0.021643396,    0.017248474,
        0.00056648307,  -0.0041656215,  -0.0059395134,  0.011312146,    0.009917236,
        -0.012490494,   -0.0018535104,  0.00029976232,  -0.010471378,   -0.02242047,
        -0.0103248805,  0.01940135,     -0.00789175,    0.0066942936,   -0.0035095678,
        -0.0060828263,  0.022509642,    0.004761165,    0.007955445,    -0.001904466,
        -0.030216677,   0.020242117,    0.022598814,    0.006745249,    -0.014764388,
        0.008286657,    0.0007209423,   -0.005420403,   0.0058312328,   0.023490537,
        0.0138344485,   -0.010636984,   0.003668804,    -0.0076369722,  0.023184804,
        0.042547937,    -0.04374539,    0.010343989,    0.009375833,    -0.004296195,
        0.0044172145,   0.0010692717,   -0.019528737,   0.03982181,     -0.0008264363,
        -0.0019554216,  -0.0024506464,  0.022458686,    0.0018996889,   -0.0052866447,
        0.011586032,    -0.012821706,   -0.012611514,   0.0055796397,   0.02113384,
        -0.021095624,   -0.0033152995,  0.029197566,    -0.0009968191,  -0.026904562,
        -0.049044777,   -0.01636949,    -0.022369513,   0.13676487,     0.013694321,
        0.0043789977,   0.027949153,    0.0061719986,   0.020254856,    -0.012477756,
        -0.031133879,   0.015872672,    -0.014738911,   0.007464997,    0.0037006512,
        -0.010038256,   0.007509583,    0.029961899,    0.010363097,    -0.00091560866,
        -0.021656135,   -0.01718478,    -0.010063733,   -0.005442696,   -0.008254809,
        0.015057383,    0.015286683,    -0.0017930006,  -0.03470077,    0.028178453,
        -0.0032993758,  -0.00024084488, -0.0020191162,  -0.01998734,    0.0017977777,
        0.013961838,    0.009095577,    -0.014573305,   0.0062739095,   0.00088933465,
        -0.013719798,   0.024573343,    -0.019133832,   0.037783585,    0.014114705,
        -0.0133758485,  -0.026802652,   0.004057341,    -0.030369544,   -0.011758007,
        0.015261206,    0.016165668,    -0.00731213,    0.033503316,    0.00021277949,
        -0.025439588,   -0.0027117939,  -0.006789835,   0.013031898,    0.015885413,
        0.026624307,    -0.024089266,   0.024242133,    -0.017490514,   -0.032815415,
        0.017503252,    -0.018254848,   0.0007571686,   -0.0045477883,  -0.02519755,
        -0.01938861,    -0.030828144,   0.0074522584,   0.010821698,    -0.0057325065,
        -0.010649723,   0.013707059,    0.022547858,    -0.013770754,   0.0202039,
        -0.03678995,    0.008904493,    -0.026318574,   -0.009471375,   -0.01915931,
        0.006353528,    -0.0378855,     0.011904505,    -0.0045541576,  0.0112038655,
        -0.012738903,   -0.014203877,   0.0021672058,   0.0016114712,   0.020917278,
        0.019694343,    -0.037783585,   -0.0033758092,  -0.020484155,   -0.01856058,
        -0.009089207,   -0.0106815705,  0.020101989,    0.014254833,    -0.0072866525,
        -0.003980907,   -0.016789874,   -0.0043471507,  -0.022573335,   -0.0019490521,
        0.020815367,    -0.026076535,   0.0034649817,   0.024547866,    -0.025108378,
        0.009859911,    0.013108331,    0.016356751,    0.013426804,    0.0035159371,
        0.022751682,    0.0029235783,   -0.018649753,   -0.015732545,   -0.0075796475,
        0.014535088,    0.045707185,    -0.020114727,   0.026089273,    0.008617868,
        -0.014293049,   -0.010254817,   -0.0036242178,  -0.032331336,   0.020127466,
        0.0069172243,   0.012828075,    -0.026445962,   -0.0024172068,  -0.009503221,
        -0.00070979574, -0.02057333,    -0.018904531,   0.013401326,    -0.009101946,
        -0.02601284,    -0.007942706,   -0.00081130886, -0.029044699,   0.0072548054,
        0.012273933,    -0.013515976,   0.008757995,    -0.029223043,   -0.012025524,
        -0.010624245,   0.0130828535,   -0.0036369567,  -0.028764443,   -0.018598799,
        -0.0027547877,  0.007949076,    0.018675232,    0.027541509,    -0.005745245,
        -0.0008415638,  0.01661153,     0.0034617968,   0.024089266,    -0.0043248576,
        0.021082884,    -0.037350465,   0.0112038655,   0.011936352,    0.01810198,
        0.023006458,    0.0018551027,   0.026879085,    0.0061210427,   0.022445947,
        0.0072420663,   -0.0071274163,  -0.014293049,   -0.018140199,   -0.0032531973,
        -0.013095592,   0.0050605293,   -0.019223005,   -0.04193647,    0.03724855,
        -0.0038885502,  0.007108308,    -0.006433146,   0.015859934,    -0.0038248557,
        0.010229339,    0.01996186,     0.020649761,    -0.007955445,   0.020764412,
        -0.0010851953,  0.00917201,     0.008490479,    0.036764473,    -0.018879054,
        -0.0083630895,  -0.0067325104,  0.0039395057,   0.018840838,    0.014828083,
        -0.0048248596,  0.025516022,    -0.024649777,   -0.009312138,   -0.023375887,
        -0.012643361,   -0.010764373,   -0.0011520745,  -0.0076114945,  0.0021433204,
        -0.0071274163,  -0.03238229,    -0.03763072,    0.01022297,     -0.012114697,
        0.0102420775,   0.016433185,    0.03182178,     0.031847257,    -0.0026815392,
        -0.023503276,   0.025987362,    -0.000399285,   -0.0033248537,  -0.003496829,
        -0.0060764565,  0.0014721395,   -0.014407699,   0.001737268,    0.0049395096,
        -0.0157835,     -0.030598845,   0.020178422,    -0.002496825,   -0.015121078,
        0.009242074,    -0.036738995,   -0.0004032659,  0.029783554,    -0.0015143371,
        -0.016305795,   -0.007509583,   -0.018267587,   -0.027770808,   -0.020955496,
        -0.003141732,   -0.001470547,   -0.002194276,   -0.026649784,   0.00441403,
        -0.033503316,   -0.0039299517,  -0.0019506445,  -0.0304205,     0.02589819,
        0.0055350536,   0.01777077,     -0.0009864687,  -0.016356751,   0.006993658,
        0.0058248634,   -0.0064841015,  0.025146594,    0.0036879124,   0.0051847333,
        -0.01834402,    0.026930042,    0.00411785,     0.006707032,    -0.017528731,
        -0.010203862,   0.0065987515,   -0.006904485,   0.013286675,    -0.0027086092,
        -0.023261236,   -0.004713394,   -0.020394983,   -0.013210243,   -0.02820393,
        0.011566924,    0.009152901,    -0.0204332,     -0.0021894989,  0.0006644134,
        -0.012343997,   0.0030605213,   0.01357967,     0.0024076526,   -0.00009633796,
        0.025261244,    -0.029324954,   -0.016726179,   -0.012547819,   0.026828129,
        -0.0130828535,  -0.0117452685,  0.017694335,    -0.015490506,   0.013414064,
        -0.0024235763,  -0.01625484,    0.012369474,    0.011993677,    0.007178372,
        0.0140637485,   -0.023834487,   0.006783466,    -0.009076469,   0.023885444,
        0.0011226158,   -0.016229363,   0.024356782,    0.007191111,    -0.0011520745,
        0.0039108433,   -0.010369467,   0.013630626,    0.0153376395,   0.0072038495,
        0.008490479,    -0.009885388,   -0.01126756,    -0.012140174,   0.015694328,
        -0.00179937,    -0.017605163,   -0.0024888632,  -0.0008439523,  0.00028483392,
        0.003076445,    0.0031783562,   -0.01103826,    -0.028611576,   -0.0018614721,
        0.009834433,    -0.0009235705,  0.012923617,    -0.0059968387,  -0.005235689,
        -0.049426943,   -0.01881536,    -0.013337632,   -0.03622944,    0.012687948,
        0.007700667,    0.032586113,    -0.0031560631,  0.012369474,    -0.022267602,
        0.0060191317,   0.0026672077,   0.011050998,    0.039516076,    -0.0021210273,
        0.024471432,    0.012401322,    -0.015515984,   0.03773263,     0.0043853675,
        0.00055175374,  0.014318527,    0.02761794,     -0.014471394,   0.011554185,
        -0.0073694554,  0.00046377568,  0.00048567067,  -0.008031879,   -0.0044618007,
        0.021184796,    -0.006586013,   -0.016687963,   0.015235728,    -0.0043853675,
        0.007515953,    -0.015172034,   -0.016114712,   -0.02751603,    0.0005804163,
        0.00812742,     -0.01126119,    -0.018127458,   0.006175183,    0.009394941,
        -0.0013686359,  0.021923652,    -0.013681582,   -0.016356751,   0.0042547937,
        -0.015961844,   0.015949106,    -0.012000047,   -0.009121055,   0.014025532,
        0.0056051174,   -0.0007714998,  0.009063729,    0.011554185,    0.008987296,
        -0.0081337895,  -0.010535073,   -0.0028519218,  0.028713487,    -0.006464993,
        0.01149686,     -0.019235743,   0.019528737,    -0.0020939573,  0.01056692,
        -0.03031859,    0.014955472,    0.018382236,    -0.01881536,    0.0075414306,
        -0.008484109,   0.0006261967,   0.004936325,    -0.024178438,   -0.016178407,
        0.013452281,    0.015949106,    0.006050979,    0.0056847353,   -0.028840877,
        0.008515957,    0.010783481,    -0.019681605,   0.015172034,    0.23215377,
        -0.016000062,   0.020637022,    0.031872734,    -0.01984721,    0.026649784,
        0.0037070208,   -0.0011066922,  -0.017159302,   -0.005503206,   -0.010305773,
        -0.006433146,   -0.0041879145,  0.0071019386,   0.012598775,    -0.02461156,
        -0.0153376395,  -0.0056974743,  -0.006257986,   -0.022089258,   0.012133805,
        0.023324931,    -0.001724529,   -0.018152937,   0.016178407,    0.013681582,
        0.007420411,    0.014203877,    0.0056019328,   0.0033057453,   -0.010191122,
        -0.002286633,   0.0061879223,   0.0045318645,   0.003391733,    0.005493652,
        0.0034840899,   0.007152894,    -0.010261186,   -0.022445947,   -0.0073439777,
        0.0016305796,   -0.0253122,     -0.004541419,   0.012433169,    0.025592456,
        -0.0030971458,  -0.027108386,   -0.009662458,   0.027312208,    -0.040203977,
        -0.030165723,   0.0057547996,   0.0119745685,   0.014318527,    -0.0025430035,
        0.05179638,     0.027006473,    0.00051791605,  0.0084458925,   0.010904501,
        0.027847242,    -0.018140199,   0.007503214,    0.020025555,    0.036942817,
        -0.026000101,   0.023095632,    0.03146509,     -0.015936367,   -0.0045923744,
        -0.023974616,   -0.021401357,   0.009076469,    -0.005700659,   -0.010573289,
        0.00021815371,  0.020764412,    0.0079235975,   -0.004404476,   -0.023541493,
        -0.00022890216, 0.031414136,    0.013923621,    0.0115159685,   -0.028993743,
        0.0055828243,   0.017719815,    0.007305761,    0.011375841,    0.013719798,
        -0.0070891995,  0.00062938145,  0.0085095875,   0.015184772,    0.001566885,
        0.005738876,    0.0038598876,   0.020152945,    -0.0078407945,  -0.016649745,
        0.018904531,    0.011898136,    -0.013961838,   -0.0010907686,  -0.009044621,
        -0.015057383,   -0.008961818,   0.004821675,    -0.018573321,   0.016904524,
        -0.0032898218,  0.008273917,    0.020980973,    0.00020879858,  0.033809047,
        0.018369498,    -0.015554201,   0.0016656115,   0.01950326,     -0.0067770965,
        -0.019312177,   0.018178415,    0.0038503334,   0.010133797,    -0.021108363,
        -0.04519763,    0.012586036,    -0.010554181,   -0.022777159,   0.0068917465,
        -0.033528794,   0.0029331325,   0.008159268,    -0.0072993916,  -0.007280283,
        -0.006668816,   -0.0010119466,  -0.024458693,   -0.011254821,   -0.008681563,
        0.008503218,    0.004006385,    0.014458654,    0.00062938145,  -0.019082876,
        0.032229424,    -0.008076465,   -0.011605141,   0.010528703,    -0.034496948,
        -0.025516022,   0.0035382302,   -0.007012766,   0.0063121263,   -0.0012675208,
        -0.019579694,   -0.033044714,   -0.013770754,   -0.008611498,   -0.023197543,
        -0.008974557,   0.0018312173,   -0.03322306,    0.003006381,    -0.018165676,
        -0.16040827,    0.0033248537,   0.031643435,    -0.02728673,    0.018140199,
        0.0005306549,   0.02450965,     -0.010089211,   -0.025477806,   0.015477767,
        0.03503198,     -0.008980926,   -0.037656195,   -0.018293064,   0.000320264,
        -0.018649753,   -0.018025547,   0.0053025684,   0.015515984,    -0.0013224573,
        0.008369459,    0.0014426807,   -0.020216638,   0.003216573,    0.0080064,
        -0.00206211,    0.005936329,    0.025286723,    -0.008535065,   -0.01253508,
        -0.030471455,   0.0056847353,   -0.0019458674,  0.0034617968,   0.021898175,
        0.0016289873,   -0.019057399,   -0.0015000058,  0.0017866312,   0.021095624,
        0.023019198,    -0.0020923647,  0.012242085,    -0.006592382,   -0.009687936,
        0.02868801,     0.007108308,    -0.0022691172,  0.016051019,    -0.03332497,
        0.0114522735,   -0.032586113,   -0.0004593967,  -0.00020163295, 0.01775803,
        0.012624253,    0.010152905,    0.010114689,    0.00018909309,  0.018713448,
        -0.010305773,   -0.010044625,   -0.0060796416,  -0.009165641,   -0.017707076,
        -0.03296828,    -0.014955472,   0.018624276,    -0.026369529,   0.0061592595,
        -0.011847179,   -0.026344052,   -0.0075796475,  -0.024114743,   0.009770739,
        0.004828044,    -0.018853577,   0.028611576,    -0.0038407792,  -0.018394975,
        -0.0067261406,  0.02149053,     0.011108323,    -0.02033129,    -0.01963065,
        0.0068790074,   0.0051592556,   0.002234085,    0.014840822,    -0.03997468,
        0.002699055,    -0.0160128,     -0.031490568,   -0.006757988,   0.0036624346,
        0.040076587,    0.027031953,    -0.013273937,   0.01904466,     -0.0054618046,
        0.010949087,    -0.00005752411, -0.032713503,   0.025592456,    0.0074586277,
        -0.009019143,   -0.004296195,   0.0057547996,   0.013337632,    -0.017286692,
        -0.013745276,   0.00021496898,  0.02103193,     0.040076587,    0.0021751677,
        0.002746826,    0.02343958,     -0.014802605,   0.0022914102,   0.030981012,
        0.038547922,    0.021961868,    -0.0060446095,  0.013910882,    -0.0029012852,
        -0.023184804,   -0.11128706,    -0.020637022,   -0.01079622,    -0.0064363307,
        0.017121086,    0.024458693,    -0.014853561,   -0.00458919,    -0.001228508,
        0.008471371,    0.0120382635,   -0.02914661,    -0.004621037,   0.0011417242,
        0.02438226,     0.010484117,    -0.014293049,   -0.015528723,   -0.024203915,
        0.014369482,    -0.0034331344,  0.015248467,    -0.009796216,   -0.013847187,
        0.013070115,    -0.024127482,   -0.016280318,   0.005828048,    0.024471432,
        -0.0035159371,  -0.006949072,   -0.023898182,   0.009898128,    -0.0021576516,
        0.013133809,    0.018789882,    -0.025057422,   -0.008605129,   0.014598783,
        -0.045605272,   -0.005796201,   -0.013910882,   0.017363125,    -0.022382252,
        -0.010108319,   0.004828044,    0.011337624,    0.015159295,    0.01636949,
        -0.030369544,   -0.029910944,   0.0016353567,   -0.024140222,   -0.00021735753,
        0.003716575,    -0.014891777,   -0.0029952344,  -0.0033471468,  -0.041325003,
        -0.0024809013,  0.0050127585,   -0.0118917655,  -0.023745315,   -0.013617887,
        -0.012356736,   -0.0013049414,  -0.00731213,    -0.009942714,   -0.0009307361,
        -0.018509626,   -0.012490494,   0.019324915,    -0.013859927,   -0.0005613079,
        -0.027974632,   0.020382244,    -0.00087739195, 0.0017531915,   0.012719794,
        0.00054976327,  -0.028891832,   -0.003751607,   0.020063773,    0.0060000233,
        0.020471416,    0.013770754,    0.003936321,    0.017031914,    0.0033694399,
        0.0014203876,   0.010821698,    0.011764376,    0.030140243,    -0.0063025723,
        -0.01428031,    0.047312286,    -0.005130593,   0.0009116277,   -0.0057898313,
        0.025681628,    -0.03228038,    0.009484113,    -0.06608943,    0.02415296,
        -0.02217843,    -0.015719807,   -0.015312161,   -0.011573293,   0.012579666,
        -0.007191111,   -0.013172026,   0.0153376395,   -0.014458654,   -0.0028981005,
        0.015592417,    -0.00023447543, -0.027770808,   -0.037019253,   0.032815415,
        0.0038216708,   0.025439588,    0.015554201,    -0.013490498,   0.008025509,
        0.00065485924,  0.013248459,    0.013261198,    0.016866308,    0.01103826,
        0.007535061,    -0.008070095,   -0.005608302,   0.018025547,    -0.019363133,
        -0.014140182,   -0.0086751925,  0.011821702,    -0.023490537,   -0.0148663,
        0.0097197825,   0.004519126,    0.03969442,     0.0013073299,   -0.017477775,
        0.017681597,    -0.029961899,   0.00731213,     0.020713456,    -0.02552876,
        0.025095638,    0.0119745685,   -0.0012571705,  -0.009560547,   0.027414119,
        -0.042547937,   -0.025630673,   -0.0102420775,  -0.03893009,    0.019121094,
        -0.0037484223,  0.009936344,    -0.009668827,   0.019656127,    0.015974585,
        0.0017802616,   -0.0076560806,  -0.0020254855,  0.00067436567,  0.004694286,
        0.0008168822,   0.0024124298,   -0.031745344,   -0.011273929,   -0.019872688,
        -0.0014785089,  -0.00406371,    0.004191099,    0.008777104,    0.0027356795,
        0.018369498,    -0.028025586,   0.0071337856,   -0.0004542215,  -0.01684083,
        -0.032000124,   0.023910921,    0.039414167,    0.00150956,     0.017401341,
        0.019770777,    -0.0063471585,  -0.008910863,   -0.022484163,   0.0032356814,
        -0.0056146714,  -0.019936383,   -0.011388579,   -0.010165645,   -0.019414088,
        0.0028423676,   0.023732577,    -0.0006556554,  -0.0040159393,  -0.0059299595,
        0.006477732,    -0.020114727,   -0.008713409,   0.022560596,    0.015579678,
        -0.022586076,   -0.0016218215,  0.0033375926,   0.018229371,    0.014229354,
        0.012375845,    0.01543955,     -0.0023184803,  0.020382244,    -0.012222977,
        0.008636977,    -0.027082907,   0.03643326,     0.011847179,    0.019949121,
        0.03658613,     -0.03447147,    0.005468174,    -0.007719775,   0.026777174,
        -0.020344028,   -0.005528684,   0.0030748527,   -0.01661153,    -0.020815367,
        -0.04588553,    0.0021273969,   -0.009770739,   0.003668804,    -0.0076242336,
        0.0012412468,   -0.013668843,   0.034318604,    0.020000078,    -0.01904466,
        0.0082165925,   -0.017847203,   0.022649769,    0.011101954,    0.008484109,
        -0.013961838,   -0.01335037,    0.02171983,     0.0015079676,   0.012293042,
        -0.0388027,     -0.030242156,   0.020038294,    -0.009019143,   0.024318567,
        -0.021426834,   0.014025532,    0.025248505,    0.016407708,    0.007879011,
        -0.0056274105,  -0.016662486,   -0.022611553,   0.04792375,     -0.004936325,
        0.007815317,    -0.039516076,   -0.002211792,   0.008031879,    -0.0039649834,
        -0.0020796258,  0.013159287,    0.030904578,    -0.00009723366, -0.0045668967,
        0.017235735,    0.018993704,    -0.01996186,    0.043337747,    -0.012796228,
        -0.042547937,   0.011866288,    0.014942734,    -0.012299411,   0.0030557443,
        0.006675185
    ],
    [
        0.0023261087,   -0.022289462,   0.0017823848,   -0.021092625,    -0.0018789038,
        0.025133556,    0.007953168,    0.0023309346,   -0.0013536795,   -0.0028183558,
        -0.0046747383,  0.01091952,     0.032121535,    -0.026330391,    0.027256975,
        -0.02005022,    0.029702123,    -0.026291784,   0.0063219965,    -0.006090351,
        0.010694308,    0.009510342,    -0.006489296,   -0.02213503,     0.0012322263,
        0.011016039,    -0.00034043068, -0.013004331,   0.019818574,     -0.0068464167,
        0.0071231043,   -0.00404093,    0.011768887,    -0.006585815,    -0.020783765,
        -0.0019078595,  -0.016022159,   0.006338083,    0.0067885052,    -0.021864777,
        0.0054115,      -0.0046650865,  -0.0013930914,  -0.02070655,     -0.013158761,
        -0.009304435,   0.008229856,    -0.03188989,    -0.037294954,    0.010848739,
        -0.0034167736,  0.024670264,    -0.018621739,   -0.000066306566, -0.025030602,
        -0.012257917,   -0.016253805,   -0.0028875277,  -0.0030596533,   -0.014851062,
        -0.003880065,   -0.015726168,   -0.0016134764,  0.005849053,     -0.014259079,
        0.011717411,    0.010044414,    -0.012978592,   -0.00012024662,  0.012618255,
        0.03389748,     0.017090304,    0.0040891897,   -0.0057557514,   0.00293257,
        -0.017489249,   -0.025571108,   -0.012689035,   -0.008287768,    0.014851062,
        0.0033974699,   -0.033408456,   -0.019303806,   0.031169213,     0.0043883985,
        0.01584199,     -0.016755704,   0.00889262,     -0.0187633,      -0.005952007,
        0.0071874503,   0.00051838765,  0.01140855,     0.0032784299,    -0.029084401,
        0.009696946,    -0.015919205,   -0.008390721,   -0.017116042,    -0.032404657,
        0.0089634005,   0.005929486,    0.0141303865,   -0.010436924,    0.002351847,
        0.018441569,    0.0095039075,   -0.02929031,    0.021568786,     0.009806333,
        -0.0016376062,  0.002868224,    0.012032706,    -0.027514359,    -0.015069838,
        -0.03446373,    -0.0019094682,  0.009542515,    0.00019052454,   -0.0048356033,
        0.029084401,    0.019483974,    0.012997896,    -0.019162245,    0.005446891,
        0.017527856,    -0.007631438,   -0.017708024,   0.0019770316,    -0.0132938875,
        0.034309298,    -0.000662764,   0.032739256,    0.006235129,     -0.007914561,
        0.018801907,    -0.007245362,   -0.013081546,   -0.007502746,    -0.024039673,
        0.033511408,    0.0187633,      -0.012830596,   0.0028666153,    -0.026742207,
        0.004594306,    0.015764775,    0.018660346,    0.01694874,      -0.02263693,
        0.017270472,    -0.025931446,   0.013216672,    -0.0064860787,   0.015327222,
        0.004240403,    -0.014374901,   0.0033106029,   -0.012180702,    -0.011820364,
        0.011093254,    0.0032575172,   -0.012495997,   -0.010333971,    0.007534919,
        0.028363725,    0.023190306,    -0.0003335939,  0.010379014,     -0.018209923,
        -0.0024644525,  0.020809503,    -0.0093880845,  0.02375655,      -0.012946419,
        0.014915408,    0.00034907716,  0.01180106,     0.016035028,     -0.020938195,
        -0.005109074,   0.012631124,    0.010462663,    0.023293259,     0.005286026,
        0.005514454,    -0.0014630676,  -0.0046843905,  0.020655073,     -0.021079756,
        0.016627012,    0.011131861,    -0.011717411,   -0.0067563322,   -0.66096234,
        0.010102325,    -0.006231912,   -0.0062898234,  0.005546627,     0.011498634,
        0.020500641,    0.026459083,    -0.00035531068, -0.0048870803,   -0.004957861,
        0.005057597,    0.018042624,    -0.0134483185,  -0.03345993,     -0.018557392,
        -0.010868043,   -0.025648324,   -0.0053568063,  0.001993118,     -0.04298314,
        0.027797481,    0.001224183,    -0.00452996,    0.009349477,     -0.009529646,
        0.014825324,    -0.04043504,    -0.0138215255,  0.026536299,     -0.033254024,
        0.016279543,    -0.01519853,    0.032764994,    0.047281455,     -0.0014904147,
        -0.011453591,   0.01763081,     -0.00009702174, 0.014696632,     -0.009664772,
        -0.008410024,   0.006029222,    -0.0137185715,  0.0018097318,    0.012508866,
        0.020912457,    -0.0006551229,  -0.009407388,   0.0038832824,    0.008918358,
        0.027437143,    -0.012727643,   -0.006267302,   -0.010070153,    0.00130542,
        0.022984399,    0.00084856316,  0.010610659,    -0.009355911,    -0.006608336,
        -0.01630528,    -0.015584607,   0.0141947325,   -0.014439247,    0.05791142,
        0.0039572804,   0.022701276,    0.026433345,    -0.03703757,     0.0134483185,
        0.009529646,    -0.00444631,    0.005620625,    -0.011279858,    0.0134740565,
        0.023795158,    -0.0032591259,  0.0065150345,   -0.007734392,    0.0136542255,
        -0.0068399822,  -0.0034264256,  0.0018177751,   0.018634608,     -0.0070394548,
        -0.030113937,   0.012669732,    0.014387771,    -0.029624907,    0.006585815,
        0.020938195,    -0.018454438,   0.01091952,     0.018042624,     0.0064603407,
        -0.0035937252,  -0.0012418783,  -0.0034457294,  -0.037964154,    -0.0058715744,
        -0.03232744,    0.00021857538,  -0.0012153354,  0.0035293791,    -0.00017996777,
        -0.019483974,   0.0015040883,   0.033048116,    -0.01683292,     0.0089119235,
        0.0047262153,   0.0056817536,   0.0011485765,   -0.005183072,    -0.024309926,
        0.017154649,    0.016575536,    0.0136928335,   -0.021903386,    0.0009426692,
        0.026047269,    -0.0029856553,  -0.0134483185,  0.014374901,     0.020616464,
        -0.005321416,   -0.032764994,   -0.020783765,   0.0057943594,    -0.004092407,
        0.0037642422,   -0.011337769,   -0.004787344,   0.014632286,     0.021903386,
        0.015957814,    -0.009574688,   0.020487772,    -0.017334819,    -0.01293355,
        0.0131651955,   0.020320473,    -0.0037256347,  0.009761292,     -0.021787563,
        -0.0075284843,  -0.025764147,   -0.03443799,    0.018776169,     0.015056969,
        -0.0016142807,  0.0035293791,   0.00005660439,  0.02086098,      0.00808186,
        -0.0022714145,  -0.00985781,    0.0040666685,   -0.019599797,    0.016176589,
        0.021967731,    -0.018596,      -0.009709815,   0.012116356,     -0.024155496,
        0.012701904,    0.0139373485,   -0.0002853344,  -0.01683292,     -0.003934759,
        -0.02944474,    -0.02262406,    0.0058297496,   0.024657395,     -0.012463824,
        0.0005035076,   -0.01536583,    -0.005154116,   -0.0054887156,   -0.007444835,
        -0.013133023,   -0.001068144,   -0.00041382536, 0.019200852,     -0.0009298,
        0.027076805,    0.02440001,     -0.012476694,   0.016215198,     -0.005556279,
        -0.0008179988,  0.0066791167,   -0.0043111835,  0.012734078,     0.007670046,
        0.002448366,    0.038684826,    0.007213189,    0.0255325,       0.021774694,
        0.008744624,    0.025674062,    -0.011421419,   0.008596628,     -0.032070056,
        -0.0033363411,  -0.025481025,   0.04159327,     -0.008500109,    0.015558868,
        -0.022997268,   0.0010834262,   0.006154697,    0.008789666,     0.019239461,
        -0.012232179,   0.0008598237,   -0.020037351,   0.006572946,     0.0028392682,
        -0.007425531,   -0.026008662,   -0.0058104456,  -0.026163092,    0.0133324955,
        -0.012502432,   0.024876172,    -0.00013200988, -0.020449165,    -0.010456229,
        0.00050752924,  -0.014181863,   0.01584199,     0.015867729,     -0.0058747916,
        0.01990866,     -0.0028875277,  0.007599265,    -0.0005485498,   0.008860447,
        0.030319845,    0.024657395,    -0.03361436,    0.00008289577,   0.0060549607,
        0.019689882,    0.0038189364,   -0.009600426,   0.004944992,     -0.008056122,
        0.0128499,      -0.01957406,    0.016665619,    0.0138215255,    0.010842305,
        0.018879123,    0.009992937,    0.025738409,    0.031272165,     -0.0019303806,
        -0.023846636,   0.021131232,    0.008004645,    0.025982924,     -0.00006902116,
        0.031143473,    -0.015919205,   0.0074319653,   0.013499795,     0.018750431,
        0.010938823,    0.0037738942,   -0.021620262,   0.009600426,     0.001300594,
        0.01043049,     -0.00784378,    0.019059291,    0.027256975,     0.012734078,
        -0.03912238,    0.01663988,     0.016137982,    0.014593678,     -0.020976802,
        -0.009980068,   -0.0022360242,  -0.019213721,   0.023537774,     0.0035004236,
        0.01618946,     -0.009265827,   -0.013010765,   -0.014979754,    -0.020281866,
        0.0329709,      0.0057621864,   0.040949807,    -0.022739884,    -0.0005851466,
        0.03865909,     -0.0017534291,  -0.029624907,   0.0023035875,    0.0140016945,
        -0.00226498,    -0.028852755,   -0.0040377127,  -0.0005561909,   0.00016287586,
        -0.01663988,    -0.0133324955,  0.0005839401,   -0.01570043,     -0.010218148,
        -0.041361623,   -0.0021716782,  0.01568756,     -0.02153018,     -0.023074483,
        -0.006048526,   -0.015880598,   -0.004111711,   0.12158824,      0.012315828,
        0.020989671,    0.007277535,    0.027900435,    0.021440094,     -0.012985027,
        -0.019458236,   0.0135770105,   0.0022907183,   0.0003516912,    -0.0139373485,
        -0.0029583082,  -0.0011759235,  0.017334819,    0.0014123952,    -0.013371103,
        -0.036316894,   0.0076250033,   -0.0018081232,  -0.016614143,    0.018789038,
        0.019368153,    0.016176589,    -0.023074483,   -0.035210144,    0.00008661578,
        0.031478073,    -0.014143256,   -0.034360774,   -0.022701276,    -0.0018756865,
        0.011974795,    -0.0046843905,  -0.008184814,   -0.00011542068,  -0.007946733,
        -0.00067925267, 0.005849053,    -0.008673844,   0.036625754,     0.034386512,
        0.0133968415,   -0.02459305,    0.021452963,    0.0066340747,    -0.018673215,
        0.02862111,     0.005832967,    -0.011176904,   0.04169622,      -0.0027234454,
        -0.0010198845,  -0.003185128,   0.0027958346,   0.008281332,     -0.00017644886,
        -0.017399164,   0.022340938,    0.033228286,    -0.013988825,    -0.01746351,
        -0.02118271,    -0.027076805,   0.0090920925,   -0.04061521,     -0.006071047,
        -0.033022378,   -0.011665934,   -0.010977431,   0.004233968,     -0.02568693,
        0.018737562,    -0.02376942,    0.036316894,    0.007020151,     0.000746816,
        -0.024760349,   0.010938823,    0.023318999,    -0.008931228,    -0.0070458893,
        -0.029238831,   -0.015018362,   -0.0051315953,  0.029727861,     0.014825324,
        -0.00020510294, -0.009967199,   0.003180302,    0.030191153,     0.018338615,
        0.001332767,    -0.0049063843,  0.012618255,    -0.018570261,    0.0056656674,
        0.023653597,    -0.01108682,    -0.00065592723, 0.012701904,     -0.031246427,
        0.010173106,    0.008159076,    -0.00022661863, -0.001592564,    -0.0091435695,
        -0.0025352333,  -0.026767945,   -0.01585486,    0.023962459,     -0.018287139,
        0.008429329,    -0.01956119,    0.021156972,    0.007329012,     0.0006804592,
        0.009967199,    0.011723845,    0.004188926,    -0.0138215255,   -0.016897265,
        0.015957814,    0.020526381,    -0.011530807,   0.009162873,     0.02088672,
        -0.02618883,    0.0023759769,   0.004404485,    -0.031194951,    -0.011582283,
        0.0037964152,   0.008680278,    -0.022250853,   0.007489877,     -0.010115194,
        0.020011613,    -0.0032526914,  -0.007908126,   -0.023035875,    -0.0054887156,
        0.025300855,    -0.008410024,   -0.044424493,   -0.027643051,    0.003963715,
        0.0041857087,   0.01618946,     -0.0019030336,  -0.013268149,    -0.0136284875,
        -0.019870052,   0.008815405,    -0.0077086533,  -0.047307193,    -0.015430176,
        0.009941461,    0.010777959,    0.0026269264,   0.034232084,     0.0053375023,
        0.024683133,    0.005479064,    -0.008313506,   -0.00079949934,  -0.017090304,
        -0.009458865,   -0.063831255,   -0.0042468375,  0.027051067,     0.024206974,
        0.00077335874,  -0.002255328,   0.02831225,     -0.0048420383,   0.011768887,
        -0.019213721,   -0.009233654,   -0.007946733,   0.017025957,     0.010591355,
        -0.026304653,   -0.00272988,    0.0013544838,   -0.009497473,    0.040512256,
        0.005942355,    -0.0025577543,  -0.013190934,   0.03881352,      -0.018776169,
        -0.017991148,   -0.017218996,   -0.005720361,   0.009413823,     0.023692206,
        -0.010520575,   -0.0076121343,  0.020127436,    0.017373426,     0.00815264,
        0.007567092,    -0.0006941327,  -0.0007745652,  0.023357606,     -0.012039141,
        -0.008274898,   0.0002593949,   -0.010385448,   -0.015764775,    -0.028878493,
        -0.026317522,   -0.037552338,   -0.018480178,   0.0022167205,    -0.0013504621,
        0.009484603,    0.0023132395,   -0.04434728,    0.018660346,     0.023795158,
        0.029084401,    0.01423334,     0.028415203,    0.0037899807,    -0.015507391,
        -0.0004681173,  0.041799176,    0.0046522175,   -0.0070651933,   0.0063863425,
        -0.0013190934,  0.0094910385,   -0.031786934,   -0.01860887,     -0.0028843104,
        -0.041155715,   -0.02944474,    0.010321102,    -0.022431023,    0.004401268,
        -0.010391883,   -0.010456229,   0.0036709404,   -0.0025529284,   -0.0184287,
        -0.00041261886, -0.0004218686,  -0.0138343945,  -0.062029563,    -0.008828274,
        -0.012837031,   -0.0034457294,  0.010449794,    -0.0070394548,   0.0070394548,
        -0.006206174,   0.0013416145,   -0.01793967,    0.0019046422,    0.024374273,
        -0.012264351,   -0.003867196,   0.0036162464,   -0.02490191,     -0.0065053827,
        -0.017502118,   0.0003850707,   0.026716467,    -0.02133714,     0.019947266,
        -0.016627012,   0.027874697,    0.010044414,    0.006608336,     -0.0088347085,
        -0.014979754,   0.0015032839,   0.019110769,    0.037758246,     0.008596628,
        -0.031194951,   -0.018441569,   -0.015597476,   0.004497787,     -0.024348535,
        -0.015082708,   -0.0074834423,  -0.014168994,   0.0031046956,    -0.008223422,
        -0.0022955444,  0.011485765,    0.028595371,    -0.0044173542,   -0.0068078088,
        0.027437143,    -0.037783984,   0.019921528,    -0.006299475,    -0.0053728926,
        -0.033871744,   0.004143884,    0.02297153,     -0.01124125,     0.01941963,
        -0.02618883,    -0.011987664,   -0.008615932,   -0.0026848377,   -0.0006112872,
        -0.010353275,   0.0031690416,   -0.0017807761,  0.008107599,     -0.009349477,
        -0.022984399,   -0.019123638,   0.0037867634,   0.034489468,     0.0014260687,
        0.018454438,    -0.025622586,   -0.0015177617,  -0.009986502,    0.013107284,
        0.0093108695,   -0.04787344,    -0.0028553547,  0.006074264,     0.012457389,
        -0.008448632,   -0.014542201,   -0.0189306,     -0.019779967,    -0.019303806,
        0.025635455,    0.00711667,     -0.021646,      0.007509181,     0.027076805,
        0.030989043,    0.0010343622,   0.012090617,    -0.015121315,    0.008480806,
        -0.03345993,    -0.020500641,   -0.029341785,   0.01584199,      0.035956558,
        0.00305161,     -0.014606547,   -0.04012618,    0.0033878179,    -0.040512256,
        -0.009896418,   -0.016459713,   0.023653597,    0.016627012,     -0.0027411405,
        0.015147054,    0.03415487,     0.002462844,    0.011041777,     -0.026562037,
        -0.012508866,   0.005704275,    0.00905992,     0.011929752,     0.008506544,
        -0.011125427,   0.0011027299,   0.011556545,    0.00030182305,   -0.014683762,
        0.013216672,    -0.015610345,   0.005997049,    -0.029316047,    0.014645155,
        -0.006315562,   0.01697448,     0.0032832557,   0.011530807,     0.014310555,
        0.0096197305,   0.012959288,    -0.014760978,   -0.023743682,    0.0039090207,
        0.01488967,     0.021156972,    0.010205279,    -0.009780595,    -0.012463824,
        -0.014748108,   0.023524905,    0.00485169,     0.0017968626,    0.00792743,
        -0.0038639784,  -0.021362878,   -0.010726482,   0.016781442,     -0.0011357073,
        -0.00018217968, -0.0020751592,  0.009664772,    0.005253853,     -0.003815719,
        0.005845836,    -0.037552338,   -0.004156753,   0.010308232,     -0.017643679,
        -0.02554537,    0.021813301,    0.016665619,    -0.017309079,    -0.015867729,
        0.01108682,     -0.0025078862,  -0.018287139,   -0.0086545395,   0.0007669241,
        -0.0069043282,  0.019162245,    -0.002153983,   -0.016884396,    -0.022997268,
        -0.006283389,   -0.0029213093,  -0.037809722,   0.008944097,     0.23267521,
        -0.014027433,   0.0135512715,   0.022984399,    -0.0018676432,   0.016022159,
        0.02929031,     0.021131232,    -0.00023104243, -0.013081546,    0.0033492104,
        0.017489249,    0.0141303865,   0.000037954098, -0.0137185715,   -0.02797765,
        -0.019200852,   -0.018866254,   -0.0027604443,  -0.016601274,    0.011543676,
        -0.005096205,   -0.009690511,   -0.012148528,   0.0065697287,    -0.032584824,
        -0.015571737,   -0.0010858391,  0.0058747916,   0.025944315,     -0.020256128,
        -0.006489296,   -0.0052313316,  -0.02150444,    -0.027231235,    -0.0070587583,
        0.0071874503,   -0.0027636616,  -0.006202956,   0.007534919,     0.02055212,
        -0.01585486,    0.004095624,    0.010160237,    0.0029679602,    0.008339244,
        -0.002039769,   -0.012450955,   0.015275746,    0.02149157,      -0.030525751,
        -0.0010641223,  -0.00077416305, 0.037114784,    -0.002655882,    -0.000815988,
        -0.003912238,   0.0026944897,   0.01697448,     -0.01778524,     0.007901691,
        0.018634608,    -0.0037803287,  0.0078051724,   -0.023627859,    0.02069368,
        -0.025210772,   0.055389054,    0.023074483,    -0.012791989,    -0.018235663,
        -0.015571737,   -0.007181016,   -0.0042500547,  0.011698106,     -0.01697448,
        0.0074641383,   0.007637873,    0.023550645,    -0.014490724,    -0.011093254,
        -0.0047744745,  0.014979754,    0.00025919382,  -0.02554537,     0.00018690508,
        0.026278915,    0.0025802755,   -0.011871841,   0.0021958079,    0.006071047,
        -0.011904014,   0.004156753,    0.00088314916,  0.00662764,      0.036085248,
        -0.008506544,   0.009812769,    -0.011099689,   0.0138215255,    -0.022932922,
        -0.03832449,    0.029161617,    -0.011550111,   -0.024940517,    -0.021748954,
        0.0034103391,   0.031941365,    0.023653597,    -0.020616464,    -0.004111711,
        -0.00872532,    0.0063413004,   -0.02635613,    0.0061289584,    0.017360557,
        0.019599797,    -0.0067048552,  0.007425531,    0.00642495,      0.006659813,
        -0.015430176,   -0.0041181454,  0.0033106029,   -0.0032366049,   -0.016923003,
        -0.004957861,   0.008088294,    0.03425782,     -0.020024482,    0.020320473,
        -0.037320692,   0.015108446,    -0.014490724,   0.0023759769,    0.0038285882,
        0.013030069,    0.0012579648,   0.0134611875,   0.0028827018,    0.032070056,
        -0.0010343622,  0.010359709,    0.0067498977,   0.0027507923,    0.00018529643,
        0.016047897,    0.00420823,     0.002876267,    0.003217301,     -0.0043111835,
        -0.030319845,   0.014954016,    -0.010321102,   0.011118992,     -0.012997896,
        -0.017386295,   -0.009896418,   0.013371103,    0.0035165101,    -0.028440941,
        -0.0017132128,  0.0032752124,   -0.04285445,    -0.023499167,    -0.004671521,
        -0.16307856,    0.011987664,    0.0017373426,   -0.010488401,    0.0189306,
        -0.00075485924, 0.01633102,     -0.0070394548,  0.0043851812,    -0.006392777,
        -0.0010351666,  0.021311402,    -0.032893687,   -0.015172792,    -0.008377852,
        -0.011151166,   -0.018004017,   0.015301484,    0.0074384,       -0.01076509,
        0.012920681,    -0.013860133,   -0.0066984207,  -0.00051838765,  0.0054694116,
        0.01083587,     -0.0014815672,  -0.0086545395,  -0.0074834423,   -0.008596628,
        -0.014104648,   -0.009793464,   0.010160237,    -0.0089762695,   0.0060227877,
        0.005086553,    -0.017103173,   -0.0025561457,  -0.009072789,    -0.0018467308,
        0.014606547,    0.028286511,    0.033871744,    0.008120468,     0.0038704132,
        0.036960356,    0.0031979973,   0.0069493703,   0.007071628,     -0.022997268,
        0.0014888061,   -0.04336922,    -0.0013705703,  0.008429329,     0.020796634,
        0.014632286,    -0.005450108,   0.0035036409,   -0.0031979973,   -0.004320835,
        -0.007316143,   -0.017373426,   -0.00070458895, -0.018235663,    -0.007489877,
        -0.02344769,    -0.005919834,   -0.007650742,   -0.029161617,    0.027076805,
        -0.01729621,    -0.00776013,    0.0067820707,   -0.009137135,    0.015159923,
        0.0014180255,   -0.0095682535,  -0.004340139,   -0.0090534855,   -0.010777959,
        -0.04998399,    0.023370475,    -0.012869204,   -0.0069944123,   0.012006967,
        0.007393358,    -0.016536927,   -0.0135512715,  -0.0045589157,   -0.007850215,
        -0.0017695156,  -0.039688624,   -0.014593678,   -0.028878493,    0.015983552,
        0.028157819,    0.0023438039,   -0.0016987349,  0.0058587054,    0.0061836527,
        -0.0090534855,  0.0010617094,   -0.0049417745,  0.0055788,       0.03899369,
        0.03389748,     0.033073854,    0.016253805,    0.029419001,     -0.0016762138,
        -0.018943468,   0.002844094,    0.007071628,    0.04079538,      -0.014387771,
        0.0072839693,   -0.028080603,   -0.0045203078,  0.029367523,     -0.006367039,
        0.06331649,     0.0074384,      -0.021298533,   -0.01957406,     -0.02021752,
        0.005192724,    -0.097445615,   0.0060227877,   -0.010385448,    0.016459713,
        -0.011402115,   0.027179759,    0.007985341,    0.007779434,     0.012579647,
        0.007309708,    0.0046876078,   -0.03279073,    0.018415831,     0.004201795,
        0.017244734,    -0.00776013,    -0.044012677,   0.010076587,     -0.01076509,
        0.014452117,    -0.009889984,   0.015314353,    0.0014630676,    -0.022019207,
        -0.010829436,   0.0134611875,   -0.035184406,   0.013499795,     0.024232712,
        0.012264351,    0.03219875,     -0.011260553,   0.01956119,      -0.0068335473,
        -0.00058474444, -0.01010876,    -0.02424558,    0.004497787,     0.0300882,
        -0.0304228,     -0.007071628,   -0.0134740565,  -0.0034907716,   -0.015790513,
        0.018402962,    -0.011016039,   -0.018132709,   -0.0054758466,   0.025352333,
        -0.022431023,   -0.035776388,   0.008326375,    -0.04653504,     0.012116356,
        0.051296648,    0.016060768,    -0.00046288918, -0.0086545395,   -0.003770677,
        0.007502746,    -0.0056270594,  -0.008062556,   -0.004011974,    0.008776797,
        -0.011929752,   -0.009400954,   -0.0065697287,  0.016627012,     0.00857089,
        -0.0060195704,  0.01860887,     0.020333342,    -0.0014952406,   -0.0032977336,
        -0.032147273,   0.0072389273,   -0.014786716,   0.010379014,     0.012817727,
        -0.02504347,    -0.00013020015, -0.014979754,   0.021864777,     -0.025506763,
        0.00752205,     0.007901691,    0.00066557917,  -0.022842837,    0.0032269529,
        -0.013190934,   0.009992937,    0.0019352066,   -0.01761794,     -0.007309708,
        -0.004111711,   0.021800432,    -0.014658024,   -0.00095392973,  -0.00022259701,
        -0.0024435401,  -0.01252817,    0.0044205715,   -0.059146862,    0.023023006,
        0.009433127,    -0.009606861,   -0.0019593362,  -0.016742835,    0.0134097105,
        -0.027771743,   -0.012560343,   -0.014979754,   -0.018789038,    0.0339747,
        0.022250853,    0.018660346,    -0.0039379764,  -0.0057235784,   -0.0070008473,
        -0.005250635,   0.0010946867,   0.005237766,    -0.0012515301,   -0.0027556184,
        0.018351486,    -0.018235663,   -0.005707492,   0.0037867634,    0.008583759,
        0.022572584,    0.0018869471,   -0.0128499,     0.0011783366,    -0.03188989,
        -0.010546313,   0.035493266,    0.011550111,    -0.014168994,    -0.0068399822,
        0.0051798546,   0.0069815433,   0.044115633,    -0.0297536,      -0.02280423,
        0.029702123,    -0.010578486,   -0.03279073,    0.0095039075,    0.012489563,
        0.0006575359,   0.036136724,    -0.006112872,   0.01712891,      0.014143256,
        0.010282494,    -0.0023856286,  0.002747575,    -0.020500641,    0.03250761,
        0.0070137163,   -0.0015941727,  0.012418782,    0.022868576,     -0.011337769,
        0.024464358,    0.0034167736,   -0.012804858,   -0.015983552,    0.0055820174,
        0.013120154,    -0.0034682506,  -0.026562037,   0.005997049,     -0.011910449,
        0.008281332,    0.011929752,    0.010604224,    0.019316675,     -0.018801907,
        -0.01663988,    -0.009658338,   -0.012026271,   -0.006434602,    -0.018776169,
        -0.035158664,   -0.0010737742,  0.026407607,    0.025519632,     0.014748108,
        0.023331868,    0.0027170107,   0.012824162,    -0.0044237887,   0.014323425,
        0.0012828988,   0.004977165,    0.000665177,    0.01714178,      -0.019059291,
        -0.015970683,   0.035596218,    0.017862456,    0.0045267427,    0.01286277,
        -0.0014091779,  0.003654854,    -0.018814776,   0.02441288,      -0.014670893,
        -0.04334348,    -0.0048259515,  0.020732287,    0.024798956,     -0.0018081232,
        -0.014336294,   0.014966885,    -0.019381022,   0.0021990254,    -0.010198845,
        -0.0072196233,  -0.030036723,   0.042777233,    0.019381022,     0.008429329,
        0.025583979,    -0.016884396,   0.02005022,     0.011421419,     0.01600929,
        -0.015237138,   -0.015751906,   -0.011556545,   0.008603063,     0.00985781,
        -0.029367523,   -0.0049192533,  0.0013890697,   -0.0071617123,   -0.023499167,
        0.017605072,    -0.01567469,    0.037758246,    -0.011144731,    -0.0060324394,
        0.02554537,     -0.03557048,    0.029032925,    -0.0071745813,   0.033717316,
        -0.007875953,   -0.0067692013,  -0.010507706,   -0.010546313,    -0.0014107865,
        0.022006338,    -0.022649799,   0.0016778224,   0.007798738,     -0.017167518,
        0.000390701,    -0.02232807,    0.028981447,    0.011807495,     0.01796541,
        -0.0030918263,  -0.021285664,   0.0014630676,   0.003199606,     -0.0014976537,
        -0.0068078088,  -0.035184406,   -0.0068142437,  0.0028875277,    -0.024567312,
        0.01051414,     0.015816253,    -0.0015346525,  0.0029132662,    -0.0033202546,
        0.0070394548,   -0.0035036409,  -0.0019159027,  0.005556279,     0.004317618,
        -0.005913399,   0.016215198,    0.015816253,    0.00206229,      -0.015970683,
        -0.0043594427
    ],
    [
        -0.00047567577, -0.035206478,    -0.013435413,   -0.01746086,    -0.00509329,
        0.016554812,    -0.008387426,    0.0008550838,   -0.0037924626,  0.012419344,
        0.017227877,    -0.0035886015,   0.011908074,    -0.036293738,   0.02041199,
        -0.009746499,   0.027776876,     -0.02302659,    0.0022505613,   0.0068147834,
        0.013305978,    0.009519987,     0.011260896,    -0.010892005,   0.0066853478,
        -0.010781984,   0.0069895214,    -0.019777756,   0.010600775,    0.0013881966,
        0.022172315,    -0.009261116,    0.006416769,    -0.023363123,   -0.02855349,
        -0.013668397,   -0.010646077,    -0.016179448,   0.011299727,    -0.026288368,
        0.013953156,    0.01935062,      0.004248723,    -0.009306419,   -0.014833318,
        0.004242251,    0.023194857,     -0.013901382,   -0.010445451,   0.014807431,
        0.016399488,    0.018522233,     -0.03761398,    -0.026029496,   -0.0039704363,
        -0.0041354666,  -0.027802764,    0.022612397,    0.014859205,    0.0004510021,
        -0.0030854207,  0.008141498,     -0.0103872055,  0.024890462,    -0.00767553,
        0.015881745,    -0.0015621257,   -0.00234602,    -0.000688031,   0.013163599,
        0.02568002,     0.007863211,     0.0006864131,   -0.0037309807,  0.017603239,
        -0.00071310916, -0.018457513,    -0.0056110327,  0.0063941176,   0.013616623,
        0.025291713,    -0.020424934,    -0.020437878,   0.021913445,    0.017447917,
        -0.0050188648,  -0.015001584,    0.012613498,    -0.01724082,    0.0020725874,
        -0.003811878,   -0.009960068,    0.013047107,    0.027103812,    -0.02775099,
        0.018017434,    -0.004989742,    0.00673065,     0.0065170815,   -0.047192212,
        0.0045787836,   0.019816589,     -0.018832877,   -0.004488179,   0.009228757,
        0.024411552,    0.019441225,     0.027052037,    0.017991547,    -0.018522233,
        0.015907634,    0.015001584,     0.016710134,    -0.04615673,    -0.0160759,
        -0.023091309,   0.031867042,     0.0061967284,   -0.0062290872,  -0.016748965,
        0.037510432,    0.0024706016,    -0.0033847406,  0.000017721552, 0.00927406,
        0.03411922,     -0.019285902,    -0.017616183,   0.008859865,    0.0037762832,
        0.029873732,    -0.0057469397,   0.024139736,    0.001084832,    -0.017538521,
        0.015959408,    -0.02208171,     0.027414456,    -0.013066522,   0.0040836926,
        0.010950251,    0.0077208327,    -0.019324733,   0.011370916,    -0.018302191,
        0.01822453,     0.0066982913,    0.0028977392,   0.0038765958,   -0.0012320649,
        0.032902524,    -0.006950691,    0.013616623,    -0.01625711,    0.022146428,
        0.010581359,    -0.013875495,    0.014276745,    -0.016011182,   -0.017253764,
        0.011066742,    0.0071060136,    0.017810335,    -0.0069895214,  0.0143932365,
        0.02505873,     0.0016179448,    -0.028424054,   -0.0037665754,  -0.010904948,
        -0.01360368,    0.02051554,      -0.00825799,    0.020774411,    -0.00068155926,
        0.014470899,    0.01117029,      0.014690938,    -0.011700977,   -0.006064057,
        -0.0059605087,  0.019014087,     0.015959408,    0.015415778,    -0.0100377295,
        0.0037374524,   -0.0063682306,   -0.001959331,   0.010348375,    -0.007824381,
        0.008749845,    0.0016025744,    -0.02234058,    -0.004840891,   -0.66436696,
        -0.02819107,    0.006995993,     0.008529805,    0.010083032,    0.019428281,
        0.008821035,    0.0018671083,    0.0037859909,   -0.0022910098,  0.0027683035,
        0.011506823,    -0.0033232586,   -0.018832877,   -0.00081584865, -0.005688694,
        0.00374716,     -0.025459979,    0.016503036,    0.0007535578,   -0.05306859,
        0.032980185,    0.011228537,     -0.010290129,   -0.0073389974,  0.016192392,
        0.028475828,    -0.00854922,     -0.023376066,   0.013500132,    -0.012619969,
        0.016852513,    -0.0047535216,   0.0154934395,   0.05954037,     -0.008607467,
        -0.024631592,   0.012561724,     -0.007798494,   -0.0010112155,  -0.0055171917,
        0.011183234,    0.0057501756,    -0.013072994,   0.0038765958,   0.008659241,
        -0.0005452474,  -0.028346393,    0.01454856,     -0.005513956,   0.008633354,
        0.042196,       -0.0049670907,   0.02037316,     0.0022537971,   -0.00040266602,
        0.026042439,    -0.0028281675,   0.013849608,    0.004015739,    -0.0054362947,
        0.018056264,    -0.014626221,    -0.006416769,   -0.00927406,    0.039167207,
        -0.014574447,   0.024761027,     0.008465087,    -0.052602623,   0.028424054,
        0.014885092,    -0.0017020779,   0.0095005715,   0.015079245,    0.013163599,
        0.03409333,     -0.017564408,    -0.013526019,   0.031349298,    0.013500132,
        -0.024799857,   -0.031841155,    -0.015687592,   0.016192392,    -0.0066141584,
        -0.0369668,     0.01884582,      0.0032747202,   -0.0037083295,  0.016399488,
        0.040720433,    -0.00920287,     -0.010963194,   -0.0052065463,  -0.016166504,
        -0.0073066386,  -0.016050013,    -0.0064879586,  -0.018030377,   0.014910979,
        -0.011927489,   0.008089724,     0.011254424,    0.0064588357,   -0.015066301,
        -0.0028767057,  0.008795148,     0.03251422,     -0.0029430415,  -0.016270053,
        0.013318921,    0.0061190673,    0.002221438,    -0.0032731022,  -0.017163157,
        0.035879545,    0.012652328,     0.020023685,    -0.020826185,   0.02280655,
        -0.0027731573,  0.009701197,     -0.0025498809,  0.017318482,    0.013131239,
        0.008270933,    -0.022948928,    -0.033472043,   -0.00551072,    -0.006355287,
        0.012031037,    0.007798494,     0.0066076866,   0.0114097465,   -0.0028653801,
        -0.0039057187,  -0.028268732,    0.0064620716,   -0.013267147,   -0.022961872,
        0.028268732,    0.01043898,      -0.004954147,   -0.013538962,   -0.029071232,
        -0.003989852,   0.0001670528,    -0.024748083,   0.011901602,    0.012192832,
        -0.018522233,   -0.006827727,    0.0023832326,   0.016736021,    0.0062549748,
        -0.004721163,   -0.023984414,    -0.015299286,   -0.011118516,   0.020800298,
        0.013066522,    -0.0053780484,   -0.005394228,   0.0018832877,   -0.013849608,
        -0.013538962,   0.013629567,     -0.022107597,   -0.026016552,   -0.0006382792,
        -0.030650346,   -0.020748524,    0.025563527,    -0.020075459,   -0.0059961034,
        -0.011739807,   -0.0008271743,   -0.01073021,    -0.0126717435,  -0.009604121,
        0.031219862,    0.0008704543,    -0.00028738743, 0.017939772,    -0.008633354,
        0.03626785,     0.01854812,      -0.006775953,   0.02335018,     -0.009630008,
        0.04921141,     0.006597979,     0.0043587433,   0.0003838574,   -0.0044719996,
        0.004342564,    0.009235228,     0.01211517,     0.024877518,    0.021602798,
        -0.00081342174, 0.022547679,     -0.0081868,     0.025084617,    -0.021848727,
        -0.014613277,   -0.034559302,    0.008924584,    -0.0114356335,  0.0066076866,
        -0.0011511677,  -0.0041742977,   0.0031339591,   0.022055823,    -0.009565289,
        -0.0072548646,  0.0018153341,    -0.027776876,   -0.004070749,   -0.00789557,
        -0.0041322308,  -0.008083252,    -0.012529365,   -0.023673767,   0.033730913,
        0.0093387775,   0.005853724,     0.022327637,    -0.02971841,    0.02527877,
        -0.009636479,   0.000064667234,  0.011506823,    0.019518886,    0.004316677,
        -0.01960949,    -0.012574667,    0.016826626,    0.009325834,    0.0001675584,
        0.0077596633,   0.034895834,     -0.018664612,   -0.008115611,   0.019130578,
        0.01036779,     0.008115611,     -0.016412431,   -0.013111824,   -0.04105697,
        -0.0057210526,  0.00017494029,   0.013034163,    0.02186167,     0.0024786915,
        0.009733556,    -0.0011349883,   0.017693844,    0.03634551,     0.013823721,
        0.0053715766,   0.00057032553,   0.0049670907,   0.013927269,    -0.005882847,
        0.009655895,    0.004714691,     0.02284538,     0.01931179,     0.002930098,
        -0.0082644615,  0.0075784535,    -0.03026204,    0.020424934,    -0.009138152,
        -0.012801179,   0.01571348,      0.019544773,    -0.013577793,   -0.0017409086,
        -0.03342027,    0.011377388,     0.0144191235,   0.0042034206,   0.00014258138,
        -0.030857444,   0.0065106098,    -0.02266417,    0.02375143,     -0.03383446,
        0.0034041558,   0.005161244,     -0.018108038,   -0.004313441,   -0.015571101,
        0.01196632,     0.0043263845,    0.0327472,      -0.02222409,    -0.005216254,
        0.022612397,    0.007591397,     -0.017305538,   0.029200668,    -0.00048740586,
        -0.008607467,   -0.022353524,    0.007144844,    -0.020101346,   0.011921017,
        0.0030320284,   -0.022457074,    -0.0030029055,  0.01065902,     -0.008012063,
        -0.03546535,    -0.015480496,    0.0413935,      -0.0007992647,  0.0071383724,
        -0.009112265,   -0.028993571,    -0.005128885,   0.096455395,    0.008516861,
        0.017266707,    0.015325173,     0.02208171,     -0.0017667958,  -0.021952275,
        -0.02047671,    -0.0036209605,   -0.008348595,   -0.022249976,   -0.013474245,
        0.004915316,    0.0025595888,    0.0269226,      -0.0038668881,  -0.009079906,
        -0.01876816,    -0.0033491456,   0.0019738926,   -0.0036241964,  0.0022537971,
        0.01975187,     -0.00591197,     0.0040060314,   -0.03207414,    -0.0069895214,
        0.015234568,    -0.0037439242,   -0.028657038,   -0.014872149,   0.0054362947,
        -0.0033685612,  0.018418683,     0.020787355,    0.017926829,    -0.004365215,
        0.017849168,    0.025524696,     -0.010024786,   0.011306198,    0.018897595,
        0.014574447,    -0.04633794,     0.015040414,    0.0028589084,   -0.0076561146,
        0.029925507,    -0.0072872234,   -0.0181857,     0.03670793,     -0.0024706016,
        -0.00749432,    0.0010718884,    -0.010303073,   0.026469577,    0.036293738,
        -0.00060753827, -0.008808091,    -0.011112045,   -0.018535176,   -0.0107366815,
        -0.0005909543,  -0.0037730474,   -0.006277626,   -0.024748083,   0.0060446416,
        -0.018328078,   -0.0074101873,   -0.010083032,   0.016451262,    -0.0258224,
        -0.0038442367,  0.008562163,     0.017033722,    -0.0012975917,  0.016205335,
        -0.022923041,   0.010303073,     -0.0023298406,  -0.011299727,   -0.021408645,
        0.014341462,    -0.016477149,    0.007908514,    0.008633354,    -0.002693878,
        0.011163819,    -0.006352051,    0.011176762,    0.0051741875,   -0.013396583,
        0.0020693515,   0.0040351544,    0.014121423,    -0.003459166,   0.029459538,
        0.01414731,     0.0004570694,    0.0038312932,   -0.005012393,   -0.043127935,
        0.0028637622,   0.008646297,     0.012742933,    0.005012393,    0.00019890608,
        0.005882847,    -0.031193975,    -0.03743277,    0.005310095,    -0.012982389,
        0.006407061,    -0.016477149,    0.015946465,    0.013053578,    0.014302632,
        0.012141057,    -0.012749405,    -0.02433389,    -0.0026210705,  -0.04506947,
        0.001847693,    0.045716647,     -0.007597869,   0.018561063,    0.000061835824,
        -0.015066301,   -0.008063837,    0.012089283,    -0.04372334,    0.014496786,
        0.013784889,    -0.0005173379,   -0.035853658,   0.010671964,    -0.015480496,
        -0.00019465898, -0.0034235711,   -0.006183785,   -0.013293034,   -0.0035886015,
        0.0052291974,   -0.017693844,    -0.023544332,   -0.023596106,   0.00079521985,
        0.007701417,    -0.006775953,    0.0065203174,   -0.013280091,   0.005682222,
        0.0038798316,   0.0017797393,    -0.01691723,    -0.025796512,   -0.00035797028,
        -0.013901382,   0.033808574,     0.0009926091,   0.027802764,    -0.022547679,
        0.038753014,    0.011014968,     0.005921678,    0.0055560223,   0.0056919297,
        -0.021835783,   -0.03070212,     0.018198643,    0.017370256,    0.005213018,
        0.021758122,    -0.0065429686,   0.011403275,    0.0007264572,   -0.012723518,
        0.003397684,    -0.009222285,    -0.015661705,   0.0035983091,   -0.0147944875,
        -0.006212908,   0.005154772,     -0.01985542,    -0.006711235,   0.026767278,
        0.022987759,    -0.023091309,    -0.009397023,   0.03176349,     -0.0037374524,
        0.010341903,    -0.008827507,    0.014846262,    0.00052664103,  0.0006087517,
        0.015376947,    -0.008594522,    0.0016729549,   0.0048214756,   0.01131267,
        0.0011463139,   0.013849608,     0.012063396,    0.039892048,    0.010471338,
        -0.007170731,   -0.0021842255,   -0.024605704,   -0.022508848,   -0.031918816,
        -0.028864134,   -0.04095342,     -0.009015189,   -0.010950251,   0.013991986,
        0.017176101,    -0.03313551,     -0.017253764,   0.03427454,     -0.002813606,
        0.024592761,    0.00015168232,   0.030650346,    0.015428722,    -0.010322488,
        -0.010542528,   0.01771973,      -0.008225631,   0.0140696475,   0.027647441,
        -0.0100118425,  -0.001201324,    -0.019596547,   -0.01513102,    0.00087692606,
        -0.03466285,    -0.027906312,    0.0026987318,   0.007177203,    0.0076625864,
        -0.0098500475,  -0.015273399,    -0.00369215,    0.02073558,     0.00066982914,
        -0.009979484,   -0.012386985,    -0.024502156,   -0.024916349,   -0.011882187,
        0.00007852088,  -0.0055301352,   0.011953376,    -0.0072225058,  0.01906586,
        -0.0026194525,  0.02419151,      -0.0030562978,  -0.004517302,   0.015933521,
        0.0035918374,   -0.014432067,    0.0009060491,   0.007351941,    -0.010594303,
        0.012464646,    0.008704543,     0.023557276,    -0.0022537971,  0.0058925548,
        -0.012354626,   0.026560182,     0.016930174,    0.013137711,    -0.011668618,
        -0.010290129,   -0.00018737823,  -0.0019221184,  0.009287003,    0.01571348,
        -0.017189045,   -0.020826185,    -0.012652328,   0.0025142862,   -0.03339438,
        -0.010678436,   0.013901382,     -0.016580699,   -0.0026307781,  0.006475015,
        -0.017616183,   -0.0064394204,   0.035672445,    -0.00054362946, -0.011830412,
        0.034714624,    -0.021991106,    0.003918662,    -0.0053424537,  0.022275863,
        -0.020399047,   0.0027197653,    0.021033281,    -0.010969666,   0.020450823,
        -0.04864189,    -0.026417803,    -0.005161244,   0.00369215,     -0.009539402,
        -0.007442546,   -0.014250858,    0.01225755,     0.0065397327,   -0.002020813,
        -0.020800298,   -0.0018897596,   0.025447035,    0.017900942,    0.008115611,
        0.034429867,    -0.03357559,     0.000249568,    -0.02234058,    0.0020289028,
        0.0005039898,   -0.04928907,     0.015700536,    -0.004096636,   0.0026599013,
        0.011629787,    -0.031608168,    -0.027388569,   -0.0103872055,  -0.023505501,
        0.017434973,    0.026793165,     -0.018794047,   0.010484282,    0.042428985,
        0.02146042,     -0.004666153,    0.009714141,    -0.02943365,    0.018664612,
        -0.012723518,   -0.01880699,     -0.012451703,   0.004808532,    0.029459538,
        -0.0021874614,  -0.013810777,    -0.021628685,   -0.011351501,   -0.03518059,
        0.0038410008,   -0.025084617,    0.011034383,    0.017189045,    0.0071577877,
        0.01454856,     0.011875715,     0.006879501,    0.0019900722,   -0.012710574,
        -0.015325173,   0.022780662,     -0.02234058,    0.01036779,     0.010393677,
        -0.015105133,   -0.0012409637,   0.0077273045,   -0.013746059,   -0.0029414236,
        -0.009746499,   -0.004491415,    0.017486747,    -0.0047243987,  0.012639385,
        -0.0055463146,  0.0070154085,    -0.0015839679,  -0.017266707,   0.0068600858,
        0.0009448798,   -0.002926862,    -0.017913885,   -0.010697851,   0.014522673,
        -0.0020725874,  -0.0027683035,   0.020826185,    -0.009668838,   -0.00369215,
        -0.018599894,   0.012186361,     -0.023440784,   -0.011720392,   0.006232323,
        0.012348155,    -0.03626785,     -0.024398608,   0.022703001,    0.021978162,
        -0.002344402,   0.007099542,     0.012833538,    -0.012755876,   0.008523333,
        0.014833318,    -0.045561325,    0.0024188275,   -0.008445672,   0.0019253542,
        -0.019557716,   0.035258252,     0.004070749,    -0.0059022624,  -0.005458946,
        0.009888878,    -0.0042098924,   -0.0072289775,  -0.0057501756,  0.019492999,
        0.0037859909,   0.021512194,     0.0038539446,   -0.008827507,   -0.019518886,
        0.0039672004,   -0.010212467,    -0.03409333,    0.034688737,    0.23319115,
        -0.013131239,   0.023596106,     0.030210266,    -0.020787355,   0.03466285,
        0.0016745728,   0.007714361,     -0.0126588,     -0.018237473,   -0.0038668881,
        0.018457513,    0.008503918,     0.0003561501,   -0.007707889,   -0.011299727,
        -0.007170731,   0.0006649753,    -0.016244166,   -0.020217838,   0.0086916,
        -0.0047049834,  0.0067824246,    -0.010969666,   0.0038927752,   -0.0136942845,
        -0.008270933,   -0.026793165,    0.015376947,    0.012141057,    -0.015855858,
        -0.041626483,   -0.008296821,    -0.0020062516,  -0.0058990265,  -0.0045528966,
        0.00067953684,  -0.00088744273,  -0.020787355,   -0.0040319185,  0.012581139,
        0.013131239,    0.011720392,     -0.008542748,   -0.0023346944,  0.004688804,
        -0.0036500834,  -0.0144191235,   -0.013655454,   0.016282996,    -0.028941797,
        -0.00059014536, 0.008303293,     0.04343858,     -0.009351721,   0.013681341,
        0.007947344,    0.0025061965,    0.0052259616,   0.0037989344,   -0.01720199,
        0.028320506,    -0.012781763,    0.0023945584,   -0.005588381,   0.018703442,
        -0.014962753,   0.011092629,     0.028941797,    -0.005306859,   -0.012742933,
        -0.013888438,   -0.025201108,    -0.002457658,   -0.0071966182,  -0.036837365,
        0.019260015,    0.011338557,     0.0044396403,   0.011908074,    -0.0038183497,
        0.00032399344,  -0.0048829573,   -0.0072225058,  -0.022249976,   -0.021551024,
        0.048331246,    -0.007830853,    -0.020929733,   0.014160253,    -0.0026194525,
        -0.0413935,     0.0069571626,    -0.022314694,   0.014755656,    0.012341683,
        0.014690938,    0.002638868,     -0.019803645,   -0.008704543,   -0.031556394,
        -0.014212027,   0.020295499,     -0.008749845,   -0.010956722,   -0.004860306,
        -0.004543189,   0.015364003,     0.018030377,    -0.013629567,   -0.028838247,
        -0.011112045,   0.0047794087,    -0.009403495,   -0.004077221,   0.018418683,
        0.007843796,    -0.0045334813,   0.029485425,    -0.023052478,   -0.004196949,
        -0.0073972438,  -0.00048740586,  0.01749969,     -0.0035238836,  -0.03176349,
        -0.017603239,   0.015027471,     0.022780662,    -0.021072112,   0.012315796,
        -0.019713039,   0.008322708,     -0.009319362,   -0.00070744636, -0.0042260718,
        0.011959848,    -0.00093274517,  -0.00090038625, 0.015907634,    0.011047327,
        0.004187241,    0.016205335,     -0.008859865,   0.014807431,    -0.03088333,
        0.023363123,    -0.0028637622,   -0.006507374,   0.0042390153,   -0.023181913,
        -0.027595667,   -0.004536717,    -0.009215813,   0.022910098,    -0.00862041,
        -0.013079465,   -0.012729989,    -0.011959848,   0.011461521,    -0.040073257,
        0.026974376,    0.013979043,     -0.036500834,   -0.013305978,   -0.0124840615,
        -0.16505626,    0.014250858,     0.01091142,     -0.0038636522,  0.020282555,
        -0.0121345855,  0.011357972,     0.000115784176, -0.0012369188,  0.0018379852,
        0.0160759,      0.010607246,     -0.02935599,    0.0016244166,   0.007067183,
        0.013435413,    -0.024049131,    0.017655013,    0.014626221,    0.0028103702,
        0.016050013,    -0.021654572,    -0.0038798316,  -0.0023961763,  0.007416659,
        0.006627102,    0.007876155,     0.0041548824,   -0.0018687262,  0.008808091,
        -0.012445231,   -0.017693844,    0.03303196,     -0.0015346206,  0.02033433,
        -0.0075849253,  0.0015451373,    -0.014677995,   -0.019402394,   0.005158008,
        0.0147427125,   0.0039769085,    0.011629787,    -0.01342247,    0.00078672566,
        0.021835783,    0.021007394,     0.020800298,    0.02127921,     -0.0060252263,
        0.002954367,    -0.03575011,     -0.023013646,   0.0072872234,   0.018198643,
        0.018120982,    0.005979924,     0.00469204,     0.0027958085,   -0.03176349,
        -0.021227436,   -0.014328519,    0.00474705,     -0.010451923,   -0.020554371,
        -0.015027471,   -0.011293255,    0.0066335737,   -0.030080829,   0.017072553,
        -0.0066918195,  -0.011254424,    0.02226292,     -0.005568966,   -0.0070218802,
        0.0050512236,   -0.022948928,    0.019454168,    -0.015829971,   -0.031116314,
        -0.03259188,    0.01625711,      0.008665713,    -0.0121086985,  0.009060491,
        -0.00039498077, -0.010775512,    0.0022505613,   -0.01800449,    -0.034714624,
        -0.01247759,    -0.012166945,    -0.026223648,   -0.009623536,   0.023091309,
        0.0516448,      0.007591397,     -0.00029406146, 0.03743277,     -0.0025547347,
        0.0009885642,   0.019777756,     -0.022482961,   0.014263801,    0.0403839,
        0.022094654,    -0.0037374524,   0.00756551,     0.01458739,     -0.010930835,
        -0.027052037,   0.008160913,     0.00967531,     0.03888245,     0.0010718884,
        0.012788235,    -0.010296601,    -0.01603707,    0.036034867,    -0.0010767423,
        0.06254327,     -0.000047375444, -0.03709624,    0.0017959187,   -0.011914546,
        0.0047988244,   -0.10251298,     -0.019557716,   -0.0068600858,  0.007151316,
        0.0033944482,   0.015674649,     -0.0029090648,  0.0101736365,   -0.031038653,
        0.021136831,    0.00047001295,   -0.051515363,   0.024916349,    -0.0054751253,
        0.02455393,     -0.021305097,    0.00018687262,  0.0021583384,   -0.016723078,
        0.008924584,    0.0144450115,    0.004067513,    -0.001347748,   -0.023272518,
        -0.0018946134,  0.0051224134,    -0.036216076,   0.011014968,    0.015571101,
        -0.013001804,   0.009869463,     -0.026560182,   0.025874173,    -0.012878841,
        -0.001408421,   0.0026890242,    -0.01993308,    -0.0032941357,  0.040099144,
        -0.043412693,   -0.011552126,    0.016969005,    0.0003074095,   -0.03862358,
        0.0009238465,   -0.017900942,    -0.014224971,   0.0025126683,   -0.0015014528,
        -0.027492117,   -0.06652989,     -0.013189486,   -0.021706346,   0.0009756207,
        0.020929733,    0.005685458,     0.023194857,    0.0067241783,   0.008833978,
        -0.0054006996,  -0.011700977,    0.00938408,     -0.031556394,   0.00012336829,
        -0.011558598,   -0.014729769,    -0.033549704,   0.008303293,    0.019713039,
        -0.013195958,   -0.010458395,    0.02971841,     -0.008516861,   0.009390552,
        -0.022651227,   0.0075525665,    -0.018108038,   -0.014820375,   0.019001143,
        -0.009519987,   -0.008245046,    -0.010976138,   0.035206478,    -0.017797392,
        0.0013380403,   0.028864134,     0.011571541,    -0.014574447,   0.0021146538,
        0.0036403758,   -0.004416989,    0.0005327083,   -0.017512634,   -0.028993571,
        -0.019221185,   0.00585696,      -0.000543225,   -0.015234568,   0.0023799967,
        -0.023233688,   -0.015700536,    0.022237033,    -0.060265206,   0.038856562,
        0.003485053,    0.0052065463,    0.00680184,     -0.011662146,   0.019091748,
        -0.014315575,   0.0068924446,    0.018017434,    -0.011746279,   0.00992771,
        0.0003148925,   -0.003695386,    0.0037439242,   0.008465087,    0.01018658,
        -0.00023662443, 0.0012660418,    -0.00023642219, -0.003459166,   0.0048732497,
        0.011338557,    0.0039801444,    0.011189706,    0.000044088996, -0.004242251,
        -0.0030433543,  -0.0131830145,   0.0008753081,   0.0043199128,   -0.02590006,
        -0.0140437605,  0.012975917,     -0.013318921,   -0.00047648474, -0.0059637446,
        0.00020537787,  0.012820595,     0.060990047,    -0.016994892,   -0.025951834,
        0.021123888,    -0.012846482,    -0.018625781,   0.004743814,    0.008199744,
        -0.004886193,   0.026314255,     -0.012166945,   0.020800298,    0.009804745,
        -0.008361539,   -0.0051741875,   -0.011642731,   -0.020282555,   0.037148014,
        -0.016179448,   0.0036533193,    -0.003549771,   0.025252882,    -0.0019269723,
        0.028424054,    0.00055697747,   0.0033912123,   0.017745618,    -0.008044422,
        0.014470899,    -0.0048441268,   -0.032436557,   0.0072225058,   -0.0108984765,
        0.011047327,    0.0034785813,    0.0011034383,   0.012801179,    -0.01043898,
        0.017033722,    -0.0012708956,   -0.00018849057, 0.0072807516,   -0.0016050013,
        -0.05146359,    0.0036080168,    0.033446155,    0.015842915,    -0.005452474,
        0.011882187,    -0.007423131,    0.002752124,    -0.008678656,   0.013927269,
        -0.0018493109,  0.014173197,     -0.0038539446,  0.0051806592,   -0.035594784,
        -0.005882847,   0.039348416,     0.018250417,    -0.0066724042,  -0.012166945,
        0.0070154085,   -0.009746499,    -0.03124575,    0.0012069868,   -0.018457513,
        -0.02989962,    0.0018315135,    0.0033200227,   0.031116314,    0.01454856,
        -0.0014262183,  0.01575231,      -0.0062614465,  0.0073389974,   0.00056142686,
        -0.005685458,   -0.014134366,    0.0075331507,   0.013280091,    0.026508408,
        0.008128555,    -0.016774852,    0.0072548646,   0.011610372,    0.025705907,
        -0.0017247292,  -0.015001584,    0.005740468,    0.0057534114,   0.0029786364,
        -0.015842915,   0.00080047816,   -0.018496346,   0.011053799,    -0.024320945,
        0.011493879,    -0.030546797,    0.03844237,     -0.009144624,   -0.00063099846,
        0.0060672928,   -0.02720736,     0.03393801,     0.0034818172,   0.018625781,
        -0.017214933,   -0.008057365,    -0.0054233507,  -0.029873732,   0.029485425,
        -0.0011091011,  -0.01036779,     0.0028912674,   0.0030401181,   0.018315135,
        -0.0018509289,  -0.01850929,     0.02909712,     0.0014375439,   0.02527877,
        0.0028071343,   -0.033264946,    0.0048797214,   0.00832918,     0.026055383,
        -0.016981948,   -0.029485425,    0.008141498,    -0.011558598,   -0.032436557,
        -0.008749845,   0.0065138456,    0.0024269172,   0.004465528,    -0.012827067,
        0.015674649,    -0.01720199,     0.0021648102,   -0.0003074095,  -0.019713039,
        -0.01342247,    0.006057585,     -0.0023249867,  -0.0053715766,  -0.033161398,
        -0.011908074
    ],
    [
        -0.0019634168,   -0.03276472,    -0.014759702,   -0.02150996,    -0.0072889817,
        0.017836262,     -0.01782328,    0.0052866214,   -0.011631216,   0.012092051,
        0.010008558,     -0.004128043,   0.0045337076,   -0.01514914,    0.032998383,
        0.0055754543,    0.031700257,    -0.023833608,   0.009060925,    0.008119783,
        0.01657708,      0.0021646265,   0.017291049,    -0.024833165,   -0.0063510854,
        0.011825935,     0.014500076,    -0.039489016,   0.025222603,    0.009378966,
        0.006685353,     -0.015992923,   0.0019553034,   -0.010274674,   -0.023002807,
        -0.014915477,    -0.009735951,   -0.013357725,   0.027702026,    -0.015408765,
        0.012150466,     0.012351676,    0.0072824913,   -0.0026741412,  -0.017148254,
        -0.017135274,    0.0004080986,   -0.022107098,   -0.03206373,    0.009151794,
        0.034062847,     0.027364513,    -0.017745392,   -0.017888186,   -0.01925122,
        -0.01065113,     -0.017524712,   -0.007009885,   0.0027017263,   -0.018770913,
        -0.016927574,    0.014980383,    -0.015785221,   -0.0044168765,  0.0042740824,
        0.009145304,     0.0018400947,   0.017966075,    -0.005650097,   0.016044848,
        0.02796165,      0.008619562,    0.009865764,    0.0045272172,   0.015928015,
        -0.0044266125,   -0.026572656,   -0.0014125243,  0.005345037,    0.015694354,
        0.013786106,     -0.02274318,    -0.013085118,   0.0030376166,   0.039125543,
        0.01126125,      -0.01464287,    0.006305651,    -0.0150193265,  -0.018550232,
        0.0022717218,    -0.015291934,   0.00419944,     0.029649215,    -0.018095888,
        0.029779028,     -0.007691401,   -0.003297242,   0.0067113154,   -0.04514885,
        -0.003368639,    0.023041751,    -0.013020212,   -0.0078082327,  0.007957517,
        0.001113955,     0.010170823,    0.014837589,    0.029000152,    -0.0050821663,
        -0.0051632994,   0.0072240755,   0.008028914,    -0.042656448,   0.0069190157,
        -0.024093233,    0.012072579,    -0.005137337,   0.015798204,    -0.0018903972,
        0.035283085,     -0.0032469395,  0.010157842,    0.005260659,    0.0071137347,
        0.033024345,     -0.01565541,    -0.014889514,   0.00056711916,  -0.008820771,
        0.026196199,     0.0048679756,   0.026585637,    0.0073993225,   -0.014110638,
        0.027779913,     -0.01401977,    -0.00022453537, -0.0031349761,  -0.011644198,
        0.016421303,     0.020043077,    -0.012689189,   0.02088686,     -0.013941881,
        0.013695237,     0.012306242,    0.00850273,     0.011332647,    0.0020445497,
        0.026351973,     -0.014590945,   0.024612484,    -0.024534596,   0.024755279,
        0.0074123037,    -0.016551116,   0.019277183,    -0.01248798,    -0.01577224,
        -0.0023788174,   0.00018234625,  0.0010230861,   -0.014084675,   -0.0067632403,
        0.027909726,     0.012624283,    -0.011053549,   0.0064744074,   -0.022353742,
        -0.016810741,    0.029441515,    -0.005951911,   0.0178103,      -0.018744951,
        0.040605407,     -0.005007524,   0.036685064,    -0.012234845,   -0.009502288,
        -0.018757932,    0.02733855,     0.016667947,    0.0038424553,   -0.011040568,
        0.00057320413,   0.02396342,     0.009989086,    0.021639774,    -0.02457354,
        0.009132322,     -0.0077952514,  0.012410092,    -0.013247384,   -0.66547173,
        -0.013812069,    -0.014461133,   0.0040988354,   -0.010255202,   0.019212276,
        0.018264644,     -0.012312733,   0.0023609682,   0.016551116,    -0.009580175,
        -0.008165217,    0.0040371744,   -0.0149674015,  -0.021652754,   -0.029882878,
        0.0026384427,    -0.016395342,   0.009976104,    0.007185132,    -0.039904416,
        0.023158582,     -0.0034822251,  -0.011702613,   0.0029954275,   0.022872994,
        0.016758816,     -0.028013576,   -0.015123177,   0.017446823,    -0.027286625,
        0.02047146,      -0.009612629,   -0.001638885,   0.052703947,    -0.015421746,
        -0.012273788,    0.016291492,    -0.009411419,   0.0017492259,   -0.010767962,
        0.0044590654,    -0.016005903,   -0.0009784631,  -0.011845407,   0.01198171,
        -0.00589025,     -0.013838031,   0.039878454,    -0.00053060934, 0.0127151515,
        0.034452286,     0.0055397563,   0.011040568,    0.0068021845,   0.015265971,
        0.022068156,     -0.026559673,   0.025287509,    -0.0074707195,  -0.008950585,
        0.01167016,      -0.008476768,   -0.005507303,   -0.017966075,   0.043461286,
        0.00059876096,   0.035179235,    0.009963123,    -0.0444219,     0.0280655,
        0.01401977,      0.0033978468,   -0.02099071,    0.011812953,    0.011754538,
        0.024313916,     -0.012617792,   -0.0040890994,  0.0036152832,   0.002599499,
        -0.02580676,     -0.025573097,   0.022613369,    0.003321582,    -0.01916035,
        -0.03411477,     0.009917689,    0.012312733,    -0.004569406,   0.0032696568,
        0.010774452,     -0.024171121,   -0.017992036,   0.0029013134,   -0.015525596,
        0.0013038061,    0.0037418504,   0.007327926,    -0.030973306,   0.0049101645,
        -0.014616908,    0.0021678717,   0.008742884,    0.013747162,    0.0071072443,
        -0.00067948824,  0.016538136,    0.052548174,    -0.011202835,   -0.011598763,
        0.011962239,     -0.004936127,   -0.0034043374,  -0.006419237,   -0.018693026,
        0.022691255,     0.0049718255,   0.017472787,    -0.046628714,   0.0041832137,
        0.020458478,     0.015642427,    -0.009638592,   0.025001923,    0.012974777,
        -0.0049296366,   -0.02476826,    -0.04945863,    -0.010274674,   -0.0027341796,
        -0.010112408,    0.006370557,    -0.0003527254,  0.008528693,    0.011819445,
        -0.0036087926,   -0.015590503,   0.010372033,    0.00038497572,  -0.018680044,
        0.010982153,     -0.0002235212,  -0.008652015,   0.0029159172,   -0.021925362,
        0.0025508192,    0.0023625907,   -0.03325801,    0.0008437824,   0.018277625,
        0.0025394605,    0.0022311555,   -0.0034595078,  0.009171266,    0.018186755,
        -0.01361735,     -0.022678275,   -0.018641101,   -0.007516154,   0.024534596,
        0.005221715,     -0.008100311,   -0.0020737576,  0.004436348,    0.0023350054,
        0.014928458,     0.017135274,    -0.0021987022,  -0.019186314,   0.015928015,
        -0.022924919,    -0.030973306,   0.020744067,    -0.004209176,   0.012617792,
        -0.011851897,    -0.0009249153,  -0.016252548,   -0.00073790393, -0.010008558,
        -0.0069579594,   0.008061367,    0.003787285,    0.02652073,     -0.0040306835,
        0.043980535,     0.0047349175,   0.008372918,    0.027676063,    0.0017881696,
        0.02476826,      -0.00911285,    -0.0018968878,  0.011183362,    -0.01790117,
        0.007191622,     0.015473671,    0.028896302,    0.021730643,    0.02918189,
        0.0067956937,    0.021159466,    -0.015317896,   0.01761558,     -0.029727103,
        0.004186459,     -0.03133678,    0.008885678,    0.00798348,     0.012539905,
        -0.0036152832,   -0.016044848,   0.010469393,    -0.0031284855,  -0.0010263314,
        -0.010326599,    0.0056371153,   -0.01782328,    -0.012436055,   -0.0016380737,
        -0.012254317,    -0.010053992,   -0.010073463,   -0.03530905,    0.034478247,
        0.010320108,     0.044889223,    0.004319517,    -0.015110196,   0.0045012548,
        0.0113651,       -0.01474672,    0.009359494,    0.0071007535,   -0.010703055,
        0.008587109,     -0.02457354,    0.0055884356,   0.010871812,    -0.009638592,
        0.005653342,     0.03318012,     -0.009132322,   0.012663227,    0.024028327,
        0.020601273,     0.0096321,      -0.04434401,    0.00062310084,  -0.026494768,
        0.021250335,     -0.010618677,   0.0149674015,   0.0018303588,   -0.013747162,
        0.027727988,     -0.0016924328,  0.032634906,    0.019978171,    0.0025784043,
        -0.014837589,    -0.0057085124,  0.020951767,    0.012870927,    0.0034010923,
        0.005455378,     -0.005364509,   0.014110638,    0.0138769755,   -0.0072760005,
        -0.005263904,    0.010871812,    -0.0033459219,  -0.0019747755,  -0.020211834,
        -0.0060947053,   0.0029110494,   0.0041312883,   -0.0014782419,  0.00013386933,
        -0.029908841,    -0.003758077,   0.026390918,    -0.0041832137,  -0.005435906,
        -0.025313472,    -0.00060484593, -0.024430746,   0.0067827124,   -0.025547136,
        0.028454939,     -0.025339434,   0.0010141615,   0.007094263,    0.002318779,
        0.015940998,     -0.0065782573,  0.021574868,    -0.017291049,   -0.0012234845,
        -0.00027666328,  0.010053992,    -0.024638446,   -0.014227469,   0.0055787,
        0.0034789797,    -0.004115062,   0.0017784337,   -0.00327777,    0.0053385464,
        0.001584526,     -0.010716037,   0.0010182182,   -0.0016891875,  -0.013072137,
        -0.03224547,     0.003501697,    0.02620918,     -0.011715595,   0.009489307,
        -0.037126426,    -0.030480016,   -0.019913265,   0.097722985,    0.025053848,
        0.005192507,     0.0063640666,   0.02507981,     0.012338695,    -0.015499634,
        -0.0076070228,   0.0061466303,   -0.025508191,   -0.013591387,   0.0012713529,
        0.010871812,     0.013889956,    0.024456708,    0.018744951,    -0.0034984518,
        -0.01916035,     -0.023067713,   -0.0031365987,  0.0029873142,   0.019277183,
        0.01699248,      0.01577224,     -0.0023155336,  -0.023561,      -0.00911934,
        0.016823724,     -0.0124685075,  -0.017174218,   -0.019731527,   -0.0021110787,
        -0.020562328,    0.013234403,    0.029830953,    0.0010693319,   0.0056273798,
        0.0021776077,    0.03593215,     0.010495355,    0.028792452,    0.01914737,
        0.0045045,       -0.027468363,   0.0055851904,   0.008716921,    -0.000664073,
        0.0027617647,    -0.011728575,   -0.028506864,   0.048394166,    -0.0051860167,
        -0.02005606,     -0.0027455383,  0.002651424,    0.014707777,    0.022963863,
        -0.0036509815,   -0.029830953,   0.008424843,    -0.026611598,   -0.021159466,
        -0.002038059,    -0.009787876,   0.0055137933,   -0.016771799,   0.0047835973,
        0.014681814,     -0.017187199,   -0.020004135,   0.017511731,    -0.03286857,
        0.010521318,     -0.0052152243,  0.01813483,     -0.00839239,    0.015240008,
        -0.029960766,    -0.0012161825,  0.017342974,    -0.031181006,   -0.01648621,
        -0.0040793633,   -0.029207852,   0.023976402,    0.026637562,    -0.008892168,
        -0.014694795,    -0.0030862964,  0.0066204467,   0.01688863,     -0.0054131886,
        0.016758816,     0.005468359,    0.0050399774,   -0.0039690225,  0.004085854,
        0.011812953,     -0.0023366283,  0.00008006806,  0.004890693,    -0.039956342,
        -0.010346071,    0.013292818,    0.008736393,    -0.019212276,   0.00006521059,
        0.007321435,     -0.031596407,   -0.0075096632,  -0.0081392545,  -0.0012291638,
        0.004381178,     -0.008333974,   0.020692142,    0.013247384,    0.02887034,
        -0.0033102233,   -0.002469686,   -0.013026702,   0.00036327267,  -0.014629889,
        0.023353301,     0.033855148,    0.0005638738,   -0.0002861964,  0.013825051,
        -0.03369937,     -0.000855141,   -0.011916804,   -0.029675178,   0.02015991,
        0.012857946,     -0.0021029655,  -0.028480902,   0.00044663675,  -0.01596696,
        0.015291934,     0.0020607763,   -0.008359936,   -0.017213162,   -0.0100929355,
        -0.010729018,    0.010462902,    -0.031103117,   -0.026066385,   0.013137043,
        0.0037807943,    0.0045272172,   -0.0074252854,  -0.03224547,    -0.017472787,
        -0.0094244005,   0.0074901916,   -0.019848358,   -0.03767164,    -0.010780943,
        -0.000359216,    0.020964747,    0.0062342538,   0.04647294,     -0.027078925,
        0.031466592,     -0.0034303,     0.010060483,    -0.004374687,   0.0010936718,
        -0.0046051047,   -0.046239275,   0.02191238,     0.0068021845,   0.00032027223,
        0.017862225,     -0.0115014035,  0.016187642,    -0.00650037,    0.0051860167,
        -0.027831838,    -0.016252548,   -0.027104888,   -0.01044343,    0.008736393,
        -0.009534741,    0.0026449333,   -0.011825935,   -0.010904265,   0.039411128,
        0.027260663,     -0.013500518,   -0.0022116834,  0.025715891,    0.006565276,
        0.0025719136,    -0.013967844,   0.014292376,    -0.0075940415,  -0.0029759556,
        0.0050367317,    0.0011934653,   0.01893967,     0.013773126,    0.026897186,
        0.0026546693,    -0.006399765,   -0.009800857,   0.039566904,    0.015681371,
        -0.009671045,    -0.008677977,   -0.01803098,    -0.017953094,   -0.01575926,
        -0.010359052,    -0.034140736,   -0.0046018595,  -0.013292818,   0.00087542424,
        0.012332205,     -0.024599502,   -0.040475592,   0.035984073,    0.0117805,
        0.02366485,      -0.0150193265,  0.037178352,    0.0076654386,   -0.002937012,
        -0.022262875,    0.021795548,    0.00056671345,  0.017628562,    0.017472787,
        0.00085027306,   0.0021402866,   -0.013435612,   -0.004880957,   0.008697449,
        -0.04239682,     -0.031804107,   0.030947343,    0.00911934,     0.004890693,
        -0.010112408,    -0.022470575,   0.016564097,    0.01453902,     -0.019783452,
        -0.015902054,    0.00726951,     -0.055404052,   -0.020808972,   -0.01320844,
        0.01126774,      0.0056176437,   -0.004371442,   -0.025767816,   0.008762356,
        -0.0119232945,   0.021341205,    -0.00042554218, 0.0021386638,   0.022146042,
        -0.0012721643,   -0.019523827,   -0.0013240894,  -0.013072137,   0.0013062401,
        0.013260365,     0.0037223785,   0.032089695,    -0.0147207575,  0.005078921,
        -0.008833753,    0.016564097,    0.012851455,    0.03411477,     -0.0057896455,
        -0.011605253,    -0.0056176437,  -0.0005788834,  0.009690517,    0.013143534,
        -0.025715891,    -0.01116389,    -0.006062252,   0.010099426,    -0.054729026,
        -0.010495355,    0.004822541,    -0.012423073,   -0.005026996,   0.009359494,
        -0.004647294,    0.012929343,    0.032712795,    0.0016202244,   -0.016330434,
        0.019121407,     -0.027935687,   0.006698334,    0.006380293,    0.007496682,
        -0.028351089,    0.006613956,    0.022366725,    0.0038002662,   0.036607176,
        -0.027208738,    -0.024184102,   0.001377637,    -0.023729758,   0.00828854,
        -0.00039288617,  -0.020627234,   0.025443286,    0.0011983333,   0.0017849243,
        -0.014655852,    -0.021847473,   0.028766489,    0.00588376,     -0.0010133502,
        0.017226143,     -0.01177401,    0.009281606,    -0.024171121,   0.014902496,
        0.0006454124,    -0.029623253,   -0.022081137,   0.010521318,    0.01873197,
        0.024820184,     -0.027909726,   -0.008885678,   -0.010352561,   -0.01556454,
        0.0015950733,    0.01535684,     -0.005439151,   -0.010826377,   0.02160083,
        0.0074252854,    0.005935685,    0.0049231458,   -0.025287509,   0.0074123037,
        -0.016200623,    -0.031985845,   -0.026053404,   -0.011300194,   0.0034789797,
        0.013902938,     -0.011611744,   -0.043694947,   -0.02262635,    -0.032557018,
        0.009171266,     -0.014396226,   0.011631216,    0.032375284,    0.020224815,
        -0.000093759234, 0.019316126,    -0.0062277634,  -0.004575897,   -0.010897774,
        0.007938045,     0.013954863,    -0.018744951,   0.002503762,    0.025573097,
        -0.02814339,     0.016161678,    0.022003248,    -0.0019893793,  -0.027702026,
        -0.003060334,    -0.0006705636,  0.014837589,    -0.012682699,   0.009690517,
        0.0027617647,    0.001513129,    0.00588376,     0.002964597,    -0.006613956,
        0.012176429,     0.016252548,    -0.019290164,   -0.011170381,   -0.0013265233,
        -0.0069060344,   0.016278509,    0.018537251,    -0.037386052,   -0.0032842609,
        -0.006776222,    0.005766928,    -0.0009038208,  0.0026400653,   0.008431333,
        0.015330877,     -0.021354185,   -0.0073668696,  0.024002364,    0.020120965,
        -0.016460247,    0.013188968,    0.024287952,    0.0070488285,   -0.004647294,
        0.025754835,     -0.03606196,    0.00044420277,  0.0013614105,   -0.011436497,
        -0.02109456,     0.024326896,    0.02489807,     0.0067827124,   0.013150024,
        0.003900871,     -0.007976989,   0.006010327,    -0.012130994,   -0.00011449884,
        -0.0008738016,   0.012994249,    -0.0061888197,  -0.010469393,   -0.022133062,
        0.011228797,     -0.012481489,   -0.028325126,   0.006873581,    0.22847031,
        -0.0071072443,   0.008269068,    0.04042367,     -0.0047738613,  0.020951767,
        0.0274424,       0.00048355223,  -0.01916035,    -0.012072579,   -0.007964008,
        0.0005565719,    0.012585339,    0.004627822,    -0.0048679756,  -0.015694354,
        -0.020510403,    -0.0066593904,  -0.019017557,   0.0020591535,   0.02006904,
        0.013941881,     0.0009249153,   -0.013993807,   0.018667063,    -0.011410534,
        -0.0364514,      -0.012137486,   0.01617466,     0.016966516,    -0.0040793633,
        -0.02488509,     -0.0006908468,  0.0018968878,   -0.024443727,   0.0100215385,
        0.0076719294,    -0.011137928,   -0.022976844,   -0.004939372,   0.01668093,
        0.012955305,     -0.008957075,   0.0037548316,   -0.003240449,   0.0015747901,
        0.0019585488,    -0.011806463,   -0.016732855,   0.003748341,    -0.030376166,
        -0.013396668,    -0.012416583,   0.03982653,     -0.004566161,   0.0043681967,
        0.015953979,     -0.0014498454,  0.0032469395,   0.000990633,    0.0007496682,
        0.009456853,     -0.010326599,   0.009982595,    -0.00004895865, 0.02221095,
        -0.028896302,    0.0075421166,   0.016005903,    -0.020185871,   -0.018861782,
        -0.025650986,    -0.018952651,   0.011546838,    -0.014733739,   -0.018511288,
        0.017433843,     0.0120466165,   0.0023917987,   -0.011189853,   -0.00020952578,
        0.015240008,     -0.0077238544,  0.0015106951,   -0.016564097,   -0.021250335,
        0.047667217,     -0.00399174,    -0.036087923,   0.0071202256,   0.003259921,
        -0.01657708,     -0.006318632,   0.00094763254,  0.009164775,    0.012760586,
        -0.0074901916,   -0.0014466001,  0.023353301,    -0.0036574723,  -0.0076135136,
        0.013461575,     0.0019634168,   -0.00726951,    -0.0077433265,  0.0067956937,
        -0.002133796,    0.009314059,    0.03346571,     -0.021899398,   -0.036788914,
        -0.012942324,    -0.0004243252,  -0.005867533,   0.015136158,    0.011540347,
        0.0008932735,    -0.014629889,   0.029882878,    -0.026027443,   0.0026952357,
        -0.028377052,    -0.01586311,    0.008405371,    0.00054886425,  -0.03214162,
        -0.008126274,    0.016291492,    0.00941791,     -0.03193392,    0.009800857,
        -0.03647736,     -0.009554213,   -0.0029775782,  0.0059648925,   -0.003026258,
        0.011332647,     -0.018043961,   -0.010041011,   0.027182775,    -0.009171266,
        -0.0046440484,   0.025560116,    -0.0027958406,  0.013234403,    -0.001914737,
        0.03245317,      0.014772682,    -0.0025459512,  0.018718988,    -0.015850129,
        -0.017992036,    -0.015577521,   0.021107541,    0.008243105,    -0.022976844,
        -0.023197526,    -0.01003452,    -0.011014606,   -0.007639476,   -0.012325713,
        0.0059876097,    0.012267298,    -0.04260452,    -0.008411862,   -0.012202391,
        -0.16501787,     0.013344743,    0.00068516756,  -0.02088686,    0.022172006,
        0.0028088219,    0.01116389,     -0.0133317625,  -0.009229681,   0.009028472,
        0.0192642,       -0.0089311125,  -0.042864148,   0.011287212,    0.023028769,
        0.010488864,     -0.027286625,   0.028351089,    0.00038193323,  0.00078820635,
        0.013838031,     -0.012462017,   0.001530167,    -0.010878302,   0.013863994,
        0.026183218,     0.000041555268, 0.0027520289,   -0.005448887,   0.0037710583,
        -0.026235143,    -0.020847917,   0.012137486,    0.0054034526,   0.0011520875,
        -0.018446382,    0.0115014035,   -0.005260659,   -0.022470575,   0.0069644502,
        0.01832955,      0.0053612636,   0.012234845,    -0.018251663,   0.008483258,
        0.042630482,     0.01803098,     -0.0053807357,  0.009482816,    -0.009645082,
        -0.006565276,    -0.0042124214,  0.013773126,    0.0055657187,   0.022483556,
        0.020860897,     0.02343119,     0.00031114477,  0.010858831,    -0.013643312,
        -0.0060233083,   0.0002460356,   0.0078082327,   -0.019926246,   -0.026351973,
        -0.02436584,     -0.019822396,   0.012040126,    -0.021159466,   0.022782125,
        -0.00808733,     0.006565276,    0.028299164,    -0.02907804,    0.02334032,
        -0.006318632,    0.0038586818,   0.009359494,    -0.015188083,   -0.027182775,
        -0.015902054,    0.016538136,    0.00089246215,  -0.012306242,   0.008379408,
        0.0041507604,    0.000047589532, -0.0009354626,  -0.0045823874,  -0.031155042,
        -0.018550232,    -0.008580618,   -0.028117426,   -0.006951469,   -0.0013038061,
        0.04507096,      0.003097655,    0.0028575016,   0.0356206,      -0.0050107692,
        0.009593157,     0.010151352,    -0.019484883,   0.010105917,    0.02343119,
        0.0038164929,    -0.003920343,   0.009482816,    0.02047146,     0.005387226,
        -0.013760144,    0.011644198,    0.0055462467,   0.022509519,    -0.0018644346,
        0.007516154,     -0.027182775,   -0.010625168,   0.017940111,    0.008165217,
        0.051431783,     0.018900726,    -0.026585637,   0.004024193,    -0.01187786,
        -0.01720018,     -0.114650555,   -0.003159316,   -0.015811184,   0.013565425,
        -0.012124504,    0.017057385,    -0.0060460255,  0.026274087,    -0.031492557,
        0.014564983,     0.0059843645,   -0.037619714,   0.008340465,    -0.0039722677,
        0.01699248,      -0.00828854,    -0.029363628,   0.0062699523,   -0.020328665,
        0.008366427,     0.0037288691,   -0.0031284855,  0.002698481,    -0.019848358,
        0.012929343,     0.010839359,    -0.020666178,   0.00726951,     0.016810741,
        0.009327041,     0.003040862,    -0.028766489,   0.0272347,      -0.009541232,
        0.0002667245,    -0.010488864,   -0.017291049,   -0.011326157,   0.025715891,
        -0.054209776,    -0.00019319777, 0.00015131291,  0.00001773515,  -0.030116541,
        -0.006808675,    -0.017524712,   0.0016218472,   0.003282638,    0.007003394,
        -0.046239275,    -0.04247471,    -0.0051568085,  -0.01934209,    -0.0033621483,
        0.00008260346,   -0.012293261,   0.009099869,    0.013656294,    0.0018936425,
        -0.0056014173,   0.0023382509,   0.001966662,    -0.022288837,   -0.028480902,
        -0.013201949,    -0.009430891,   -0.026845261,   -0.00033386197, 0.015330877,
        -0.03533501,     0.027416438,    0.017459806,    -0.007951027,   -0.0039852494,
        -0.040994845,    -0.002284703,   0.0012948815,   -0.012215373,   0.028351089,
        -0.013552444,    -0.0114300065,  -0.009456853,   0.032660868,    -0.012942324,
        -0.004433103,    0.015123177,    -0.0077563077,  0.0033037327,   -0.017550673,
        0.0023333828,    0.007139697,    -0.011313175,   -0.01934209,    -0.008405371,
        -0.013292818,    0.007769289,    -0.006613956,   -0.012072579,   0.0018644346,
        0.015343859,     -0.018056944,   0.013052665,    -0.059246507,   0.04011212,
        -0.004874466,    -0.009463345,   -0.008716921,   -0.016044848,   0.014331319,
        -0.004741408,    -0.009573685,   0.0034173187,   -0.014097657,   0.017654525,
        0.0076719294,    0.0059551564,   -0.007762798,   0.00278935,     0.01617466,
        0.0013062401,    0.018355513,    0.009151794,    0.003378375,    0.00409559,
        0.0009013868,    -0.000532232,   -0.007847177,   0.011196343,    0.0237687,
        0.025274528,     -0.013065646,   -0.0052379416,  0.008067858,    -0.011793482,
        -0.00031601274,  0.0025297245,   0.01340965,     -0.009833311,   -0.000012651665,
        0.011073021,     0.0058707786,   0.063400514,    -0.007964008,   -0.02713085,
        0.021990268,     -0.018887745,   -0.0117805,     0.010560261,    -0.012338695,
        -0.0036931706,   0.026248123,    -0.0020120966,  0.025962535,    0.031206967,
        -0.019796433,    0.008431333,    -0.009210209,   -0.022068156,   0.034997497,
        -0.0049848068,   0.011962239,    0.007301963,    0.023794664,    0.0030716925,
        0.024391802,     0.025430303,    -0.0073993225,  -0.0028250485,  0.0073668696,
        0.0090025095,    -0.0008381031,  -0.025274528,   0.011339137,    -0.0059097223,
        0.01883582,      -0.009086887,   -0.0126437545,  0.01065113,     0.00036996615,
        0.012533414,     -0.0061109317,  -0.012481489,   0.011890842,    -0.010741999,
        -0.03575041,     0.020549348,    0.023171563,    0.020224815,    0.006581503,
        0.022483556,     -0.0098462915,  0.005763683,    -0.0047446536,  0.024041308,
        0.0119232945,    0.019108426,    -0.023729758,   0.018342532,    -0.032401245,
        -0.0020640215,   0.027078925,    0.019432958,    -0.0032907515,  -0.00055535487,
        0.011858388,     0.004572652,    -0.02088686,    0.0044720466,   -0.025157697,
        -0.013422631,    -0.01474672,    0.017394898,    0.028948227,    0.01106004,
        0.0009143681,    0.01791415,     -0.008587109,   0.011319665,    -0.0018465853,
        0.010229239,     -0.024184102,   0.021133505,    0.021367166,    0.021432074,
        0.0125918295,    -0.0017508485,  0.0024972714,   0.007847177,    0.018459363,
        -0.0019358316,   -0.0067956937,  -0.014370264,   -0.005958402,   -0.013221421,
        -0.017057385,    -0.010346071,   -0.011514384,   -0.015746279,   -0.007496682,
        0.02038059,      -0.032712795,   0.028766489,    -0.000462052,   0.0008932735,
        0.0010101049,    -0.02345715,    0.038736105,    0.0002687528,   0.029155927,
        -0.017368937,    -0.014798645,   0.0042740824,   -0.021250335,   0.011825935,
        -0.0144741135,   -0.015811184,   0.040164042,    -0.0005111374,  0.010287655,
        0.0011553328,    -0.006328368,   0.0062829335,   0.0004953165,   0.032557018,
        -0.016213603,    -0.015265971,   -0.012085561,   0.013565425,    0.0022035702,
        0.004757635,     -0.026040424,   -0.0064744074,  -0.0133317625,  -0.013266856,
        -0.015733296,    0.003602302,    0.0024583277,   0.007840686,    -0.008340465,
        0.004128043,     -0.028195314,   -0.019744508,   0.00037442843,  -0.014980383,
        -0.030428091,    0.0012421451,   0.0019617942,   -0.016836705,   -0.01688863,
        -0.0054131886
    ],
    [
        -0.0038074553,   -0.031848937,   0.0019348557,   0.010498353,    -0.010904657,
        0.017077846,     -0.028441232,   -0.027156789,   -0.014495853,   -0.008086747,
        0.019843329,     -0.0011804095,  0.022019017,    -0.009115611,   -0.00931221,
        -0.016016215,    0.026435928,    -0.010288648,   -0.0013901143,  -0.0063304678,
        0.007981895,     0.011822116,    -0.01011171,    -0.018899657,   0.00042186736,
        0.019869542,     0.02985674,     -0.00891246,    0.02402432,     -0.009967538,
        0.029122774,     -0.010963636,   -0.008591349,   -0.007870489,   -0.0064975764,
        -0.010131369,    0.010996402,    -0.008774841,   0.013322816,    -0.038009018,
        0.015701657,     -0.0052688364,  -0.0076411236,  0.006520513,    -0.0087682875,
        -0.00967264,     0.021009814,    -0.019410813,   -0.008067086,   0.0044103567,
        0.025072847,     0.0024132452,   -0.008099853,   -0.006789197,   -0.016383197,
        0.004334994,     -0.0015146267,  0.011625517,    -0.0028048034,  -0.014037124,
        -0.003601027,    0.021953486,    0.016343879,    -0.0060781664,  -0.005491648,
        -0.00093711895,  0.0025443106,   0.01622592,     0.015609911,    -0.01752347,
        0.018283648,     0.013126219,    0.0102820955,   -0.0012320165,  0.025046634,
        -0.0066220886,   -0.007824616,   0.006536896,    0.0087682875,   0.008735521,
        0.008401304,     -0.047812726,   -0.0009960984,  0.027890757,    0.01736619,
        0.009266336,     -0.0050656847,  0.021992804,    -0.021887952,   -0.000119597345,
        0.0033241508,    0.015872043,    0.012051481,    0.025977198,    -0.006946476,
        0.010000304,     0.0034765147,   -0.008991099,   -0.0052393465,  -0.024351986,
        -0.01568855,     0.018034624,    -0.007228267,   -0.011697603,   -0.028231528,
        -0.016540477,    -0.010976743,   -0.00400733,    0.012208759,    0.010314861,
        -0.020433124,    0.01572787,     0.006284595,    -0.059346497,   -0.010537673,
        -0.035020724,    0.02022342,     0.005652203,    0.017851133,    -0.0018054284,
        0.020551084,     0.03145574,     0.012313612,    -0.0013073792,  0.018375395,
        0.008027767,     -0.019581199,   -0.013919165,   0.0045053796,   -0.0022821794,
        0.013670141,     0.02654078,     0.025872346,    -0.0039778403,  -0.036226526,
        0.011704157,     -0.023106862,   -0.011363386,   -0.0021429223,  -0.0032913845,
        0.0074772914,    0.010072391,    -0.019830223,   -0.028126674,   -0.005629267,
        0.006012634,     0.015033223,    0.014141977,    -0.019410813,   -0.0023493506,
        0.029201413,     -0.0074052056,  0.017497256,    -0.0055211377,  0.015413313,
        0.0016825545,    -0.011881095,   0.025466044,    0.0024263517,   -0.031167395,
        0.023618018,     0.010642526,    -0.008414411,   -0.016959887,   -0.007968787,
        0.021573395,     0.03355279,     0.0032897461,   -0.016160386,   -0.016396305,
        0.0031324674,    0.03001402,     -0.012084247,   0.024037428,    -0.00725448,
        -0.007791849,    0.011186448,    -0.0026688229,  -0.022084551,   0.0012483997,
        -0.00039135365,  -0.0073658857,  0.0061142095,   0.016134173,    -0.014391001,
        0.0058160354,    -0.008538923,   -0.022438427,   -0.01045248,    0.001480222,
        0.02220251,      0.011474792,    -0.0067236647,  -0.0043841437,  -0.6689587,
        -0.023893256,    -0.017457936,   0.009895451,    0.010603206,    -0.007418312,
        0.0039221374,    -0.011284747,   -0.0024427348,  0.0009010759,   0.0013352307,
        -0.00028834428,  -0.0005517042,  -0.0006803123,  0.0018300032,   0.009482595,
        0.02851987,      -0.042072054,   -0.009580894,   0.009109058,    -0.0111209145,
        0.013958485,     0.004374314,    -0.010878444,   0.0010173966,   -0.0021445607,
        -0.009823365,    0.011946628,    0.0017562788,   0.026042731,    -0.025046634,
        0.02943733,      0.010721165,    0.014063337,    0.043120578,    -0.010878444,
        -0.026449036,    0.026160691,    0.007818062,    0.0011673028,   -0.022110764,
        0.012274292,     -0.0009207357,  -0.009325316,   -0.01812637,    0.0048264903,
        0.0065074065,    -0.00062993396, -0.010268989,   0.007883595,    0.012097353,
        0.006097826,     0.0066319187,   -0.009744726,   -0.004718361,   -0.008958333,
        0.021049133,     -0.017195804,   -0.0010616313,  0.0050656847,   0.026042731,
        0.013591501,     -0.0015457547,  -0.023172395,   0.008860034,    0.046528284,
        -0.0064320434,   0.016855035,    0.005937271,    -0.009974091,   0.0323732,
        0.013204858,     -0.028729577,   0.010898103,    -0.009161484,   0.015623018,
        0.024076749,     0.00035653936,  -0.010603206,   0.008525817,    0.01530846,
        -0.000052400635, -0.00015389967, 0.008230919,    0.004511933,    0.0013950294,
        -0.018689953,    0.016409412,    0.0017661088,   -0.018978296,   0.0052983263,
        0.023709765,     -0.012287399,   -0.011946628,   -0.0032111069,  0.0039352444,
        0.0049870457,    -0.002182242,   0.011448579,    -0.054051448,   -0.012680596,
        -0.0016096492,   0.007981895,    -0.015649231,   0.01412887,     0.0051770904,
        -0.012857534,    -0.010019964,   0.04707876,     0.005327816,    0.010793251,
        0.0044398466,    -0.0004476709,  -0.008276791,   0.010773591,    -0.022372896,
        0.010878444,     0.012477444,    0.011258534,    -0.0036075802,  0.008801054,
        0.004721638,     0.0123725915,   0.001629309,    -0.012307058,   0.03782553,
        -0.031219821,    -0.006245275,   -0.013840525,   -0.007962234,   -0.010360735,
        -0.0129754925,   0.016540477,    0.0016612563,   0.013801206,    -0.0035846438,
        0.0074510784,    0.008342325,    0.018532673,    -0.0022887327,  -0.008381644,
        0.012811661,     0.005406455,    -0.0059503773,  0.0033978752,   -0.019292854,
        0.0014007634,    -0.015111862,   -0.011075042,   0.012857534,    -0.017156485,
        -0.027654838,    -0.021979699,   -0.014626919,   0.005947101,    0.017392403,
        -0.0201841,      -0.002929316,   -0.010386948,   -0.016894354,   0.019056937,
        -0.009777493,    -0.031429525,   0.008375091,    0.011337173,    -0.03473238,
        0.0062518283,    0.026068944,    -0.015098755,   -0.022687452,   0.00648447,
        -0.020629723,    0.010105156,    0.035204217,    -0.031010117,   -0.00034814296,
        0.011186448,     -0.017025419,   -0.017090952,   -0.013460436,   -0.013021366,
        0.0058684614,    0.009784046,    -0.00089779927, 0.03279261,     -0.018113263,
        0.010504907,     0.008145726,    -0.01327039,    0.020629723,    -0.0022264766,
        0.029332478,     0.014862837,    -0.012418464,   -0.002745824,   -0.009764386,
        0.0011091426,    0.03221592,     0.028467445,    0.016828822,    -0.01173037,
        -0.016055534,    0.0071234144,   -0.0029751887,  0.022870945,    -0.040499266,
        0.005344199,     -0.027812118,   0.003836945,    0.007588697,    0.013250731,
        0.009502254,     -0.02034138,    -0.0105442265,  0.00020755464,  0.022228723,
        0.010236222,     -0.0000900052,  -0.00095350214, 0.0080933,      0.008991099,
        -0.029253839,    0.0036534532,   -0.0029358692,  0.0037615823,   0.0041089063,
        0.018296756,     0.03271397,     0.010550779,    -0.02353938,    -0.010393501,
        -0.006543449,    -0.023355886,   0.013774993,    -0.016920567,   -0.028493658,
        0.017903559,     -0.0281791,     0.008656882,    0.008067086,    -0.0035256643,
        0.011317513,     0.02030206,     -0.02444373,    -0.011540324,   0.013539075,
        0.014666239,     -0.0015244565,  -0.013237624,   0.006127316,    -0.03287125,
        -0.00181362,     -0.019004509,   -0.002300201,   0.018807912,    -0.024247132,
        0.005629267,     0.0019168342,   0.03591197,     0.01626524,     0.00079704256,
        0.011055382,     -0.010826018,   0.035020724,    0.051482562,    -0.0011361748,
        0.0059045046,    -0.006101103,   -0.007182394,   -0.0032061918,  -0.002141284,
        -0.00801466,     0.010681845,    -0.025295658,   0.003427365,    0.0070709884,
        -0.014364788,    -0.02292337,    0.018912764,    0.016619116,    0.0028048034,
        -0.042491462,    0.019607412,    0.017457936,    0.0014564663,   0.0062321685,
        -0.029044133,    -0.0006352585,  -0.034942083,   0.012208759,    -0.0034011519,
        -0.008040873,    0.034627527,    0.006281318,    -0.009305657,   -0.00059307175,
        0.015465739,     -0.01652737,    0.011632071,    0.015740978,    -0.0019348557,
        0.020315165,     -0.009207358,   -0.01334903,    0.009436722,    0.0031521274,
        -0.005593224,    -0.020446232,   0.0039221374,   -0.010373841,   -0.012962386,
        -0.0072806934,   0.0009469488,   -0.006300978,   -0.0072217137,  -0.018034624,
        -0.0009297465,   0.016632224,    0.023604913,    -0.0030767645,  -0.0064746398,
        -0.020787003,    -0.02993538,    -0.0020347931,  0.123306505,    0.024351986,
        0.011179894,     -0.01374878,    0.008748628,    0.013774993,    -0.022648133,
        -0.030879052,    0.017641427,    0.0033241508,   -0.013008259,   -0.016488051,
        -0.008801054,    0.007916361,    0.015649231,    0.00087322446,  -0.005026365,
        -0.03481102,     -0.02216319,    -0.010655632,   -0.01045248,    0.013722567,
        0.03043343,      0.01015103,     -0.011809009,   -0.012706809,   0.034024626,
        0.018519567,     0.0039909473,   -0.022661239,   -0.018598206,   -0.008224365,
        0.009004205,     0.0035354942,   -0.011992501,   0.01968605,     -0.008257132,
        0.0021887952,    0.018021518,    -0.0029391458,  0.015164288,    0.036619723,
        0.016435625,     -0.017982198,   0.009344976,    0.0031177227,   -0.0053114328,
        0.03287125,      0.011874542,    -0.02414228,    0.04804864,     -0.017300658,
        -0.01614728,     -0.01884723,    0.013604607,    -0.004574189,   0.004774064,
        -0.017208911,    0.022831624,    -0.0017661088,  -0.016474944,   -0.00807364,
        0.008388197,     -0.016710863,   -0.0065794922,  -0.00921391,    -0.0063599576,
        -0.01854578,     -0.0055473507,  0.00564565,     -0.017497256,   -0.021534076,
        0.004125289,     -0.0024214366,  0.0011238874,   -0.007084095,   0.023473846,
        -0.009679194,    -0.019371493,   -0.0058160354,  0.013499755,    -0.02300201,
        -0.011579645,    -0.017090952,   -0.0066777915,  0.017143378,    0.015334673,
        0.013591501,     -0.010590099,   -0.01652737,    0.031770296,    0.021691354,
        0.0057832687,    0.0032668097,   0.016160386,    -0.016658437,   -0.013342476,
        0.0010182158,    -0.0037615823,  0.0044758897,   0.0035125576,   -0.02623933,
        -0.01338835,     -0.01201216,    0.0217831,      -0.0068350704,  0.011075042,
        -0.0064156605,   -0.01904383,    -0.01374878,    0.0185851,      -0.024614116,
        0.011861435,     0.003938521,    0.014626919,    0.02513838,     0.014312362,
        0.030459642,     0.0049116826,   -0.028231528,   -0.011284747,   -0.015570591,
        0.0000960977,    0.030774198,    -0.0026966743,  0.0075231646,   -0.0017464489,
        -0.0024296283,   0.019817116,    0.011324067,    -0.020472445,   0.016881248,
        0.011461685,     0.0045610825,   -0.03834979,    -0.0039614574,  0.0029129325,
        0.01045248,      -0.0069530294,  -0.013801206,   -0.020236526,   -0.012542976,
        -0.0063960007,   -0.017169591,   -0.0030882328,  -0.021455437,   -0.018768592,
        0.01201216,      -0.013191751,   0.019214215,    -0.0032979378,  -0.0025082675,
        -0.009109058,    0.01854578,     -0.0107277185,  -0.03363143,    -0.017549682,
        -0.005711183,    0.0201841,      0.012575743,    0.044011824,    0.0010067475,
        0.0131327715,    0.009469489,    -0.021416117,   0.010937423,    -0.011363386,
        -0.006828517,    -0.053133987,   0.0016358623,   0.020669043,    0.01568855,
        -0.0016858311,   -0.023146182,   0.0016604371,   -0.009921664,   0.008355431,
        -0.0016415964,   -0.017720068,   -0.022097658,   -0.005019812,   -0.006264935,
        -0.0029669972,   0.0035748137,   0.007326566,    -0.018729271,   0.03952938,
        0.0013622629,    -0.002480416,   -0.008257132,   0.020197207,    -0.019948183,
        0.003964734,     0.008250578,    0.005835695,    0.006946476,    -0.0106228655,
        -0.005281943,    0.0026000135,   0.005029642,    0.01125198,     0.010242775,
        -0.027707264,    0.00925323,     -0.0037222626,  0.009600554,    -0.008204706,
        -0.04188856,     -0.0053245393,  -0.015256034,   -0.03179651,    -0.027759692,
        -0.005409732,    -0.050512675,   0.001567872,    -0.030538281,   -0.011494452,
        0.011677943,     0.0037943486,   -0.033579003,   -0.0087682875,  -0.004508656,
        0.03515179,      0.01584583,     0.031272247,    0.0126085095,   -0.01644873,
        -0.009561234,    0.021953486,    0.019581199,    -0.0068874964,  0.008289898,
        0.016553583,     -0.008250578,   0.00067375903,  -0.026488354,   -0.011199554,
        -0.03793038,     -0.027183002,   0.014207509,    0.015452633,    -0.000625019,
        -0.010904657,    -0.008303005,   -0.011848329,   0.017169591,    -0.020197207,
        0.017903559,     -0.01694678,    -0.023434527,   -0.02699951,    -0.009161484,
        -0.0058062053,   0.0041121827,   0.0017448106,   0.0045872955,   0.0029276775,
        -0.0035518773,   0.00487564,     0.00034158968,  0.011330619,    0.026370395,
        0.00005334779,   -0.0025656088,  -0.006736771,   0.014731771,    0.006101103,
        0.0120908,       -0.017457936,   0.026409715,    -0.0038402216,  0.005858632,
        -0.012831321,    0.008361984,    0.015229821,    0.023329673,    -0.0030931479,
        -0.013984698,    -0.026894659,   0.01330971,     0.0066155354,   0.0017808536,
        -0.03601682,     -0.007503505,   -0.019961288,   -0.019843329,   -0.0066777915,
        -0.007536271,    -0.012739575,   -0.011022615,   0.010642526,    0.011632071,
        -0.021835526,    0.024247132,    0.010249329,    0.021769993,    0.000014143307,
        0.016291453,     -0.030826626,   0.011907308,    -0.014194403,   0.008126066,
        -0.021193305,    0.021638928,    0.0034339183,   -0.016422518,   0.02186174,
        -0.023985002,    -0.010013411,   -0.017720068,   -0.008342325,   0.002013495,
        -0.013152432,    0.009718513,    0.004184269,    0.0068678367,   0.017575895,
        -0.01946324,     -0.009738173,   0.0046757646,   0.017471042,    -0.01015103,
        -0.0052164104,   -0.03171787,    -0.005855355,   -0.009403956,   0.019227322,
        -0.008807607,    -0.019856436,   0.0017038526,   -0.0313771,     0.021468543,
        -0.0063697873,   -0.03019751,    -0.018178796,   0.0056063305,   -0.008099853,
        0.024351986,     0.003263533,    0.013552181,    0.025269445,    0.02384083,
        -0.011009509,    0.004220312,    -0.007896702,   -0.025452936,   0.016094854,
        0.0021478373,    -0.03103633,    -0.015177394,   -0.03305474,    0.022254936,
        0.026606314,     -0.007968787,   -0.02136369,    -0.008656882,   -0.015570591,
        -0.0037976254,   -0.018558886,   0.017654534,    0.0032160217,   -0.0126871485,
        0.0013622629,    0.015570591,    0.0064517036,   -0.011579645,   -0.010904657,
        -0.016055534,    -0.02661942,    -0.016619116,   0.011618964,    0.044038035,
        -0.0131065585,   -0.016304558,   0.007182394,    0.0019643453,   -0.0043448242,
        0.0021953485,    -0.0016162025,  -0.0040171603,  -0.009004205,   -0.0067072813,
        0.012385698,     -0.003591197,   0.0008642137,   -0.01167139,    0.0025852686,
        -0.00012103088,  0.003212745,    -0.016710863,   -0.028886855,   0.017497256,
        -0.009954431,    0.0033945986,   0.009482595,    0.000637716,    -0.023080649,
        -0.022517068,    0.021848634,    -0.021258838,   -0.017274445,   0.01644873,
        -0.010157582,    -0.017195804,   -0.029751888,   -0.00037312735, -0.005956931,
        -0.005793099,    0.001122249,    0.0033241508,   0.028493658,    -0.015256034,
        0.008630669,     -0.009036972,   -0.010413161,   0.004954279,    0.027995609,
        -0.024365092,    0.04152158,     0.016134173,    -0.019358387,   -0.001977452,
        -0.01614728,     -0.009561234,   -0.008021214,   -0.0217831,     -0.024037428,
        0.0014679346,    -0.008316112,   -0.0034044285,  -0.010996402,   -0.03103633,
        -0.019712264,    -0.014456534,   -0.008224365,   0.009023866,    0.24661301,
        -0.0145876,      -0.0007519888,  0.016317666,    0.012621616,    0.028231528,
        0.020131674,     0.00017417388,  -0.0065336195,  -0.011193001,   -0.0040957993,
        0.01664533,      0.006690898,    0.0010542588,   -0.026082052,   -0.009436722,
        -0.048153497,    0.00006292172,  -0.013126219,   -0.03614789,    -0.0025901836,
        -0.027707264,    -0.0029784655,  -0.00609455,    0.009377742,    -0.010878444,
        -0.011926969,    -0.011409259,   0.023224821,    0.023578698,    -0.0035027277,
        0.009810259,     0.005527691,    0.0032815547,   -0.02505974,    0.013788099,
        -0.003755029,    -0.001690746,   0.0050951745,   0.00801466,     -0.007025115,
        -0.012195652,    0.0061240396,   0.01330971,     -0.010000304,   0.012575743,
        -0.013460436,    0.022936476,    0.0071889474,   0.020852534,    -0.013460436,
        -0.011848329,    0.044693366,    0.031848937,    -0.017877346,   0.0077590826,
        0.006264935,     -0.003800902,   -0.017457936,   -0.0050361953,  -0.0006459076,
        0.022215616,     0.008368538,    0.009679194,    -0.010983296,   -0.0023886703,
        -0.014823518,    0.017772494,    0.016933674,    -0.014194403,   -0.012248079,
        -0.030721772,    -0.005147601,   -0.020983601,   -0.045217626,   -0.024745183,
        0.036462445,     -0.0053114328,  0.011363386,    0.023198608,    0.0037943486,
        -0.019305961,    -0.014797305,   -0.019594304,   -0.00049477257, -0.026134478,
        0.017169591,     -0.0021658589,  -0.0030243383,  0.010360735,    -0.0051410478,
        -0.03853328,     -0.005000152,   0.008060534,    0.014286148,    0.015387099,
        -0.00685473,     0.029961593,    -0.00035449144, -0.014155083,   -0.010210009,
        -0.010898103,    0.011750029,    0.012772341,    -0.012805108,   0.0018725996,
        0.011238874,     -0.011867989,   0.029070348,    0.0043808674,   -0.009063185,
        -0.027523773,    0.008977992,    -0.018047731,   0.010498353,    0.0058127586,
        0.008637222,     -0.0013761886,  0.03329066,     -0.013322816,   0.009875792,
        -0.011101255,    0.0061731893,   0.009436722,    -0.0023427974,  -0.0062059555,
        0.005707906,     0.019305961,    0.0030603814,   -0.011848329,   0.008230919,
        -0.02620001,     -0.011160235,   -0.017261337,   -0.01926664,    0.041967202,
        -0.00400733,     0.0046167853,   0.007621464,    0.010714612,    0.0041351193,
        -0.005049302,    0.011553431,    0.0069530294,   0.022949584,    0.0067040045,
        0.018991403,     -0.005229517,   0.01884723,     0.00062051363,  -0.03732748,
        -0.003981117,    -0.025466044,   -0.006402554,   0.010590099,    -0.007582144,
        -0.03735369,     -0.026947085,   -0.025597109,   0.037379906,    -0.033814922,
        0.022608813,     0.009187697,    -0.03205864,    -0.018454034,   -0.010845677,
        -0.16797365,     0.019188002,    0.03588576,     -0.0177856,     0.0037845187,
        0.020669043,     0.035938185,    -0.009587447,   -0.0042661848,  0.0072413734,
        0.0066417484,    0.0077525293,   -0.02993538,    0.0057537793,   0.0064058304,
        0.025688855,     -0.009620214,   0.019620517,    0.0071692877,   0.031167395,
        0.012772341,     0.002218285,    -0.02030206,    0.014155083,    -0.0011042275,
        0.020551084,     0.015898256,    0.0070054554,   -0.010341074,   -0.017379297,
        -0.017025419,    -0.0015809786,  0.003912308,    0.009659533,    0.022569494,
        -0.01374878,     0.0017644705,   -0.0034568547,  0.0045348695,   0.014613813,
        0.021599608,     0.022136977,    0.012051481,    -0.015151181,   0.007745976,
        0.042203117,     0.007647677,    0.016737076,    0.014784198,    -0.00002390923,
        0.009764386,     -0.01656669,    0.011586198,    0.015059436,    0.025557788,
        0.014692452,     0.014141977,    -0.0029948486,  0.008565136,    -0.0075493776,
        -0.0011845052,   -0.016278345,   0.00847339,     -0.014299255,   -0.024456838,
        -0.004626615,    0.00687439,     -0.007437972,   -0.016016215,   -0.0043055043,
        0.00014232904,   0.004276015,    0.010773591,    -0.015505059,   -0.008021214,
        0.017497256,     0.003918861,    0.00445623,     -0.0026819296,  -0.0020413464,
        -0.021180198,    0.00092319323,  -0.009141824,   -0.0090304185,  0.029122774,
        0.03769446,      0.017484149,    -0.011835222,   -0.01500701,    -0.021887952,
        0.012588849,     -0.018571993,   -0.004184269,   -0.019948183,   0.00042760148,
        0.028860642,     0.014377895,    0.0039680107,   0.01576719,     -0.0044332934,
        0.00019321934,   -0.011212661,   -0.010026517,   0.02204523,     -0.0018611313,
        -0.0059339944,   0.013591501,    0.03347415,     0.029411117,    -0.01251021,
        0.010183796,     0.032163493,    0.009515362,    0.02959461,     0.01211046,
        0.01500701,      -0.009836473,   -0.014823518,   0.018152583,    -0.018807912,
        0.056305774,     -0.005809482,   -0.0015645954,  0.019515665,    -0.007392099,
        0.009240123,     -0.091274075,   -0.014037124,   0.011533772,    0.008866587,
        -0.016435625,    0.00927289,     0.0025803538,   0.010432821,    -0.021101559,
        0.03218971,      0.021809313,    -0.031088756,   0.00564565,     -0.017602108,
        0.014902157,     -0.021612715,   -0.004102353,   -0.017379297,   0.003528941,
        0.026920872,     -0.018938977,   0.0006291148,   0.017431723,    -0.020708362,
        -0.0055407975,   -0.010432821,   -0.018440928,   0.02273988,     0.003856605,
        0.0042268652,    0.01884723,     -0.0051869205,  0.02901792,     -0.014522066,
        0.003037445,     0.010314861,    -0.035807118,   0.0050230883,   0.027235428,
        -0.02262192,     0.017339977,    0.004813384,    0.002786782,    -0.02620001,
        -0.025072847,    -0.009371189,   -0.015085649,   0.0043874206,   0.03743233,
        -0.027209215,    -0.0281791,     -0.01668465,    -0.03483723,    0.017575895,
        0.025675748,     -0.009620214,   0.023211716,    0.025872346,    0.024509264,
        0.020918068,     0.0035846438,   0.0019741755,   -0.029253839,   0.00079253723,
        0.00006169298,   0.00025660184,  -0.012746128,   0.0065303426,   0.006736771,
        -0.023657339,    -0.01794288,    0.007929468,    -0.009515362,   0.014561387,
        -0.022661239,    0.0038795413,   0.013283497,    -0.024784502,   0.034417823,
        -0.032609116,    -0.012307058,   -0.01408955,    0.0033618324,   -0.053841744,
        0.016999206,     0.00035060043,  0.024273347,    -0.008099853,   0.0108587835,
        -0.0011156958,   -0.0049247895,  0.006671238,    0.007228267,    -0.030066445,
        0.0011591113,    0.026147583,    0.023329673,    -0.017680747,   -0.01782492,
        0.0064091072,    -0.012051481,   -0.0034503015,  -0.05368446,    0.016553583,
        0.009947878,     -0.005406455,   -0.006189572,   -0.02072147,    0.037877955,
        -0.018480247,    -0.0007167649,  -0.029201413,   -0.018873444,   0.024836928,
        0.0074772914,    -0.0011345365,  -0.016750181,   -0.026802912,   0.014600706,
        -0.009666087,    0.0070775417,   0.0056685866,   0.0062321685,   0.02422092,
        0.015583698,     -0.020891855,   0.007025115,    -0.007929468,   -0.013008259,
        0.022648133,     -0.010662185,   0.002423075,    -0.0025983753,  -0.035859544,
        0.011789349,     0.031088756,    -0.009738173,   0.002064283,    -0.008067086,
        -0.009285997,    0.010373841,    0.049333084,    -0.03069556,    -0.01964673,
        -0.0015424781,   -0.04380212,    -0.006264935,   0.01794288,     -0.017890451,
        0.006248552,     0.033002313,    -0.012018714,   0.011972841,    0.01884723,
        0.0031324674,    0.010989849,    -0.00015226135, -0.014456534,   0.028703364,
        0.011835222,     -0.015636124,   -0.021285051,   0.008152279,    -0.0084799435,
        0.0193846,       -0.015229821,   0.0056653097,   0.01488905,     -0.000845373,
        -0.01850646,     -0.017798707,   -0.027523773,   0.0012025267,   0.0040695863,
        0.002387032,     -0.018938977,   0.0037026028,   0.03279261,     0.0056358203,
        -0.009036972,    -0.020655936,   0.026711166,    -0.007922915,   0.0044234633,
        -0.03420812,     -0.0030669346,  0.031980004,    0.025833027,    0.009050079,
        0.009856132,     0.017497256,    -0.00052221445, 0.0060224636,   0.016252132,
        -0.020564191,    -0.000563582,   0.00039094407,  0.033814922,    -0.01327039,
        0.0023804787,    0.032740183,    0.01416819,     -0.002750739,   0.005409732,
        -0.013683247,    -0.013322816,   -0.018834125,   -0.006264935,   -0.011035723,
        -0.023591805,    0.006238722,    0.0052229636,   0.007870489,    0.006992349,
        -0.009207358,    0.014391001,    0.00010393091,  0.006517236,    -0.003673113,
        -0.0086110085,   -0.019161789,   0.0355712,      0.0023690104,   0.0072151604,
        -0.014836624,    -0.015649231,   0.0004390697,   0.020629723,    0.013788099,
        0.0063763405,    0.0018627696,   -0.00026704613, 0.017929772,    -0.018532673,
        -0.023473846,    -0.008702755,   0.011474792,    -0.014810411,   -0.019174894,
        0.016972993,     -0.023906363,   0.04346135,     -0.006500853,   0.005629267,
        0.004072863,     -0.011966288,   0.034077052,    -0.0029637206,  0.010229669,
        0.0011394514,    -0.0015899894,  0.0033618324,   -0.033841133,   0.0020528147,
        -0.0032537032,   -0.026095157,   0.0032668097,   -0.0026622696,  -0.0071955007,
        -0.017222017,    -0.0006966955,  0.039660446,    0.0033536407,   0.030931478,
        -0.00303253,     -0.025177699,   -0.0020266017,  0.028388806,    0.020839429,
        0.01003307,      -0.020459337,   -0.010288648,   -0.0062518283,  -0.029201413,
        -0.022870945,    0.02148165,     -0.0050591314,  0.022071445,    -0.0046495516,
        -0.00096251286,  0.026829125,    -0.009790599,   0.009521915,    -0.026894659,
        -0.025295658,    0.0043481006,   0.004518486,    -0.00052057614, -0.009489148,
        -0.0072872466
    ],
    [
        0.0035295584,   -0.026654368,    0.0008388148,   -0.014802023,     0.004954119,
        0.0393648,      -0.0091373,      0.001012276,    -0.0005346292,    -0.02584991,
        0.0055474066,   0.002713369,     0.023007493,    -0.018422084,     0.02686889,
        0.0046524475,   0.030033091,     -0.0065027005,  0.0038245264,     -0.023396313,
        -0.015391959,   0.04033015,      -0.003293249,   -0.0108601805,    0.007132859,
        -0.0075551993,  0.009814385,     -0.011175259,   0.013729413,      0.002458624,
        -0.0086680325,  -0.00027359943,  0.009097077,    -0.050975807,     -0.03177608,
        -0.010176391,   0.005540703,     0.0035563738,   0.012241166,      0.00071521325,
        0.017617626,    0.019360617,     -0.007930613,   -0.014158457,     0.0016399208,
        0.011135036,    -0.0059328764,   -0.002386558,   -0.02483093,      0.0052725505,
        0.017134951,    0.016357308,     -0.014252311,   -0.0023714744,    -0.030247612,
        -0.01572715,    -0.00609712,     0.012938363,    0.018247783,      -0.01309255,
        -0.001845225,   -0.004893785,    -0.01566011,    0.0011999828,     -0.018998612,
        -0.0030284484,  -0.007340677,    0.016692499,    -0.00086981995,   -0.015686927,
        0.014104826,    -0.0014279126,   -0.0006620017,  -0.023798542,     0.02551472,
        -0.020862272,   -0.01764444,     0.0066468325,   -0.00017241374,   0.0031993957,
        0.025890132,    -0.02286001,     -0.043413904,   0.034993913,      0.024871154,
        0.00397201,     -0.0042166994,   0.039793845,    0.008466918,      0.011483635,
        -0.011778602,   0.0037440807,    -0.0057518734,  0.0060904156,     0.0086680325,
        -0.0051284186,  -0.019508101,    0.0051250663,   -0.005902709,     -0.008339546,
        0.0005974775,   -0.004417814,    0.013300369,    -0.010243429,     0.0046289843,
        -0.011678046,   -0.005282606,    0.0039653066,   0.02273934,       -0.015700335,
        -0.00096870126, 0.016397532,     0.02454937,     -0.058350004,     0.0055172397,
        -0.0182746,     0.016692499,     -0.00854066,    -0.009117188,     -0.013307072,
        0.03094481,     0.0006356054,    0.01883772,     -0.016705906,     0.004880377,
        -0.0037072096,  0.012147313,     -0.021680137,   0.00486697,       -0.014815431,
        0.015003137,    -0.0006326725,   0.049206,       0.0050010458,     -0.0032781656,
        0.0021066738,   -0.01906565,     0.011926087,    -0.021827621,     -0.02896048,
        0.0055306475,   0.017671255,     -0.026399624,   0.0055172397,     0.004240163,
        0.0196824,      -0.008433399,    -0.0049641747,  -0.0035295584,    0.015458997,
        0.007984243,    -0.022323703,    0.031883344,    -0.0037306729,    0.028826404,
        0.01165123,     0.0043340162,    0.013199812,    -0.018515937,     -0.002141869,
        -0.008741775,   0.012623283,     -0.011336151,   -0.00042443527,   0.013427741,
        0.034886654,    0.037863147,     0.0144266095,   0.002711693,      -0.014185272,
        0.000433653,    0.010819958,     0.0015485813,   0.02210918,       0.0075753108,
        0.03236602,     -0.020553896,    0.0029412988,   -0.002971466,     -0.012965178,
        -0.022484595,   0.021009756,     0.0005467799,   0.031588376,      -0.033921305,
        -0.018301414,   -0.01815393,     -0.024670038,   0.006190973,      0.017228805,
        -0.0021167295,  0.015646704,     -0.0026128117,  -0.00275024,      -0.66029894,
        -0.0074077155,  -0.0084199915,   0.013159589,    -0.001484895,     0.005691539,
        0.02483093,     0.0032848692,    -0.022377335,   0.024254402,      0.0006728954,
        0.010343987,    -0.003878157,    -0.007561903,   0.0060401373,     -0.023744913,
        0.021385169,    -0.01934721,     -0.007273639,   0.0011086434,     -0.009271376,
        0.030623026,    0.0181003,       0.0033250921,   0.014104826,      0.009814385,
        -0.00053043937, -0.012764064,    -0.0057150023,  0.009707124,      -0.008480326,
        0.03483302,     -0.016772944,    -0.0012921604,  0.04944734,       -0.0058557824,
        0.014319348,    0.03467213,      0.00919093,     0.032178313,      -0.02788787,
        -0.011208778,   -0.008212173,    -0.0114702275,  0.014547278,      -0.007528384,
        0.025380643,    0.009834496,     0.022484595,    0.0029077798,     -0.009586455,
        0.01136967,     -0.019132687,    -0.015566258,   0.006663592,      -0.00019242044,
        0.010531693,    -0.000049833438, -0.0020379596,  -0.009680308,     -0.015901448,
        0.00181003,     0.015432182,     0.012341723,    -0.015646704,     0.04220722,
        0.0031424132,   0.03319729,      -0.011590896,   -0.018904759,     0.01793941,
        0.01600871,     -0.024147142,    0.0050848434,   0.009981981,      0.02641303,
        0.0023681226,   0.0019139391,    -0.0066602402,  -0.01066577,      0.004706078,
        -0.0098881265,  -0.013561818,    -0.002936271,   0.0059831548,     -0.01448024,
        0.00021336986,  -0.004494908,    0.0048099873,   0.0025608572,     0.011135036,
        0.031186147,    0.0021536006,    0.014775208,    0.00905015,       -0.001954162,
        0.0008572503,   -0.0010407673,   0.010893699,    -0.02222985,      -0.017429918,
        -0.023892397,   0.03099844,      -0.015794188,   0.005614445,      -0.006938448,
        -0.020687973,   0.012495911,     0.042770337,    -0.013441149,     0.0004897975,
        0.00520216,     -0.0009938405,   -0.009224449,   -0.0069652637,    -0.02217622,
        0.026681183,    0.013139477,     0.033411812,    -0.02353039,      -0.0017295842,
        0.025890132,    0.03349226,      -0.0149361,     0.02047345,       0.025930356,
        -0.034296717,   -0.020339373,    -0.03207105,    0.008748478,      0.00941886,
        0.001336573,    -0.006345161,    -0.019588547,   -0.0054803686,    0.025032045,
        0.013421037,    -0.0023094642,   0.03191016,     0.006847947,      0.000077722354,
        -0.0151506215,  0.008265804,     -0.009821089,   0.0066032577,     -0.027405195,
        -0.0137025975,  -0.0093920445,   -0.033760414,   0.0015108723,     -0.0033133605,
        -0.030193983,   -0.00047974175,  0.016357308,    0.01131604,       0.011436708,
        -0.0050814915,  -0.0056982427,   -0.005031213,   -0.018556159,     0.014440017,
        0.009123892,    -0.031132516,    -0.011570784,   -0.02342313,      -0.007863575,
        0.021908067,    0.0006800182,    -0.0018670125,  -0.019038834,     0.017228805,
        -0.04842836,    -0.032902323,    0.024240995,    0.002497171,      0.0015552851,
        0.003001633,    0.013890305,     -0.024308033,   0.0045854095,     0.004139606,
        -0.022953862,   -0.014091419,    -0.017926,      0.023168385,      0.0075551993,
        0.011845641,    0.050600395,     -0.0037139135,  0.05073447,       -0.011342855,
        0.016209824,    0.0062043807,    -0.0064222547,  -0.007789833,     0.005104955,
        0.02834373,     0.020567304,     0.0047999313,   0.020620935,      0.006740686,
        0.0052256235,   0.025125898,     0.004887081,    0.017523773,      -0.010920514,
        -0.0048334505,  -0.018247783,    0.036897797,    -0.000086887725,  0.025662204,
        -0.022310296,   0.010799846,     0.0018401971,   -0.012817694,     0.015405366,
        -0.0077227945,  -0.0017496956,   -0.023731505,   0.02409351,       -0.003579837,
        -0.028638696,   -0.018958388,    -0.0041999402,  -0.010752919,     0.022149405,
        0.00074077153,  0.02788787,      0.017456735,    -0.017443327,     -0.0041094385,
        0.02268571,     -0.015137214,    0.02584991,     0.015753966,      -0.024871154,
        -0.007414419,   -0.019963961,    0.021371761,    -0.016035525,     0.028156022,
        0.021827621,    0.032553725,     -0.010223318,   0.0049407114,     -0.0008505465,
        0.0058055036,   0.011644526,     -0.0023848822,  0.00947249,       -0.0119461985,
        0.009921646,    -0.0066803517,   0.019601954,    0.0044077584,     -0.0028424175,
        0.015418774,    0.0037072096,    0.0025508015,   0.0025508015,     -0.0035630777,
        -0.0060904156,  0.026681183,     -0.00783676,    0.015164029,      -0.007414419,
        0.01991033,     0.0047530048,    0.018515937,    0.0033753708,     -0.006365272,
        0.002069803,    -0.010679177,    0.005681483,    0.033921305,      0.007917206,
        0.0009955165,   -0.009204337,    0.011396485,    0.016276862,      -0.021613099,
        -0.015633296,   0.0018871239,    0.034189455,    -0.002101646,     -0.015821002,
        -0.011383078,   0.01368919,      -0.010960737,   0.017429918,      0.012167424,
        0.0050043976,   -0.029309079,    0.002425105,    -0.00006483846,   -0.006978671,
        0.0279415,      -0.019695807,    0.040008366,    -0.022270072,     0.00011878322,
        -0.007166378,   -0.00095696957,  -0.019226542,   0.016464569,      -0.0014354544,
        -0.003475928,   -0.02539405,     -0.006985375,   -0.014024381,     0.019615361,
        -0.016142786,   -0.025809687,    -0.0000578204,  -0.0149226915,    -0.008225581,
        -0.019253356,   0.00062429276,   0.005771985,    0.00919093,       -0.019280171,
        -0.022203036,   -0.02286001,     -0.011590896,   0.12839146,       0.004608873,
        0.0072803427,   0.020687973,     0.006479237,    0.00048057974,    -0.002931243,
        -0.028209653,   0.010752919,     -0.002284325,   -0.00637868,      0.006613313,
        -0.0054870723,  0.013588632,     0.02307453,     0.014118234,      -0.01289814,
        -0.027070004,   0.017282436,     -0.020942718,   0.015874634,      0.000007044243,
        0.0018234376,   0.0051719933,    0.0053664036,   0.001196631,      -0.0000052439023,
        0.028719142,    -0.019239949,    -0.019829884,   -0.009780866,     -0.0024854394,
        -0.016089156,   0.0025290141,    0.0017949464,   0.008044578,      -0.011758491,
        0.0026345993,   0.033572704,     0.0051183626,   0.022082366,      0.04405747,
        0.017738294,    -0.03587882,     0.005332885,    -0.008158543,     0.008192061,
        0.016464569,    0.0063853837,    -0.0058691897,  0.04003518,       -0.00011312687,
        -0.0035563738,  -0.0020413117,   -0.007354085,   0.0028038705,     0.011275817,
        0.015445589,    0.0036100042,    0.002678174,    -0.02788787,      -0.018636605,
        -0.006093768,   -0.028048761,    -0.007716091,   -0.0231952,       -0.033760414,
        -0.007059117,   -0.023369499,    0.0040088813,   0.013219923,      -0.059690766,
        -0.004994342,   -0.01641094,     0.01759081,     -0.0034273253,    0.022363927,
        -0.0073205656,  0.026520291,     0.015606481,    -0.00012087816,   -0.008842332,
        -0.0142925335,  -0.016437754,    -0.0050412687,  0.010082537,      -0.012040052,
        -0.006083712,   -0.020312559,    0.031293407,    -0.0070792283,    0.002247454,
        0.02080864,     -0.0014790292,   -0.0031357093,  -0.023463352,     -0.023154976,
        0.024334848,    0.007568607,     0.0069183367,   0.026909113,      -0.013193108,
        -0.012147313,   -0.012321612,    -0.006559683,   0.010685881,      -0.0049038404,
        -0.013112662,   -0.011302632,    0.007494865,    0.011657934,      -0.036495566,
        0.0047831717,   0.0042770337,    -0.005607741,   0.00882222,       0.008721664,
        0.02154606,     0.016571831,     0.016759537,    0.0047965795,     -0.016504792,
        0.025018638,    0.0064993487,    -0.014440017,   -0.0004173125,    -0.0030619674,
        -0.025340421,   -0.013642264,    -0.00783676,    -0.0000036563288, 0.02308794,
        0.013032217,    -0.019132687,    -0.03099844,    -0.0026111358,    -0.017496957,
        -0.00083253003, -0.023677874,    -0.0068647065,  -0.009532825,     0.0050781397,
        -0.007313862,   -0.01771148,     -0.010444543,   -0.030703472,     -0.0010692584,
        0.00018100301,  -0.012676914,    0.017443327,    -0.02438848,      -0.018207561,
        0.00296979,     0.016612053,     -0.023382906,   -0.06011981,      -0.028102392,
        -0.014440017,   0.03064984,      0.03483302,     0.027726978,      -0.03064984,
        0.021090202,    0.004675911,     -0.003439057,   0.01012276,       -0.009291488,
        0.027512455,    -0.05282606,     0.03646875,     0.014533871,      0.006013322,
        0.017456735,    0.005215568,     0.020393005,    0.00876859,       -0.02024552,
        -0.030891178,   -0.008017763,    0.0097540505,   -0.005470313,     -0.005396571,
        -0.003982066,   -0.0014337784,   -0.032660987,   -0.012817694,     0.023007493,
        0.003221183,    -0.011295928,    -0.002783759,   0.01012276,       0.0007009676,
        -0.02788787,    -0.0247773,      -0.019253356,   -0.0028440934,    -0.0001556542,
        -0.0049440633,  0.014319348,     0.027083412,    -0.020299152,     -0.00905015,
        0.023597429,    0.0044613886,    -0.0014756772,  0.020339373,      0.012221054,
        -0.009036742,   0.0044345735,    -0.0071395626,  -0.01077303,      -0.005296014,
        -0.02946997,    -0.037085503,    -0.0033770467,  0.0064926445,     -0.006405495,
        0.014091419,    -0.00550048,     -0.044996005,   0.005614445,      -0.0025256623,
        0.03542296,     0.02092931,      0.03869442,     0.037031874,      -0.010524989,
        -0.005839023,   0.03416264,      0.0050948993,   0.0077630174,     0.012683618,
        0.010940626,    0.0047328933,    -0.028424175,   -0.010223318,     0.018743867,
        -0.04405747,    -0.023034308,    0.026614144,    -0.005279254,     -0.0039250837,
        -0.0040692156,  -0.0056881867,   -0.006495997,   -0.0049909903,    -0.013642264,
        0.018757274,    0.00072485,      -0.038104482,   -0.036066525,     0.0028373897,
        0.0006724764,   -0.0042133476,   -0.0070390054,  -0.0109942565,    0.005138474,
        -0.0025859966,  0.007876983,     0.020312559,    -0.004283738,     0.022323703,
        -0.008936185,   -0.0003733187,   0.017403103,    -0.010183095,     -0.011161852,
        -0.019508101,   0.0037206172,    0.025434274,    -0.0011262409,    0.021827621,
        -0.008728367,   0.013032217,     -0.010739512,   0.0020614231,     -0.012281389,
        -0.030864364,   0.00055474066,   -0.004803283,   0.012053459,      0.008775294,
        -0.022725932,   -0.0021519247,   -0.0149361,     -0.00087819976,   -0.01776511,
        0.002718397,    0.00797754,      0.0051451777,   -0.0070993397,    -0.020607527,
        -0.0006330915,  0.02363765,      0.012884732,    -0.0025575054,    -0.009304895,
        0.02551472,     -0.03909665,     -0.0011698157,  0.0027016373,     0.021224277,
        -0.016933836,   0.004055808,     -0.017067913,   0.007233416,      0.0026161638,
        -0.022927048,   -0.032500096,    -0.008963,      -0.005460257,     0.013313777,
        -0.015914857,   -0.017336065,    0.018797496,    -0.0025072268,    0.021143831,
        -0.01521766,    -0.01850253,     0.009438971,    -0.003764192,     -0.005021157,
        0.02353039,     -0.04475467,     0.0026345993,   -0.004917248,     0.011249001,
        0.015056768,    -0.007776425,    -0.01629027,    -0.007876983,     0.022149405,
        0.016397532,    -0.025447682,    0.00011731676,  -0.02189466,      -0.015458997,
        0.012040052,    0.025876725,     -0.021291316,   0.019508101,      0.047918867,
        0.013394222,    -0.0023714744,   -0.0007914691,  -0.012623283,     0.0015502572,
        -0.025461089,   -0.034591686,    -0.03528888,    -0.028853219,     0.024415294,
        -0.0056312047,  -0.018998612,    -0.029148187,   0.016491385,      -0.024938192,
        -0.010685881,   -0.011564081,    -0.0024804114,  0.019950554,      -0.000020975609,
        -0.011175259,   0.01883772,      0.019320395,    0.013729413,      -0.017523773,
        -0.019414248,   -0.0147886155,   -0.017966224,   0.017684665,      0.01606234,
        -0.032687802,   -0.020741602,    0.030167166,    -0.016947243,     0.011792011,
        0.006992079,    -0.028638696,    -0.0077227945,  -0.0042234035,    0.025461089,
        0.0041999402,   -0.013206515,    0.022310296,    -0.019320395,     -0.009747347,
        0.016947243,    0.0047697644,    -0.0038178226,  0.009298191,      0.00608036,
        -0.013152885,   0.014279125,     -0.011034479,   -0.0075484957,    0.021411985,
        0.0008019439,   0.026506884,     0.012904843,    0.00724012,       0.024737077,
        0.018904759,    -0.024173956,    -0.009090373,   0.021706952,      0.009593159,
        -0.01108811,    0.011785307,     -0.0071797855,  0.030193983,      -0.008929482,
        0.015405366,    -0.010142872,    0.00506138,     0.0007738716,     -0.01289814,
        -0.019387433,   0.029040925,     -0.01771148,    -0.028745959,     0.0052323276,
        -0.0092780795,  -0.010364098,    -0.013662375,   -0.01957514,      -0.00071186136,
        -0.008326138,   0.007166378,     -0.0010390913,  -0.016866798,     -0.011336151,
        0.008091505,    0.011778602,     -0.025554942,   0.0066870553,     0.22696435,
        -0.003512799,   -0.0029932533,   0.028772773,    -0.015928265,     0.011021072,
        0.04089327,     -0.00030984194,  0.018529344,    -0.006636777,     -0.020540489,
        0.013387518,    -0.02166673,     0.0017195285,   -0.010565212,     -0.0036033005,
        -0.024308033,   -0.010813253,    0.010263541,    -0.00042485425,   0.026064433,
        -0.0017245563,  0.01578078,      -0.017791925,   0.028290099,      0.015405366,
        0.0015720446,   0.002027904,     0.008393176,    0.0036267638,     -0.0022642135,
        -0.02584991,    -0.0140646035,   -0.0071797855,  0.005976451,      -0.0020413117,
        -0.013628855,   0.008621106,     0.0074077155,   0.0058155595,     0.0102501325,
        0.014520463,    0.020620935,     0.0083998805,   0.0012494235,     0.0011170232,
        -0.001048309,   -0.0017362881,   -0.013561818,   0.03646875,       -0.009170819,
        -0.013957342,   0.014909284,     0.027338156,    -0.008527253,     -0.016343901,
        0.007092636,    0.0139305275,    -0.0095060095,  0.00003605919,    -0.008815517,
        0.022913639,    -0.0011656258,   0.018341638,    -0.019990776,     0.023946026,
        -0.014359571,   0.0058490783,    -0.00797754,    0.011155148,      -0.010189799,
        -0.027592901,   -0.01685339,     -0.019615361,   0.0008656301,     -0.014694762,
        0.021733768,    0.0056747794,    0.031749267,    0.022900231,      -0.009626678,
        0.009660197,    0.00021766449,   0.00442787,     -0.009512713,     0.0005580926,
        0.033170477,    -0.009438971,    -0.021023164,   -0.005976451,     -0.0010080861,
        -0.012361835,   -0.022645487,    -0.030193983,   0.0018200857,     0.016491385,
        0.009097077,    0.018435491,     -0.024750484,   -0.034591686,     -0.021613099,
        0.009948461,    0.0042669782,    0.0025005229,   0.0055608144,     0.002492143,
        -0.009103781,   0.018341638,     0.0077227945,   -0.026225325,     0.008922777,
        -0.029255448,   0.0075484957,    -0.0009578075,  0.009660197,      0.009452379,
        0.017403103,    -0.03370678,     0.022645487,    0.005835671,      -0.0040725674,
        -0.03625423,    -0.014145049,    -0.0097540505,  -0.0050178054,    -0.028370544,
        0.0016910373,   0.021720361,     0.017403103,    -0.025367236,     -0.008406584,
        -0.0044312216,  -0.0034558165,   -0.022725932,   -0.017563995,     -0.009184226,
        0.017671255,    -0.019199725,    0.025595166,    0.017952817,      -0.001595508,
        0.004887081,    0.017269026,     0.002101646,    0.016196417,      -0.03528888,
        0.019977368,    -0.001086856,    0.008554067,    0.00075208425,    -0.025246566,
        -0.008983112,   0.010518285,     -0.009988684,   0.020902494,      -0.014185272,
        -0.009995388,   -0.021492431,    -0.00089663523, -0.004893785,     -0.013387518,
        0.00077722355,  0.024804115,     -0.018596383,   -0.011416596,     0.011443412,
        -0.17215396,    0.019937145,     0.013997565,    -0.007159674,     0.020352783,
        -0.0034222975,  0.015391959,     -0.0067507415,  -0.030676657,     -0.012670211,
        0.0044412776,   0.0051921047,    -0.041644096,   -0.021693544,     0.008131728,
        -0.0018703643,  -0.0043977024,   0.0064658294,   0.009432267,      -0.00072526897,
        0.023677874,    0.0002635437,    0.009150707,    0.002497171,      -0.00924456,
        0.008245693,    0.013260146,     -0.012402058,   -0.02409351,      -0.013997565,
        0.0012728869,   -0.0059496355,   0.0042267554,   0.0063216975,     0.004163069,
        0.009217746,    -0.010330578,    -0.0196824,     -0.034350347,     0.0058122077,
        0.009123892,    0.0142925335,    -0.0069451523,  -0.008560772,     0.016799761,
        0.024911376,    0.012288093,     0.00774961,     0.00615075,       -0.032955956,
        0.0035295584,   -0.027338156,    0.015968487,    0.006733982,      0.030113537,
        0.021733768,    0.0086680325,    0.009854608,    0.0029044277,     -0.021023164,
        -0.025367236,   -0.022618672,    0.015056768,    0.0053597,        -0.038319007,
        -0.009760754,   -0.0019055593,   0.0029664382,   -0.029067742,     0.029711308,
        -0.008125024,   0.021411985,     -0.00035697815, -0.01980307,      0.007347381,
        0.005386515,    -0.019561732,    -0.023007493,   -0.008252396,     0.009103781,
        -0.037031874,   0.024308033,     -0.025380643,   0.008875851,      0.021009756,
        0.005332885,    0.006083712,     -0.009881423,   0.0033217403,     -0.014641131,
        -0.0037742478,  -0.03054258,     -0.024482332,   -0.021411985,     -0.000977081,
        0.018998612,    0.007106044,     0.013917119,    -0.0038077668,    -0.027539272,
        -0.0011078054,  -0.005463609,    -0.01804667,    0.008741775,      0.019494694,
        0.013374111,    0.04022289,      0.0056613716,   0.027230896,      0.0012427197,
        -0.009157411,   0.022363927,     0.00803117,     0.026949335,      -0.0050814915,
        0.027700163,    0.01894498,      -0.022953862,   0.0349671,        -0.024308033,
        0.032795064,    0.0119663095,    -0.013132773,   0.0029547063,     -0.019709216,
        -0.017376289,   -0.11198052,     -0.0069652637,  -0.019414248,     -0.005031213,
        -0.02409351,    0.025192937,     0.002279297,    0.0068278355,     -0.0020832105,
        0.00789039,     0.0034239735,    -0.0029278912,  0.0019441063,     -0.017926,
        0.033814043,    -0.01128252,     -0.028504621,   0.0050111017,     -0.014748393,
        0.024790708,    0.001811706,     -0.0026379512,  0.005064732,      -0.020687973,
        -0.008527253,   0.015096991,     -0.029389525,   0.02834373,       0.00039217318,
        -0.001196631,   -0.0056781312,   -0.032875508,   0.009405452,      -0.02483093,
        0.0027334804,   -0.005875894,    -0.013756228,   0.0057988,        0.035449773,
        -0.059261724,   -0.0028792885,   0.017067913,    0.009532825,      -0.018194154,
        0.0072267125,   -0.014238902,    -0.020178482,   0.0065764426,     0.03424309,
        -0.011838937,   -0.02539405,     -0.008252396,   -0.025756057,     -0.002936271,
        0.017228805,    0.00015303552,   0.0024083455,   0.018556159,      0.005182049,
        0.0033083328,   0.0060669524,    0.013213219,    0.0115841925,     0.025648795,
        -0.010625547,   0.0018536048,    -0.025099084,   0.029282263,      0.01980307,
        -0.021586284,   0.011483635,     0.019642178,    -0.019012019,     -0.0018921518,
        -0.030006275,   0.0013416009,    -0.023101347,   0.019427655,      0.009941758,
        -0.021049978,   0.011322743,     -0.015847819,   0.013347295,      -0.015016546,
        0.005544055,    -0.003874805,    0.0038479897,   0.005647964,      0.0015770724,
        0.0068647065,   -0.012596468,    -0.011570784,   -0.0057920963,    -0.022578448,
        -0.0009594835,  0.030167166,     -0.01748355,    -0.02834373,      0.00042464476,
        0.006878114,    -0.028129207,    -0.009177523,   -0.056204785,     0.027592901,
        -0.0013374111,  -0.0069719674,   -0.007850167,   -0.004464741,     0.0041898843,
        0.009070261,    0.019588547,     -0.011872456,   -0.010886995,     0.032714617,
        -0.014734985,   -0.0061675096,   -0.00029454887, -0.0031239777,    0.027726978,
        0.01498973,     0.017912593,     0.0013876897,   -0.0057284096,    -0.00774961,
        0.011443412,    -0.0019357265,   0.0033100087,   0.010598731,      -0.015204252,
        0.021961698,    0.010055723,     0.0051921047,   0.014131642,      -0.023262238,
        -0.009425564,   -0.01595508,     0.011865753,    -0.012395354,     0.009170819,
        -0.0039686584,  -0.017805332,    0.027418602,    -0.025420867,     -0.009130596,
        -0.0006963588,  -0.013206515,    0.0020798587,   0.009251265,      -0.00075166527,
        0.012978585,    0.028209653,     -0.0046960223,  0.029389525,      0.026681183,
        -0.023584021,   0.003975362,     -0.01136967,    -0.013588632,     0.0015477432,
        0.0133204805,   0.0064658294,    -0.001628189,   0.003299953,      0.009968572,
        -0.012737248,   0.01154397,      -0.0067205746,  -0.012562949,     -0.0009812709,
        -0.00275024,    -0.0000653622,   -0.022524819,   -0.0314543,       0.005644612,
        0.0044446294,   0.00859429,      -0.018515937,   -0.015083583,     -0.02212259,
        -0.00041752198, -0.003837934,    0.025139306,    -0.040973715,     -0.0035161509,
        -0.024938192,   -0.005282606,    0.02551472,     0.0076557565,     0.0033619632,
        0.013662375,    -0.0029882255,   0.002322872,    -0.017778518,     0.016933836,
        0.004424518,    0.011188667,     -0.014158457,   0.0006909119,     -0.021505838,
        -0.015767373,   0.005550759,     0.021921474,    0.02595717,       -0.0013608744,
        -0.0069183367,  -0.027726978,    -0.010484766,   0.0107462155,     -0.005654668,
        -0.040517855,   -0.0017681312,   0.02001759,     0.015807595,      -0.014587501,
        0.01883772,     -0.00181003,     -0.010967441,   0.029067742,      0.0151506215,
        -0.02539405,    -0.022940455,    0.010330578,    -0.0010709345,    0.006020026,
        0.023007493,    -0.008969705,    0.01850253,     0.0035329105,     0.037997223,
        -0.034645315,   0.010679177,     -0.010102649,   0.007937317,      0.0053127734,
        -0.03491347,    0.0010390913,    -0.03370678,    -0.012294796,     0.000022625376,
        -0.0026245436,  -0.037487734,    0.053550072,    0.0006343485,     -0.0015293078,
        0.02799513,     -0.025474496,    0.021747176,    -0.0052725505,    0.041885436,
        -0.026935928,   -0.00794402,     0.023838766,    -0.0147618,       0.017376289,
        0.0030669954,   -0.004451333,    0.014440017,    -0.014051196,     0.008192061,
        -0.002498847,   -0.006278123,    0.015177437,    -0.011289224,     0.00973394,
        0.009016631,    -0.015458997,    -0.0231952,     -0.0055608144,    -0.010645658,
        -0.016652277,   -0.0054166825,   -0.004313905,   0.011691453,      -0.004997694,
        -0.008694848,   -0.0022910286,   0.0036535792,   0.021505838,      -0.0011605979,
        -0.009928349,   0.009003223,     -0.018663421,   -0.0042636264,    -0.008674736,
        -0.021237686,   -0.010752919,    0.01470817,     -0.0018418732,    0.0083998805,
        -0.01532492
    ],
    [
        0.0071738027,   -0.032486614,   -0.004333496,    -0.02835762,     -0.0025806213,
        0.035031527,    -0.004765223,   -0.024501296,    -0.007686681,    -0.0028857514,
        0.004729516,    0.0073880428,   0.010218611,     -0.016126448,    0.021398058,
        -0.011744262,   0.03799194,     -0.017827386,    0.01777545,      0.008920185,
        -0.0019752304,  -0.015425299,   0.021787586,     -0.024747996,    0.0067063696,
        -0.016970426,   0.0057974714,   -0.02259261,     0.01960623,      0.0013998654,
        0.0062616584,   -0.003875801,   0.000032511365,  -0.010750966,    -0.02213816,
        0.00481716,     -0.012951798,   -0.011335257,    0.0142697,       -0.023254806,
        0.007699665,    0.0114131635,   -0.012107821,    -0.001331698,    -0.01795723,
        -0.0040478427,  0.0074205035,   -0.03570671,     -0.023436585,    0.0052456404,
        0.004982709,    0.027396785,    -0.008576103,    -0.014646243,    -0.007076421,
        -0.020619003,   -0.0000880495,  0.00927076,      -0.0014266454,   -0.028773116,
        -0.006842704,   -0.016515976,   -0.01661985,     0.021086436,     -0.0015483728,
        -0.006641448,   0.0029896256,   -0.004882081,    0.002518946,     -0.005482603,
        0.012023423,    0.028799085,    0.015009803,     -0.003164913,    0.019515341,
        -0.0022982138,  -0.013776298,   0.008589087,     0.00080542977,   0.023008106,
        0.019619213,    -0.029630078,   -0.016425086,    0.03726482,      0.021644758,
        0.009140918,    -0.0049437564,  0.008387831,     -0.022280987,    -0.020437222,
        -0.0027981077,  0.0026147051,   0.0021846015,    0.006135062,     -0.026721604,
        0.008602072,    -0.012114313,   0.008816311,     -0.016645819,    -0.043029834,
        -0.00853715,    -0.0020498899,  0.004869097,     -0.00573255,     -0.021242246,
        0.0016392627,   0.020787798,    -0.026474902,    0.027422754,     -0.0037362203,
        -0.022462767,   0.014646243,    0.010341962,     -0.036693513,    -0.020657955,
        -0.040588792,   0.020631986,    -0.000015444166, 0.006044172,     -0.01054971,
        0.027734376,    0.0106406,      -0.0016157286,   -0.00461915,     0.017814402,
        0.009601859,    -0.010296517,   -0.0254881,      0.023150932,     -0.029344425,
        0.015477236,    0.0073036454,   0.016477024,     0.0052131796,    -0.030175416,
        0.02503365,     -0.022462767,   -0.004784699,    -0.010426359,    -0.009764162,
        0.020541096,    0.016879536,    -0.022060255,    -0.015165614,    -0.008563118,
        0.015269488,    0.0012375622,   0.008816311,     0.019060891,     -0.019125812,
        0.023332711,    -0.015957654,   0.018333772,     -0.0055442783,   0.0119649945,
        -0.010225103,   -0.002566014,   -0.0015004934,   -0.01177023,     -0.02067094,
        -0.008400816,   0.0028435525,   -0.013932109,    -0.04232868,     0.010036832,
        0.0355509,      0.0075633307,   -0.026825478,    -0.002668265,    -0.017554717,
        -0.015983623,   0.022203082,    0.00020937117,   0.0128674,       -0.0070179915,
        0.021216279,    0.0050995676,   0.02731888,      -0.000051226958, 0.0006512417,
        -0.00033515616, -0.0030253322,  0.0034765352,    0.024202658,     -0.025072603,
        -0.016256291,   0.0016928227,   0.00030168114,   0.023475539,     -0.014412527,
        0.0059630205,   0.006092863,    -0.012737557,    0.016541945,     -0.668949,
        0.0032801481,   0.006644694,    -0.0061675226,   -0.011990963,    0.015646031,
        0.006329826,    0.020696908,    -0.019515341,    0.0143995425,    0.009011075,
        0.021501932,    -0.0052975775,  -0.01365944,     -0.022177113,    -0.006998515,
        -0.007284169,   -0.032174993,   0.015074724,     -0.012588238,    -0.048457254,
        0.045600716,    0.012211695,    -0.004982709,    -0.0017723512,   0.020112617,
        0.025267366,    -0.010776934,   -0.0034992576,   0.0061026015,    -0.01317253,
        0.0059013455,   0.0021424026,   0.022579625,     0.050275046,     -0.020528112,
        0.0008188198,   0.022917217,    -0.015607079,    0.024877839,     -0.004972971,
        -0.014256716,   0.044484068,    -0.013003735,    0.007686681,     0.016425086,
        0.03238274,     -0.01238049,    0.0048528668,    -0.0012034784,   0.0122896,
        0.012731065,    -0.013360802,   0.00045160874,   0.013828235,     -0.0018372725,
        0.0257348,      0.0037492046,   -0.0032298341,   -0.015282472,    -0.023787161,
        0.024371453,    -0.008180083,   -0.011971486,    -0.014931897,    0.04528909,
        -0.021969365,   0.03131803,     0.02125523,      -0.024683075,    0.040381044,
        0.011062589,    0.0075892988,   0.006125324,     -0.010887301,    0.0040023974,
        0.03801791,     -0.009244792,   -0.00072143786,  0.003713498,     0.01689252,
        -0.0050508766,  -0.009621335,   -0.008037256,    0.03690126,      -0.012198711,
        -0.03417457,    0.008361862,    0.0078100315,    0.002764024,     0.001053348,
        0.026306108,    -0.022943184,   -0.00070764206,  0.0029036049,    -0.0009575891,
        0.022995122,    0.010588663,    0.024189673,     -0.026591761,    -0.0042620827,
        -0.01777545,    0.013204991,    -0.02073586,     -0.012250648,    -0.0031259602,
        0.0038433406,   -0.007381551,   0.03814775,      -0.024618154,    0.003869309,
        -0.022631561,   -0.016269276,   -0.0050963215,   -0.032252897,    -0.023189886,
        0.012925829,    0.0114131635,   0.020774813,     -0.0087513905,   0.023060042,
        0.0004073811,   0.004128994,    -0.011380702,    -0.0065051136,   0.009088981,
        -0.02073586,    -0.01960623,    -0.035317183,    -0.010906777,    -0.0152045665,
        -0.013062164,   0.00046215844,  -0.01304918,     0.011666356,     -0.0006232444,
        0.012354522,    -0.016074512,   0.0056676287,    -0.0073036454,   -0.027344847,
        -0.0020872196,  0.023241822,    -0.0048398823,   -0.0028013538,   -0.022735436,
        -0.021385074,   -0.006673909,   -0.027864218,    -0.011601435,    -0.0028516678,
        0.0015378231,   0.0009989764,   0.025150508,     0.019450419,     0.0033823992,
        0.004401664,    -0.023215855,   -0.020320363,    -0.029604109,    0.023150932,
        0.013906141,    -0.005774749,   -0.010400391,    0.013321849,     -0.018333772,
        -0.01994382,    0.023423603,    -0.0051060594,   -0.023579413,    -0.0033531848,
        -0.019541308,   -0.039108586,   0.024994697,     -0.0026520349,   -0.010419867,
        -0.014295668,   -0.003573917,   -0.020891672,    -0.0060149576,   -0.01793126,
        0.0043107737,   -0.0020352826,  0.0063460562,    0.0021326644,    0.003022086,
        0.012880384,    0.025864642,    -0.008076209,    0.021047482,     0.009355159,
        0.018528536,    0.007641236,    -0.0002322965,   0.015464252,     0.026306108,
        0.023008106,    0.003820618,    0.013412739,     0.034797814,     0.009530446,
        -0.021125387,   0.02607239,     -0.0042977897,   0.015152629,     -0.016879536,
        0.009718717,    -0.036433827,   0.02957814,      -0.0066057416,   0.017723512,
        -0.020930624,   -0.011062589,   -0.019567277,    0.024929777,     0.029811857,
        -0.014256716,   -0.0053527607,  -0.020359317,    -0.003220096,    -0.0062616584,
        -0.0054306663,  0.0029944945,   0.005323546,     -0.013516613,    0.007985319,
        0.013399755,    0.010802903,    0.006024696,     -0.014061952,    0.0111859385,
        -0.008128146,   -0.017736496,   0.006492129,     0.00993945,      -0.005787733,
        -0.016451055,   -0.01256227,    0.02905877,      0.0062032295,    -0.0060571567,
        0.036148176,    0.019281624,    -0.021229262,    -0.014425511,    0.0028841284,
        0.027085163,    -0.023254806,   -0.0024296793,   0.019826962,     -0.022891248,
        0.0063168416,   -0.0060636485,  -0.0013641586,   -0.0051969495,   -0.0062194597,
        0.010387407,    0.0077256337,   0.020956593,     0.012445412,     0.018177962,
        -0.005339776,   0.0004374072,   0.004229622,     0.032850172,     -0.012815463,
        0.000551831,    -0.0010119607,  0.020593034,     -0.0011726408,   -0.0073101376,
        -0.0076022833,  0.011510545,    -0.025501084,    0.017528748,     0.0011020389,
        0.008095685,    0.004479569,    0.018606443,     -0.0017204143,   0.017658591,
        -0.024501296,   0.01036793,     0.01015369,      0.010880808,     -0.022293972,
        0.0005092264,   0.01558111,     -0.016853567,    0.02799406,      0.0069660544,
        -0.0062616584,  0.004671087,    -0.009173378,    0.00905652,      -0.001809681,
        0.030720755,    -0.009984895,   0.0327463,       -0.005232656,    -0.018009167,
        0.00055385975,  -0.0021781093,  -0.029188612,    0.004830144,     0.013010227,
        0.008381339,    -0.00786846,    0.0066609243,    -0.013399755,    -0.015074724,
        0.0106341075,   -0.002867898,   -0.0017333985,   -0.01795723,     -0.010043324,
        0.002718579,    -0.00553454,    0.022190098,     -0.00051166094,  -0.00028788534,
        -0.030149449,   -0.013153054,   -0.0170743,      0.108132906,     0.028565368,
        0.0113871945,   0.023228839,    0.018035134,     0.0064564226,    -0.032071117,
        -0.006836212,   0.0059467903,   -0.026319092,    0.020437222,     0.016061528,
        -0.017970214,   0.020294396,    -0.0041939155,   0.005021662,     0.010270548,
        -0.014438495,   -0.021592822,   -0.0026228202,   -0.012705097,    0.0063590407,
        0.023800146,    0.016593883,    -0.016230322,    -0.043471295,    -0.0044633388,
        0.020839734,    -0.018580474,   -0.005781241,    -0.019593246,    0.0011669602,
        0.0059045916,   0.014152842,    0.0025968517,    0.009004584,     0.0013024834,
        0.019800995,    0.030071542,    -0.007900922,    0.023657318,     0.0140489675,
        0.005933806,    -0.015295456,   0.008530658,     0.00081922556,   -0.004823652,
        0.02869521,     0.010614631,    -0.0036355923,   0.04482166,      -0.011432639,
        -0.0035479486,  -0.018528536,   0.018801207,     0.0044763233,    0.0023728732,
        -0.0049015577,  0.005170981,    0.007790555,     0.00920584,      -0.018840158,
        0.010776934,    -0.0047132857,  -0.0061642765,   -0.02003471,     -0.0026358045,
        -0.0049989396,  -0.013114101,   0.017346969,     0.008439768,     -0.027760344,
        -0.0012205202,  -0.013685408,   0.013159546,     -0.003221719,    0.0099069895,
        -0.016697757,   -0.0069206096,  0.015788859,     0.007816523,     -0.01890508,
        -0.006680401,   -0.00914741,    0.013945093,     0.011263844,     0.0027899926,
        -0.004323758,   -0.003012348,   0.011581958,     0.021086436,     -0.0006861369,
        -0.008855265,   0.01094573,     0.017944245,     -0.0011450492,   0.014191794,
        0.008835788,    -0.00005320503, 0.0069530704,    0.00792689,      -0.023371665,
        -0.016399119,   0.005132028,    0.0028987357,    0.0068621803,    -0.016970426,
        0.0056546447,   -0.0038465864,  -0.011497561,    0.009952434,     -0.019125812,
        0.011172954,    -0.017697545,   0.0016205978,    -0.01198447,     0.024657106,
        0.03781016,     0.018255867,    -0.0152045665,   -0.0023371666,   -0.008582595,
        0.032149024,    0.03832953,     -0.0075892988,   -0.001861618,    0.004219884,
        -0.035291214,   0.013607503,    -0.009997879,    -0.015126661,    0.014944881,
        -0.007284169,   0.02765647,     -0.038121782,    0.0053170538,    -0.0053462684,
        0.013114101,    0.0050508766,   -0.0037524507,   -0.025176477,    -0.008803328,
        -0.0009803115,  0.008517673,    -0.014321637,    -0.023319729,    0.00044755117,
        -0.0038011416,  -0.0071023894,  0.01408792,      -0.01716519,     -0.013737345,
        -0.016308228,   -0.01911283,    -0.011900073,    -0.055209067,    -0.017918276,
        0.00003973893,  0.015775874,    0.014295668,     0.021579837,     -0.0081995595,
        0.017606655,    0.008270972,    0.023605382,     0.010932745,     -0.0010395522,
        0.0031048607,   -0.050326984,   0.006290873,     0.01689252,      -0.0000105053305,
        0.0013414362,   -0.029993637,   0.013036195,     0.02869521,      0.0014128496,
        -0.0013625356,  0.0025075849,   -0.033135828,    -0.016788647,    0.009887513,
        -0.0011377457,  0.015438283,    0.0040056435,    -0.010958714,    0.052612215,
        0.0060604024,   -0.018074088,   -0.0013544204,   0.018333772,     -0.014931897,
        0.018593458,    -0.0015321425,  -0.008082701,    -0.011056096,    0.00713485,
        -0.009043536,   0.0041257483,   0.007082913,     0.006131816,     -0.008108669,
        0.010841856,    0.002668265,    -0.002165125,    0.039965548,     0.021151356,
        0.00014881177,  0.02750066,     -0.018061103,    -0.013932109,    -0.011828659,
        -0.008030764,   -0.024358468,   -0.0096797645,   -0.00019598115,  0.00047108514,
        0.020969577,    -0.04427632,    -0.017905293,    0.0005100379,    0.013503629,
        0.059831463,    0.026578777,    0.02329376,      0.03046107,      -0.02616328,
        -0.009958927,   0.017178174,    -0.00632658,     0.0115884505,    0.026241185,
        0.00884228,     -0.00564166,    -0.021203294,    -0.03845937,     -0.006992023,
        -0.013373786,   -0.023929989,   0.0008934793,    -0.0057065818,   0.0021521407,
        -0.0065083597,  -0.011192431,   0.0014777709,    0.022449782,     -0.025851658,
        -0.012270124,   -0.024475327,   0.0030431855,    -0.023254806,    -0.014983834,
        -0.016814614,   0.021203294,    0.009835576,     0.0026780032,    0.027864218,
        -0.011536513,   0.0042620827,   0.006784275,     -0.0017723512,   0.026539825,
        -0.01177023,    -0.016217338,   -0.0075892988,   -0.012763526,    -0.010173166,
        -0.010101753,   0.011309289,    0.025578989,     -0.021333136,    0.0024718782,
        -0.022774389,   0.0030951225,   0.01097819,      0.0074140113,    -0.010380914,
        -0.004067319,   -0.0002805817,  -0.0041549625,   0.018359741,     -0.0029912486,
        -0.023735223,   -0.0057487804,  -0.0087513905,   -0.0058559007,   -0.018242883,
        -0.0041452246,  -0.019034922,   -0.0053040697,   -0.0057065818,   -0.008731914,
        0.0065538045,   0.015009803,    0.01960623,      -0.0028240762,   -0.022293972,
        0.02695532,     -0.023852082,   0.0077775707,    -0.0010484789,   0.0038108798,
        -0.02405983,    0.0031081068,   0.017723512,     -0.029162643,    0.007900922,
        -0.013763314,   -0.021034498,   -0.012529809,    -0.014620275,    0.0020742354,
        -0.0049632327,  -0.021021515,   0.011224891,     -0.0051579964,   0.00009717906,
        -0.017892309,   -0.022190098,   0.024683075,     0.00936165,      0.013776298,
        0.01576289,     0.005576739,    0.008154114,     -0.015074724,    0.015256504,
        -0.0070244838,  -0.032174993,   0.01723011,      0.0010257564,    0.03427844,
        0.013269912,    -0.012698605,   -0.026877414,    -0.035447024,    -0.013633471,
        0.0259815,      0.0010290025,   -0.016061528,    0.010608139,     0.020021725,
        0.038900837,    -0.01924267,    0.0047067935,    -0.013633471,    0.012847924,
        -0.021813555,   -0.025669878,   -0.0245792,      0.01506174,      0.04217287,
        0.0005485849,   -0.0058137015,  -0.0481716,      0.007628252,     -0.031032378,
        -0.0038271102,  -0.012620699,   0.026085375,     0.03658964,      0.020787798,
        -0.0023225592,  0.022891248,    -0.008757882,    0.009614843,     0.007491917,
        -0.02082675,    0.014529385,    0.008459244,     0.013243943,     0.004271821,
        -0.0052099335,  -0.0038400944,  0.004083549,     0.015282472,     -0.03417457,
        0.011237876,    -0.030435102,   -0.0060604024,   -0.007965842,    0.021696696,
        0.011043112,    0.0076672044,   0.0010890546,    -0.01793126,     0.012036407,
        -0.009426571,   0.012068868,    -0.013425723,    -0.0035609328,   0.010744474,
        -0.0061448,     0.02835762,     0.016502993,     -0.016684772,    0.0056124455,
        -0.034538127,   0.0245792,      0.005187211,     -0.010296517,    0.012860908,
        0.019255655,    -0.02338465,    -0.022800358,    0.014983834,     0.003570671,
        -0.0017707283,  0.008621547,    0.018087072,     0.010750966,     -0.00612857,
        -0.0011028504,  -0.022904232,   0.017463828,     -0.0057552727,   0.012088344,
        -0.03482378,    0.012309077,    0.028097935,     0.009225315,     0.0018729792,
        -0.012841431,   -0.0038076336,  -0.009984895,    -0.018216914,    -0.0020028218,
        -0.017061315,   0.00031243372,  -0.007446472,    0.002613082,     -0.0240858,
        0.021787586,    0.0021310414,   -0.03417457,     0.02405983,      0.22021303,
        0.0015418807,   0.007894429,    0.01829482,      0.00431402,      0.034070693,
        0.010958714,    -0.0048139137,  0.0015775873,    -0.018087072,    -0.0050638607,
        0.0148020545,   0.011802691,    0.001330075,     0.0010249449,    -0.025890611,
        -0.024410406,   -0.007030976,   -0.0083488785,   -0.014892944,    0.008082701,
        0.014191794,    -0.0073880428,  -0.024890823,    0.021566853,     -0.020021725,
        -0.0083229095,  0.0010476673,   0.030720755,     0.018918063,     0.00008247033,
        -0.027007258,   -0.009095473,   -0.011296305,    -0.014334621,    0.0011134001,
        0.006985531,    0.008056732,    -0.008004795,    0.021449994,     0.000111989226,
        0.0254881,      0.012016931,    0.012296093,     -0.00276727,     0.0044406164,
        -0.011822167,   0.016178386,    0.0036031317,    0.0332397,       -0.046795268,
        -0.009063012,   0.01646404,     0.02634506,      -0.017333984,    -0.008946154,
        0.00040717822,  0.0143995425,   0.000113916576,  -0.010393899,    -0.022605594,
        0.019463403,    0.017528748,    0.032980017,     -0.01265316,     0.023073027,
        -0.027968092,   0.0002400059,   0.024644122,     -0.01915178,     -0.008193067,
        -0.026903383,   -0.022813343,   -0.009926465,    -0.0045769513,   -0.026241185,
        -0.002311198,   0.0044406164,   0.018580474,     -0.011977978,    0.0097057335,
        0.0025010929,   0.011361226,    -0.006232444,    -0.037732255,    -0.024410406,
        0.007550346,    0.00513852,     -0.020761829,    -0.006979039,    -0.008582595,
        -0.015022787,   0.0028484217,   0.0036842832,    0.00713485,      0.027864218,
        0.017295033,    0.0155291725,   -0.020619003,    -0.0025351765,   -0.013153054,
        -0.03012348,    -0.0063135955,  -0.0028370605,   -0.020995546,    0.016762678,
        -0.0053008236,  0.005476111,    0.022761405,     -0.0012708342,   0.00582344,
        -0.008037256,   0.006440192,    -0.02415072,     -0.010705521,    0.024540247,
        0.0009129557,   -0.001507797,   0.005631922,     -0.018035134,    -0.00014830458,
        -0.018931048,   0.003973183,    0.0070179915,    -0.013854204,    -0.020255443,
        0.017152205,    0.01469818,     0.0226835,       -0.018177962,    0.00393423,
        -0.029188612,   0.006222706,    -0.026721604,    0.010296517,     0.020722875,
        0.013276404,    -0.009192855,   -0.014568338,    0.0015288964,    0.014685196,
        0.009368142,    0.018320788,    0.018593458,     -0.0026763803,   -0.013146562,
        0.01637315,     0.0042263763,   -0.009855052,    0.000008584319,  -0.016736709,
        -0.037160948,   -0.017892309,   -0.011179446,    0.012192219,     -0.014659228,
        -0.039809737,   -0.01793126,    -0.01643807,     0.02100853,      -0.013055672,
        0.025747783,    0.0047003017,   -0.022787374,    0.0021992088,    0.009627827,
        -0.16547139,    -0.005089829,   0.03009751,      -0.016048543,    0.021151356,
        -0.010166674,   0.02189146,     0.009510969,     -0.012770018,    -0.006998515,
        -0.00573255,    0.00048244634,  -0.047730133,    -0.008134638,    -0.0072646923,
        0.0128933685,   0.0021294183,   0.012971274,     0.02302109,      0.0020222983,
        0.030331228,    0.008134638,    -0.012549286,    0.006673909,     0.040225234,
        0.01689252,     0.0017285293,   -0.018398695,    -0.0025367995,   -0.0016360165,
        -0.0055312943,  -0.014620275,   0.020372301,     -0.0073620747,   0.024306532,
        -0.015788859,   -0.01600959,    -0.011945518,    -0.0130946245,   -0.0020433976,
        -0.0012951797,  0.01115997,     0.03851131,      -0.010322485,    0.012614207,
        0.049963426,    0.0056059537,   0.011809183,     0.016217338,     -0.00984856,
        0.01924267,     -0.0229302,     -0.0034927656,   0.005878623,     0.030954473,
        0.02125523,     0.014750117,    0.012808971,     0.017567702,     -0.002259261,
        -0.021385074,   -0.0023939726,  -0.0038076336,   -0.030045575,    -0.017372938,
        -0.028643275,   -0.0023809883,  0.008647516,     -0.029915731,    0.008219035,
        -0.023150932,   -0.0032444415,  0.0016895767,    -0.000805024,    -0.009783639,
        0.013841219,    0.0014031114,   -0.0030269553,   0.008108669,     -0.010315993,
        -0.039030682,   0.017308017,    -0.001484263,    0.0040543345,    0.016827598,
        -0.011179446,   -0.014711165,   -0.011276828,    -0.019190734,    -0.012354522,
        -0.0100563085,  -0.0143995425,  -0.0057065818,   -0.0038433406,   0.016035559,
        0.0240858,      0.0035511947,   0.003976429,     0.020865703,     -0.00017508461,
        -0.00352198,    0.0011142116,   -0.035628803,    0.012568762,     0.030928504,
        0.027007258,    0.024098784,    0.017658591,     0.019839946,     0.004401664,
        -0.0027396786,  -0.0012894991,  -0.0044763233,   0.039653923,     -0.006336318,
        -0.001809681,   -0.004278313,   -0.015684985,    0.026981289,     0.0058137015,
        0.038407438,    -0.0064109773,  -0.034044724,    -0.00026435137,  -0.0021359106,
        -0.023137948,   -0.100186534,   0.0049599865,    -0.013451692,    0.007939874,
        -0.007095897,   0.007881445,    -0.00024994698,  -0.0036615608,   0.008361862,
        0.027344847,    -0.010010863,   -0.024449358,    0.015282472,     0.0026731342,
        0.006725846,    -0.015710952,   -0.023176901,    -0.012276616,    -0.02555302,
        0.004687317,    -0.01207536,    0.01643807,      0.020528112,     -0.008582595,
        -0.008037256,   -0.0036777912,  -0.020761829,    -0.005826686,    0.017489797,
        -0.005570247,   0.0037556968,   -0.01655493,     0.005875377,     -0.028565368,
        -0.0026844954,  0.0031048607,   -0.023787161,    0.012107821,     0.040692665,
        -0.027422754,   0.0013235828,   0.002208947,     0.002368004,     -0.02143701,
        0.005183965,    0.0043919254,   -0.019580262,    0.014581322,     0.012516825,
        -0.01911283,    -0.0271371,     0.0036355923,    -0.036511734,    0.0027899926,
        0.029136676,    -0.01646404,    -0.008387831,    -0.0074594566,   -0.0031551747,
        0.006544066,    0.008920185,    -0.0148020545,   -0.020541096,    0.020619003,
        -0.01445148,    -0.014308653,   -0.01698341,     0.012575254,     0.019684136,
        -0.028513432,   0.0021294183,   0.014659228,     -0.0041419785,   0.012575254,
        -0.041419785,   0.005469619,    -0.0094785085,   -0.008959138,    0.025163492,
        -0.027682438,   0.0039050158,   -0.010160182,    0.0091539025,    -0.023034073,
        0.015412315,    0.004317266,    -0.013763314,    -0.001207536,    0.0029036049,
        -0.0095044775,  0.013153054,    -0.0034018757,   -0.008615055,    -0.0017236603,
        -0.01569797,    0.016957441,    0.0023712502,    -0.0229302,      -0.0332397,
        -0.02189146,    -0.020424237,   -0.0010923008,   -0.07639938,     0.029214581,
        0.011874104,    0.0008593956,   0.0070114993,    -0.013373786,    0.029318456,
        -0.019930836,   -0.004586689,   0.016295245,     -0.015243519,    0.020839734,
        0.035161372,    -0.003564179,   -0.010471804,    -0.018424662,    -0.010841856,
        -0.010387407,   0.0020239213,   0.011620911,     -0.0028808822,   0.0059045916,
        -0.005521556,   0.014853992,    -0.013581534,    -0.01054971,     -0.008037256,
        -0.0017934507,  -0.0004556663,  -0.008413799,    0.013789282,     -0.016295245,
        0.013529597,    0.012925829,    -0.00009139701,  -0.010530233,    -0.007894429,
        0.0109846825,   0.015970638,    0.06320737,      -0.015191582,    -0.024747996,
        0.027552595,    0.0060831252,   -0.010491281,    0.00920584,      -0.019736072,
        0.005943544,    0.03009751,     0.008316417,     0.014931897,     0.021462979,
        -0.016515976,   -0.015191582,   -0.0032233421,   -0.009309713,    0.01890508,
        0.007920397,    -0.002200832,   -0.011640388,    0.03417457,      -0.0078035393,
        0.03292808,     0.019008955,    0.025877627,     -0.019437434,    -0.00018675016,
        -0.011114525,   -0.010932745,   -0.009608351,    0.00452826,      -0.016477024,
        0.009647304,    0.024903808,    0.0012262008,    0.0055150636,    -0.024345484,
        -0.019723088,   -0.019489372,   0.008439768,     0.0011150232,    0.0068037515,
        -0.044224385,   -0.012120805,   0.027240975,     -0.00008206457,  -0.012244156,
        0.012971274,    -0.0040997798,  0.016801631,     0.0048950654,    0.022358892,
        -0.018268852,   0.0055150636,   0.0012391851,    0.019450419,     -0.009335682,
        -0.0299417,     0.019645182,    0.010997667,     -0.015347393,    0.008504689,
        -0.0006256789,  -0.0099069895,  -0.014412527,    0.0011726408,    -0.028331652,
        -0.036693513,   -0.0104588205,  0.0028289452,    0.007848985,     -0.008303433,
        -0.01637315,    0.01569797,     -0.022774389,    -0.024799934,    -0.005339776,
        -0.02030738,    -0.0100628,     0.013555566,     0.0044925534,    -0.00826448,
        0.01845063,     -0.022488736,   0.009829083,     0.002962034,     0.044536006,
        -0.0067128614,  -0.011789707,   -0.018502569,    0.011504053,     -0.00046094117,
        -0.011517037,   -0.005943544,   -0.002561145,    -0.009316205,    0.0030821383,
        0.019476388,    -0.047340605,   0.056091994,     -0.014711165,    -0.002968526,
        0.009510969,    -0.0229302,     0.015321425,     0.01417881,      0.025812706,
        -0.015723936,   -0.011315781,   -0.008835788,    -0.0043594646,   0.048613064,
        0.014074936,    -0.02048916,    0.015165614,     0.023891035,     0.0045996737,
        -0.00062080985, 0.0010598401,   0.035654772,     -0.0044568465,   0.029318456,
        0.005842916,    -0.02451428,    0.012588238,     0.010997667,     0.0027867465,
        -0.0021034498,  -0.030564943,   0.010880808,     0.0048561124,    -0.029682014,
        -0.0045120297,  0.023124965,    -0.023280775,    0.019619213,     -0.010841856,
        0.016451055,    0.015360378,    -0.016074512,    0.03344745,      -0.0092383,
        -0.009569398,   -0.013984046,   0.009673272,     -0.017619638,    -0.015840795,
        -0.010121229
    ],
    [
        -0.010552211,   -0.03476334,    -0.0106317,      0.0066241124,   0.0022720706,
        0.025714803,    -0.0025270989,  -0.0092008915,   0.00040945294,  -0.027476817,
        0.012638806,    0.010022282,    0.0021313082,    -0.016109841,   0.012221487,
        0.0049217152,   0.03214019,     -0.01201614,     0.01947489,     -0.017673131,
        -0.00425268,    0.0054185237,   -0.014586295,    0.007419006,    -0.006789715,
        -0.006408829,   0.020799713,    -0.016507288,    0.014215345,    0.008220524,
        -0.0036730703,  -0.017037217,   0.012830906,     -0.028324705,   -0.016692763,
        -0.007882694,   0.008796821,    -0.013380707,    0.0058093467,   -0.003885042,
        0.019156933,    -0.00016405027, -0.012247983,    -0.010048779,   -0.014904252,
        -0.010565459,   0.0036134531,   -0.026310975,    -0.027794775,   0.010870168,
        0.018295798,    0.011181502,    0.003116645,     0.003184542,    -0.01649404,
        0.019050946,    0.0034644108,   0.00067648746,   0.01448031,     0.009929544,
        0.01955438,     0.0005945141,   -0.0023714323,   -0.03028544,    -0.004295737,
        -0.0041765026,  -0.011843912,   0.009452608,     -0.020283032,   -0.012956764,
        0.03940022,     0.013367458,    -0.0018464713,   -0.005683488,   0.0064585092,
        -0.005921956,   -0.016745755,   0.0061802967,    0.00032768655,  0.004891907,
        0.008233772,    -0.027768278,   -0.0018779358,   0.033014577,    0.019130437,
        0.003123269,    -0.020177046,   0.021700593,     -0.020097557,   -0.023555344,
        0.013201856,    -0.0006371568,  -0.0002707606,   0.0135595575,   0.018150067,
        -0.025860535,   -0.017090209,   0.023409612,     -0.0048057935,  -0.023674577,
        -0.010499218,   0.03216669,     0.0023664641,    -0.008743828,   -0.013480068,
        -0.0147187775,  0.011578948,    -0.017858606,    0.02060099,     0.014811515,
        -0.0136986645,  0.02417801,     0.016017104,     -0.024336988,   0.014665784,
        -0.024072023,   0.007823077,    0.008511985,     0.008114537,    0.004126822,
        0.021197159,    0.03349151,     -0.024906661,    -0.011698183,   0.007326268,
        0.021660848,    -0.009850055,   -0.011035771,    -0.01275804,    -0.015805133,
        0.010101771,    -0.0054549566,  0.01805733,      0.013201856,    -0.028033243,
        0.02424425,     -0.058981095,   -0.021223655,    -0.0072335307,  -0.028483683,
        0.013486693,    0.036220647,    -0.032802604,    0.0044779,      0.0030305313,
        -0.0028086237,  0.025317358,    0.0009199236,    -0.0021594607,  -0.015858125,
        0.020230038,    -0.016984224,   0.0136986645,    -0.027556308,   0.02843069,
        0.013552934,    -0.004663375,   0.007664098,     -0.015526919,   0.008531856,
        0.01448031,     0.028086236,    -0.013486693,    -0.015871372,   -0.002007106,
        0.023422861,    0.0026844216,   -0.0026032762,   -0.010982778,   -0.020574493,
        -0.014122607,   0.012625558,    -0.030576902,    0.014069614,    0.0024542336,
        0.00765085,     0.005534446,    0.0048819706,    -0.0045441412,  -0.013115742,
        0.003835361,    -0.0030884924,  0.022336507,     0.022071542,    -0.021329641,
        0.009485729,    -0.027582804,   0.010525715,     0.012565941,    -0.017487656,
        -0.005322474,   0.024535712,    0.0039777793,    0.010883416,    -0.6689823,
        -0.024005784,   -0.028748646,   0.00053199905,   -0.012923643,   0.005011141,
        -0.00007431426, -0.0035637724,  0.012433459,     -0.005656992,   -0.00212634,
        0.0141756,      -0.01287065,    0.009903048,     -0.004842226,   -0.0132416,
        0.0034246661,   -0.04173191,    -0.011625317,    0.010578707,    -0.0029808504,
        0.029887995,    0.009724197,    -0.007955559,    0.004312297,    -0.0014904252,
        0.011936651,    -0.002177677,   -0.0067367223,   0.0010474378,   -0.009929544,
        0.03865832,     0.004845538,    0.014162352,     0.054900642,    -0.008220524,
        0.0014473685,   0.039294235,    0.013778154,     0.008419246,    -0.035955682,
        -0.013632423,   0.0058855237,   -0.0043950984,   -0.019753102,   0.0042559924,
        0.015328196,    0.0037293753,   -0.007326268,    0.018242804,    -0.0005460752,
        0.019514635,    -0.0022538542,  -0.0104859695,   0.012950139,    -0.015049983,
        0.038260873,    -0.016189331,   -0.0032590632,   -0.0052198004,  -0.009320126,
        -0.0083331335,  0.006190233,    -0.00017295143,  -0.0045640133,  0.023926293,
        -0.0029642903,  0.03791642,     0.02448272,      -0.0034478505,  0.006776467,
        0.014599543,    0.0046865596,   0.0021130918,    -0.007856197,   0.0034644108,
        0.024045527,    0.040195115,    -0.001059858,    0.007001687,    0.009916296,
        -0.016229074,   -0.009359871,   -0.0016866645,   0.030921357,    -0.014016622,
        -0.013162111,   0.02559557,     0.0051568714,    -0.010194508,   -0.019408649,
        0.026178492,    -0.025251117,   0.0058225947,    0.015089728,    0.013619175,
        -0.0054814527,  0.017103458,    0.013857643,     -0.04202337,    0.016613273,
        -0.008015176,   0.01702397,     -0.014109359,    -0.0039115385,  -0.013023005,
        -0.00731302,    -0.0046699992,  0.045123454,     -0.023780564,   0.018759485,
        0.0020319463,   -0.013142238,   -0.01836204,     -0.030762378,   -0.018746238,
        0.027132364,    0.0073925094,   0.030682888,     -0.031212818,   -0.015208961,
        0.035478745,    -0.0113802245,  -0.009028665,    0.0025254427,   0.011923402,
        -0.025224619,   -0.0032839037,  -0.020773215,    0.0062862826,   0.016282069,
        0.006789715,    0.0054052756,   -0.019832592,    0.014679032,    -0.019647118,
        0.011658438,    0.0010209413,   0.027423825,     -0.012254608,   -0.010512467,
        0.013738409,    0.008723956,    0.008465615,     -0.005136999,   -0.010591956,
        0.00014573048,  -0.010399857,   -0.029146094,    0.013990125,    -0.01858726,
        -0.012592438,   -0.017620139,   0.010287247,     0.001535138,    0.007611105,
        0.007544864,    0.0021048116,   -0.007856197,    -0.0027655668,  0.016732508,
        0.0124997,      -0.029146094,   0.029808505,     0.011009275,    -0.0094658565,
        0.0056503676,   0.01902445,     -0.0051701195,   -0.030338435,   -0.009154523,
        -0.032299172,   -0.01357943,    0.023303626,     0.0020799714,   0.0028616164,
        -0.020508252,   -0.0045772614,  -0.043719143,    0.001649404,    -0.011280864,
        0.0023234074,   -0.015116224,   -0.0009025353,   0.03081537,     0.009061785,
        0.024509216,    0.020468507,    0.022217272,     0.016189331,    -0.030921357,
        0.020322777,    0.020190295,    -0.0068427077,   -0.006425389,   -0.005666928,
        0.029808505,    0.011605444,    -0.006713538,    0.0253836,      0.011234495,
        -0.016586777,   0.02625798,     -0.005713297,    -0.0011525955,  -0.037121527,
        0.021833073,    -0.032723114,   0.03388896,      0.013658919,    0.02515838,
        -0.020468507,   -0.0063492116,  -0.019050946,    0.028907625,    0.024906661,
        0.014268338,    -0.006246538,   -0.0078098285,   -0.0018216309,  -0.017474407,
        -0.025502833,   -0.008776949,   -0.005829219,    -0.0016701043,  -0.0067069135,
        0.0054383962,   -0.008657714,   0.008558353,     -0.009512225,   -0.003596893,
        0.0033551129,   -0.011983019,   0.015884621,     -0.018401783,   -0.03081537,
        0.006789715,    -0.025635315,   0.018097075,     0.0072732754,   0.003825425,
        0.024072023,    0.019064195,    -0.007001687,    -0.008465615,   0.0058093467,
        0.006915573,    0.02058774,     -0.0047991695,   0.0012701736,   -0.0116451895,
        0.01694448,     0.0052131764,   0.012334097,     0.013268097,    -0.03574371,
        0.009538721,    0.012923643,    0.023369867,     0.019355657,    -0.0046501267,
        0.007783332,    -0.010419728,   -0.0006607552,   0.046607252,    0.011863785,
        0.017394919,    0.015765388,    -0.012208239,    -0.010863544,   0.000472382,
        -0.011572324,   -0.011578948,   -0.017487656,    0.0026628932,   -0.0029775384,
        -0.011413345,   -0.014983742,   0.016136337,     0.026244733,    -0.014811515,
        -0.03486933,    0.030947853,    0.009386367,     -0.0027804712,  -0.007240155,
        0.003610141,    0.010962905,    0.0075249914,    0.0139503805,   0.01320848,
        0.0020882513,   0.010797303,    -0.011400097,    -0.002836776,   -0.002063411,
        0.01879923,     -0.027556308,   0.02223052,      -0.026734916,   0.007140793,
        0.0061074314,   -0.016838493,   -0.03857883,     -0.00027490067, -0.00824702,
        -0.012340721,   -0.020998435,   -0.00036370516,  -0.023184393,   -0.014652536,
        -0.005915332,   -0.018666748,   -0.026973385,    -0.011155005,   -0.0027887512,
        -0.0041036378,  0.016070096,    0.0257413,       0.0124135865,   -0.0032723115,
        -0.012850778,   -0.022561727,   0.0016303597,    0.1224136,      0.025436591,
        0.00963146,     0.0013099182,   0.010240878,     -0.016441047,   -0.025781045,
        -0.021501869,   0.00531585,     0.019739855,     0.020243287,    -0.024350237,
        -0.003947971,   0.025648562,    0.0077502113,    0.0016916327,   -0.0010739343,
        -0.016202578,   0.0025718117,   -0.027317839,    0.018428281,    0.012877274,
        0.009147899,    0.024058776,    -0.0052131764,   -0.032564137,   -0.004822354,
        0.019819343,    -0.009359871,   0.0019044323,    -0.021753585,   -0.01153258,
        -0.016878238,   0.02582079,     -0.005084006,    0.007902566,    0.012572565,
        0.011930026,    0.0038717936,   0.00079530745,   0.029755512,    0.013937132,
        0.012214863,    -0.006021318,   -0.0067499704,   -0.004302361,   -0.0136986645,
        0.018931713,    0.010810551,    -0.021435628,    0.063167535,    0.011724679,
        -0.004971396,   -0.0014217001,  0.037889924,     0.01834879,     -0.0017255812,
        0.013135615,    -0.015341444,   0.041917384,     0.006375708,    -0.026019514,
        0.010141516,    -0.010724437,   0.007948935,     -0.026019514,   -0.01633506,
        -0.010737686,   -0.003835361,   0.0065777437,    -0.008935927,   -0.027119115,
        -0.00858485,    -0.008525233,   0.019289415,     0.012632182,    0.011797544,
        -0.017421415,   0.0131819835,   0.019130437,     -0.017620139,   -0.025900278,
        -0.009273757,   -0.016215827,   0.004272552,     0.020547995,    -0.0066472967,
        0.0034246661,   -0.016626522,   0.008293388,     0.024350237,    0.020203542,
        0.003779056,    -0.0025502832,  0.01670601,      0.0052893534,   -0.008737204,
        -0.007869446,   -0.016997471,   0.009604963,     0.007207034,    -0.029517043,
        -0.017143203,   -0.016507288,   0.009121402,     -0.0019806095,  -0.018984705,
        -0.008690835,   -0.007942311,   0.0015599785,    0.004080453,    -0.016282069,
        -0.010929786,   0.0231314,      -0.014003374,    0.00248073,     0.0014846291,
        0.025449838,    0.005441708,    -0.005183368,    -0.0041765026,  -0.004971396,
        0.02007106,     0.030841867,    -0.013778154,    -0.0019027763,  0.017116707,
        -0.025635315,   0.025118634,    -0.0025635315,   -0.0018547515,  0.0035306518,
        0.0012925299,   -0.017447911,   -0.041890886,    -0.0011410033,  -0.010413105,
        -0.010830424,   -0.015089728,   -0.0064551975,   -0.017792366,   -0.0020203541,
        -0.010525715,   -0.028616166,   0.0069751902,    -0.03036493,    0.0030719321,
        -0.0025535952,  -0.0023333435,  0.03126581,      -0.01425509,    -0.011075515,
        -0.007849573,   0.0019855776,   0.010525715,     -0.0387908,     -0.011373601,
        -0.014798267,   0.028987115,    0.007842949,     0.024191258,    -0.0102342535,
        0.02672167,     0.01108214,     -0.0012560973,   0.0039049143,   0.0015003615,
        0.006365772,    -0.036989044,   0.043772135,     0.019594124,    0.04297724,
        0.007445502,    -0.013109118,   -0.0035836447,   0.014877756,    0.000014322055,
        -0.009505601,   -0.02103818,    -0.024045527,    -0.0016808684,  -0.002007106,
        -0.015778635,   0.007842949,    -0.015261955,    -0.015990607,   0.02015055,
        -0.011413345,   0.013082622,    0.0052429847,    0.025555825,    -0.015844876,
        0.008121162,    -0.0111285085,  -0.0144538125,   0.021091174,    -0.006140552,
        -0.00053986517, -0.0025237869,  0.009306878,     -0.0016792124,  -0.0036730703,
        0.017037217,    -0.013990125,   -0.013910635,    0.029146094,    0.015129472,
        -0.02603276,    0.020004818,    -0.0042891125,   -0.029225584,   -0.019965075,
        -0.011135133,   -0.041943878,   -0.017765868,    -0.021369386,   -0.030099966,
        0.020495003,    -0.030232448,   -0.008750453,    -0.002482386,   -0.0042758645,
        0.01828255,     -0.0038651696,  0.030338435,     0.022694208,    -0.009267133,
        -0.0042162472,  0.023515599,    -0.01224136,     -0.020057812,   0.011247743,
        0.011439842,    -0.008531856,   -0.010492594,    -0.017487656,   0.008644466,
        -0.060464896,   -0.010028906,   -0.0013438668,   0.01227448,     0.0022041732,
        -0.022296762,   -0.015791884,   -0.0006433669,   0.023012167,    -0.038631823,
        0.011022523,    -0.010896665,   0.002291943,     -0.03571721,    -0.00977719,
        0.020759968,    0.0027258222,   0.001829911,     0.0028516804,   0.018600507,
        -0.0029626342,  -0.0072732754,  -0.010525715,    0.00029104692,  0.040857524,
        -0.014069614,   -0.0012850778,  0.0016361558,    -0.015831629,   0.0034445385,
        -0.011559076,   -0.0008669307,  0.02633747,      0.0063856444,   0.0071805376,
        -0.012440083,   0.021223655,    0.0012155246,    0.011400097,    -0.0065843677,
        -0.010353488,   -0.002361496,   -0.010651573,    0.014414068,    0.0010921505,
        -0.0040572686,  -0.0029427619,  -0.013764906,    -0.0136854155,  -0.02074672,
        -0.011843912,   0.0020501628,   -0.008829942,    -0.01257919,    -0.012797785,
        -0.0030421235,  0.028112732,    0.010287247,     -0.0060743107,  0.006359148,
        0.016454294,    -0.027503313,   0.0019011202,    -0.0013902356,  -0.0055708783,
        -0.017487656,   0.02074672,     0.012552693,     0.011188125,    0.028404193,
        -0.02148862,    0.0008718988,   0.016282069,     -0.015699146,   -0.0108767925,
        -0.009803686,   -0.0075117433,  -0.004646815,    -0.011877033,   -0.0024956344,
        -0.0118969055,  0.006667169,    -0.0010938066,   0.02201855,     -0.010002409,
        0.03296158,     -0.032219682,   0.017474407,     0.017752621,    0.013122367,
        -0.023966039,   -0.017527401,   -0.00963146,     -0.018242804,   0.0061538005,
        0.0008404342,   -0.0059385165,  -0.0010896665,   -0.022270266,   0.0008702428,
        0.028218718,    -0.002407865,   -0.022429245,    0.0031646697,   0.016679514,
        0.0131819835,   0.007862821,    -0.0067300983,   0.012738168,    -0.024456222,
        -0.01738167,    -0.028695654,   -0.022667712,    -0.017090209,   0.027476817,
        0.002651301,    -0.025582321,   -0.034233414,    0.01783211,     -0.018931713,
        -0.021740336,   -0.017408168,   0.016626522,     0.024959655,    0.0016278756,
        0.010009034,    0.0205215,      0.00032913557,   0.0069553177,   -0.02723835,
        -0.012320849,   0.010956282,    -0.0077104666,   0.015924366,    0.02515838,
        -0.034816336,   -0.023396365,   0.01850777,      0.014612792,    -0.014891004,
        0.016467543,    -0.017752621,   -0.010479346,    -0.0070546796,  0.0038154887,
        0.0031050525,   0.0042328076,   0.009167772,     -0.027291343,   0.010591956,
        0.0029940987,   -0.00085865054, -0.027264846,    -0.016600026,   0.009412863,
        0.0023167832,   0.023528846,    -0.019541131,    -0.001001897,   -0.02037577,
        -0.01320848,    0.023157896,    -0.016109841,    -0.0088233175,  0.02074672,
        0.007306396,    -0.042791765,   -0.010479346,    0.017355174,    -0.0028135916,
        -0.014559799,   0.0126918,      -0.00884319,     0.0028516804,   -0.015195713,
        0.010095147,    -0.007955559,   0.0104859695,    0.008081417,    0.015155969,
        -0.007869446,   0.02670842,     0.030258944,     -0.017275685,   0.000050224226,
        -0.012744792,   0.0077237147,   -0.02201855,     -0.02798025,    0.0040572686,
        0.006534687,    -0.028192222,   -0.003835361,    -0.019368904,   -0.020680478,
        0.0010656541,   -0.017341927,   -0.042765267,    -0.0033402087,  0.22998917,
        -0.0020799714,  -0.018415032,   0.047773097,     0.009028665,    0.00041959612,
        0.012320849,    0.0060610627,   -0.0144670615,   -0.012546069,   -0.022031797,
        0.004352042,    -0.009300253,   -0.004173191,    -0.011744551,   -0.0063392753,
        -0.019541131,   0.009141275,    -0.0009911328,   -0.020177046,   0.007438878,
        0.0052264244,   -0.021621102,   -0.024098521,    0.04035409,     -0.0013074342,
        0.010307118,    -0.0011410033,  0.0063061547,    0.008882934,    0.012638806,
        -0.012850778,   -0.007776708,   -0.0042228717,   0.00576629,     -0.0048687225,
        0.018666748,    0.01051909,     0.0099825375,    0.018534265,    0.021475373,
        0.013778154,    0.016109841,    0.002058443,     0.003245815,    0.027556308,
        -0.0085716015,  0.00943936,     -0.0149704935,   0.0025999642,   -0.029411059,
        -0.0017934784,  0.02723835,     0.023210889,     -0.011930026,   0.010042154,
        0.0075978567,   0.019236421,    -0.014096111,    -0.026125498,   -0.0006624112,
        0.021422379,    -0.0035339638,  0.028907625,     -0.018785981,   0.026615683,
        -0.027927257,   -0.0029907867,  0.023462605,     -0.01074431,    -0.018375287,
        -0.01085692,    -0.005007829,   -0.006428701,    -0.013380707,   -0.019673614,
        0.022296762,    -0.031663258,   0.0085716015,    0.003722751,    0.01425509,
        0.001588131,    -0.005527822,   -0.01108214,     -0.022521982,   -0.03081537,
        0.015619657,    0.01679875,     -0.01857401,     -0.0034776588,  0.013857643,
        -0.026390463,   -0.008942552,   -0.010691317,    0.016864989,    0.021965556,
        0.0092008915,   0.035346262,    0.0068758284,    0.0026711733,   -0.020879202,
        -0.019792847,   0.011141757,    0.017103458,     -0.03388896,    -0.003242503,
        -0.0111285085,  0.002426081,    0.027370831,     -0.0089491755,  0.0052231126,
        0.004358666,    0.003666446,    -0.018110324,    -0.011910154,   0.005246297,
        -0.0024608576,  -0.009763941,   -0.013923884,    -0.013360835,   -0.018415032,
        -0.024734436,   -0.016825246,   0.01567265,      0.010678069,    -0.016586777,
        0.015513671,    -0.0008611346,  0.026549442,     -0.018494522,   0.029993981,
        -0.0088233175,  -0.0011906842,  -0.023568591,    -0.0003421768,  0.025317358,
        0.026801158,    -0.008001927,   -0.005951765,    0.012459955,    0.021992052,
        -0.0071076723,  0.026814407,    0.014427316,     -0.001238709,   -0.015765388,
        0.01257919,     0.0017885104,   -0.009445984,    -0.011731302,   -0.019859089,
        -0.017739372,   0.0018994642,   -0.022694208,    0.011810793,    -0.012261231,
        -0.035982177,   -0.017726125,   0.007664098,     0.013075998,    -0.042659283,
        0.009373119,    0.0032607194,   -0.013168735,    0.01462604,     -0.012473203,
        -0.1701072,     0.01932916,     0.0023747443,    -0.007902566,   0.03343852,
        0.015738891,    0.01312899,     -0.008160906,    -0.008631218,   -0.0012560973,
        0.01783211,     -0.0029725705,  -0.028165726,    -0.006776467,   -0.0003649472,
        0.04162592,     -0.0051999283,  0.024535712,     0.038631823,    0.0011873721,
        0.026893895,    -0.005070758,   -0.006296219,    -0.0020998437,  0.011877033,
        0.039638687,    0.0072666514,   -0.011824041,    -0.0053820913,  -0.008598098,
        -0.03341202,    -0.020985188,   0.0080218,       0.0021097797,   0.03820788,
        -0.012002892,   -0.0036134531,  0.013175359,     -0.005070758,   0.029782008,
        0.022204025,    0.018030833,    0.010883416,     0.0028649285,   0.008439119,
        0.043295197,    -0.0004077969,  0.0104859695,    0.0083198855,   -0.0086974595,
        0.004888595,    0.00059699814,  0.01932916,      -0.002594996,   0.013393955,
        0.051429607,    -0.00063467276, 0.018905217,     0.005640432,    -0.022415996,
        0.007419006,    -0.0029940987,  0.019130437,     0.00623329,     -0.020336024,
        -0.0065214387,  0.0075051193,   0.0031712938,    -0.037333496,   0.016467543,
        -0.015579912,   -0.0032259426,  -0.0023333435,   -0.018772734,   0.003951283,
        -0.002192581,   -0.008081417,   0.0060047577,    0.0059749493,   -0.00081683585,
        -0.02991449,    0.023078406,    -0.0090882825,   -0.0115657,     0.018481273,
        0.018110324,    0.017726125,    -0.025410095,    -0.00029001193, -0.007021559,
        0.011890282,    -0.022733953,   -0.0058225947,   -0.019951826,   -0.0026678613,
        0.018931713,    0.017633386,    0.0036929427,    0.021992052,    -0.0024393294,
        -0.01074431,    0.0037889923,   -0.0016974288,   0.022641215,    0.01227448,
        0.020945443,    0.021660848,    -0.004295737,    0.03455137,     -0.028563172,
        -0.0020236664,  -0.0014895973,  0.03751897,      0.028669158,    -0.010797303,
        0.026099002,    0.001829911,    -0.01738167,     0.019435145,    -0.02603276,
        0.05238348,     0.020865954,    -0.009750693,    0.022415996,    -0.02582079,
        -0.01633506,    -0.108370475,   -0.010664821,    -0.01746116,    0.0026860775,
        -0.00995604,    0.0335975,      0.008518608,     -0.0051038787,  0.0019839215,
        -0.0024409853,  -0.012459955,   -0.012327473,    -0.019156933,   -0.019315911,
        0.017898351,    -0.010075275,   -0.013009757,    -0.0015690866,  -0.010015658,
        0.016083345,    -0.024429725,   0.001653544,     0.0007162321,   -0.008326509,
        0.0035140915,   -0.0013595991,  -0.03799591,     0.0026330845,   0.01235397,
        0.013499941,    0.020932194,    -0.0022223897,   0.0034942192,   -0.009333374,
        -0.011506083,   -0.014559799,   -0.029729016,    0.016414551,    0.023330124,
        -0.032749612,   0.015937613,    -0.0040307725,   0.011459714,    -0.02529086,
        -0.013513189,   0.002664549,    -0.018242804,    0.01402987,     0.01858726,
        -0.010943034,   -0.021157414,   -0.0096977,      -0.030338435,   -0.007823077,
        0.048620984,    -0.004239432,   -0.005584127,    -0.007551488,   -0.0035902688,
        -0.010009034,   0.01723594,     -0.022283513,    -0.025131881,   -0.015314948,
        -0.017355174,   -0.011930026,   -0.0048587862,   0.008551729,    0.015010239,
        -0.021303145,   -0.0057431054,  0.0022257017,    -0.0036796944,  0.003775744,
        -0.014838012,   -0.00010671031, -0.018189812,    -0.016639771,   0.015049983,
        -0.018150067,   -0.003947971,   -0.024045527,    0.01108214,     -0.018017584,
        0.006537999,    0.00650819,     -0.009194268,    0.0035637724,   0.010903289,
        -0.0152354585,  0.00083463814,  0.0048654103,    0.009803686,    -0.014559799,
        -0.009770566,   0.010770806,    -0.024986152,    -0.012599061,   0.010883416,
        0.008458992,    -0.031822234,   0.0014241842,    -0.06682404,    0.025661811,
        0.0077568353,   0.012877274,    -0.01559316,     -0.01991208,    0.03852584,
        -0.005521198,   -0.021395883,   0.0074984953,    -0.013990125,   0.03910876,
        -0.0024641699,  -0.013619175,   0.0022704145,    -0.019859089,   0.0023747443,
        -0.005898772,   0.015752139,    0.015844876,     -0.017341927,   -0.014785019,
        0.005656992,    0.014943997,    0.0024409853,    0.009426111,    0.005902084,
        0.008213899,    0.00081931986,  -0.0017156451,   0.0033104,      -0.025608817,
        0.01003553,     0.002003794,    -0.013976877,    0.0081807785,   0.000105261286,
        0.0045143324,   0.018216308,    0.033173554,     -0.032776106,   -0.018706493,
        0.008531856,    -0.021157414,   -0.018044082,    0.014652536,    -0.018997954,
        0.0034379142,   0.03910876,     -0.0018944961,   0.030099966,    0.02424425,
        0.0009778846,   -0.007445502,   -0.0118969055,   -0.021448875,   0.04154643,
        -0.008141034,   -0.01290377,    -0.020508252,    0.017076962,    -0.011850537,
        0.0120227635,   -0.0060378783,  0.010439601,     -0.027503313,   -0.013751657,
        0.00048687225,  0.0052992897,   -0.02970252,     0.0013281346,   0.0008495424,
        -0.005859027,   0.010638325,    -0.001358771,    0.016626522,    -0.010379984,
        -0.017938096,   -0.017209444,   0.022800194,     -0.0053489706,  0.0056868005,
        -0.03253764,    -0.013228352,   0.026814407,     0.015407685,    -0.0042328076,
        -0.006183609,   0.0057596657,   0.009101531,     0.0160436,      0.019302662,
        0.010240878,    0.021886067,    0.0014250121,    0.023436109,    -0.007915814,
        -0.0083066365,  -0.003610141,   0.013817898,     -0.0055940626,  0.008008552,
        0.011784296,    -0.022707457,   0.002192581,     0.001944177,    -0.01813682,
        -0.016600026,   0.00053531106,  0.008969048,     0.017143203,    -0.0066539207,
        0.010697941,    0.02231001,     -0.0046998076,   -0.0027970313,  -0.017977841,
        -0.02723835,    -0.00779658,    0.027741782,     -0.0026777973,  0.0052827294,
        0.016003855,    -0.015195713,   0.012380466,     0.024376733,    0.009916296,
        -0.01783211,    0.0034379142,   -0.00035004294,  0.0012817658,   0.010134892,
        -0.018772734,   -0.006802963,   0.009094906,     -0.005133687,   -0.017845359,
        0.008372878,    -0.0041003255,  0.039585695,     0.013340962,    0.009975913,
        -0.002291943,   -0.026986632,   0.024760932,     0.0028533363,   0.011618693,
        -0.00073486246, -0.0044017225,  -0.000070536444, -0.016096592,   0.016507288,
        -0.0013057782,  -0.014361075,   0.032219682,     -0.029543541,   -0.014957245,
        -0.012479828,   -0.017951345,   0.016666267,     -0.006435325,   0.025781045,
        0.001472209,    -0.028192222,   0.000078920086,  -0.011486211,   0.006415453,
        0.016109841,    -0.013844395,   0.009492353,     0.0009828527,   -0.020243287,
        -0.00768397,    0.00084002025,  -0.007213658,    0.0027589428,   -0.0073527647,
        -0.00578285,    0.011512707,    -0.038817298,    0.009194268,    -0.024760932,
        -0.008651091,   -0.017209444,   0.0070480555,    -0.006090871,   0.0013852675,
        -0.0044547156
    ],
    [
        0.0045611933,   -0.00776415,     0.020242948,    -0.032440957,   -0.022476202,
        0.00042975452,  -0.024317658,    0.031892437,    -0.009168097,   -0.022541502,
        -0.010911602,   0.032623798,     -0.010108414,   -0.008175539,   -0.005080327,
        -0.00092725764, 0.022110524,     -0.01164296,    0.020504147,    -0.018793292,
        -0.0072939913,  -0.00043710077,  0.004672203,    0.023442639,    -0.0024911887,
        -0.016207417,   0.0017973778,    -0.025088195,   0.020020928,    0.0021859119,
        -0.0041857194,  0.0019802174,    -0.025088195,   -0.0055243657,  -0.008136359,
        -0.010101884,   -0.005553751,    -0.0038298352,  0.005439476,    0.0016365771,
        -0.0014129251,  0.013569305,     -0.0026136257,  -0.010258604,   -0.025780374,
        -0.0066769077,  -0.0055178357,   -0.0076727304,  -0.025271036,   0.01923733,
        0.025310215,    -0.019224271,    0.0056549655,   -0.032702155,   0.02290718,
        0.014640222,    -0.014457383,    -0.011087911,   0.005726795,    -0.0043914136,
        0.013882744,    -0.012563688,    -0.008573868,   0.007352761,    -0.017082436,
        -0.01992951,    -0.022123583,    0.0098341545,   -0.013843564,   0.0053872364,
        0.03186632,     0.017108556,     0.012047819,    0.0011141783,   0.018584331,
        -0.022110524,   -0.012302488,    -0.015149561,   -0.019864209,   0.0043554986,
        0.0158548,      -0.017918274,    -0.0041628643,  -0.003457626,   0.0099321045,
        0.0030446048,   -0.025362454,    0.002275699,    -0.017552596,   0.012668167,
        0.024996776,    0.009285636,     -0.02356018,    0.011042202,    0.003490276,
        -0.0005856579,  -0.001376194,    0.008071059,    -0.010167184,   -0.047668878,
        -0.0031833667,  0.0068826023,    -0.017173856,   -0.011009552,   -0.0014194552,
        -0.012028229,   0.033459634,     0.010336963,    0.016533917,    0.0061479793,
        0.011140151,    0.01930263,      0.03570595,     -0.024461318,   0.010330433,
        -0.016520858,   0.028784167,     -0.0082538985,  0.017173856,    -0.030429723,
        0.002900945,    -0.0072221616,   0.006474478,    -0.0037449454,  0.000810126,
        -0.0033400864,  -0.016155178,    -0.022280302,   -0.00008718548, 0.0132036265,
        0.014365963,    0.0067128227,    -0.0040192045,  -0.017526476,   0.010461033,
        0.002927065,    -0.0018496178,   0.0317096,      -0.005485186,   -0.014640222,
        0.012485328,    0.028653566,     -0.037194785,   0.007365821,    -0.014287603,
        0.016834296,    -0.01568502,     0.030586442,    0.0075943703,   0.0015778072,
        0.036149986,    -0.018440673,    0.01586786,     -0.024931476,   0.012844477,
        0.024631096,    0.008208189,     -0.0064320336,  -0.030299122,   0.0036992356,
        -0.021535885,   0.024030339,     0.013073026,    -0.0065136584,  0.0052305167,
        0.029933443,    0.013438705,     -0.020569447,   0.0020602096,   -0.0147969425,
        -0.010513273,   0.024291538,     -0.01962913,    0.013216686,    0.008136359,
        0.029123725,    0.02685129,      0.0095403055,   -0.01544994,    -0.010970372,
        -0.025375515,   0.01968137,      0.018741053,    0.011910689,    -0.014143944,
        0.016599217,    -0.0020193972,   0.01542382,     0.032310355,    -0.020804526,
        -0.020360488,   0.025271036,     0.029175965,    0.008567338,    -0.66323733,
        -0.04231429,    -0.0116103105,   -0.0019720548,  0.0025009837,   0.009710085,
        0.01936793,     0.020726167,     -0.005498246,   -0.0047701527,  -0.020269068,
        0.0030119547,   0.0061838944,    0.0020683722,   -0.014823062,   -0.016507797,
        -0.00022446817, 0.008599988,     -0.017800733,   0.001771258,    -0.0031572469,
        0.024056459,    -0.004688528,    0.014888362,    0.008103709,    0.00812983,
        -0.0025336335,  -0.028105048,    -0.021601185,   0.0010488785,   0.0048909574,
        0.025597535,    0.006686703,     -0.0032241791,  0.040459774,    -0.033537995,
        -0.002571181,   0.031944677,     0.029489404,    0.044978525,    -0.010474093,
        -0.008978727,   0.0072548115,    0.008456328,    0.020843707,    -0.006239399,
        0.02000787,     0.0087436475,    0.021914624,    0.0060500293,   0.026355013,
        0.009063616,    -0.036254466,    -0.00387881,    -0.0012635518,  -0.008952607,
        0.03168348,     -0.018440673,    -0.017017135,   -0.010336963,   -0.008815478,
        0.010715703,    -0.008377968,    -0.0064516235,  -0.0032421367,  0.032989476,
        -0.026106874,   0.037247024,     0.017696254,    -0.03116108,    0.014718582,
        0.0155935995,   0.008097179,     -0.003513131,   -0.0018430877,  0.021235505,
        0.04740768,     0.0039441097,    -0.014836122,   0.009272576,    0.007052382,
        -0.004280404,   -0.007346231,    0.007032792,    0.025597535,    0.0076139607,
        -0.030325241,   -0.012837947,    0.008959137,    -0.0044338587,  -0.028862527,
        0.021731785,    -0.02400422,     -0.006980552,   -0.014627162,   0.029228205,
        -0.010774473,   -0.005106447,    0.028392367,    -0.03095212,    0.014888362,
        -0.024304597,   0.017265275,     0.0024699662,   0.0026821906,   -0.011244631,
        0.0060337046,   0.010395734,     0.04278445,     -0.03103048,    0.02375608,
        -0.0070001422,  -0.008430208,    -0.01595928,    -0.00800576,    -0.017748494,
        0.0021516294,   0.017134676,     -0.0076857903,  -0.02797445,    0.011296871,
        0.011068322,    -0.0056778206,   -0.0013157916,  -0.014457383,   0.0065528383,
        0.0060304394,   -0.0043228487,   0.00582148,     -0.017291395,   0.0026577031,
        -0.012674698,   0.013308106,     -0.005494981,   -0.008286549,   -0.00289768,
        0.04322849,     -0.010467563,    0.0071829814,   0.0020242948,   -0.03567983,
        0.010219424,    0.0057365904,    0.016533917,    0.00200144,     -0.026420312,
        0.00049954373,  -0.013236276,    -0.022802701,   -0.013686845,   -0.0081428895,
        -0.033668593,   -0.022972481,    0.022567622,    -0.0059488146,  0.004299994,
        -0.013634605,   -0.014143944,    0.0032943767,   -0.018153353,   0.022698222,
        0.01932875,     -0.03173572,     0.014261483,    0.013673785,    -0.025610594,
        0.0010113311,   0.0063667335,    -0.018466793,   -0.01554136,    0.026159113,
        -0.00772497,    0.007463771,     0.018923892,    0.018845532,    0.0060467646,
        -0.012021699,   -0.001541076,    0.0068434225,   -0.00778374,    0.00784251,
        -0.0032225468,  -0.018009694,    -0.00024058907, 0.016847357,    0.017552596,
        0.010963842,    0.018519033,     -0.025897913,   0.026799051,    0.00398982,
        0.007013202,    -0.00782292,     0.010382674,    -0.008084119,   0.03181408,
        -0.0024977187,  0.000016975406,  0.021326926,    0.01155154,     0.02348182,
        -0.0031605118,  0.010441443,     0.001952465,    0.008658757,    0.010193304,
        0.009475006,    -0.009710085,    0.048478596,    0.005099917,    0.022423962,
        -0.017957455,   -0.04299341,     -0.017356696,   0.022802701,    0.02692965,
        0.03403427,     -0.011048731,    0.0004550582,   -0.010787533,   0.0001958995,
        0.0053807064,   -0.0045416034,   0.0060369694,   -0.010082294,   -0.016220478,
        0.019890329,    0.0006864645,    0.032623798,    -0.01183886,    -0.0067128227,
        0.0056484356,   -0.01167561,     0.016507797,    0.026524791,    0.011747439,
        0.01978585,     0.0064352984,    0.028496847,    -0.00026079122, -0.0006272865,
        -0.009181157,   0.0055113058,    -0.01964219,    0.014117824,    -0.015280161,
        0.013242806,    0.0026136257,    -0.025479995,   -0.013673785,   0.022358663,
        -0.0036567906,  -0.021979924,    -0.02695577,    -0.019028371,   -0.014770822,
        0.029175965,    0.025388574,     0.01179968,     0.013288516,    -0.00024895562,
        -0.013373406,   -0.0015116911,   0.003493541,    0.009919045,    -0.017095497,
        -0.0048223925,  0.011747439,     -0.0010554085,  -0.0027899353,  -0.00046648568,
        -0.018871652,   0.011845389,     -0.020112349,   0.020099288,    -0.0064548883,
        0.030481962,    0.0045971083,    0.009115856,    0.0022267243,   -0.017826853,
        -0.036620148,   0.006947902,     0.025519174,    -0.0022708017,  -0.02729533,
        -0.017278336,   0.008671817,     -0.02711249,    0.020556387,    0.0015043449,
        -0.0005162768,  -0.014104764,    -0.021823203,   -0.015084261,   -0.013895804,
        0.021131026,    -0.017839914,    0.0036469956,   -0.016481677,   0.0088415975,
        -0.02690353,    0.0068695424,    -0.00084481656, 0.027739368,    0.008410619,
        -0.025440814,   -0.002117347,    -0.009631725,   -0.010572043,   0.009083207,
        -0.009618665,   -0.01957689,     -0.029646125,   -0.024134818,   0.0074964208,
        -0.00091746263, 0.013464825,     0.014574923,    0.0027785078,   0.021509765,
        -0.036907464,   -0.010252073,    0.0053937663,   0.112315714,    0.01943323,
        -0.0020161322,  0.010023524,     0.01962913,     -0.007333171,   0.004251019,
        0.005811685,    0.0046036383,    0.009207277,    0.025179615,    -0.0131056765,
        0.005837805,    0.0050084973,    0.021366104,    0.009644785,    0.0020683722,
        -0.024539677,   0.0065397783,    -0.00398329,    -0.023050841,   -0.0037188255,
        -0.012681227,   0.017748494,     -0.021797083,   -0.039597817,   0.017213035,
        0.0016080084,   0.0008456328,    0.0076662004,   -0.0012684492,  0.0021320395,
        -0.0032209142,  0.008828538,     -0.013673785,   0.0010660198,   -0.0014765925,
        0.008730588,    0.008364908,     -0.0131056765,  0.015267101,    -0.029097605,
        -0.00085624406, -0.01940711,     0.0021581594,   0.000029971603, -0.01965525,
        0.020869827,    0.0019165501,    -0.022606801,   0.061016165,    -0.0023671188,
        -0.029724484,   -0.0120151695,   0.026459493,    -0.0027670804,  -0.0060402346,
        -0.002920535,   -0.013451765,    0.020948187,    -0.012452678,   -0.04385537,
        0.016050698,    -0.016938776,    0.012720407,    -0.034164872,   -0.02687741,
        -0.0014855711,  -0.03792614,     -0.0115254205,  0.03889258,     -0.004531808,
        -0.0014790412,  -0.0072809313,   0.027817728,    -0.016977957,   0.015136501,
        -0.036489546,   -0.009448886,    0.03084764,     0.005876985,    -0.004058385,
        -0.014104764,   -0.029881204,    0.012145769,    0.024957595,    0.00085053034,
        -0.022071343,   0.0029825699,    0.020321308,    0.00784251,     0.008201659,
        -0.0018822677,  -0.00795352,     0.015306281,    0.00047260753,  -0.010134534,
        0.007960049,    0.005857395,     0.007437651,    0.024761697,    -0.005818215,
        -0.0079274,     -0.015267101,    0.01168214,     -0.018793292,   -0.017121617,
        0.0022544768,   0.00010300028,   0.007320111,    -0.00591943,    -0.020412728,
        -0.028131168,   0.010996492,     -0.039545577,   0.022019103,    0.013908864,
        0.050333112,    0.0060630892,    0.020478027,    -0.004394679,   -0.024787817,
        0.009416236,    0.010650403,     -0.0044044736,  -0.0033107016,  -0.019825028,
        -0.040720977,   -0.011179332,    -0.0028797225,  0.0071503315,   -0.003535986,
        -0.011094442,   -0.0020585773,   -0.018597392,   -0.0018055404,  0.0013745615,
        -0.008952607,   -0.00779027,     -0.0107287625,  -0.033146195,   0.008221249,
        -0.024644157,   -0.017330576,    0.011042202,    -0.01983809,    -0.024291538,
        -0.03212752,    0.006660583,     0.012446148,    0.012041289,    -0.013073026,
        -0.024448257,   -0.008919957,    0.003490276,    -0.01180621,    0.0014431262,
        -0.0055243657,  0.03432159,      0.016742878,    0.028940886,    0.013490945,
        0.020478027,    0.011270751,     -0.0022446818,  0.023116142,    -0.021810144,
        -0.011303401,   -0.024957595,    -0.010291253,   0.0034053863,   0.017474236,
        0.033198435,    -0.008351848,    -0.011388291,   0.0078490395,   0.014300663,
        -0.0048942226,  -0.008404088,    -0.026198292,   0.003454361,    0.013830504,
        -0.0075682504,  0.03087376,      -0.028183408,   -0.012798768,   0.016272718,
        -0.018701872,   -0.01153848,     -0.005876985,   0.045788243,    -0.02713861,
        0.010212894,    0.008195129,     -0.00582801,    0.0122110685,   0.0058737197,
        -0.011133621,   0.012472268,     -0.010173714,   0.002275699,    0.010506743,
        -0.013530125,   -0.0005950447,   0.0056941453,   0.033067834,    -0.006928312,
        -0.0056647602,  0.005416621,     -0.012041289,   -0.021196326,   -0.010493683,
        -0.021797083,   -0.023821378,    0.006138184,    0.025257975,    -0.0076009007,
        0.0011941707,   -0.030664802,    -0.031213319,   -0.013647665,   -0.024030339,
        0.016586157,    0.009266046,     0.037847783,    -0.0016178034,  -0.014679402,
        -0.00590637,    0.030299122,     0.0036045508,   0.005449271,    0.024160938,
        0.01606376,     -0.024565797,    0.005155422,    0.009638255,    0.008391028,
        -0.00581495,    -0.00015335258,  0.029489404,    -0.0011802944,  0.004633023,
        -0.014979782,   -0.02328592,     0.009566425,    0.019864209,    -0.016586157,
        -0.013569305,   0.008978727,     -0.010141064,   -0.010493683,   0.0135954255,
        -0.0109377215,  0.011584191,     -0.0036796455,  -0.023899738,   0.010369614,
        -0.008345319,   -0.010572043,    -0.01196293,    -0.024095638,   0.012668167,
        -0.041791894,   -0.00789475,     0.015606659,    0.020190708,    0.01913285,
        -0.010343494,   0.0030446048,    0.02732145,     -0.018166414,   -0.017382815,
        -0.00045913944, 0.009063616,     0.017343635,    -0.0120151695,  -0.009899454,
        -0.024082579,   -0.009226866,    -0.015776439,   0.009873334,    -0.017931335,
        0.025336334,    -0.002389974,    -0.005987995,   -0.06566551,    0.0029417574,
        -0.005070532,   0.005142362,     -0.016155178,   -0.041530695,   -0.031996917,
        -0.014065584,   0.016977957,     -0.0231292,     -0.01901531,    -0.014313723,
        0.02713861,     -0.021183265,    0.021209385,    -0.0014390451,  -0.005987995,
        -0.02333816,    0.025675895,     0.008227779,    0.010212894,    0.018388433,
        -0.010676523,   -0.04241877,     -0.029802844,   0.020686988,    0.008234309,
        0.010350023,    -0.014666342,    -0.0004926056,  -0.00069585134, -0.016377198,
        -0.0138043845,  0.0018430877,    0.03147452,     -0.006174099,   0.013464825,
        0.02721697,     0.005064002,     0.018767172,    -0.010702643,   0.0118192695,
        -0.00800576,    -0.013144856,    0.0076009007,   0.00777721,     0.012602868,
        0.006947902,    -0.00042404077,  -0.018153353,   -0.01558054,    -0.00800576,
        0.011225041,    0.020856766,     -0.0054068263,  0.002680558,    -0.024017278,
        0.015227921,    0.0021157146,    0.016194358,    -0.012837947,   -0.0079274,
        -0.014170064,   -0.015058141,    -0.015032021,   0.0067454726,   0.040094096,
        -0.0055308957,  0.009546836,     -0.01965525,    0.011375231,    -0.047590517,
        -0.016925717,   0.018845532,     0.017356696,    0.033955913,    0.041400094,
        0.016298838,    0.0022283567,    -0.017539535,   0.012204539,    0.0048974873,
        0.0036959704,   0.012707347,     -0.00035241502, 0.004652613,    -0.016560037,
        -0.014365963,   -0.008306138,    0.019746669,    0.0067585325,   -0.017552596,
        0.016429437,    0.0025924034,    0.002729533,    0.0130077265,   0.0072091017,
        0.032231998,    0.005011762,     0.020373547,    -0.029228205,   -0.0050084973,
        0.001554136,    -0.0039310497,   -0.024252357,   -0.01183886,    0.009873334,
        0.028261768,    -0.00584107,     -0.0045611933,  0.0076400805,   0.010957312,
        -0.006954432,   0.00082359416,   -0.010075764,   -0.0020177648,  0.029593885,
        0.025440814,    -0.0057300604,   -0.0016357608,  0.030664802,    -0.0018773702,
        -0.03113496,    0.0060892096,    -0.026642332,   0.0044110036,   -0.025271036,
        -0.0016137221,  -0.013366875,    -0.005452536,   -0.0026658657,  -0.025584474,
        -0.037638824,   0.009220337,     0.017539535,    -0.00812983,    0.011936809,
        -0.0081428895,  -0.0068891323,   0.0057365904,   0.006151244,    0.0031784694,
        -0.018166414,   -0.0015141398,   0.014653282,    0.010526333,    -0.045553163,
        -0.004737503,   -0.0064320336,   -0.032623798,   0.020373547,    0.18994415,
        0.0008619578,   0.002097757,     0.024787817,    -0.018166414,   0.0020585773,
        -0.0067454726,  0.031996917,     0.0040747095,   0.026067693,    -0.011845389,
        -0.0055798707,  -0.0017745229,   -0.0036763805,  -0.0019443025,  -0.005204397,
        -0.029646125,   -0.044586726,    -0.00074401,    -0.026825171,   0.0059129,
        0.012870597,    0.0073005212,    -0.023494879,   0.0116952,      0.007307051,
        -0.0048550423,  0.010839772,     0.020295188,    0.023938918,    0.009155037,
        -0.037664942,   -0.0036110808,   0.012896717,    -0.021823203,   0.00087338523,
        0.001537811,    -0.017604835,    0.017369755,    0.0005640273,   0.0057170005,
        0.0053023463,   0.00023793627,   0.0030282796,   -0.0036927054,  0.013001197,
        -0.015776439,   -0.0072744014,   0.0068368926,   0.0061218594,   -0.026537852,
        0.0003987371,   0.016742878,     0.016782057,    0.023769138,    -0.001155807,
        0.01555442,     0.01951159,      -0.005403561,   -0.017186916,   -0.0007791086,
        0.038291823,    -0.010134534,    0.0068368926,   -0.013517065,   0.028810287,
        -0.014849182,   -0.02753041,     -0.013268926,   -0.013856624,   -0.016142119,
        -0.029071486,   -0.0461278,      0.0015076098,   0.0006885051,   -0.018806351,
        0.007365821,    -0.006582223,    0.020530267,    0.020582506,    0.020242948,
        -0.01625966,    0.0063340836,    0.004290199,    -0.0057039405,  -0.021274686,
        0.00585413,     0.008828538,     0.0031719394,   0.0010954047,   0.006928312,
        -0.031892437,   -0.014810002,    0.0032290767,   0.02747817,     0.018479852,
        0.016168239,    0.0052207215,    -0.008972197,   0.009194217,    -0.031605117,
        0.010558983,    0.022645982,     -0.013477885,   -0.016638398,   -0.012439618,
        -0.02750429,    0.011257691,     0.0028633976,   -0.0319708,     -0.024317658,
        0.017004076,    0.020216828,     -0.0119172195,  -0.013712965,   0.01543688,
        0.0102390135,   0.012256779,     0.00386575,     0.0068826023,   -0.016677577,
        -0.026211353,   0.017291395,     0.007032792,    0.001754933,    -0.020478027,
        -0.019798908,   0.005054207,     0.009664375,    -0.04597108,    0.020935126,
        -0.013530125,   -0.010905072,    -0.012851007,   -0.00023059003, 0.0236516,
        0.008573868,    -0.021692604,    -0.016102938,   -0.018257834,   0.021144086,
        -0.032545436,   -0.018022753,    0.009599076,    0.004202044,    -0.00778374,
        0.013184036,    0.0033890612,    0.006304699,    -0.010539393,   -0.021979924,
        -0.021078786,   -0.015227921,    -0.010180244,   0.020399667,    -0.036045507,
        -0.024631096,   -0.006987082,    0.0039441097,   -0.004058385,   -0.039702296,
        0.019145912,    0.017147737,     -0.044403885,   -0.0028862525,  0.014744702,
        -0.1654959,     0.018858591,     -0.008599988,   0.011499301,    0.045709882,
        0.004525278,    0.015802559,     0.00195573,     -0.004237959,   0.0038428952,
        0.009794975,    -0.012276368,    -0.028993126,   -0.0014733275,  -0.026185233,
        -0.010336963,   -0.015227921,    -0.0048191277,  0.022528442,    0.015267101,
        0.031787958,    0.018336194,     0.016468618,    -0.017748494,   0.013125266,
        0.006324289,    -0.0035849607,   0.010167184,    0.020869827,    -0.022149703,
        -0.033198435,   0.001991645,     0.041530695,    -0.0012855905,  -0.014875302,
        0.0071372716,   -0.011198921,    -0.0046036383,  0.0027703454,   0.0050084973,
        0.009168097,    0.009612136,     0.02750429,     -0.0011525421,  -0.022998601,
        0.021823203,    0.02337734,      -0.005057472,   0.015267101,    -0.011016082,
        -0.012942427,   -0.0153977005,   0.008737118,    0.0031980593,   0.030325241,
        0.03479175,     0.028444607,     -0.0009239926,  0.014718582,    0.020203767,
        -0.024396017,   -0.007346231,    -0.004538338,   -0.012975077,   0.0030772546,
        -0.036776867,   -0.003487011,    -0.014222303,   -0.020256007,   0.010617753,
        -0.011473181,   0.0023622215,    0.005204397,    -0.008691408,   0.028209528,
        0.018832471,    -0.0022822293,   0.004234694,    -0.0061022695,  0.0076662004,
        -0.03873586,    0.044403885,     0.0075094807,   -0.012367789,   0.006559368,
        -0.006206749,   -0.03168348,     0.00089542393,  -0.024722517,   -0.014248423,
        0.015920099,    -0.034347713,    -0.009409706,   -0.0029189026,  -0.00075053994,
        0.018205592,    -0.0020536797,   0.0020716372,   0.0040845047,   -0.0048093325,
        -0.013255866,   0.009187686,     -0.011231571,   0.024787817,    0.013517065,
        0.019093672,    0.0068564825,    0.009481535,    0.044821806,    0.0089264875,
        0.010056174,    -0.01170173,     0.005103182,    0.019172031,    -0.021836264,
        -0.003509866,   0.009919045,     -0.028183408,   -0.00591943,    0.029097605,
        0.04672856,     -0.0024128288,   -0.013987225,   0.030299122,    -0.007085032,
        -0.028784167,   -0.108658925,    -0.021235505,   0.004182454,    0.002486291,
        0.0071307416,   0.042053092,     -0.0034151813,  0.009612136,    -0.0063210237,
        0.0055602808,   0.008887307,     -0.018858591,   -0.0012333506,  -0.005031352,
        0.056680255,    0.004646083,     0.004659143,    -0.0156589,     -0.0147969425,
        0.0036339357,   -0.00021508132,  0.009455415,    -0.0055864006,  -0.024356838,
        -0.016612276,   -0.013340755,    -0.026315833,   0.025440814,    0.017931335,
        0.008384499,    0.02361242,      -0.017813794,   -0.03089988,    0.004704853,
        0.00774456,     -0.0011190759,   -0.029149845,   -0.0013353815,  0.010741822,
        -0.036202226,   0.014143944,     0.01935487,     0.013699905,    -0.023194501,
        -0.016808176,   0.007378881,     -0.0128118275,  0.02340346,     -0.0001007556,
        0.0006713639,   0.0034021214,    0.011734379,    -0.01981197,    0.004544868,
        0.025101256,    0.0009729675,    0.014666342,    -0.00030078736, -0.0039245198,
        -0.002561386,   -0.013014257,    -0.0010325536,  0.0041106245,   -0.011257691,
        0.0016333121,   -0.009879865,    -0.0015949483,  -0.0010407161,  0.024500497,
        -0.01975973,    0.0034478311,    0.021287745,    -0.013517065,   0.025702015,
        -0.029881204,   -0.016442498,    -0.051717468,   0.004234694,    0.016951837,
        -0.012759587,   -0.0044534486,   -0.01904143,    0.0052696965,   0.00577577,
        -0.0071633914,  0.024853116,     0.011179332,    0.013125266,    -0.0149928415,
        0.00788169,     0.017030196,     0.03123944,     0.014405143,    0.0011435633,
        -0.0022805966,  0.03421711,      0.013229746,    -0.025140436,   -0.022097463,
        0.021940744,    -0.011205452,    -0.000388534,   -0.061068404,   0.014261483,
        0.05448618,     0.00591943,      0.020099288,    -0.0056190505,  0.00388534,
        -0.012759587,   -0.019119792,    0.0005550486,   -0.01995563,    0.03842242,
        0.025610594,    0.006229604,     -0.026002394,   -0.01162337,    0.01554136,
        -0.002350794,   0.0036992356,    0.0019720548,   -0.027817728,   -0.019080611,
        0.008815478,    0.02348182,      -0.007359291,   -0.0034021214,  0.003085417,
        0.014143944,    -0.0041269492,   -0.00773803,    0.026093813,    -0.012106589,
        0.0118911,      0.0013753778,    -0.012962016,   -0.012537568,   0.0032013243,
        0.002499351,    0.011094442,     0.03863138,     0.023494879,    0.0012733467,
        0.010173714,    -0.000029665509, -0.016742878,   0.00200797,     -0.0062034843,
        -0.010572043,   0.01571114,      0.012354728,    0.012694287,    0.0378739,
        -0.0067128227,  -0.014300663,    -0.020569447,   -0.013399526,   0.01961607,
        0.005184807,    -0.003862485,    -0.012158829,   0.022632921,    -0.01960301,
        0.03186632,     -0.004600373,    0.0014945499,   -0.025571415,   -0.0239781,
        -0.00020049089, 0.0032682566,    -0.020151528,   0.0028536026,   0.010336963,
        0.001359869,    0.019942569,     0.011114031,    0.014862242,    -0.0056582303,
        -0.0005403561,  -0.008515098,    0.009651315,    0.012831417,    -0.005403561,
        -0.055687696,   0.010702643,     0.0068695424,   -0.009977815,   -0.010878952,
        0.02739981,     0.010160654,     0.003921255,    -0.0031915293,  0.019080611,
        -0.0041432744,  -0.01548912,     0.010447973,    0.010088824,    0.0011492771,
        -0.008756707,   0.012276368,     -0.012504918,   -0.0045546633,  0.016729817,
        -0.012694287,   -0.04315013,     -0.014274543,   0.0019067551,   -0.004202044,
        -0.03507907,    0.011832329,     -0.008652228,   0.0025238385,   0.0032698892,
        -0.025140436,   0.015084261,     0.0016733082,   0.010310844,    0.017526476,
        -0.003467421,   -0.008776298,    0.021405285,    -0.00025875057, 0.0085346885,
        0.013948044,    0.0029809372,    0.017043257,    -0.015188741,   0.0009492963,
        -0.02690353,    -0.0051815417,   0.00801882,     -0.026772931,   -0.008482448,
        -0.006516923,   0.0011207084,    0.010702643,    -0.010219424,   0.0067520025,
        0.0048583075,   -0.015084261,    0.03502683,     0.021810144,    -0.0071764514,
        0.0067389426,   -0.018610451,    0.023220621,    0.01551524,     0.008149419,
        -0.00022875347, -0.014627162,    0.011375231,    0.0059618745,   0.0142092435,
        -0.0052729617,  0.0014161901,    0.020974306,    -0.0075551905,  0.0067128227,
        -0.031187199,   0.004704853,     -0.00590637,    0.00390493,     0.01898919,
        -0.0006983001,  0.009063616,     -0.014157004,   -0.019916449,   0.0122241285,
        -0.008717528,   -0.028314007,    -0.025205735,   -0.006291639,   -0.022868002,
        -0.023886679,   0.0034217113,    -0.008136359,   0.017931335,    -0.036855225,
        0.016076818,    -0.013934984,    -0.017892154,   0.044586726,    -0.017552596,
        -0.031996917,   -0.021784024,    0.001471695,    -0.010212894,   -0.026825171,
        -0.012628987
    ],
    [
        0.004438986,      -0.036302213,   -0.019494658,   0.0049131806,   -0.020153262,
        0.012572737,      -0.019323422,   -0.030796291,   -0.0035103557,  0.0067111677,
        0.025026925,      0.013251099,    0.028214566,    -0.01396239,    0.025198162,
        -0.0060789087,    0.036908127,    -0.005216138,   0.019850304,    0.016201641,
        -0.009661711,     -0.002069661,   0.0035070626,   -0.018335516,   -0.0006561335,
        -0.0070799855,    0.0014662156,   -0.019073151,   0.029347364,    -0.013415749,
        -0.00047995715,   -0.007982272,   0.011413596,    -0.014397068,   -0.036512967,
        -0.01894143,      0.009450957,    -0.027503274,   0.016412394,    -0.013178652,
        0.00672434,       0.0028665708,   0.0015501875,   0.02206321,     -0.015819652,
        -0.002510925,     -0.0074817333,  -0.015793307,   -0.014976639,   0.016926104,
        0.027239833,      -0.002491167,   -0.021272887,   -0.008706735,   -0.003961499,
        -0.011696795,     0.009589264,    0.02633096,     0.012085371,    -0.025685528,
        -0.020364014,     -0.0052951705,  0.0047188927,   -0.0027628408,  -0.0168339,
        -0.0052424823,    -0.0057232627,  0.01118967,     0.008996521,    -0.0044554514,
        0.030928012,      0.026594402,    0.0051107616,   0.007949342,    0.011598004,
        -0.0101885935,    -0.013455265,   -0.001911596,   0.0028418733,   0.011393837,
        0.012671527,      -0.037197914,   -0.004965869,   0.027002735,    0.019665895,
        0.007567352,      0.012994243,    0.0097736735,   -0.020061057,   -0.015068844,
        -0.0042578704,    -0.0050547803,  0.0256987,      0.031929087,    -0.008904316,
        0.0045410697,     -0.009148,      0.00014427528,  -0.004438986,   -0.036934473,
        -0.014410241,     0.013949218,    0.0050778314,   -0.0130864475,  -0.032113496,
        0.010610099,      -0.018480409,   -0.009510232,   0.027239833,    -0.0026772225,
        -0.01912584,      0.021207027,    0.023196008,    -0.029031234,   -0.0040833405,
        -0.03851512,      0.031454895,    0.007429045,    0.012559565,    -0.009009693,
        0.032982852,      0.0024483579,   0.011545316,    0.0012340579,   0.020666972,
        0.024539558,      -0.027213488,   0.0039088107,   0.0023528603,   -0.014370725,
        0.014686854,      0.005186501,    0.0092797205,   -0.00019644902, -0.03577533,
        0.0070733996,     -0.031929087,   0.0063028336,   0.005301757,    -0.014528789,
        0.027766716,      0.010070045,    -0.0060920804,  -0.018269656,   -0.008996521,
        0.00415908,       -0.002099298,   0.0040932195,   -0.0039680847,  -0.013685777,
        0.014502444,      -0.015016155,   0.017611053,    -0.01728175,    0.0139755625,
        0.0017864614,     -0.0054729935,  0.0168339,      -0.004985627,   -0.0134420935,
        0.0064707776,     0.00031962842,  -0.0129481405,  -0.030190375,   0.022300309,
        0.037013505,      0.021852458,    -0.008831871,   -0.016175298,   -0.00087676564,
        0.0006664242,     0.012612253,    -0.028899513,   0.01035983,     -0.022669125,
        0.009075553,      0.0060723224,   0.036065117,    -0.01804573,    -0.013158894,
        -0.02257692,      -0.015121532,   0.017558364,    0.015674759,    -0.013791153,
        -0.002313344,     0.002594897,    -0.012427844,   -0.017518848,   -0.0024714088,
        0.012045855,      -0.0014752714,  -0.0041030985,  0.018388204,    -0.67103773,
        -0.005822053,     -0.0197581,     -0.019613206,   0.0036223182,   0.012348812,
        0.016978793,      0.008877972,    -0.0053281006,  0.0074224593,   0.0046958416,
        0.012875695,      -0.023196008,   -0.015648415,   -0.008601359,   -0.010893298,
        0.0013987088,     -0.040517274,   0.022550577,    -0.021760253,   -0.031454895,
        0.018691162,      -0.007145846,   -0.00831816,    -0.016557287,   0.012210505,
        0.014831746,      -0.003385221,   0.0055355607,   0.004794632,    -0.030243063,
        0.01472637,       0.019283906,    0.027397897,    0.04979041,     -0.029426396,
        -0.0050449013,    0.027134456,    -0.0092599625,  0.021207027,    -0.008120579,
        -0.004583879,     0.009786845,    -0.00024841694, -0.0043138517,  0.018414548,
        0.014265347,      -0.014410241,   0.0035366998,   -0.0071853623,  0.022102727,
        0.010596927,      0.02976887,     -0.007343427,   0.014805403,    0.000119577664,
        0.0280565,        -0.007613454,   0.016478255,    0.004567414,    -0.019863475,
        0.053531278,      -0.011235773,   -0.0013517833,  -0.016649492,   0.03066457,
        -0.007613454,     0.02307746,     -0.005377496,   -0.023696547,   0.03245597,
        0.023551654,      0.0029554823,   -0.001807866,   -0.0071326736,  0.0020466098,
        0.019336592,      -0.013237926,   0.0046826694,   0.008232541,    0.015608898,
        -0.011031605,     -0.015766963,   0.011907548,    0.041913513,    -0.028135533,
        -0.016820729,     0.008423536,    0.03003231,     0.0135804005,   -0.00058162905,
        0.028030157,      -0.017321266,   -0.021589017,   0.014476101,    0.007119502,
        0.014001906,      0.019139012,    0.00605915,     -0.039858673,   -0.014080939,
        -0.007771519,     0.018177452,    -0.009786845,   0.0021503398,   0.005354445,
        -0.0095958505,    -0.025171818,   0.040016737,    -0.029057577,   0.013646261,
        0.016017232,      -0.019428797,   0.0024714088,   -0.007843966,   -0.019283906,
        0.018124763,      0.015055671,    0.012770318,    -0.031375863,   0.034062963,
        0.00841695,       0.031138765,    -0.01118967,    0.004992213,    0.033588767,
        -0.017518848,     -0.008410364,   -0.015121532,   0.0024104882,   -0.010175421,
        -0.010287384,     0.015964543,    -0.0026409992,  -0.0070733996,  -0.010761578,
        0.0036848856,     -0.003780383,   0.006777028,    -0.0013015647,  -0.0162675,
        0.0018539682,     -0.000599329,   -0.014541961,   -0.018137936,   -0.045206532,
        -0.011262117,     -0.0040602894,  -0.04028018,    0.018994119,    0.011709967,
        0.00025953088,    -0.033035543,   -0.013870185,   -0.012157817,   0.0014925598,
        -0.008785768,     -0.0131259635,  -0.014304864,   -0.013909702,   0.028451663,
        -0.015398146,     -0.015951373,   0.012460775,    0.0028501058,   -0.006029513,
        -0.009971254,     0.037118882,    -0.0128691085,  -0.03124414,    0.00022474838,
        -0.0129283825,    -0.021918317,   0.023709718,    -0.03667103,    0.004047117,
        -0.010261039,     -0.006948265,   -0.0058352253,  -0.0026031295,  -0.025092786,
        0.017452987,      0.011492628,    -0.0041459077,  0.0042940937,   0.002915966,
        -0.0041228565,    0.022524234,    0.01080768,     0.03398393,     -0.007382943,
        0.023222353,      0.009523404,    -0.000945919,   -0.018691162,   -0.001344374,
        0.011558488,      0.028583383,    -0.0057331417,  0.02619924,     0.011327977,
        -0.016333362,     0.012144645,    -0.012256607,   0.014871263,    -0.036328558,
        0.0031892864,     -0.022919394,   0.028346287,    0.0035366998,   0.0057133837,
        -0.023090633,     0.0077056587,   -0.022616437,   0.01709734,     0.018203795,
        -0.0007252869,    0.010768164,    -0.012072199,   0.01645191,     0.01396239,
        -0.013290615,     -0.0013254392,  -0.024407838,   -0.036802754,   0.027397897,
        0.010142491,      0.01912584,     0.009819775,    -0.035669956,   0.0089438325,
        0.00876601,       -0.014937123,   0.012803248,    0.016728524,    -0.009009693,
        0.0041656657,     -0.018862398,   0.028820481,    0.005749607,    0.0134025775,
        0.027134456,      0.033378016,    -0.010577169,   -0.0028879754,  0.008627703,
        0.020640628,      -0.005983411,   -0.026620746,   0.0034873046,   -0.024842517,
        0.003576216,      0.014476101,    -0.00460693,    0.009233618,    -0.004396177,
        0.0015263131,     0.0023116977,   0.02926833,     0.028319942,    0.015226908,
        -0.00040668753,   0.004452158,    0.001535369,    0.042097922,    -0.0070470553,
        0.0048374413,     0.01676804,     -0.01157166,    0.01676804,     -0.010511309,
        -0.009200688,     0.022129072,    -0.024394667,   -0.002692041,   0.0042512845,
        0.022537405,      -0.005973532,   0.011762655,    0.0016926104,   -0.0024516508,
        -0.026383648,     0.029979622,    0.026752466,    -0.0038297782,  -0.022326652,
        -0.022300309,     -0.0020564888,  -0.005170036,   0.0064510196,   -0.0073302547,
        -0.011894376,     0.017690085,    -0.020074228,   0.0066815307,   0.0031151937,
        0.03435275,       -0.03435275,    -0.0057133837,  0.00064584287,  -0.0051403986,
        0.01389653,       -0.027187144,   -0.005114055,   0.012658356,    0.00952999,
        0.0098527055,     -0.0036289042,  -0.0021486932,  -0.01804573,    -0.017347611,
        0.004959283,      0.02179977,     0.009938324,    0.0023594464,   -0.020429874,
        -0.015358629,     0.0036815924,   0.029004889,    0.012875695,    0.013633088,
        -0.015345457,     -0.028952202,   0.0009401562,   0.107800186,    0.017953526,
        0.012170989,      0.01112381,     0.014331208,    -0.009760501,   -0.029057577,
        -0.025013754,     0.0035268208,   -0.002585018,   0.006948265,    0.004198596,
        -0.009938324,     0.004959283,    -0.007033883,   0.00026673434,  0.0000030727317,
        0.0029044405,     -0.015780136,   -0.029373707,   -0.016162125,   0.0015864107,
        -0.0049000084,    0.008739666,    -0.013567228,   -0.02990059,    0.004587172,
        -0.0036618344,    -0.014423412,   -0.014541961,   -0.022050038,   0.00092863064,
        -0.012572737,     0.012915211,    0.015121532,    0.014607822,    0.002976887,
        0.029531771,      0.033378016,    -0.011565074,   0.00828523,     0.001094928,
        0.015582554,      -0.034405436,   0.020943586,    -0.0097143985,  0.0036651273,
        0.0096748825,     0.011314805,    -0.03290382,    0.035222106,    0.004972455,
        -0.023788752,     -0.015503522,   0.006954851,    0.017900838,    0.035169415,
        0.02103579,       -0.0074553895,  0.025198162,    -0.009365339,   -0.032666724,
        0.019916164,      -0.008812112,   -0.003796848,   -0.030005967,   -0.009391683,
        0.00066807074,    -0.003767211,   0.03295651,     -0.023894127,   -0.015516694,
        0.0010512955,     -0.010320314,   -0.0039582057,  -0.0052819983,  0.012230263,
        -0.014871263,     0.01170338,     -0.013712121,   0.0068297163,   -0.010939401,
        -0.00068824046,   -0.0030229893,  -0.0042908005,  -0.0038627083,  -0.001888545,
        -0.011183084,     -0.013949218,   0.008785768,    0.02307746,     0.0070536416,
        -0.0048308554,    0.0127308015,   0.0067210468,   -0.0011484395,  0.007870309,
        -0.009865877,     -0.0019675773,  0.016148953,    0.000057216163, -0.031033387,
        -0.008173267,     -0.0036782995,  0.024183914,    -0.026726123,   -0.012236849,
        -0.005775951,     -0.015911857,   -0.002585018,   -0.011143568,   -0.021852458,
        0.018954603,      -0.00398455,    0.008660633,    -0.008074476,   0.019613206,
        0.01657046,       -0.0132840285,  -0.027582306,   -0.011670451,   -0.011584832,
        0.011268702,      0.022300309,    -0.0018292706,  -0.0048703714,  0.0022721814,
        -0.008614531,     0.004369833,    -0.010629857,   -0.04346782,    0.009424613,
        0.0033539373,     0.013435507,    -0.020522078,   -0.0019330007,  0.005018557,
        -0.0012315882,    -0.008186439,   -0.016741697,   -0.032561347,   -0.011657278,
        -0.011117224,     -0.0008619471,  -0.015608898,   -0.021338748,   0.0013954157,
        0.0048604924,     -0.0030888496,  0.007791277,    -0.027081767,   -0.011769241,
        -0.0162675,       -0.0003511179,  -0.023288213,   -0.034695223,   -0.030085,
        -0.020179605,     0.028504351,    0.005173329,    0.01479223,     -0.0126847,
        0.030480161,      0.002099298,    0.008891145,    -0.0043237307,  0.0074027013,
        0.0023940231,     -0.04947428,    0.014331208,    0.019586863,    0.0014826807,
        0.0029274917,     -0.010037114,   0.031481236,    0.026041174,    -0.016293846,
        -0.011742897,     -0.012513462,   -0.026120206,   -0.009068968,   -0.01689976,
        0.0022655954,     0.0023314557,   -0.005561905,   -0.02090407,    0.039858673,
        0.007448803,      -0.0031497702,  -0.003921983,   0.021404607,    0.0012669881,
        0.017650569,      -0.01823014,    0.014871263,    -0.005538854,   0.01198658,
        0.0022688883,     -0.0013674251,  0.0006116778,   0.0013698948,   -0.015147876,
        -0.0046793763,    0.0036519554,   0.0035169416,   0.03780383,     0.0010973978,
        -0.020983102,     -0.0050942968,  -0.010978917,   -0.018137936,   -0.003961499,
        -0.02045622,      -0.035169415,   -0.009925152,   -0.014357552,   0.000058914124,
        0.012026097,      -0.006404917,   -0.037355978,   0.012427844,    0.00436654,
        0.053083427,      0.011881203,    0.020205949,    0.015134704,    -0.019521002,
        -0.012974485,     0.028899513,    0.0048571993,   -0.011400423,   0.008746251,
        0.0051502776,     -0.008410364,   -0.011874618,   -0.017242234,   -0.003207398,
        -0.051476434,     -0.024473699,   0.008522327,    0.0012496997,   0.010280797,
        -0.004379712,     0.0034741324,   -0.0094575435,  0.012263194,    -0.013435507,
        0.0050877105,     -0.017545192,   -0.008581601,   -0.011038192,   0.0009673236,
        -0.010379588,     0.0034971836,   0.012309296,    -0.006006462,   0.020508908,
        -0.018151106,     0.02141778,     -0.0010191887,  -0.005934016,   0.021957833,
        0.001337788,      -0.013158894,   0.0023380418,   -0.010728648,   -0.0027447292,
        0.0062896614,     0.014502444,    0.02702908,     0.0044488655,   0.013606744,
        -0.018783366,     0.016491426,    0.003823192,    0.033641458,    0.00041903634,
        -0.009187516,     -0.0016498013,  -0.0073500127,  0.004037238,    -0.014779058,
        -0.02575139,      -0.020548424,   -0.029795213,   -0.0038495364,  -0.0129481405,
        -0.008871387,     0.011018434,    -0.025962142,   -0.004336903,   0.0029801799,
        0.0022902929,     0.0036980575,   0.00006889608,  0.0049065948,   0.006329178,
        0.008772596,      -0.030690914,   0.0051206406,   0.019494658,    0.020258637,
        -0.0139755625,    0.00039207478,  0.02824091,     -0.026791982,   0.027371554,
        -0.02971618,      -0.012480533,   0.0015378387,   -0.010353244,   -0.0015814712,
        -0.014528789,     -0.008772596,   -0.011584832,   0.016096264,    0.009602436,
        -0.009068968,     -0.025804078,   0.0066222562,   0.017755944,    -0.0038660015,
        0.014449757,      -0.010208352,   0.03804093,     -0.01421266,    -0.0030542728,
        0.0136199165,     -0.011446525,   -0.011828516,   -0.012309296,   0.022287136,
        -0.008871387,     -0.026857844,   -0.023564827,   -0.011308218,   -0.014423412,
        0.010405933,      0.011821929,    -0.018888744,   0.0162675,      0.029031234,
        0.0038857595,     -0.0030987286,  0.0017568243,   -0.01351454,    0.0029917054,
        -0.00035667486,   -0.008818698,   -0.008344504,   -0.0047386508,  0.03582802,
        0.0018687869,     -0.0013353182,  -0.018151106,   -0.0016498013,  -0.02837263,
        -0.013073276,     -0.0033325327,  0.016412394,    0.031718336,    0.009720985,
        0.006246852,      0.03538017,     -0.016517771,   0.000022999662, 0.00013305845,
        -0.012651769,     -0.0052128453,  -0.0058681555,  0.002407195,    0.0221159,
        -0.014225831,     -0.005423598,   0.010234695,    0.004109685,    0.0036025601,
        0.004992213,      -0.019837132,   0.0036618344,   -0.02173391,    0.00062855455,
        0.020008368,      0.006141476,    -0.0062863687,  -0.03345705,    0.011670451,
        -0.011848274,     0.014976639,    -0.007251222,   -0.0013567228,  0.007251222,
        -0.008726493,     0.0017354197,   0.0040438245,   -0.022050038,   -0.012124887,
        -0.030559193,     0.040859748,    -0.0049164738,  -0.012032682,   0.019415626,
        0.008713322,      -0.030243063,   -0.027134456,   -0.004801218,   0.011110637,
        -0.0018160986,    -0.010913056,   -0.012981071,   0.025711874,    -0.0035268208,
        0.015437662,      -0.019797616,   0.0015715922,   -0.008113992,   0.035222106,
        -0.023485795,     0.033694144,    0.004975748,    -0.0068428884,  0.010524481,
        -0.0042578704,    -0.0007907356,  0.00018934844,  -0.02435515,    -0.0131457215,
        0.015569382,      0.015714275,    -0.00870015,    -0.0011698441,  -0.022787673,
        0.0074356315,     -0.01778229,    -0.011558488,   0.014199487,    0.2339359,
        -0.02174708,      -0.0022244328,  0.014318036,    0.0019494658,   0.022326652,
        0.036170494,      0.0009936678,   -0.022194931,   -0.0011657279,  0.00841695,
        0.019784443,      0.007415873,    -0.0010068398,  0.006348936,    -0.02538257,
        -0.022919394,     0.020219121,    -0.018440893,   -0.018375032,   0.030269409,
        0.0027529618,     0.008614531,    -0.024197085,   0.025356228,    -0.03232425,
        0.0074553895,     -0.017795462,   0.02556698,     0.016188469,    -0.0077451747,
        -0.0042776284,    0.014252176,    -0.013475023,   -0.017294923,   0.009325823,
        0.013698949,      -0.00041738985, -0.004359954,   0.007876895,    0.012012924,
        -0.015029327,     -0.0017963406,  0.011064536,    0.018559441,    0.00061250106,
        -0.020825036,     0.0088648,      0.007876895,    0.013646261,    -0.017189546,
        -0.01434438,      0.0129086245,   0.016544115,    -0.0057627787,  -0.0065135867,
        0.028715104,      0.0060657365,   0.015543038,    -0.020021541,   -0.0023363952,
        0.019560518,      -0.0031365983,  0.0132445125,   -0.011775827,   0.031718336,
        -0.020956757,     0.019968852,    0.03482694,     -0.021878801,   0.004162373,
        -0.0000032608582, -0.01963955,    0.0025636135,   -0.019626379,   -0.019376108,
        0.027503274,      0.002692041,    0.020153262,    -0.010386175,   -0.0051305196,
        -0.014950295,     0.009780259,    0.0056903325,   -0.0043434887,  -0.013336717,
        -0.00096485385,   -0.008140337,   -0.015701102,   -0.00094097946, -0.007982272,
        -0.019600034,     0.0015032621,   -0.0121183,     0.017308095,    -0.009641953,
        0.030954355,      0.026383648,    0.010267626,    -0.016307019,   0.0068099583,
        -0.010978917,     0.0008644168,   -0.001610285,   -0.033641458,   0.027661338,
        0.0047024274,     0.010880127,    0.027371554,    0.00061538245,  0.01643874,
        -0.022497889,     0.0020614283,   -0.019600034,   0.0011681976,   0.014844919,
        0.00439947,       0.000011679918, 0.017057825,    -0.018506752,   -0.0017452987,
        -0.014357552,     0.015569382,    -0.0019297077,  0.01874385,     -0.034062963,
        0.00054499425,    0.0043237307,   -0.011709967,   -0.02779306,    0.00023936114,
        -0.024078537,     0.016715351,    0.013336717,    -0.009918566,   0.017637396,
        0.0010233049,     -0.005199673,   -0.0062995404,  0.008779182,    0.006039392,
        -0.0017107221,    0.005552026,    0.0009533283,   0.02976887,     -0.007000953,
        0.0076793144,     0.0008318983,   -0.0013221462,  0.0039483267,   -0.010926229,
        -0.033298984,     -0.01278349,    0.0131852385,   0.024276117,    -0.0056705745,
        -0.03959523,      -0.023749236,   -0.011940478,   0.021048961,    -0.008996521,
        0.017044654,      0.035590924,    -0.017703258,   -0.0076859007,  -0.0036717134,
        -0.16902395,      0.008752838,    0.016886588,    -0.021391435,   0.037013505,
        -0.008515741,     0.02792478,     -0.0032222166,  -0.006734219,   0.019020464,
        0.01696562,       0.0058648624,   -0.034326404,   -0.0064905356,  0.014686854,
        0.013593572,      -0.0010932814,  0.018691162,    -0.012520049,   0.021668049,
        0.008265471,      0.005802295,    -0.005041608,   0.012645183,    0.008239128,
        0.0136199165,     0.028609728,    0.01288228,     0.009306065,    0.0055158027,
        -0.009740743,     -0.023433106,   -0.0014991458,  0.000689887,    -0.007626626,
        -0.005031729,     -0.014844919,   -0.0034280303,  -0.011960236,   0.013909702,
        -0.0002401844,    -0.00009045505, 0.021088477,    -0.019810786,   -0.0024318928,
        0.039384477,      -0.00036820042, 0.007738589,    0.015740618,    -0.036433935,
        0.007817621,      -0.01313255,    -0.02096993,    -0.00032786097, 0.040069424,
        0.020390358,      0.0162675,      -0.0150425,     0.031744678,    -0.008706735,
        -0.01753202,      0.0009220446,   0.014910779,    -0.027239833,   -0.018388204,
        0.008680391,      -0.0096748825,  0.016781213,    -0.01804573,    0.004755116,
        -0.018519925,     -0.024565903,   0.02518499,     0.003563044,    0.0015197272,
        0.007916411,      -0.016227985,   0.0026113621,   -0.0049526966,  -0.018664818,
        -0.01575379,      0.00072487525,  -0.0030213427,  -0.0077122445,  0.018533098,
        0.012315881,      0.008304988,    0.0009607376,   -0.024183914,   -0.028504351,
        -0.0049362318,    -0.002076247,   -0.027187144,   -0.023538481,   0.012408086,
        0.03206081,       0.0003346528,   0.00045649442,  0.014963467,    -0.016807556,
        0.007764933,      -0.011933892,   -0.02045622,    0.021891974,    0.026699778,
        0.02543526,       -0.0012110068,  0.021496812,    0.023472622,    -0.016280673,
        -0.0021519864,    0.009088726,    0.0048506134,   0.008193025,    0.00028381686,
        0.009760501,      0.0019066565,   -0.012315881,   0.027213488,    -0.018269656,
        0.044521585,      0.02173391,     -0.017110514,   0.015279597,    -0.002853399,
        -0.022418857,     -0.103637815,   0.010076631,    -0.010557411,   0.014647338,
        -0.024684452,     0.024197085,    -0.009503646,   -0.019837132,   -0.021127993,
        0.008272057,      0.00032456795,  -0.044389863,   -0.0014324621,  -0.026844671,
        0.019165356,      0.0036684205,   -0.013922874,   -0.019995196,   0.0006092081,
        0.021826113,      -0.017637396,   0.0009763794,   -0.0071853623,  -0.0022145535,
        -0.0031991655,    -0.006994367,   -0.031981777,   0.0038857595,   0.0016226339,
        0.0013484902,     -0.0076529705,  0.0037276947,   0.023433106,    -0.018915087,
        -0.0003136598,    0.006777028,    -0.031086076,   -0.0034873046,  0.036565654,
        -0.01811159,      -0.008278644,   0.008877972,    0.0029390173,   -0.029558117,
        -0.015450833,     0.0071326736,   -0.0067375116,  0.008970177,    0.023498965,
        -0.04257212,      -0.024882033,   -0.0131852385,  -0.041412976,   -0.007830793,
        0.021681221,      -0.006948265,   0.0044883816,   -0.0025701993,  0.007231464,
        -0.010300555,     -0.016675835,   -0.0057100905,  -0.021312403,   0.00077632867,
        -0.018282827,     -0.002957129,   -0.013593572,   -0.0048736646,  -0.00007398996,
        -0.022208104,     0.0038429503,   0.0013089741,   -0.0099910125,  0.022326652,
        -0.026923703,     0.003783676,    0.0136199165,   -0.004778167,   0.021470468,
        -0.03851512,      -0.0015197272,  -0.009767087,   -0.0035663368,  -0.040069424,
        0.0130469315,     0.023630686,    -0.0006083848,  -0.018137936,   -0.0031316588,
        -0.026791982,     -0.008509154,   0.00018677578,  0.013277442,    -0.024592247,
        -0.0008022612,    0.007824208,    0.007870309,    0.007791277,    -0.016030405,
        0.00008541262,    0.0033358256,   0.014423412,    -0.059379674,   0.0422033,
        0.003609146,      -0.0064707776,  0.0074356315,   -0.021523155,   0.026146552,
        -0.020047884,     -0.0045410697,  0.021496812,    -0.0064082104,  0.024763484,
        0.01606992,       -0.0058549833,  -0.01676804,    -0.02128606,    0.0008384843,
        -0.010399346,     0.007211706,    0.0012686346,   -0.0068955766,  0.005331394,
        -0.004613516,     0.00009626928,  -0.016412394,   -0.006948265,   -0.011209428,
        0.0048736646,     0.0015608899,   -0.008607945,   0.0061381827,   -0.023946816,
        0.006763856,      0.03833071,     0.0076727285,   -0.011742897,   -0.011828516,
        0.0058483975,     0.007145846,    0.066861406,    -0.020864552,   -0.008160095,
        0.014515617,      0.0044356934,   -0.007758347,   0.022326652,    -0.01163752,
        0.0072841523,     0.033509735,    0.0133630615,   0.020232294,    0.016794384,
        -0.0050975895,    -0.019204872,   -0.020930413,   -0.010208352,   0.027503274,
        0.008522327,      0.006994367,    -0.015371801,   0.018401377,    0.008621117,
        0.012941555,      -0.005756193,   0.019521002,    -0.017255407,   0.0013270857,
        -0.001642392,     0.0064740703,   -0.012039268,   -0.0012579323,  -0.007429045,
        -0.0062797824,    0.020126916,    0.008179853,    0.021246543,    0.0059208437,
        -0.013672604,     -0.02103579,    0.02403902,     -0.016333362,   -0.010959159,
        -0.031586614,     0.0070602274,   0.030559193,    0.006204043,    0.0037145226,
        0.022616437,      -0.012250021,   0.00015322817,  0.0056080073,   0.0131259635,
        -0.0076332125,    0.010478378,    -0.022129072,   0.0090821395,   -0.020245466,
        0.0009319237,     0.041729104,    0.013685777,    -0.01988982,    -0.002812236,
        0.007890068,      -0.019165356,   -0.02071966,    0.005584956,    -0.018967776,
        -0.015845995,     -0.0033424117,  0.015279597,    0.03282479,     0.0020433168,
        -0.0018029265,    0.009549748,    -0.008594773,   0.019744927,    0.003087203,
        -0.0336678,       -0.018915087,   0.017123686,    0.017611053,    0.03206081,
        0.004616809,      -0.01657046,    -0.004429107,   0.010004184,    0.02702908,
        0.01950783,       -0.02372289,    -0.005552026,   0.004969162,    -0.020746004,
        -0.019586863,     0.00800203,     -0.017611053,   -0.003921983,   0.0054203053,
        0.01709734,       -0.05558612,    0.03627587,     0.0150425,      -0.00018811357,
        0.0005524035,     -0.017584708,   0.020535251,    0.0038594154,   0.0006339057,
        -0.005726556,     -0.029742526,   0.006180992,    -0.016372878,   0.030005967,
        0.0013468438,     -0.026726123,   0.009365339,    -0.00006570597, 0.0064345542,
        0.0030641519,     -0.027872091,   0.028267253,    0.009753915,    0.04507481,
        -0.006171113,     -0.0280565,     -0.005377496,   0.016083093,    0.005137106,
        -0.0014217598,    -0.033193607,   0.008140337,    -0.003783676,   -0.017373955,
        -0.0044653304,    0.0065333447,   -0.001029891,   0.009148,       -0.015766963,
        0.023512138,      0.026502198,    -0.011044777,   0.026594402,    -0.024816172,
        -0.015951373,     -0.007086572,   0.008627703,    -0.013415749,   -0.004037238,
        0.0010899885
    ]
];

/**
 * @returns An array of movie documents with vector embeddings for plot where $search on "ape" in
 *     "fullplot" and "title" has no ties.
 */
export function getMovieData() {
    const
        data =
            [
                {
                    "_id": 0,
                    "title": "It's a Mad, Mad, Mad, Mad World",
                    "genres": ["Action", "Adventure", "Comedy"],
                    "plot_embedding": plotEmbeddings[0],
                    "fullplot":
                        "After a long prison sentence Smiler Grogan is heading at high speed to a California park where he hid $350,000 from a job 15 years previously. He accidentally careens over a cliff in view of four cars whose occupants go down to help. The dying Grogan gives details of where the money is buried and when the witnesses fail to agree on sharing the cash, a crazy chase develops across the state."
                },
                {
                    "_id": 1,
                    "title": "Battle for the Planet of the Apes",
                    "genres": ["Action", "Sci-Fi"],
                    "plot_embedding": plotEmbeddings[1],
                    "fullplot":
                        "After conquering the oppressive humans in \"Conquest for the Planet of the Apes\", Caesar must now keep the peace among the humans and apes. Gorilla General Aldo views things differently, and tries to cause an ape civil war. In the meantime, other human survivors learn of the ape city, and decide they want to take back civilization for themselves, thus setting the stage of warring ape factions and humans."
                },
                {
                    "_id": 2,
                    "title": "King Kong Lives",
                    "genres": ["Action", "Adventure", "Horror"],
                    "plot_embedding": plotEmbeddings[2],
                    "fullplot":
                        "A giant ape King Kong, which was shot and fell off the World Trade Center tower, appears to be alive, but is in coma for 10 years and desperately needs a blood transfusion in order to have an artificial heart implanted. Suddenly, in the rainforest, another gigantic ape is found - this time a female. She is brought to the USA, and the heart is successfully implanted. But then King Kong, having sensed the female ape, breaks loose."
                },
                {
                    "_id": 3,
                    "title": "Rise of the Planet of the Apes",
                    "genres": ["Action", "Drama", "Sci-Fi"],
                    "plot_embedding": plotEmbeddings[3],
                    "fullplot":
                        "At the story's heart is Caesar (Andy Serkis), a chimpanzee who gains human-like intelligence and emotions from an experimental drug. Raised like a child by the drug's creator, Will Rodman (James Franco) and a primatologist Caroline Aranha (Freida Pinto), Caesar ultimately finds himself taken from the humans he loves and imprisoned in an ape sanctuary in San Bruno. Seeking justice for his fellow inmates, Caesar gives the fellow apes the same drug that he inherited. He then assembles a simian army and escapes the sanctuary - putting man and ape on a collision course that could change the planet forever."
                },
                {
                    "_id": 4,
                    "title": "King Kong",
                    "genres": ["Adventure", "Fantasy", "Horror"],
                    "plot_embedding": plotEmbeddings[4],
                    "fullplot":
                        "An expedition of the \"Petrox\" company, is exploring in search of petrol. A strange island where they arrive is the home of a giant ape, King Kong, that is captured by the expedition in order to make money exhibiting it to the world. When in the U.S. the huge gorilla becomes restless, trying to return home..."
                },
                {
                    "_id": 5,
                    "title": "George of the Jungle",
                    "genres": ["Action", "Adventure", "Comedy"],
                    "plot_embedding": plotEmbeddings[5],
                    "fullplot":
                        "Baby George got into a plane crash in a jungle, stayed alive and was adopted by a wise ape. Ursula Stanhope, US noble woman is saved from death on safari by grown-up George, and he takes her to jungle to live with him. He slowly learns a rules of human relationships, while Ursula's lover Lyle is looking for her and the one who took her. After they are found, Ursula takes George to the USA."
                },
                {
                    "_id": 6,
                    "title": "Tarzan the Ape Man",
                    "genres": ["Action", "Adventure", "Romance"],
                    "plot_embedding": plotEmbeddings[6],
                    "fullplot":
                        "James Parker and Harry Holt are on an expedition in Africa in search of the elephant burial grounds that will provide enough ivory to make them rich. Parker's beautiful young daughter Jane arrives unexpectedly to join them. Harry is obviously attracted to Jane and he does his best to help protect her from all the dangers that they experience in the jungle. Jane is terrified when Tarzan and his ape friends first abduct her, but when she returns to her father's expedition she has second thoughts about leaving Tarzan. After the expedition is captured by a tribe of violent dwarfs, Jane sends Cheetah to bring Tarzan to rescue them..."
                },
                {
                    "_id": 7,
                    "title": "Abraham Lincoln: Vampire Hunter",
                    "genres": ["Action", "Fantasy", "Horror"],
                    "plot_embedding": plotEmbeddings[7],
                    "fullplot":
                        "At the age of 9, Abraham Lincoln witnesses his mother being killed by a vampire, Jack Barts. Some 10 years later, he unsuccessfully tries to eliminate Barts but in the process makes the acquaintance of Henry Sturgess who teaches him how to fight and what is required to kill a vampire. The quid pro quo is that Abe will kill only those vampires that Henry directs him to. Abe relocates to Springfield where he gets a job as a store clerk while he studies the law and kills vampires by night. He also meets and eventually marries the pretty Mary Todd. Many years later as President of the United States, he comes to realize that vampires are fighting with the Confederate forces. As a result he mounts his own campaign to defeat them."
                },
                {
                    "_id": 8,
                    "title": "The Son of Kong",
                    "genres": ["Adventure", "Comedy", "Fantasy"],
                    "plot_embedding": plotEmbeddings[8],
                    "fullplot":
                        "After the disastrous results of his last expedition, Carl Denham leaves New York aboard a ship to escape all the trouble. After a mutiny, he and a few companions are left behind on Skull island, where they meet a smaller relative of King Kong and make friends with him."
                },
                {
                    "_id": 9,
                    "title": "Planet of the Apes",
                    "genres": ["Action", "Adventure", "Sci-Fi"],
                    "plot_embedding": plotEmbeddings[9],
                    "fullplot":
                        "It is the year 2029: Astronaut Leo Davidson boards a pod cruiser on a Space Station for a \"routine\" reconnaissance mission. But an abrupt detour through a space time wormhole lands him on a strange planet where talking apes rule over the human race. With the help of a sympathetic chimpanzee activist named Ari and a small band of human rebels, Leo leads the effort to evade the advancing Gorilla Army led by General Thade and his most trusted warrior Attar. Now the race is on to reach a sacred temple within the planet's Forbidden Zone to discover the shocking secrets of mankind's past - and the key to its future."
                },
                {
                    "_id": 10,
                    "title": "Dawn of the Planet of the Apes",
                    "genres": ["Action", "Drama", "Sci-Fi"],
                    "plot_embedding": plotEmbeddings[10],
                    "fullplot":
                        "A growing nation of genetically evolved apes led by Caesar is threatened by a band of human survivors of the devastating virus unleashed a decade earlier. They reach a fragile peace, but it proves short-lived, as both sides are brought to the brink of a war that will determine who will emerge as Earth's dominant species."
                },
                {
                    "_id": 11,
                    "title": "Kung Fu Panda",
                    "genres": ["Animation", "Action", "Adventure"],
                    "plot_embedding": plotEmbeddings[11],
                    "fullplot":
                        "It's the story about a lazy, irreverent slacker panda, named Po, who is the biggest fan of Kung Fu around...which doesn't exactly come in handy while working every day in his family's noodle shop. Unexpectedly chosen to fulfill an ancient prophecy, Po's dreams become reality when he joins the world of Kung Fu and studies alongside his idols, the legendary Furious Five -- Tigress, Crane, Mantis, Viper and Monkey -- under the leadership of their guru, Master Shifu. But before they know it, the vengeful and treacherous snow leopard Tai Lung is headed their way, and it's up to Po to defend everyone from the oncoming threat. Can he turn his dreams of becoming a Kung Fu master into reality? Po puts his heart - and his girth - into the task, and the unlikely hero ultimately finds that his greatest weaknesses turn out to be his greatest strengths."
                },
                {
                    "_id": 12,
                    "title": "Hatari!",
                    "genres": ["Action", "Adventure", "Drama"],
                    "plot_embedding": plotEmbeddings[12],
                    "fullplot":
                        "John Wayne and his ensemble cast cavort over the African landscape filling orders from zoos for wild animals. Bruce Cabot plays \"the Indian\", a womanizing sharpshooter who is gored by a rhino in the opening scenes of the film. This becomes a running theme through the movie; their bad luck in catching rhinos, and provides the climactic ending chase. While Bruce is in the hospital, Elsa Martinelli shows up as a woman photographer from a Swiss zoo, and John wants to send her packing. She strongarms the Duke into letting her stay by promising that her zoo will buy most of their animals this season if she's allowed to go along on the hunts and take photos. Hardy Kruger, Gerard Blain, Michelle Girardon and Valentin de Vargas round out the group. They traipse over the African landscape capturing animals; Elsa also has a running gag where she collects baby elephants as the movie goes along. In the end she's acquired three of them."
                },
                {
                    "_id": 13,
                    "title": "Journey to the Center of the Earth",
                    "genres": ["Action", "Adventure", "Family"],
                    "plot_embedding": plotEmbeddings[13],
                    "fullplot":
                        "Professor Trevor Anderson receives his teenager nephew Sean Anderson. He will spend ten days with his uncle while his mother, Elizabeth, prepares to move to Canada. She gives a box to Trevor that belonged to his missing brother, Max, and Trevor finds a book with references to the last journey of his brother. He decides to follow the steps of Max with Sean and they travel to Iceland, where they meet the guide Hannah èsgeirsson. While climbing a mountain, there is a thunderstorm and they protect themselves in a cave. However, a lightening collapses the entrance and the trio is trapped in the cave. They seek an exit and falls in a hole, discovering a lost world in the center of the Earth."
                },
                {
                    "_id": 14,
                    "title": "Beauty and the Beast",
                    "genres": ["Fantasy", "Romance"],
                    "plot_embedding": plotEmbeddings[14],
                    "fullplot":
                        "An unexpected romance blooms after the the youngest daughter of a merchant who has fallen on hard times offers herself to the mysterious beast to which her father has become indebted."
                },
                {
                    "_id": 15,
                    "title": "Titanic",
                    "genres": ["Action", "Drama", "History"],
                    "plot_embedding": plotEmbeddings[15],
                    "fullplot":
                        "The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl."
                }
            ];
    return data;
}

/**
 * @returns An array of movie documents with vector embeddings for plot with one added movie (_id:
 *     16) where $search on "ape" in "fullplot" and "title" has a tie between _id=4 and _id=16. A
 *     $search on "ape" in "fullplot" with fuzzy enabled where maxEdits = 2 and maxExpansions = 2
 *     also results in a tie between _id=4 and _id=16. This tie exists in both the standalone and
 *     sharded configurations.
 */
export function getMovieDataWithTie() {
    const data = getMovieData();
    data.push({
        "_id": 16,
        "title": "Yor, the Hunter from the Future",
        "genres": ["Action", "Adventure", "Fantasy"],
        "plot_embedding": plotEmbeddings[16],
        "fullplot":
            "Yor, an extremely blond prehistoric warrior, comes to question his origins, particularly with regard to a mysterious medallion he wears. When he learns of a desert goddess who supposedly wears the same medallion, Yor decides that he must find her and learn his true identity. Along the way, he encounters ape-men, dinosaurs, and a strange futuristic society."
    });
    return data;
}

export const enrichedTitleViewPipeline = [{
    "$addFields": {
        "enriched_title": {
            $concat:
                [{$toString: "$_id"},
                 " - ",
                 "$title",
                 " (",
                 {$arrayElemAt: ["$genres", 0]},
                 ")"]
        }
    }
}];

export const actionMoviesViewPipeline = [{"$match": {"$expr": {"$in": ["Action", "$genres"]}}}];

/**
 * @returns An array of movie documents with an additional field as specified in
 *     enrichedTitleViewPipeline above.
 */
export function getMovieDataWithEnrichedTitle() {
    const data = getMovieData();
    data.map((movie) => {
        movie.enriched_title = movie._id + " - " + movie.title + " (" + movie.genres[0] + ")";
    });
    return data;
}

/**
 * @param {Object} viewType - The type of view to create, as specified from the datasets object in
 *     search_e2e_utils.js.
 * @returns A view of the movies collection based on the specified viewType.
 */
export function createMoviesView(viewType) {
    const testDb = db.getSiblingDB("vector_search_shared_db");
    const coll = testDb.moviesColl;

    // Populate the collection.
    if (coll.count() === 0) {
        assert.commandWorked(coll.insertMany(getMovieData()));
    }

    const viewName = viewType.viewName;

    // Check if the view exists using collection metadata.
    const viewExists = testDb.getCollectionInfos({name: viewName, type: "view"}).length > 0;
    if (!viewExists) {
        // Create the view if it doesn't exist.
        if (viewType === datasets.MOVIES_WITH_ENRICHED_TITLE) {
            assert.commandWorked(
                testDb.createView(viewName, coll.getName(), enrichedTitleViewPipeline));
        } else if (viewType === datasets.ACTION_MOVIES) {
            assert.commandWorked(
                testDb.createView(viewName, coll.getName(), actionMoviesViewPipeline));
        } else if (viewType == datasets.ACTION_MOVIES_WITH_ENRICHED_TITLE) {
            // Nested view.
            const view = createMoviesView(datasets.MOVIES_WITH_ENRICHED_TITLE);
            assert.commandWorked(
                testDb.createView(viewName, view.getName(), actionMoviesViewPipeline));
        }
    }

    return testDb[viewName];
}

/**
 * @returns The movies collection with a vector search index on the plot_embedding field.
 */
export function createMoviesCollAndIndex() {
    const testDb = db.getSiblingDB("vector_search_shared_db");
    const coll = testDb.moviesColl;

    // Populate the collection.
    if (coll.count() === 0) {
        assert.commandWorked(coll.insertMany(getMovieData()));
    }

    // Create an index if it doesn't already exist.
    if (!checkForExistingIndex(coll, datasets.MOVIES.indexName)) {
        createSearchIndex(coll,
                          getMovieVectorSearchIndexSpec({indexName: datasets.MOVIES.indexName}));
    };

    return coll;
}

/**
 * @param {Object} viewType - The type of view to create, as specified from the datasets object in
 *     search_e2e_utils.js.
 * @returns The movies view with a vector search index on the plot_embedding field.
 */
export function createMoviesViewAndIndex(viewType) {
    const view = createMoviesView(viewType);

    if (!checkForExistingIndex(view, viewType.indexName)) {
        createSearchIndex(view, getMovieVectorSearchIndexSpec({indexName: viewType.indexName}));
    };

    return view;
}

/**
 * @param {Array} queryVector - A plot embedding to vector search upon
 * @param {number} limit - The maximum number of results to return.
 * @param {string} indexName - The name of the vector search index to use.
 * @returns A vector search query on the index specified.
 */
export function makeMovieVectorQuery({queryVector, limit, indexName = "vector_search_movie"}) {
    return {
        $vectorSearch: {
            queryVector: queryVector,
            path: "plot_embedding",
            exact: true,
            index: getMovieVectorSearchIndexSpec({indexName}).name,
            limit: limit,
        }
    };
}

/**
 * @param {string} indexName - The name of the vector search index to generate a spec for.
 * @param {list} filterFields - Additional fields to include in the index definition to support
 *     pre-filtering.
 * @returns A vector search index spec on the plot_embedding field.
 */
export function getMovieVectorSearchIndexSpec(
    {indexName = "vector_search_movie", filterFields = []} = {}) {
    const fields = [{
                       "type": "vector",
                       "numDimensions": 1536,
                       "path": "plot_embedding",
                       "similarity": "euclidean"
                   }].concat(filterFields);

    return {name: indexName, type: "vectorSearch", definition: {"fields": fields}};
}

export function getMovieSearchIndexSpec() {
    return {name: "search_movie", definition: {"mappings": {"dynamic": true}}};
}

/**
 * @param id of a movie document.
 * @returns The corresponding plot embedding.
 */
export function getMoviePlotEmbeddingById(id) {
    return plotEmbeddings[id];
}
