/**
 *    Copyright (C) 2018-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

#include "mongo/db/matcher/schema/expression_internal_schema_fmod.h"

#include "mongo/base/error_codes.h"
#include "mongo/bson/bsonmisc.h"
#include "mongo/bson/bsonobjbuilder.h"
#include "mongo/unittest/unittest.h"
#include "mongo/util/assert_util.h"

#include <boost/move/utility_core.hpp>
#include <boost/optional/optional.hpp>

namespace mongo {
namespace {

TEST(InternalSchemaFmodMatchExpression, ZeroDivisor) {
    ASSERT_THROWS_CODE(InternalSchemaFmodMatchExpression(""_sd, Decimal128(0), Decimal128(1)),
                       AssertionException,
                       ErrorCodes::BadValue);
}

TEST(InternalSchemaFmodMatchExpression, Equality) {
    InternalSchemaFmodMatchExpression m1("a"_sd, Decimal128(1.7), Decimal128(2));
    InternalSchemaFmodMatchExpression m2("a"_sd, Decimal128(2), Decimal128(2));
    InternalSchemaFmodMatchExpression m3("a"_sd, Decimal128(1.7), Decimal128(1));
    InternalSchemaFmodMatchExpression m4("b"_sd, Decimal128(1.7), Decimal128(2));

    ASSERT_TRUE(m1.equivalent(&m1));
    ASSERT_FALSE(m1.equivalent(&m2));
    ASSERT_FALSE(m1.equivalent(&m3));
    ASSERT_FALSE(m1.equivalent(&m4));
}
}  // namespace
}  // namespace mongo
