/**
 *    Copyright (C) 2022-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

#pragma once

#include "mongo/db/keypattern.h"
#include "mongo/db/namespace_string.h"
#include "mongo/db/operation_context.h"
#include "mongo/s/analyze_shard_key_cmd_gen.h"
#include "mongo/util/uuid.h"

#include <cstdint>
#include <utility>

#include <boost/optional/optional.hpp>

namespace mongo {
namespace analyze_shard_key {

/**
 * Returns metrics about the characteristics of the shard key (i.e. the cardinality, frequency
 * and monotonicity) if the shard key has a supporting index.
 */
boost::optional<KeyCharacteristicsMetrics> calculateKeyCharacteristicsMetrics(
    OperationContext* opCtx,
    const UUID& analyzeShardKeyId,
    const NamespaceString& nss,
    const UUID& collUuid,
    const KeyPattern& shardKey,
    boost::optional<double> sampleRate,
    boost::optional<int64_t> sampleSize);

/**
 * Returns metrics about the read and write distribution based on sampled queries.
 */
std::pair<ReadDistributionMetrics, WriteDistributionMetrics> calculateReadWriteDistributionMetrics(
    OperationContext* opCtx,
    const UUID& analyzeShardKeyId,
    const NamespaceString& nss,
    const UUID& collUuid,
    const KeyPattern& shardKey);

}  // namespace analyze_shard_key
}  // namespace mongo
