// type declarations for collection.js

declare class DBCollection {

    constructor(mongo, db, shortName, fullName);

    insert(opts)

    compact(extra = {})
    cleanup(extra = {})
    verify()
    getName()
    help()
    getFullName()
    getMongo(): Mongo
    getDB(): DB
    find(filter, projection, limit, skip, batchSize, options)
    findOne(filter, projection, options, readConcern, collation, rawData)
    findOneWithRawData(filter)
    insert(obj, options)
    remove(t, justOne)
    update(query, updateSpec, upsert, multi)
    save(obj, opts)
    createIndex(keys, options, commitQuorum, cmdArgs)
    createIndexes(keys, options, commitQuorum, cmdArgs)
    reIndex()
    dropIndexes(indexNames, cmdArgs)
    drop(options = {})
    findAndModify(args)
    renameCollection(newName, dropTarget)
    validate(options)
    getShardVersion()
    getIndexes(params)
    getIndexKeys(options = {})
    hashAllDocs()
    dropIndex(index)
    hideIndex(index)
    unhideIndex(index)
    getCollection(subName)
    stats(args)
    dataSize()
    storageSize()
    totalIndexSize(verbose)
    totalSize()
    convertToCapped(bytes)
    getMetadata()
    exists()
    isCapped()
    getUUID()
    aggregate(pipeline, aggregateOptions)
    convertToSingleObject(valueField)
    mapReduce(map, reduce, optionsOrOutString)
    toString()
    tojson =toString;
    shellPrint =toString;
    getShardDistribution()
    getShardKey()
    getSplitKeysForChunks(chunkSize)
    enableBalancing()
    disableBalancing()
    setSlaveOk(value)
    getSlaveOk()
    setSecondaryOk(value = true)
    getSecondaryOk()
    getQueryOptions()
    getPlanCache()
    setWriteConcern(wc)
    getWriteConcern()
    unsetWriteConcern()
    disableAutoMerger()
    enableAutoMerger()
    count(query, options)
    countDocuments(query, options)
    estimatedDocumentCount(options)
    distinct(keyString, query, options)
    latencyStats(options)
    watch(pipeline, options)
    checkMetadataConsistency(options = {})
}

declare class PlanCache {}
