## Testing frameworks

Here are the frequently-used WiredTiger testing frameworks (broken down by testing types):

- Unit testing
  - [Catch2](https://github.com/wiredtiger/wiredtiger/tree/develop/test/unittest)
- End-to-end testing
  - [Python suite](https://github.com/wiredtiger/wiredtiger/tree/develop/test/suite)
  - [C suite](https://github.com/wiredtiger/wiredtiger/tree/develop/test/csuite)
  - [Model test](https://github.com/wiredtiger/wiredtiger/tree/develop/test/model)
- Stress testing
  - [format test](https://github.com/wiredtiger/wiredtiger/tree/develop/test/format)
  - [checkpoint test](https://github.com/wiredtiger/wiredtiger/tree/develop/test/checkpoint)
  - [CPP Suite](https://github.com/wiredtiger/wiredtiger/tree/develop/test/cppsuite)
  - [testy](https://github.com/wiredtiger/testy)
- Performance testing
  - [wtperf](https://github.com/wiredtiger/wiredtiger/tree/develop/bench/wtperf)
  - [workgen](https://github.com/wiredtiger/wiredtiger/tree/develop/bench/workgen)
  - sys-perf
- Upstream testing
  - [mongo jstests](https://github.com/mongodb/mongo/tree/master/jstests)