# Header files in include/ are often associated with module up the src/ folder.
# This dict provided a mapping from file names in src/include to modules in the src/ directory.
header_mappings = {
    "api.h": "conn",
    "bitstring_inline.h": "support",
    "bitstring.h": "support",
    "block_chunkcache.h": "block_cache",
    "btmem.h": "btree",
    "btree_cmp_inline.h": "btree",
    "buf_inline.h": "include",
    "cache_inline.h": "evict",
    "cache.h": "evict",
    "capacity.h": "include",
    "cell_inline.h": "reconcile",
    "cell.h": "reconcile",
    "checkpoint.h": "btree",
    "column_inline.h": "btree",
    "compact.h": "btree",
    "conf_keys.h": "conf",
    "connection.h": "conn",
    "ctype_inline.h": "include",
    "dhandle.h": "btree",
    "dlh.h": "include",
    "error.h": "include",
    "futex.h": "os_layer",
    "gcc.h": "include",
    "generation.h": "support",
    "hardware.h": "include",
    "hazard.h": "support",
    "intpack_inline.h": "packing",
    "json.h": "support",
    "misc_inline.h": "include",
    "misc.h": "include",
    "modify_inline.h": "btree",
    "msvc.h": "include",
    "mutex_inline.h": "support",
    "mutex.h": "support",
    "os_fhandle_inline.h": "os_layer",
    "os_fs_inline.h": "os_layer",
    "os_fstream_inline.h": "os_layer",
    "os_windows.h": "os_layer",
    "os.h": "os_layer",
    "pagestat_inline.h": "include",
    "posix.h": "os_layer",
    "queue.h": "include",
    "ref_inline.h": "btree",
    "serial_inline.h": "btree",
    "stat.h": "support",
    "str_inline.h": "support",
    "swap.h": "include",
    "thread_group.h": "support",
    "time_inline.h": "support",
    "timestamp_inline.h": "support",
    "timestamp.h": "support",
    "truncate.h": "txn",
    "verbose.h": "support",
    "version.h": "include",
    "verify_build.h": "include",
}

# Forward declaration files aren't needed when building dependency graphs. Skip them.
skip_files = [
    "extern_posix.h", "extern_darwin.h", "extern_win.h", "extern.h", 
    "extern_linux.h", "wt_internal.h", "wiredtiger_ext.h"
]
